# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class ProcessInstanceModificationInstructionDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'variables': 'TriggerVariableValueDto',
        'activity_id': 'str',
        'transition_id': 'str',
        'activity_instance_id': 'str',
        'transition_instance_id': 'str',
        'ancestor_activity_instance_id': 'str',
        'cancel_current_active_activity_instances': 'bool'
    }

    attribute_map = {
        'type': 'type',
        'variables': 'variables',
        'activity_id': 'activityId',
        'transition_id': 'transitionId',
        'activity_instance_id': 'activityInstanceId',
        'transition_instance_id': 'transitionInstanceId',
        'ancestor_activity_instance_id': 'ancestorActivityInstanceId',
        'cancel_current_active_activity_instances': 'cancelCurrentActiveActivityInstances'
    }

    def __init__(self, type=None, variables=None, activity_id=None, transition_id=None, activity_instance_id=None, transition_instance_id=None, ancestor_activity_instance_id=None, cancel_current_active_activity_instances=None, local_vars_configuration=None):  # noqa: E501
        """ProcessInstanceModificationInstructionDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._variables = None
        self._activity_id = None
        self._transition_id = None
        self._activity_instance_id = None
        self._transition_instance_id = None
        self._ancestor_activity_instance_id = None
        self._cancel_current_active_activity_instances = None
        self.discriminator = None

        self.type = type
        if variables is not None:
            self.variables = variables
        self.activity_id = activity_id
        self.transition_id = transition_id
        self.activity_instance_id = activity_instance_id
        self.transition_instance_id = transition_instance_id
        self.ancestor_activity_instance_id = ancestor_activity_instance_id
        self.cancel_current_active_activity_instances = cancel_current_active_activity_instances

    @property
    def type(self):
        """Gets the type of this ProcessInstanceModificationInstructionDto.  # noqa: E501

        **Mandatory**. One of the following values: `cancel`, `startBeforeActivity`, `startAfterActivity`, `startTransition`.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.  # noqa: E501

        :return: The type of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ProcessInstanceModificationInstructionDto.

        **Mandatory**. One of the following values: `cancel`, `startBeforeActivity`, `startAfterActivity`, `startTransition`.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.  # noqa: E501

        :param type: The type of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["cancel", "startBeforeActivity", "startAfterActivity", "startTransition"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def variables(self):
        """Gets the variables of this ProcessInstanceModificationInstructionDto.  # noqa: E501


        :return: The variables of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :rtype: TriggerVariableValueDto
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """Sets the variables of this ProcessInstanceModificationInstructionDto.


        :param variables: The variables of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :type: TriggerVariableValueDto
        """

        self._variables = variables

    @property
    def activity_id(self):
        """Gets the activity_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501

        Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.  # noqa: E501

        :return: The activity_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this ProcessInstanceModificationInstructionDto.

        Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.  # noqa: E501

        :param activity_id: The activity_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def transition_id(self):
        """Gets the transition_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501

        Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.  # noqa: E501

        :return: The transition_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :rtype: str
        """
        return self._transition_id

    @transition_id.setter
    def transition_id(self, transition_id):
        """Sets the transition_id of this ProcessInstanceModificationInstructionDto.

        Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.  # noqa: E501

        :param transition_id: The transition_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :type: str
        """

        self._transition_id = transition_id

    @property
    def activity_instance_id(self):
        """Gets the activity_instance_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501

        Can be used with instructions of type `cancel`. Specifies the activity instance to cancel. Valid values are the activity instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.15/reference/rest/process-instance/get-activity-instances/).  # noqa: E501

        :return: The activity_instance_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_instance_id

    @activity_instance_id.setter
    def activity_instance_id(self, activity_instance_id):
        """Sets the activity_instance_id of this ProcessInstanceModificationInstructionDto.

        Can be used with instructions of type `cancel`. Specifies the activity instance to cancel. Valid values are the activity instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.15/reference/rest/process-instance/get-activity-instances/).  # noqa: E501

        :param activity_instance_id: The activity_instance_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :type: str
        """

        self._activity_instance_id = activity_instance_id

    @property
    def transition_instance_id(self):
        """Gets the transition_instance_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501

        Can be used with instructions of type `cancel`. Specifies the transition instance to cancel. Valid values are the transition instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.15/reference/rest/process-instance/get-activity-instances/).  # noqa: E501

        :return: The transition_instance_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :rtype: str
        """
        return self._transition_instance_id

    @transition_instance_id.setter
    def transition_instance_id(self, transition_instance_id):
        """Sets the transition_instance_id of this ProcessInstanceModificationInstructionDto.

        Can be used with instructions of type `cancel`. Specifies the transition instance to cancel. Valid values are the transition instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.15/reference/rest/process-instance/get-activity-instances/).  # noqa: E501

        :param transition_instance_id: The transition_instance_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :type: str
        """

        self._transition_instance_id = transition_instance_id

    @property
    def ancestor_activity_instance_id(self):
        """Gets the ancestor_activity_instance_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501

        Can be used with instructions of type `startBeforeActivity`, `startAfterActivity`, and `startTransition`. Valid values are the activity instance IDs supplied by the Get Activity Instance request. If there are multiple parent activity instances of the targeted activity, this specifies the ancestor scope in which hierarchy the activity/transition is to be instantiated.  Example: When there are two instances of a subprocess and an activity contained in the subprocess is to be started, this parameter allows to specifiy under which subprocess instance the activity should be started.  # noqa: E501

        :return: The ancestor_activity_instance_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :rtype: str
        """
        return self._ancestor_activity_instance_id

    @ancestor_activity_instance_id.setter
    def ancestor_activity_instance_id(self, ancestor_activity_instance_id):
        """Sets the ancestor_activity_instance_id of this ProcessInstanceModificationInstructionDto.

        Can be used with instructions of type `startBeforeActivity`, `startAfterActivity`, and `startTransition`. Valid values are the activity instance IDs supplied by the Get Activity Instance request. If there are multiple parent activity instances of the targeted activity, this specifies the ancestor scope in which hierarchy the activity/transition is to be instantiated.  Example: When there are two instances of a subprocess and an activity contained in the subprocess is to be started, this parameter allows to specifiy under which subprocess instance the activity should be started.  # noqa: E501

        :param ancestor_activity_instance_id: The ancestor_activity_instance_id of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :type: str
        """

        self._ancestor_activity_instance_id = ancestor_activity_instance_id

    @property
    def cancel_current_active_activity_instances(self):
        """Gets the cancel_current_active_activity_instances of this ProcessInstanceModificationInstructionDto.  # noqa: E501

        Can be used with instructions of type cancel. Prevents the deletion of new created activity instances.  # noqa: E501

        :return: The cancel_current_active_activity_instances of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :rtype: bool
        """
        return self._cancel_current_active_activity_instances

    @cancel_current_active_activity_instances.setter
    def cancel_current_active_activity_instances(self, cancel_current_active_activity_instances):
        """Sets the cancel_current_active_activity_instances of this ProcessInstanceModificationInstructionDto.

        Can be used with instructions of type cancel. Prevents the deletion of new created activity instances.  # noqa: E501

        :param cancel_current_active_activity_instances: The cancel_current_active_activity_instances of this ProcessInstanceModificationInstructionDto.  # noqa: E501
        :type: bool
        """

        self._cancel_current_active_activity_instances = cancel_current_active_activity_instances

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProcessInstanceModificationInstructionDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProcessInstanceModificationInstructionDto):
            return True

        return self.to_dict() != other.to_dict()
