# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class ProcessDefinitionSuspensionStateDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'suspended': 'bool',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'include_process_instances': 'bool',
        'execution_date': 'datetime'
    }

    attribute_map = {
        'suspended': 'suspended',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'include_process_instances': 'includeProcessInstances',
        'execution_date': 'executionDate'
    }

    def __init__(self, suspended=None, process_definition_id=None, process_definition_key=None, include_process_instances=None, execution_date=None, local_vars_configuration=None):  # noqa: E501
        """ProcessDefinitionSuspensionStateDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._suspended = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._include_process_instances = None
        self._execution_date = None
        self.discriminator = None

        self.suspended = suspended
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.include_process_instances = include_process_instances
        self.execution_date = execution_date

    @property
    def suspended(self):
        """Gets the suspended of this ProcessDefinitionSuspensionStateDto.  # noqa: E501

        A `Boolean` value which indicates whether to activate or suspend all process definitions with the given key. When the value is set to `true`, all process definitions with the given key will be suspended and when the value is set to `false`, all process definitions with the given key will be activated.  # noqa: E501

        :return: The suspended of this ProcessDefinitionSuspensionStateDto.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this ProcessDefinitionSuspensionStateDto.

        A `Boolean` value which indicates whether to activate or suspend all process definitions with the given key. When the value is set to `true`, all process definitions with the given key will be suspended and when the value is set to `false`, all process definitions with the given key will be activated.  # noqa: E501

        :param suspended: The suspended of this ProcessDefinitionSuspensionStateDto.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this ProcessDefinitionSuspensionStateDto.  # noqa: E501

        The id of the process definitions to activate or suspend.  # noqa: E501

        :return: The process_definition_id of this ProcessDefinitionSuspensionStateDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this ProcessDefinitionSuspensionStateDto.

        The id of the process definitions to activate or suspend.  # noqa: E501

        :param process_definition_id: The process_definition_id of this ProcessDefinitionSuspensionStateDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this ProcessDefinitionSuspensionStateDto.  # noqa: E501

        The key of the process definitions to activate or suspend.  # noqa: E501

        :return: The process_definition_key of this ProcessDefinitionSuspensionStateDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this ProcessDefinitionSuspensionStateDto.

        The key of the process definitions to activate or suspend.  # noqa: E501

        :param process_definition_key: The process_definition_key of this ProcessDefinitionSuspensionStateDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def include_process_instances(self):
        """Gets the include_process_instances of this ProcessDefinitionSuspensionStateDto.  # noqa: E501

        A `Boolean` value which indicates whether to activate or suspend also all process instances of  the process definitions with the given key. When the value is set to `true`, all process instances of the process definitions with the given key will be activated or suspended and when the value is set to `false`, the suspension state of  all process instances of the process definitions with the given key will not be updated.  # noqa: E501

        :return: The include_process_instances of this ProcessDefinitionSuspensionStateDto.  # noqa: E501
        :rtype: bool
        """
        return self._include_process_instances

    @include_process_instances.setter
    def include_process_instances(self, include_process_instances):
        """Sets the include_process_instances of this ProcessDefinitionSuspensionStateDto.

        A `Boolean` value which indicates whether to activate or suspend also all process instances of  the process definitions with the given key. When the value is set to `true`, all process instances of the process definitions with the given key will be activated or suspended and when the value is set to `false`, the suspension state of  all process instances of the process definitions with the given key will not be updated.  # noqa: E501

        :param include_process_instances: The include_process_instances of this ProcessDefinitionSuspensionStateDto.  # noqa: E501
        :type: bool
        """

        self._include_process_instances = include_process_instances

    @property
    def execution_date(self):
        """Gets the execution_date of this ProcessDefinitionSuspensionStateDto.  # noqa: E501

        The date on which all process definitions with the given key will be activated or suspended. If `null`, the suspension state of all process definitions with the given key is updated immediately. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The execution_date of this ProcessDefinitionSuspensionStateDto.  # noqa: E501
        :rtype: datetime
        """
        return self._execution_date

    @execution_date.setter
    def execution_date(self, execution_date):
        """Sets the execution_date of this ProcessDefinitionSuspensionStateDto.

        The date on which all process definitions with the given key will be activated or suspended. If `null`, the suspension state of all process definitions with the given key is updated immediately. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param execution_date: The execution_date of this ProcessDefinitionSuspensionStateDto.  # noqa: E501
        :type: datetime
        """

        self._execution_date = execution_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProcessDefinitionSuspensionStateDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProcessDefinitionSuspensionStateDto):
            return True

        return self.to_dict() != other.to_dict()
