# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class ProcessDefinitionStatisticsResultDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'instances': 'int',
        'failed_jobs': 'int',
        'incidents': 'list[IncidentStatisticsResultDto]',
        'definition': 'ProcessDefinitionDto'
    }

    attribute_map = {
        'id': 'id',
        'instances': 'instances',
        'failed_jobs': 'failedJobs',
        'incidents': 'incidents',
        'definition': 'definition'
    }

    def __init__(self, id=None, instances=None, failed_jobs=None, incidents=None, definition=None, local_vars_configuration=None):  # noqa: E501
        """ProcessDefinitionStatisticsResultDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._instances = None
        self._failed_jobs = None
        self._incidents = None
        self._definition = None
        self.discriminator = None

        self.id = id
        if instances is not None:
            self.instances = instances
        if failed_jobs is not None:
            self.failed_jobs = failed_jobs
        self.incidents = incidents
        if definition is not None:
            self.definition = definition

    @property
    def id(self):
        """Gets the id of this ProcessDefinitionStatisticsResultDto.  # noqa: E501

        The id of the process definition the results are aggregated for.  # noqa: E501

        :return: The id of this ProcessDefinitionStatisticsResultDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ProcessDefinitionStatisticsResultDto.

        The id of the process definition the results are aggregated for.  # noqa: E501

        :param id: The id of this ProcessDefinitionStatisticsResultDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def instances(self):
        """Gets the instances of this ProcessDefinitionStatisticsResultDto.  # noqa: E501

        The total number of running process instances of this process definition.  # noqa: E501

        :return: The instances of this ProcessDefinitionStatisticsResultDto.  # noqa: E501
        :rtype: int
        """
        return self._instances

    @instances.setter
    def instances(self, instances):
        """Sets the instances of this ProcessDefinitionStatisticsResultDto.

        The total number of running process instances of this process definition.  # noqa: E501

        :param instances: The instances of this ProcessDefinitionStatisticsResultDto.  # noqa: E501
        :type: int
        """

        self._instances = instances

    @property
    def failed_jobs(self):
        """Gets the failed_jobs of this ProcessDefinitionStatisticsResultDto.  # noqa: E501

        The total number of failed jobs for the running instances. **Note**: Will be `0` (not `null`), if failed jobs were excluded.  # noqa: E501

        :return: The failed_jobs of this ProcessDefinitionStatisticsResultDto.  # noqa: E501
        :rtype: int
        """
        return self._failed_jobs

    @failed_jobs.setter
    def failed_jobs(self, failed_jobs):
        """Sets the failed_jobs of this ProcessDefinitionStatisticsResultDto.

        The total number of failed jobs for the running instances. **Note**: Will be `0` (not `null`), if failed jobs were excluded.  # noqa: E501

        :param failed_jobs: The failed_jobs of this ProcessDefinitionStatisticsResultDto.  # noqa: E501
        :type: int
        """

        self._failed_jobs = failed_jobs

    @property
    def incidents(self):
        """Gets the incidents of this ProcessDefinitionStatisticsResultDto.  # noqa: E501

        Each item in the resulting array is an object which contains `incidentType` and `incidentCount`. **Note**: Will be an empty array, if `incidents` or `incidentsForType` were excluded. Furthermore, the array will be also empty if no incidents were found.  # noqa: E501

        :return: The incidents of this ProcessDefinitionStatisticsResultDto.  # noqa: E501
        :rtype: list[IncidentStatisticsResultDto]
        """
        return self._incidents

    @incidents.setter
    def incidents(self, incidents):
        """Sets the incidents of this ProcessDefinitionStatisticsResultDto.

        Each item in the resulting array is an object which contains `incidentType` and `incidentCount`. **Note**: Will be an empty array, if `incidents` or `incidentsForType` were excluded. Furthermore, the array will be also empty if no incidents were found.  # noqa: E501

        :param incidents: The incidents of this ProcessDefinitionStatisticsResultDto.  # noqa: E501
        :type: list[IncidentStatisticsResultDto]
        """

        self._incidents = incidents

    @property
    def definition(self):
        """Gets the definition of this ProcessDefinitionStatisticsResultDto.  # noqa: E501


        :return: The definition of this ProcessDefinitionStatisticsResultDto.  # noqa: E501
        :rtype: ProcessDefinitionDto
        """
        return self._definition

    @definition.setter
    def definition(self, definition):
        """Sets the definition of this ProcessDefinitionStatisticsResultDto.


        :param definition: The definition of this ProcessDefinitionStatisticsResultDto.  # noqa: E501
        :type: ProcessDefinitionDto
        """

        self._definition = definition

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProcessDefinitionStatisticsResultDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProcessDefinitionStatisticsResultDto):
            return True

        return self.to_dict() != other.to_dict()
