# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class JobQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'job_id': 'str',
        'job_ids': 'list[str]',
        'job_definition_id': 'str',
        'process_instance_id': 'str',
        'process_instance_ids': 'list[str]',
        'execution_id': 'str',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'activity_id': 'str',
        'with_retries_left': 'bool',
        'executable': 'bool',
        'timers': 'bool',
        'messages': 'bool',
        'due_dates': 'list[JobConditionQueryParameterDto]',
        'create_times': 'list[JobConditionQueryParameterDto]',
        'with_exception': 'bool',
        'exception_message': 'str',
        'failed_activity_id': 'str',
        'no_retries_left': 'bool',
        'active': 'bool',
        'suspended': 'bool',
        'priority_lower_than_or_equals': 'int',
        'priority_higher_than_or_equals': 'int',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'include_jobs_without_tenant_id': 'bool',
        'sorting': 'list[JobQueryDtoSorting]'
    }

    attribute_map = {
        'job_id': 'jobId',
        'job_ids': 'jobIds',
        'job_definition_id': 'jobDefinitionId',
        'process_instance_id': 'processInstanceId',
        'process_instance_ids': 'processInstanceIds',
        'execution_id': 'executionId',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'activity_id': 'activityId',
        'with_retries_left': 'withRetriesLeft',
        'executable': 'executable',
        'timers': 'timers',
        'messages': 'messages',
        'due_dates': 'dueDates',
        'create_times': 'createTimes',
        'with_exception': 'withException',
        'exception_message': 'exceptionMessage',
        'failed_activity_id': 'failedActivityId',
        'no_retries_left': 'noRetriesLeft',
        'active': 'active',
        'suspended': 'suspended',
        'priority_lower_than_or_equals': 'priorityLowerThanOrEquals',
        'priority_higher_than_or_equals': 'priorityHigherThanOrEquals',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'include_jobs_without_tenant_id': 'includeJobsWithoutTenantId',
        'sorting': 'sorting'
    }

    def __init__(self, job_id=None, job_ids=None, job_definition_id=None, process_instance_id=None, process_instance_ids=None, execution_id=None, process_definition_id=None, process_definition_key=None, activity_id=None, with_retries_left=None, executable=None, timers=None, messages=None, due_dates=None, create_times=None, with_exception=None, exception_message=None, failed_activity_id=None, no_retries_left=None, active=None, suspended=None, priority_lower_than_or_equals=None, priority_higher_than_or_equals=None, tenant_id_in=None, without_tenant_id=None, include_jobs_without_tenant_id=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """JobQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._job_id = None
        self._job_ids = None
        self._job_definition_id = None
        self._process_instance_id = None
        self._process_instance_ids = None
        self._execution_id = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._activity_id = None
        self._with_retries_left = None
        self._executable = None
        self._timers = None
        self._messages = None
        self._due_dates = None
        self._create_times = None
        self._with_exception = None
        self._exception_message = None
        self._failed_activity_id = None
        self._no_retries_left = None
        self._active = None
        self._suspended = None
        self._priority_lower_than_or_equals = None
        self._priority_higher_than_or_equals = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._include_jobs_without_tenant_id = None
        self._sorting = None
        self.discriminator = None

        self.job_id = job_id
        self.job_ids = job_ids
        self.job_definition_id = job_definition_id
        self.process_instance_id = process_instance_id
        self.process_instance_ids = process_instance_ids
        self.execution_id = execution_id
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.activity_id = activity_id
        self.with_retries_left = with_retries_left
        self.executable = executable
        self.timers = timers
        self.messages = messages
        self.due_dates = due_dates
        self.create_times = create_times
        self.with_exception = with_exception
        self.exception_message = exception_message
        self.failed_activity_id = failed_activity_id
        self.no_retries_left = no_retries_left
        self.active = active
        self.suspended = suspended
        self.priority_lower_than_or_equals = priority_lower_than_or_equals
        self.priority_higher_than_or_equals = priority_higher_than_or_equals
        self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        self.include_jobs_without_tenant_id = include_jobs_without_tenant_id
        if sorting is not None:
            self.sorting = sorting

    @property
    def job_id(self):
        """Gets the job_id of this JobQueryDto.  # noqa: E501

        Filter by job id.  # noqa: E501

        :return: The job_id of this JobQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this JobQueryDto.

        Filter by job id.  # noqa: E501

        :param job_id: The job_id of this JobQueryDto.  # noqa: E501
        :type: str
        """

        self._job_id = job_id

    @property
    def job_ids(self):
        """Gets the job_ids of this JobQueryDto.  # noqa: E501

        Filter by a  list of job ids.  # noqa: E501

        :return: The job_ids of this JobQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._job_ids

    @job_ids.setter
    def job_ids(self, job_ids):
        """Sets the job_ids of this JobQueryDto.

        Filter by a  list of job ids.  # noqa: E501

        :param job_ids: The job_ids of this JobQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._job_ids = job_ids

    @property
    def job_definition_id(self):
        """Gets the job_definition_id of this JobQueryDto.  # noqa: E501

        Only select jobs which exist for the given job definition.  # noqa: E501

        :return: The job_definition_id of this JobQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._job_definition_id

    @job_definition_id.setter
    def job_definition_id(self, job_definition_id):
        """Sets the job_definition_id of this JobQueryDto.

        Only select jobs which exist for the given job definition.  # noqa: E501

        :param job_definition_id: The job_definition_id of this JobQueryDto.  # noqa: E501
        :type: str
        """

        self._job_definition_id = job_definition_id

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this JobQueryDto.  # noqa: E501

        Only select jobs which exist for the given process instance.  # noqa: E501

        :return: The process_instance_id of this JobQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this JobQueryDto.

        Only select jobs which exist for the given process instance.  # noqa: E501

        :param process_instance_id: The process_instance_id of this JobQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def process_instance_ids(self):
        """Gets the process_instance_ids of this JobQueryDto.  # noqa: E501

        Only select jobs which exist for the given  list of process instance ids.  # noqa: E501

        :return: The process_instance_ids of this JobQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_instance_ids

    @process_instance_ids.setter
    def process_instance_ids(self, process_instance_ids):
        """Sets the process_instance_ids of this JobQueryDto.

        Only select jobs which exist for the given  list of process instance ids.  # noqa: E501

        :param process_instance_ids: The process_instance_ids of this JobQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_instance_ids = process_instance_ids

    @property
    def execution_id(self):
        """Gets the execution_id of this JobQueryDto.  # noqa: E501

        Only select jobs which exist for the given execution.  # noqa: E501

        :return: The execution_id of this JobQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this JobQueryDto.

        Only select jobs which exist for the given execution.  # noqa: E501

        :param execution_id: The execution_id of this JobQueryDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this JobQueryDto.  # noqa: E501

        Filter by the id of the process definition the jobs run on.  # noqa: E501

        :return: The process_definition_id of this JobQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this JobQueryDto.

        Filter by the id of the process definition the jobs run on.  # noqa: E501

        :param process_definition_id: The process_definition_id of this JobQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this JobQueryDto.  # noqa: E501

        Filter by the key of the process definition the jobs run on.  # noqa: E501

        :return: The process_definition_key of this JobQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this JobQueryDto.

        Filter by the key of the process definition the jobs run on.  # noqa: E501

        :param process_definition_key: The process_definition_key of this JobQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def activity_id(self):
        """Gets the activity_id of this JobQueryDto.  # noqa: E501

        Only select jobs which exist for an activity with the given id.  # noqa: E501

        :return: The activity_id of this JobQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this JobQueryDto.

        Only select jobs which exist for an activity with the given id.  # noqa: E501

        :param activity_id: The activity_id of this JobQueryDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def with_retries_left(self):
        """Gets the with_retries_left of this JobQueryDto.  # noqa: E501

        Only select jobs which have retries left. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The with_retries_left of this JobQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._with_retries_left

    @with_retries_left.setter
    def with_retries_left(self, with_retries_left):
        """Sets the with_retries_left of this JobQueryDto.

        Only select jobs which have retries left. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param with_retries_left: The with_retries_left of this JobQueryDto.  # noqa: E501
        :type: bool
        """

        self._with_retries_left = with_retries_left

    @property
    def executable(self):
        """Gets the executable of this JobQueryDto.  # noqa: E501

        Only select jobs which are executable, i.e., retries > 0 and due date is `null` or due date is in the past. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The executable of this JobQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._executable

    @executable.setter
    def executable(self, executable):
        """Sets the executable of this JobQueryDto.

        Only select jobs which are executable, i.e., retries > 0 and due date is `null` or due date is in the past. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param executable: The executable of this JobQueryDto.  # noqa: E501
        :type: bool
        """

        self._executable = executable

    @property
    def timers(self):
        """Gets the timers of this JobQueryDto.  # noqa: E501

        Only select jobs that are timers. Cannot be used together with `messages`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The timers of this JobQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._timers

    @timers.setter
    def timers(self, timers):
        """Sets the timers of this JobQueryDto.

        Only select jobs that are timers. Cannot be used together with `messages`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param timers: The timers of this JobQueryDto.  # noqa: E501
        :type: bool
        """

        self._timers = timers

    @property
    def messages(self):
        """Gets the messages of this JobQueryDto.  # noqa: E501

        Only select jobs that are messages. Cannot be used together with `timers`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The messages of this JobQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._messages

    @messages.setter
    def messages(self, messages):
        """Sets the messages of this JobQueryDto.

        Only select jobs that are messages. Cannot be used together with `timers`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param messages: The messages of this JobQueryDto.  # noqa: E501
        :type: bool
        """

        self._messages = messages

    @property
    def due_dates(self):
        """Gets the due_dates of this JobQueryDto.  # noqa: E501

        Only select jobs where the due date is lower or higher than the given date.   # noqa: E501

        :return: The due_dates of this JobQueryDto.  # noqa: E501
        :rtype: list[JobConditionQueryParameterDto]
        """
        return self._due_dates

    @due_dates.setter
    def due_dates(self, due_dates):
        """Sets the due_dates of this JobQueryDto.

        Only select jobs where the due date is lower or higher than the given date.   # noqa: E501

        :param due_dates: The due_dates of this JobQueryDto.  # noqa: E501
        :type: list[JobConditionQueryParameterDto]
        """

        self._due_dates = due_dates

    @property
    def create_times(self):
        """Gets the create_times of this JobQueryDto.  # noqa: E501

        Only select jobs created before or after the given date.   # noqa: E501

        :return: The create_times of this JobQueryDto.  # noqa: E501
        :rtype: list[JobConditionQueryParameterDto]
        """
        return self._create_times

    @create_times.setter
    def create_times(self, create_times):
        """Sets the create_times of this JobQueryDto.

        Only select jobs created before or after the given date.   # noqa: E501

        :param create_times: The create_times of this JobQueryDto.  # noqa: E501
        :type: list[JobConditionQueryParameterDto]
        """

        self._create_times = create_times

    @property
    def with_exception(self):
        """Gets the with_exception of this JobQueryDto.  # noqa: E501

        Only select jobs that failed due to an exception. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The with_exception of this JobQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._with_exception

    @with_exception.setter
    def with_exception(self, with_exception):
        """Sets the with_exception of this JobQueryDto.

        Only select jobs that failed due to an exception. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param with_exception: The with_exception of this JobQueryDto.  # noqa: E501
        :type: bool
        """

        self._with_exception = with_exception

    @property
    def exception_message(self):
        """Gets the exception_message of this JobQueryDto.  # noqa: E501

        Only select jobs that failed due to an exception with the given message.  # noqa: E501

        :return: The exception_message of this JobQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._exception_message

    @exception_message.setter
    def exception_message(self, exception_message):
        """Sets the exception_message of this JobQueryDto.

        Only select jobs that failed due to an exception with the given message.  # noqa: E501

        :param exception_message: The exception_message of this JobQueryDto.  # noqa: E501
        :type: str
        """

        self._exception_message = exception_message

    @property
    def failed_activity_id(self):
        """Gets the failed_activity_id of this JobQueryDto.  # noqa: E501

        Only select jobs that failed due to an exception at an activity with the given id.  # noqa: E501

        :return: The failed_activity_id of this JobQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._failed_activity_id

    @failed_activity_id.setter
    def failed_activity_id(self, failed_activity_id):
        """Sets the failed_activity_id of this JobQueryDto.

        Only select jobs that failed due to an exception at an activity with the given id.  # noqa: E501

        :param failed_activity_id: The failed_activity_id of this JobQueryDto.  # noqa: E501
        :type: str
        """

        self._failed_activity_id = failed_activity_id

    @property
    def no_retries_left(self):
        """Gets the no_retries_left of this JobQueryDto.  # noqa: E501

        Only select jobs which have no retries left. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The no_retries_left of this JobQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._no_retries_left

    @no_retries_left.setter
    def no_retries_left(self, no_retries_left):
        """Sets the no_retries_left of this JobQueryDto.

        Only select jobs which have no retries left. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param no_retries_left: The no_retries_left of this JobQueryDto.  # noqa: E501
        :type: bool
        """

        self._no_retries_left = no_retries_left

    @property
    def active(self):
        """Gets the active of this JobQueryDto.  # noqa: E501

        Only include active jobs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The active of this JobQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this JobQueryDto.

        Only include active jobs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param active: The active of this JobQueryDto.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def suspended(self):
        """Gets the suspended of this JobQueryDto.  # noqa: E501

        Only include suspended jobs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The suspended of this JobQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this JobQueryDto.

        Only include suspended jobs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param suspended: The suspended of this JobQueryDto.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    @property
    def priority_lower_than_or_equals(self):
        """Gets the priority_lower_than_or_equals of this JobQueryDto.  # noqa: E501

        Only include jobs with a priority lower than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :return: The priority_lower_than_or_equals of this JobQueryDto.  # noqa: E501
        :rtype: int
        """
        return self._priority_lower_than_or_equals

    @priority_lower_than_or_equals.setter
    def priority_lower_than_or_equals(self, priority_lower_than_or_equals):
        """Sets the priority_lower_than_or_equals of this JobQueryDto.

        Only include jobs with a priority lower than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :param priority_lower_than_or_equals: The priority_lower_than_or_equals of this JobQueryDto.  # noqa: E501
        :type: int
        """

        self._priority_lower_than_or_equals = priority_lower_than_or_equals

    @property
    def priority_higher_than_or_equals(self):
        """Gets the priority_higher_than_or_equals of this JobQueryDto.  # noqa: E501

        Only include jobs with a priority higher than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :return: The priority_higher_than_or_equals of this JobQueryDto.  # noqa: E501
        :rtype: int
        """
        return self._priority_higher_than_or_equals

    @priority_higher_than_or_equals.setter
    def priority_higher_than_or_equals(self, priority_higher_than_or_equals):
        """Sets the priority_higher_than_or_equals of this JobQueryDto.

        Only include jobs with a priority higher than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :param priority_higher_than_or_equals: The priority_higher_than_or_equals of this JobQueryDto.  # noqa: E501
        :type: int
        """

        self._priority_higher_than_or_equals = priority_higher_than_or_equals

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this JobQueryDto.  # noqa: E501

        Only include jobs which belong to one of the passed  tenant ids.  # noqa: E501

        :return: The tenant_id_in of this JobQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this JobQueryDto.

        Only include jobs which belong to one of the passed  tenant ids.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this JobQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this JobQueryDto.  # noqa: E501

        Only include jobs which belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this JobQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this JobQueryDto.

        Only include jobs which belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this JobQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def include_jobs_without_tenant_id(self):
        """Gets the include_jobs_without_tenant_id of this JobQueryDto.  # noqa: E501

        Include jobs which belong to no tenant. Can be used in combination with `tenantIdIn`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The include_jobs_without_tenant_id of this JobQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._include_jobs_without_tenant_id

    @include_jobs_without_tenant_id.setter
    def include_jobs_without_tenant_id(self, include_jobs_without_tenant_id):
        """Sets the include_jobs_without_tenant_id of this JobQueryDto.

        Include jobs which belong to no tenant. Can be used in combination with `tenantIdIn`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param include_jobs_without_tenant_id: The include_jobs_without_tenant_id of this JobQueryDto.  # noqa: E501
        :type: bool
        """

        self._include_jobs_without_tenant_id = include_jobs_without_tenant_id

    @property
    def sorting(self):
        """Gets the sorting of this JobQueryDto.  # noqa: E501

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Does not have an effect for the `count` endpoint.  # noqa: E501

        :return: The sorting of this JobQueryDto.  # noqa: E501
        :rtype: list[JobQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this JobQueryDto.

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Does not have an effect for the `count` endpoint.  # noqa: E501

        :param sorting: The sorting of this JobQueryDto.  # noqa: E501
        :type: list[JobQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobQueryDto):
            return True

        return self.to_dict() != other.to_dict()
