# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class JobDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'job_definition_id': 'str',
        'due_date': 'datetime',
        'process_instance_id': 'str',
        'execution_id': 'str',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'retries': 'int',
        'exception_message': 'str',
        'failed_activity_id': 'str',
        'suspended': 'bool',
        'priority': 'int',
        'tenant_id': 'str',
        'create_time': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'job_definition_id': 'jobDefinitionId',
        'due_date': 'dueDate',
        'process_instance_id': 'processInstanceId',
        'execution_id': 'executionId',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'retries': 'retries',
        'exception_message': 'exceptionMessage',
        'failed_activity_id': 'failedActivityId',
        'suspended': 'suspended',
        'priority': 'priority',
        'tenant_id': 'tenantId',
        'create_time': 'createTime'
    }

    def __init__(self, id=None, job_definition_id=None, due_date=None, process_instance_id=None, execution_id=None, process_definition_id=None, process_definition_key=None, retries=None, exception_message=None, failed_activity_id=None, suspended=None, priority=None, tenant_id=None, create_time=None, local_vars_configuration=None):  # noqa: E501
        """JobDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._job_definition_id = None
        self._due_date = None
        self._process_instance_id = None
        self._execution_id = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._retries = None
        self._exception_message = None
        self._failed_activity_id = None
        self._suspended = None
        self._priority = None
        self._tenant_id = None
        self._create_time = None
        self.discriminator = None

        self.id = id
        self.job_definition_id = job_definition_id
        self.due_date = due_date
        self.process_instance_id = process_instance_id
        self.execution_id = execution_id
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.retries = retries
        self.exception_message = exception_message
        self.failed_activity_id = failed_activity_id
        self.suspended = suspended
        self.priority = priority
        self.tenant_id = tenant_id
        self.create_time = create_time

    @property
    def id(self):
        """Gets the id of this JobDto.  # noqa: E501

        The id of the job.  # noqa: E501

        :return: The id of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this JobDto.

        The id of the job.  # noqa: E501

        :param id: The id of this JobDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def job_definition_id(self):
        """Gets the job_definition_id of this JobDto.  # noqa: E501

        The id of the associated job definition.  # noqa: E501

        :return: The job_definition_id of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._job_definition_id

    @job_definition_id.setter
    def job_definition_id(self, job_definition_id):
        """Sets the job_definition_id of this JobDto.

        The id of the associated job definition.  # noqa: E501

        :param job_definition_id: The job_definition_id of this JobDto.  # noqa: E501
        :type: str
        """

        self._job_definition_id = job_definition_id

    @property
    def due_date(self):
        """Gets the due_date of this JobDto.  # noqa: E501

        The date on which this job is supposed to be processed.  # noqa: E501

        :return: The due_date of this JobDto.  # noqa: E501
        :rtype: datetime
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this JobDto.

        The date on which this job is supposed to be processed.  # noqa: E501

        :param due_date: The due_date of this JobDto.  # noqa: E501
        :type: datetime
        """

        self._due_date = due_date

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this JobDto.  # noqa: E501

        The id of the process instance which execution created the job.  # noqa: E501

        :return: The process_instance_id of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this JobDto.

        The id of the process instance which execution created the job.  # noqa: E501

        :param process_instance_id: The process_instance_id of this JobDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def execution_id(self):
        """Gets the execution_id of this JobDto.  # noqa: E501

        The specific execution id on which the job was created.  # noqa: E501

        :return: The execution_id of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this JobDto.

        The specific execution id on which the job was created.  # noqa: E501

        :param execution_id: The execution_id of this JobDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this JobDto.  # noqa: E501

        The id of the process definition which this job belongs to.  # noqa: E501

        :return: The process_definition_id of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this JobDto.

        The id of the process definition which this job belongs to.  # noqa: E501

        :param process_definition_id: The process_definition_id of this JobDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this JobDto.  # noqa: E501

        The key of the process definition which this job belongs to.  # noqa: E501

        :return: The process_definition_key of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this JobDto.

        The key of the process definition which this job belongs to.  # noqa: E501

        :param process_definition_key: The process_definition_key of this JobDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def retries(self):
        """Gets the retries of this JobDto.  # noqa: E501

        The number of retries this job has left.  # noqa: E501

        :return: The retries of this JobDto.  # noqa: E501
        :rtype: int
        """
        return self._retries

    @retries.setter
    def retries(self, retries):
        """Sets the retries of this JobDto.

        The number of retries this job has left.  # noqa: E501

        :param retries: The retries of this JobDto.  # noqa: E501
        :type: int
        """

        self._retries = retries

    @property
    def exception_message(self):
        """Gets the exception_message of this JobDto.  # noqa: E501

        The message of the exception that occurred, the last time the job was executed. Is null when no exception occurred.  # noqa: E501

        :return: The exception_message of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._exception_message

    @exception_message.setter
    def exception_message(self, exception_message):
        """Sets the exception_message of this JobDto.

        The message of the exception that occurred, the last time the job was executed. Is null when no exception occurred.  # noqa: E501

        :param exception_message: The exception_message of this JobDto.  # noqa: E501
        :type: str
        """

        self._exception_message = exception_message

    @property
    def failed_activity_id(self):
        """Gets the failed_activity_id of this JobDto.  # noqa: E501

        The id of the activity on which the last exception occurred, the last time the job was executed. Is null when no exception occurred.  # noqa: E501

        :return: The failed_activity_id of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._failed_activity_id

    @failed_activity_id.setter
    def failed_activity_id(self, failed_activity_id):
        """Sets the failed_activity_id of this JobDto.

        The id of the activity on which the last exception occurred, the last time the job was executed. Is null when no exception occurred.  # noqa: E501

        :param failed_activity_id: The failed_activity_id of this JobDto.  # noqa: E501
        :type: str
        """

        self._failed_activity_id = failed_activity_id

    @property
    def suspended(self):
        """Gets the suspended of this JobDto.  # noqa: E501

        A flag indicating whether the job is suspended or not.  # noqa: E501

        :return: The suspended of this JobDto.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this JobDto.

        A flag indicating whether the job is suspended or not.  # noqa: E501

        :param suspended: The suspended of this JobDto.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    @property
    def priority(self):
        """Gets the priority of this JobDto.  # noqa: E501

        The job's priority for execution.  # noqa: E501

        :return: The priority of this JobDto.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this JobDto.

        The job's priority for execution.  # noqa: E501

        :param priority: The priority of this JobDto.  # noqa: E501
        :type: int
        """

        self._priority = priority

    @property
    def tenant_id(self):
        """Gets the tenant_id of this JobDto.  # noqa: E501

        The id of the tenant which this job belongs to.  # noqa: E501

        :return: The tenant_id of this JobDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this JobDto.

        The id of the tenant which this job belongs to.  # noqa: E501

        :param tenant_id: The tenant_id of this JobDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def create_time(self):
        """Gets the create_time of this JobDto.  # noqa: E501

        The date on which this job has been created.  # noqa: E501

        :return: The create_time of this JobDto.  # noqa: E501
        :rtype: datetime
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this JobDto.

        The date on which this job has been created.  # noqa: E501

        :param create_time: The create_time of this JobDto.  # noqa: E501
        :type: datetime
        """

        self._create_time = create_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobDto):
            return True

        return self.to_dict() != other.to_dict()
