# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricActivityInstanceQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'activity_instance_id': 'str',
        'process_instance_id': 'str',
        'process_definition_id': 'str',
        'execution_id': 'str',
        'activity_id': 'str',
        'activity_name': 'str',
        'activity_type': 'str',
        'task_assignee': 'str',
        'finished': 'bool',
        'unfinished': 'bool',
        'canceled': 'bool',
        'complete_scope': 'bool',
        'started_before': 'datetime',
        'started_after': 'datetime',
        'finished_before': 'datetime',
        'finished_after': 'datetime',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'sorting': 'list[HistoricActivityInstanceQueryDtoSorting]'
    }

    attribute_map = {
        'activity_instance_id': 'activityInstanceId',
        'process_instance_id': 'processInstanceId',
        'process_definition_id': 'processDefinitionId',
        'execution_id': 'executionId',
        'activity_id': 'activityId',
        'activity_name': 'activityName',
        'activity_type': 'activityType',
        'task_assignee': 'taskAssignee',
        'finished': 'finished',
        'unfinished': 'unfinished',
        'canceled': 'canceled',
        'complete_scope': 'completeScope',
        'started_before': 'startedBefore',
        'started_after': 'startedAfter',
        'finished_before': 'finishedBefore',
        'finished_after': 'finishedAfter',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'sorting': 'sorting'
    }

    def __init__(self, activity_instance_id=None, process_instance_id=None, process_definition_id=None, execution_id=None, activity_id=None, activity_name=None, activity_type=None, task_assignee=None, finished=None, unfinished=None, canceled=None, complete_scope=None, started_before=None, started_after=None, finished_before=None, finished_after=None, tenant_id_in=None, without_tenant_id=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """HistoricActivityInstanceQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._activity_instance_id = None
        self._process_instance_id = None
        self._process_definition_id = None
        self._execution_id = None
        self._activity_id = None
        self._activity_name = None
        self._activity_type = None
        self._task_assignee = None
        self._finished = None
        self._unfinished = None
        self._canceled = None
        self._complete_scope = None
        self._started_before = None
        self._started_after = None
        self._finished_before = None
        self._finished_after = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._sorting = None
        self.discriminator = None

        self.activity_instance_id = activity_instance_id
        self.process_instance_id = process_instance_id
        self.process_definition_id = process_definition_id
        self.execution_id = execution_id
        self.activity_id = activity_id
        self.activity_name = activity_name
        self.activity_type = activity_type
        self.task_assignee = task_assignee
        self.finished = finished
        self.unfinished = unfinished
        self.canceled = canceled
        self.complete_scope = complete_scope
        self.started_before = started_before
        self.started_after = started_after
        self.finished_before = finished_before
        self.finished_after = finished_after
        self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        if sorting is not None:
            self.sorting = sorting

    @property
    def activity_instance_id(self):
        """Gets the activity_instance_id of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Filter by activity instance id.  # noqa: E501

        :return: The activity_instance_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_instance_id

    @activity_instance_id.setter
    def activity_instance_id(self, activity_instance_id):
        """Sets the activity_instance_id of this HistoricActivityInstanceQueryDto.

        Filter by activity instance id.  # noqa: E501

        :param activity_instance_id: The activity_instance_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._activity_instance_id = activity_instance_id

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Filter by process instance id.  # noqa: E501

        :return: The process_instance_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricActivityInstanceQueryDto.

        Filter by process instance id.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Filter by process definition id.  # noqa: E501

        :return: The process_definition_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricActivityInstanceQueryDto.

        Filter by process definition id.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def execution_id(self):
        """Gets the execution_id of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Filter by the id of the execution that executed the activity instance.  # noqa: E501

        :return: The execution_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this HistoricActivityInstanceQueryDto.

        Filter by the id of the execution that executed the activity instance.  # noqa: E501

        :param execution_id: The execution_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def activity_id(self):
        """Gets the activity_id of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Filter by the activity id (according to BPMN 2.0 XML).  # noqa: E501

        :return: The activity_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this HistoricActivityInstanceQueryDto.

        Filter by the activity id (according to BPMN 2.0 XML).  # noqa: E501

        :param activity_id: The activity_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def activity_name(self):
        """Gets the activity_name of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Filter by the activity name (according to BPMN 2.0 XML).  # noqa: E501

        :return: The activity_name of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_name

    @activity_name.setter
    def activity_name(self, activity_name):
        """Sets the activity_name of this HistoricActivityInstanceQueryDto.

        Filter by the activity name (according to BPMN 2.0 XML).  # noqa: E501

        :param activity_name: The activity_name of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._activity_name = activity_name

    @property
    def activity_type(self):
        """Gets the activity_type of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Filter by activity type.  # noqa: E501

        :return: The activity_type of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_type

    @activity_type.setter
    def activity_type(self, activity_type):
        """Sets the activity_type of this HistoricActivityInstanceQueryDto.

        Filter by activity type.  # noqa: E501

        :param activity_type: The activity_type of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._activity_type = activity_type

    @property
    def task_assignee(self):
        """Gets the task_assignee of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Only include activity instances that are user tasks and assigned to a given user.  # noqa: E501

        :return: The task_assignee of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_assignee

    @task_assignee.setter
    def task_assignee(self, task_assignee):
        """Sets the task_assignee of this HistoricActivityInstanceQueryDto.

        Only include activity instances that are user tasks and assigned to a given user.  # noqa: E501

        :param task_assignee: The task_assignee of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_assignee = task_assignee

    @property
    def finished(self):
        """Gets the finished of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Only include finished activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.  # noqa: E501

        :return: The finished of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._finished

    @finished.setter
    def finished(self, finished):
        """Sets the finished of this HistoricActivityInstanceQueryDto.

        Only include finished activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.  # noqa: E501

        :param finished: The finished of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._finished = finished

    @property
    def unfinished(self):
        """Gets the unfinished of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Only include unfinished activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.  # noqa: E501

        :return: The unfinished of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._unfinished

    @unfinished.setter
    def unfinished(self, unfinished):
        """Sets the unfinished of this HistoricActivityInstanceQueryDto.

        Only include unfinished activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.  # noqa: E501

        :param unfinished: The unfinished of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._unfinished = unfinished

    @property
    def canceled(self):
        """Gets the canceled of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Only include canceled activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.  # noqa: E501

        :return: The canceled of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._canceled

    @canceled.setter
    def canceled(self, canceled):
        """Sets the canceled of this HistoricActivityInstanceQueryDto.

        Only include canceled activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.  # noqa: E501

        :param canceled: The canceled of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._canceled = canceled

    @property
    def complete_scope(self):
        """Gets the complete_scope of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Only include activity instances which completed a scope. Value may only be `true`, as `false` behaves the same as when the property is not set.  # noqa: E501

        :return: The complete_scope of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._complete_scope

    @complete_scope.setter
    def complete_scope(self, complete_scope):
        """Sets the complete_scope of this HistoricActivityInstanceQueryDto.

        Only include activity instances which completed a scope. Value may only be `true`, as `false` behaves the same as when the property is not set.  # noqa: E501

        :param complete_scope: The complete_scope of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._complete_scope = complete_scope

    @property
    def started_before(self):
        """Gets the started_before of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The started_before of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._started_before

    @started_before.setter
    def started_before(self, started_before):
        """Sets the started_before of this HistoricActivityInstanceQueryDto.

        Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param started_before: The started_before of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._started_before = started_before

    @property
    def started_after(self):
        """Gets the started_after of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The started_after of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._started_after

    @started_after.setter
    def started_after(self, started_after):
        """Sets the started_after of this HistoricActivityInstanceQueryDto.

        Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param started_after: The started_after of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._started_after = started_after

    @property
    def finished_before(self):
        """Gets the finished_before of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The finished_before of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._finished_before

    @finished_before.setter
    def finished_before(self, finished_before):
        """Sets the finished_before of this HistoricActivityInstanceQueryDto.

        Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param finished_before: The finished_before of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._finished_before = finished_before

    @property
    def finished_after(self):
        """Gets the finished_after of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The finished_after of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._finished_after

    @finished_after.setter
    def finished_after(self, finished_after):
        """Sets the finished_after of this HistoricActivityInstanceQueryDto.

        Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param finished_after: The finished_after of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._finished_after = finished_after

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Must be a JSON array of Strings. An activity instance must have one of the given tenant ids.  # noqa: E501

        :return: The tenant_id_in of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this HistoricActivityInstanceQueryDto.

        Must be a JSON array of Strings. An activity instance must have one of the given tenant ids.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Only include historic activity instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this HistoricActivityInstanceQueryDto.

        Only include historic activity instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def sorting(self):
        """Gets the sorting of this HistoricActivityInstanceQueryDto.  # noqa: E501

        Apply sorting of the result  # noqa: E501

        :return: The sorting of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :rtype: list[HistoricActivityInstanceQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this HistoricActivityInstanceQueryDto.

        Apply sorting of the result  # noqa: E501

        :param sorting: The sorting of this HistoricActivityInstanceQueryDto.  # noqa: E501
        :type: list[HistoricActivityInstanceQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricActivityInstanceQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricActivityInstanceQueryDto):
            return True

        return self.to_dict() != other.to_dict()
