# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class ExecutionQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'business_key': 'str',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'process_instance_id': 'str',
        'activity_id': 'str',
        'signal_event_subscription_name': 'str',
        'message_event_subscription_name': 'str',
        'active': 'bool',
        'suspended': 'bool',
        'incident_id': 'str',
        'incident_type': 'str',
        'incident_message': 'str',
        'incident_message_like': 'str',
        'tenant_id_in': 'list[str]',
        'variables': 'list[VariableQueryParameterDto]',
        'process_variables': 'list[VariableQueryParameterDto]',
        'variable_names_ignore_case': 'bool',
        'variable_values_ignore_case': 'bool',
        'sorting': 'list[ExecutionQueryDtoSorting]'
    }

    attribute_map = {
        'business_key': 'businessKey',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'process_instance_id': 'processInstanceId',
        'activity_id': 'activityId',
        'signal_event_subscription_name': 'signalEventSubscriptionName',
        'message_event_subscription_name': 'messageEventSubscriptionName',
        'active': 'active',
        'suspended': 'suspended',
        'incident_id': 'incidentId',
        'incident_type': 'incidentType',
        'incident_message': 'incidentMessage',
        'incident_message_like': 'incidentMessageLike',
        'tenant_id_in': 'tenantIdIn',
        'variables': 'variables',
        'process_variables': 'processVariables',
        'variable_names_ignore_case': 'variableNamesIgnoreCase',
        'variable_values_ignore_case': 'variableValuesIgnoreCase',
        'sorting': 'sorting'
    }

    def __init__(self, business_key=None, process_definition_id=None, process_definition_key=None, process_instance_id=None, activity_id=None, signal_event_subscription_name=None, message_event_subscription_name=None, active=None, suspended=None, incident_id=None, incident_type=None, incident_message=None, incident_message_like=None, tenant_id_in=None, variables=None, process_variables=None, variable_names_ignore_case=None, variable_values_ignore_case=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """ExecutionQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._business_key = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._process_instance_id = None
        self._activity_id = None
        self._signal_event_subscription_name = None
        self._message_event_subscription_name = None
        self._active = None
        self._suspended = None
        self._incident_id = None
        self._incident_type = None
        self._incident_message = None
        self._incident_message_like = None
        self._tenant_id_in = None
        self._variables = None
        self._process_variables = None
        self._variable_names_ignore_case = None
        self._variable_values_ignore_case = None
        self._sorting = None
        self.discriminator = None

        self.business_key = business_key
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.process_instance_id = process_instance_id
        self.activity_id = activity_id
        self.signal_event_subscription_name = signal_event_subscription_name
        self.message_event_subscription_name = message_event_subscription_name
        self.active = active
        self.suspended = suspended
        self.incident_id = incident_id
        self.incident_type = incident_type
        self.incident_message = incident_message
        self.incident_message_like = incident_message_like
        self.tenant_id_in = tenant_id_in
        self.variables = variables
        self.process_variables = process_variables
        self.variable_names_ignore_case = variable_names_ignore_case
        self.variable_values_ignore_case = variable_values_ignore_case
        if sorting is not None:
            self.sorting = sorting

    @property
    def business_key(self):
        """Gets the business_key of this ExecutionQueryDto.  # noqa: E501

        Filter by the business key of the process instances the executions belong to.  # noqa: E501

        :return: The business_key of this ExecutionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._business_key

    @business_key.setter
    def business_key(self, business_key):
        """Sets the business_key of this ExecutionQueryDto.

        Filter by the business key of the process instances the executions belong to.  # noqa: E501

        :param business_key: The business_key of this ExecutionQueryDto.  # noqa: E501
        :type: str
        """

        self._business_key = business_key

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this ExecutionQueryDto.  # noqa: E501

        Filter by the process definition the executions run on.  # noqa: E501

        :return: The process_definition_id of this ExecutionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this ExecutionQueryDto.

        Filter by the process definition the executions run on.  # noqa: E501

        :param process_definition_id: The process_definition_id of this ExecutionQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this ExecutionQueryDto.  # noqa: E501

        Filter by the key of the process definition the executions run on.  # noqa: E501

        :return: The process_definition_key of this ExecutionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this ExecutionQueryDto.

        Filter by the key of the process definition the executions run on.  # noqa: E501

        :param process_definition_key: The process_definition_key of this ExecutionQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this ExecutionQueryDto.  # noqa: E501

        Filter by the id of the process instance the execution belongs to.  # noqa: E501

        :return: The process_instance_id of this ExecutionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this ExecutionQueryDto.

        Filter by the id of the process instance the execution belongs to.  # noqa: E501

        :param process_instance_id: The process_instance_id of this ExecutionQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def activity_id(self):
        """Gets the activity_id of this ExecutionQueryDto.  # noqa: E501

        Filter by the id of the activity the execution currently executes.  # noqa: E501

        :return: The activity_id of this ExecutionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this ExecutionQueryDto.

        Filter by the id of the activity the execution currently executes.  # noqa: E501

        :param activity_id: The activity_id of this ExecutionQueryDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def signal_event_subscription_name(self):
        """Gets the signal_event_subscription_name of this ExecutionQueryDto.  # noqa: E501

        Select only those executions that expect a signal of the given name.  # noqa: E501

        :return: The signal_event_subscription_name of this ExecutionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._signal_event_subscription_name

    @signal_event_subscription_name.setter
    def signal_event_subscription_name(self, signal_event_subscription_name):
        """Sets the signal_event_subscription_name of this ExecutionQueryDto.

        Select only those executions that expect a signal of the given name.  # noqa: E501

        :param signal_event_subscription_name: The signal_event_subscription_name of this ExecutionQueryDto.  # noqa: E501
        :type: str
        """

        self._signal_event_subscription_name = signal_event_subscription_name

    @property
    def message_event_subscription_name(self):
        """Gets the message_event_subscription_name of this ExecutionQueryDto.  # noqa: E501

        Select only those executions that expect a message of the given name.  # noqa: E501

        :return: The message_event_subscription_name of this ExecutionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._message_event_subscription_name

    @message_event_subscription_name.setter
    def message_event_subscription_name(self, message_event_subscription_name):
        """Sets the message_event_subscription_name of this ExecutionQueryDto.

        Select only those executions that expect a message of the given name.  # noqa: E501

        :param message_event_subscription_name: The message_event_subscription_name of this ExecutionQueryDto.  # noqa: E501
        :type: str
        """

        self._message_event_subscription_name = message_event_subscription_name

    @property
    def active(self):
        """Gets the active of this ExecutionQueryDto.  # noqa: E501

        Only include active executions. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The active of this ExecutionQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this ExecutionQueryDto.

        Only include active executions. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param active: The active of this ExecutionQueryDto.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def suspended(self):
        """Gets the suspended of this ExecutionQueryDto.  # noqa: E501

        Only include suspended executions. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The suspended of this ExecutionQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this ExecutionQueryDto.

        Only include suspended executions. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param suspended: The suspended of this ExecutionQueryDto.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    @property
    def incident_id(self):
        """Gets the incident_id of this ExecutionQueryDto.  # noqa: E501

        Filter by the incident id.  # noqa: E501

        :return: The incident_id of this ExecutionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_id

    @incident_id.setter
    def incident_id(self, incident_id):
        """Sets the incident_id of this ExecutionQueryDto.

        Filter by the incident id.  # noqa: E501

        :param incident_id: The incident_id of this ExecutionQueryDto.  # noqa: E501
        :type: str
        """

        self._incident_id = incident_id

    @property
    def incident_type(self):
        """Gets the incident_type of this ExecutionQueryDto.  # noqa: E501

        Filter by the incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types.  # noqa: E501

        :return: The incident_type of this ExecutionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_type

    @incident_type.setter
    def incident_type(self, incident_type):
        """Sets the incident_type of this ExecutionQueryDto.

        Filter by the incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types.  # noqa: E501

        :param incident_type: The incident_type of this ExecutionQueryDto.  # noqa: E501
        :type: str
        """

        self._incident_type = incident_type

    @property
    def incident_message(self):
        """Gets the incident_message of this ExecutionQueryDto.  # noqa: E501

        Filter by the incident message. Exact match.  # noqa: E501

        :return: The incident_message of this ExecutionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_message

    @incident_message.setter
    def incident_message(self, incident_message):
        """Sets the incident_message of this ExecutionQueryDto.

        Filter by the incident message. Exact match.  # noqa: E501

        :param incident_message: The incident_message of this ExecutionQueryDto.  # noqa: E501
        :type: str
        """

        self._incident_message = incident_message

    @property
    def incident_message_like(self):
        """Gets the incident_message_like of this ExecutionQueryDto.  # noqa: E501

        Filter by the incident message that the parameter is a substring of.  # noqa: E501

        :return: The incident_message_like of this ExecutionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_message_like

    @incident_message_like.setter
    def incident_message_like(self, incident_message_like):
        """Sets the incident_message_like of this ExecutionQueryDto.

        Filter by the incident message that the parameter is a substring of.  # noqa: E501

        :param incident_message_like: The incident_message_like of this ExecutionQueryDto.  # noqa: E501
        :type: str
        """

        self._incident_message_like = incident_message_like

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this ExecutionQueryDto.  # noqa: E501

        Filter by a  list of tenant ids. An execution must have one of the given tenant ids.  # noqa: E501

        :return: The tenant_id_in of this ExecutionQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this ExecutionQueryDto.

        Filter by a  list of tenant ids. An execution must have one of the given tenant ids.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this ExecutionQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def variables(self):
        """Gets the variables of this ExecutionQueryDto.  # noqa: E501

        An array to only include executions that have variables with certain values.  The array consists of objects with the three properties `name`, `operator` and `value`. `name (String)` is the variable name, `operator (String)` is the comparison operator to be used and `value` the variable value. `value` may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.  # noqa: E501

        :return: The variables of this ExecutionQueryDto.  # noqa: E501
        :rtype: list[VariableQueryParameterDto]
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """Sets the variables of this ExecutionQueryDto.

        An array to only include executions that have variables with certain values.  The array consists of objects with the three properties `name`, `operator` and `value`. `name (String)` is the variable name, `operator (String)` is the comparison operator to be used and `value` the variable value. `value` may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.  # noqa: E501

        :param variables: The variables of this ExecutionQueryDto.  # noqa: E501
        :type: list[VariableQueryParameterDto]
        """

        self._variables = variables

    @property
    def process_variables(self):
        """Gets the process_variables of this ExecutionQueryDto.  # noqa: E501

        An array to only include executions that belong to a process instance with variables with certain values.  The array consists of objects with the three properties `name`, `operator` and `value`. `name (String)` is the variable name, `operator (String)` is the comparison operator to be used and `value` the variable value. `value` may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to.  # noqa: E501

        :return: The process_variables of this ExecutionQueryDto.  # noqa: E501
        :rtype: list[VariableQueryParameterDto]
        """
        return self._process_variables

    @process_variables.setter
    def process_variables(self, process_variables):
        """Sets the process_variables of this ExecutionQueryDto.

        An array to only include executions that belong to a process instance with variables with certain values.  The array consists of objects with the three properties `name`, `operator` and `value`. `name (String)` is the variable name, `operator (String)` is the comparison operator to be used and `value` the variable value. `value` may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to.  # noqa: E501

        :param process_variables: The process_variables of this ExecutionQueryDto.  # noqa: E501
        :type: list[VariableQueryParameterDto]
        """

        self._process_variables = process_variables

    @property
    def variable_names_ignore_case(self):
        """Gets the variable_names_ignore_case of this ExecutionQueryDto.  # noqa: E501

        Match all variable names provided in `variables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.  # noqa: E501

        :return: The variable_names_ignore_case of this ExecutionQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._variable_names_ignore_case

    @variable_names_ignore_case.setter
    def variable_names_ignore_case(self, variable_names_ignore_case):
        """Sets the variable_names_ignore_case of this ExecutionQueryDto.

        Match all variable names provided in `variables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.  # noqa: E501

        :param variable_names_ignore_case: The variable_names_ignore_case of this ExecutionQueryDto.  # noqa: E501
        :type: bool
        """

        self._variable_names_ignore_case = variable_names_ignore_case

    @property
    def variable_values_ignore_case(self):
        """Gets the variable_values_ignore_case of this ExecutionQueryDto.  # noqa: E501

        Match all variable values provided in `variables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.  # noqa: E501

        :return: The variable_values_ignore_case of this ExecutionQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._variable_values_ignore_case

    @variable_values_ignore_case.setter
    def variable_values_ignore_case(self, variable_values_ignore_case):
        """Sets the variable_values_ignore_case of this ExecutionQueryDto.

        Match all variable values provided in `variables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.  # noqa: E501

        :param variable_values_ignore_case: The variable_values_ignore_case of this ExecutionQueryDto.  # noqa: E501
        :type: bool
        """

        self._variable_values_ignore_case = variable_values_ignore_case

    @property
    def sorting(self):
        """Gets the sorting of this ExecutionQueryDto.  # noqa: E501

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the `/count` endpoint  # noqa: E501

        :return: The sorting of this ExecutionQueryDto.  # noqa: E501
        :rtype: list[ExecutionQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this ExecutionQueryDto.

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the `/count` endpoint  # noqa: E501

        :param sorting: The sorting of this ExecutionQueryDto.  # noqa: E501
        :type: list[ExecutionQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExecutionQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExecutionQueryDto):
            return True

        return self.to_dict() != other.to_dict()
