# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class EvaluationConditionDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'variables': 'dict(str, VariableValueDto)',
        'business_key': 'str',
        'tenant_id': 'str',
        'without_tenant_id': 'bool',
        'process_definition_id': 'str'
    }

    attribute_map = {
        'variables': 'variables',
        'business_key': 'businessKey',
        'tenant_id': 'tenantId',
        'without_tenant_id': 'withoutTenantId',
        'process_definition_id': 'processDefinitionId'
    }

    def __init__(self, variables=None, business_key=None, tenant_id=None, without_tenant_id=None, process_definition_id=None, local_vars_configuration=None):  # noqa: E501
        """EvaluationConditionDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._variables = None
        self._business_key = None
        self._tenant_id = None
        self._without_tenant_id = None
        self._process_definition_id = None
        self.discriminator = None

        self.variables = variables
        self.business_key = business_key
        self.tenant_id = tenant_id
        self.without_tenant_id = without_tenant_id
        self.process_definition_id = process_definition_id

    @property
    def variables(self):
        """Gets the variables of this EvaluationConditionDto.  # noqa: E501

        A map of variables which are used for evaluation of the conditions and are injected into the process instances which have been triggered. Each key is a variable name and each value a JSON variable value object with the following properties.  # noqa: E501

        :return: The variables of this EvaluationConditionDto.  # noqa: E501
        :rtype: dict(str, VariableValueDto)
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """Sets the variables of this EvaluationConditionDto.

        A map of variables which are used for evaluation of the conditions and are injected into the process instances which have been triggered. Each key is a variable name and each value a JSON variable value object with the following properties.  # noqa: E501

        :param variables: The variables of this EvaluationConditionDto.  # noqa: E501
        :type: dict(str, VariableValueDto)
        """

        self._variables = variables

    @property
    def business_key(self):
        """Gets the business_key of this EvaluationConditionDto.  # noqa: E501

        Used for the process instances that have been triggered after the evaluation.  # noqa: E501

        :return: The business_key of this EvaluationConditionDto.  # noqa: E501
        :rtype: str
        """
        return self._business_key

    @business_key.setter
    def business_key(self, business_key):
        """Sets the business_key of this EvaluationConditionDto.

        Used for the process instances that have been triggered after the evaluation.  # noqa: E501

        :param business_key: The business_key of this EvaluationConditionDto.  # noqa: E501
        :type: str
        """

        self._business_key = business_key

    @property
    def tenant_id(self):
        """Gets the tenant_id of this EvaluationConditionDto.  # noqa: E501

        Used to evaluate a condition for a tenant with the given id. Will only evaluate conditions of process definitions which belong to the tenant.  # noqa: E501

        :return: The tenant_id of this EvaluationConditionDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this EvaluationConditionDto.

        Used to evaluate a condition for a tenant with the given id. Will only evaluate conditions of process definitions which belong to the tenant.  # noqa: E501

        :param tenant_id: The tenant_id of this EvaluationConditionDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this EvaluationConditionDto.  # noqa: E501

        A Boolean value that indicates whether the conditions should only be evaluated of process definitions which belong to no tenant or not. Value may only be true, as false is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this EvaluationConditionDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this EvaluationConditionDto.

        A Boolean value that indicates whether the conditions should only be evaluated of process definitions which belong to no tenant or not. Value may only be true, as false is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this EvaluationConditionDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this EvaluationConditionDto.  # noqa: E501

        Used to evaluate conditions of the process definition with the given id.  # noqa: E501

        :return: The process_definition_id of this EvaluationConditionDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this EvaluationConditionDto.

        Used to evaluate conditions of the process definition with the given id.  # noqa: E501

        :param process_definition_id: The process_definition_id of this EvaluationConditionDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EvaluationConditionDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EvaluationConditionDto):
            return True

        return self.to_dict() != other.to_dict()
