# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class DecisionDefinitionDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'key': 'str',
        'category': 'str',
        'name': 'str',
        'version': 'int',
        'resource': 'str',
        'deployment_id': 'str',
        'tenant_id': 'str',
        'decision_requirements_definition_id': 'str',
        'decision_requirements_definition_key': 'str',
        'history_time_to_live': 'int',
        'version_tag': 'str'
    }

    attribute_map = {
        'id': 'id',
        'key': 'key',
        'category': 'category',
        'name': 'name',
        'version': 'version',
        'resource': 'resource',
        'deployment_id': 'deploymentId',
        'tenant_id': 'tenantId',
        'decision_requirements_definition_id': 'decisionRequirementsDefinitionId',
        'decision_requirements_definition_key': 'decisionRequirementsDefinitionKey',
        'history_time_to_live': 'historyTimeToLive',
        'version_tag': 'versionTag'
    }

    def __init__(self, id=None, key=None, category=None, name=None, version=None, resource=None, deployment_id=None, tenant_id=None, decision_requirements_definition_id=None, decision_requirements_definition_key=None, history_time_to_live=None, version_tag=None, local_vars_configuration=None):  # noqa: E501
        """DecisionDefinitionDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._key = None
        self._category = None
        self._name = None
        self._version = None
        self._resource = None
        self._deployment_id = None
        self._tenant_id = None
        self._decision_requirements_definition_id = None
        self._decision_requirements_definition_key = None
        self._history_time_to_live = None
        self._version_tag = None
        self.discriminator = None

        self.id = id
        self.key = key
        self.category = category
        self.name = name
        self.version = version
        self.resource = resource
        self.deployment_id = deployment_id
        self.tenant_id = tenant_id
        self.decision_requirements_definition_id = decision_requirements_definition_id
        self.decision_requirements_definition_key = decision_requirements_definition_key
        self.history_time_to_live = history_time_to_live
        self.version_tag = version_tag

    @property
    def id(self):
        """Gets the id of this DecisionDefinitionDto.  # noqa: E501

        The id of the decision definition  # noqa: E501

        :return: The id of this DecisionDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DecisionDefinitionDto.

        The id of the decision definition  # noqa: E501

        :param id: The id of this DecisionDefinitionDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def key(self):
        """Gets the key of this DecisionDefinitionDto.  # noqa: E501

        The key of the decision definition, i.e., the id of the DMN 1.0 XML decision definition.  # noqa: E501

        :return: The key of this DecisionDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this DecisionDefinitionDto.

        The key of the decision definition, i.e., the id of the DMN 1.0 XML decision definition.  # noqa: E501

        :param key: The key of this DecisionDefinitionDto.  # noqa: E501
        :type: str
        """

        self._key = key

    @property
    def category(self):
        """Gets the category of this DecisionDefinitionDto.  # noqa: E501

        The category of the decision definition.  # noqa: E501

        :return: The category of this DecisionDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this DecisionDefinitionDto.

        The category of the decision definition.  # noqa: E501

        :param category: The category of this DecisionDefinitionDto.  # noqa: E501
        :type: str
        """

        self._category = category

    @property
    def name(self):
        """Gets the name of this DecisionDefinitionDto.  # noqa: E501

        The name of the decision definition.  # noqa: E501

        :return: The name of this DecisionDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DecisionDefinitionDto.

        The name of the decision definition.  # noqa: E501

        :param name: The name of this DecisionDefinitionDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def version(self):
        """Gets the version of this DecisionDefinitionDto.  # noqa: E501

        The version of the decision definition that the engine assigned to it.  # noqa: E501

        :return: The version of this DecisionDefinitionDto.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this DecisionDefinitionDto.

        The version of the decision definition that the engine assigned to it.  # noqa: E501

        :param version: The version of this DecisionDefinitionDto.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def resource(self):
        """Gets the resource of this DecisionDefinitionDto.  # noqa: E501

        The file name of the decision definition.  # noqa: E501

        :return: The resource of this DecisionDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """Sets the resource of this DecisionDefinitionDto.

        The file name of the decision definition.  # noqa: E501

        :param resource: The resource of this DecisionDefinitionDto.  # noqa: E501
        :type: str
        """

        self._resource = resource

    @property
    def deployment_id(self):
        """Gets the deployment_id of this DecisionDefinitionDto.  # noqa: E501

        The deployment id of the decision definition.  # noqa: E501

        :return: The deployment_id of this DecisionDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._deployment_id

    @deployment_id.setter
    def deployment_id(self, deployment_id):
        """Sets the deployment_id of this DecisionDefinitionDto.

        The deployment id of the decision definition.  # noqa: E501

        :param deployment_id: The deployment_id of this DecisionDefinitionDto.  # noqa: E501
        :type: str
        """

        self._deployment_id = deployment_id

    @property
    def tenant_id(self):
        """Gets the tenant_id of this DecisionDefinitionDto.  # noqa: E501

        The tenant id of the decision definition.  # noqa: E501

        :return: The tenant_id of this DecisionDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this DecisionDefinitionDto.

        The tenant id of the decision definition.  # noqa: E501

        :param tenant_id: The tenant_id of this DecisionDefinitionDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def decision_requirements_definition_id(self):
        """Gets the decision_requirements_definition_id of this DecisionDefinitionDto.  # noqa: E501

        The id of the decision requirements definition this decision definition belongs to.  # noqa: E501

        :return: The decision_requirements_definition_id of this DecisionDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._decision_requirements_definition_id

    @decision_requirements_definition_id.setter
    def decision_requirements_definition_id(self, decision_requirements_definition_id):
        """Sets the decision_requirements_definition_id of this DecisionDefinitionDto.

        The id of the decision requirements definition this decision definition belongs to.  # noqa: E501

        :param decision_requirements_definition_id: The decision_requirements_definition_id of this DecisionDefinitionDto.  # noqa: E501
        :type: str
        """

        self._decision_requirements_definition_id = decision_requirements_definition_id

    @property
    def decision_requirements_definition_key(self):
        """Gets the decision_requirements_definition_key of this DecisionDefinitionDto.  # noqa: E501

        The key of the decision requirements definition this decision definition belongs to.  # noqa: E501

        :return: The decision_requirements_definition_key of this DecisionDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._decision_requirements_definition_key

    @decision_requirements_definition_key.setter
    def decision_requirements_definition_key(self, decision_requirements_definition_key):
        """Sets the decision_requirements_definition_key of this DecisionDefinitionDto.

        The key of the decision requirements definition this decision definition belongs to.  # noqa: E501

        :param decision_requirements_definition_key: The decision_requirements_definition_key of this DecisionDefinitionDto.  # noqa: E501
        :type: str
        """

        self._decision_requirements_definition_key = decision_requirements_definition_key

    @property
    def history_time_to_live(self):
        """Gets the history_time_to_live of this DecisionDefinitionDto.  # noqa: E501

        History time to live value of the decision definition. Is used within [History cleanup](https://docs.camunda.org/manual/7.15/user-guide/process-engine/history/#history-cleanup).  # noqa: E501

        :return: The history_time_to_live of this DecisionDefinitionDto.  # noqa: E501
        :rtype: int
        """
        return self._history_time_to_live

    @history_time_to_live.setter
    def history_time_to_live(self, history_time_to_live):
        """Sets the history_time_to_live of this DecisionDefinitionDto.

        History time to live value of the decision definition. Is used within [History cleanup](https://docs.camunda.org/manual/7.15/user-guide/process-engine/history/#history-cleanup).  # noqa: E501

        :param history_time_to_live: The history_time_to_live of this DecisionDefinitionDto.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                history_time_to_live is not None and history_time_to_live < 0):  # noqa: E501
            raise ValueError("Invalid value for `history_time_to_live`, must be a value greater than or equal to `0`")  # noqa: E501

        self._history_time_to_live = history_time_to_live

    @property
    def version_tag(self):
        """Gets the version_tag of this DecisionDefinitionDto.  # noqa: E501

        The version tag of the decision definition.  # noqa: E501

        :return: The version_tag of this DecisionDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._version_tag

    @version_tag.setter
    def version_tag(self, version_tag):
        """Sets the version_tag of this DecisionDefinitionDto.

        The version tag of the decision definition.  # noqa: E501

        :param version_tag: The version_tag of this DecisionDefinitionDto.  # noqa: E501
        :type: str
        """

        self._version_tag = version_tag

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DecisionDefinitionDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DecisionDefinitionDto):
            return True

        return self.to_dict() != other.to_dict()
