# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class CorrelationMessageDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'message_name': 'str',
        'business_key': 'str',
        'tenant_id': 'str',
        'without_tenant_id': 'bool',
        'process_instance_id': 'str',
        'correlation_keys': 'dict(str, VariableValueDto)',
        'local_correlation_keys': 'dict(str, VariableValueDto)',
        'process_variables': 'dict(str, VariableValueDto)',
        'process_variables_local': 'dict(str, VariableValueDto)',
        'all': 'bool',
        'result_enabled': 'bool',
        'variables_in_result_enabled': 'bool'
    }

    attribute_map = {
        'message_name': 'messageName',
        'business_key': 'businessKey',
        'tenant_id': 'tenantId',
        'without_tenant_id': 'withoutTenantId',
        'process_instance_id': 'processInstanceId',
        'correlation_keys': 'correlationKeys',
        'local_correlation_keys': 'localCorrelationKeys',
        'process_variables': 'processVariables',
        'process_variables_local': 'processVariablesLocal',
        'all': 'all',
        'result_enabled': 'resultEnabled',
        'variables_in_result_enabled': 'variablesInResultEnabled'
    }

    def __init__(self, message_name=None, business_key=None, tenant_id=None, without_tenant_id=False, process_instance_id=None, correlation_keys=None, local_correlation_keys=None, process_variables=None, process_variables_local=None, all=False, result_enabled=False, variables_in_result_enabled=False, local_vars_configuration=None):  # noqa: E501
        """CorrelationMessageDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._message_name = None
        self._business_key = None
        self._tenant_id = None
        self._without_tenant_id = None
        self._process_instance_id = None
        self._correlation_keys = None
        self._local_correlation_keys = None
        self._process_variables = None
        self._process_variables_local = None
        self._all = None
        self._result_enabled = None
        self._variables_in_result_enabled = None
        self.discriminator = None

        self.message_name = message_name
        self.business_key = business_key
        self.tenant_id = tenant_id
        self.without_tenant_id = without_tenant_id
        self.process_instance_id = process_instance_id
        self.correlation_keys = correlation_keys
        self.local_correlation_keys = local_correlation_keys
        self.process_variables = process_variables
        self.process_variables_local = process_variables_local
        self.all = all
        self.result_enabled = result_enabled
        self.variables_in_result_enabled = variables_in_result_enabled

    @property
    def message_name(self):
        """Gets the message_name of this CorrelationMessageDto.  # noqa: E501

        The name of the message to deliver.  # noqa: E501

        :return: The message_name of this CorrelationMessageDto.  # noqa: E501
        :rtype: str
        """
        return self._message_name

    @message_name.setter
    def message_name(self, message_name):
        """Sets the message_name of this CorrelationMessageDto.

        The name of the message to deliver.  # noqa: E501

        :param message_name: The message_name of this CorrelationMessageDto.  # noqa: E501
        :type: str
        """

        self._message_name = message_name

    @property
    def business_key(self):
        """Gets the business_key of this CorrelationMessageDto.  # noqa: E501

        Used for correlation of process instances that wait for incoming messages. Will only correlate to executions that belong to a process instance with the provided business key.  # noqa: E501

        :return: The business_key of this CorrelationMessageDto.  # noqa: E501
        :rtype: str
        """
        return self._business_key

    @business_key.setter
    def business_key(self, business_key):
        """Sets the business_key of this CorrelationMessageDto.

        Used for correlation of process instances that wait for incoming messages. Will only correlate to executions that belong to a process instance with the provided business key.  # noqa: E501

        :param business_key: The business_key of this CorrelationMessageDto.  # noqa: E501
        :type: str
        """

        self._business_key = business_key

    @property
    def tenant_id(self):
        """Gets the tenant_id of this CorrelationMessageDto.  # noqa: E501

        Used to correlate the message for a tenant with the given id. Will only correlate to executions and process definitions which belong to the tenant. Must not be supplied in conjunction with a `withoutTenantId`.  # noqa: E501

        :return: The tenant_id of this CorrelationMessageDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this CorrelationMessageDto.

        Used to correlate the message for a tenant with the given id. Will only correlate to executions and process definitions which belong to the tenant. Must not be supplied in conjunction with a `withoutTenantId`.  # noqa: E501

        :param tenant_id: The tenant_id of this CorrelationMessageDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this CorrelationMessageDto.  # noqa: E501

        A Boolean value that indicates whether the message should only be correlated to executions and process definitions which belong to no tenant or not. Value may only be `true`, as `false` is the default behavior. Must not be supplied in conjunction with a `tenantId`.  # noqa: E501

        :return: The without_tenant_id of this CorrelationMessageDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this CorrelationMessageDto.

        A Boolean value that indicates whether the message should only be correlated to executions and process definitions which belong to no tenant or not. Value may only be `true`, as `false` is the default behavior. Must not be supplied in conjunction with a `tenantId`.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this CorrelationMessageDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this CorrelationMessageDto.  # noqa: E501

        Used to correlate the message to the process instance with the given id.  # noqa: E501

        :return: The process_instance_id of this CorrelationMessageDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this CorrelationMessageDto.

        Used to correlate the message to the process instance with the given id.  # noqa: E501

        :param process_instance_id: The process_instance_id of this CorrelationMessageDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def correlation_keys(self):
        """Gets the correlation_keys of this CorrelationMessageDto.  # noqa: E501

        Used for correlation of process instances that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against process instance variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.  # noqa: E501

        :return: The correlation_keys of this CorrelationMessageDto.  # noqa: E501
        :rtype: dict(str, VariableValueDto)
        """
        return self._correlation_keys

    @correlation_keys.setter
    def correlation_keys(self, correlation_keys):
        """Sets the correlation_keys of this CorrelationMessageDto.

        Used for correlation of process instances that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against process instance variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.  # noqa: E501

        :param correlation_keys: The correlation_keys of this CorrelationMessageDto.  # noqa: E501
        :type: dict(str, VariableValueDto)
        """

        self._correlation_keys = correlation_keys

    @property
    def local_correlation_keys(self):
        """Gets the local_correlation_keys of this CorrelationMessageDto.  # noqa: E501

        Local variables used for correlation of executions (process instances) that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against local variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.  # noqa: E501

        :return: The local_correlation_keys of this CorrelationMessageDto.  # noqa: E501
        :rtype: dict(str, VariableValueDto)
        """
        return self._local_correlation_keys

    @local_correlation_keys.setter
    def local_correlation_keys(self, local_correlation_keys):
        """Sets the local_correlation_keys of this CorrelationMessageDto.

        Local variables used for correlation of executions (process instances) that wait for incoming messages. Has to be a JSON object containing key-value pairs that are matched against local variables during correlation. Each key is a variable name and each value a JSON variable value object with the following properties.  # noqa: E501

        :param local_correlation_keys: The local_correlation_keys of this CorrelationMessageDto.  # noqa: E501
        :type: dict(str, VariableValueDto)
        """

        self._local_correlation_keys = local_correlation_keys

    @property
    def process_variables(self):
        """Gets the process_variables of this CorrelationMessageDto.  # noqa: E501

        A map of variables that is injected into the triggered execution or process instance after the message has been delivered. Each key is a variable name and each value a JSON variable value object with the following properties.  # noqa: E501

        :return: The process_variables of this CorrelationMessageDto.  # noqa: E501
        :rtype: dict(str, VariableValueDto)
        """
        return self._process_variables

    @process_variables.setter
    def process_variables(self, process_variables):
        """Sets the process_variables of this CorrelationMessageDto.

        A map of variables that is injected into the triggered execution or process instance after the message has been delivered. Each key is a variable name and each value a JSON variable value object with the following properties.  # noqa: E501

        :param process_variables: The process_variables of this CorrelationMessageDto.  # noqa: E501
        :type: dict(str, VariableValueDto)
        """

        self._process_variables = process_variables

    @property
    def process_variables_local(self):
        """Gets the process_variables_local of this CorrelationMessageDto.  # noqa: E501

        A map of local variables that is injected into the triggered execution or process instance after the message has been delivered. Each key is a variable name and each value a JSON variable value object with the following properties.  # noqa: E501

        :return: The process_variables_local of this CorrelationMessageDto.  # noqa: E501
        :rtype: dict(str, VariableValueDto)
        """
        return self._process_variables_local

    @process_variables_local.setter
    def process_variables_local(self, process_variables_local):
        """Sets the process_variables_local of this CorrelationMessageDto.

        A map of local variables that is injected into the triggered execution or process instance after the message has been delivered. Each key is a variable name and each value a JSON variable value object with the following properties.  # noqa: E501

        :param process_variables_local: The process_variables_local of this CorrelationMessageDto.  # noqa: E501
        :type: dict(str, VariableValueDto)
        """

        self._process_variables_local = process_variables_local

    @property
    def all(self):
        """Gets the all of this CorrelationMessageDto.  # noqa: E501

        A Boolean value that indicates whether the message should be correlated to exactly one entity or multiple entities. If the value is set to `false`, the message will be correlated to exactly one entity (execution or process definition). If the value is set to `true`, the message will be correlated to multiple executions and a process definition that can be instantiated by this message in one go.  # noqa: E501

        :return: The all of this CorrelationMessageDto.  # noqa: E501
        :rtype: bool
        """
        return self._all

    @all.setter
    def all(self, all):
        """Sets the all of this CorrelationMessageDto.

        A Boolean value that indicates whether the message should be correlated to exactly one entity or multiple entities. If the value is set to `false`, the message will be correlated to exactly one entity (execution or process definition). If the value is set to `true`, the message will be correlated to multiple executions and a process definition that can be instantiated by this message in one go.  # noqa: E501

        :param all: The all of this CorrelationMessageDto.  # noqa: E501
        :type: bool
        """

        self._all = all

    @property
    def result_enabled(self):
        """Gets the result_enabled of this CorrelationMessageDto.  # noqa: E501

        A Boolean value that indicates whether the result of the correlation should be returned or not. If this property is set to `true`, there will be returned a list of message correlation result objects. Depending on the all property, there will be either one ore more returned results in the list.  The default value is `false`, which means no result will be returned.  # noqa: E501

        :return: The result_enabled of this CorrelationMessageDto.  # noqa: E501
        :rtype: bool
        """
        return self._result_enabled

    @result_enabled.setter
    def result_enabled(self, result_enabled):
        """Sets the result_enabled of this CorrelationMessageDto.

        A Boolean value that indicates whether the result of the correlation should be returned or not. If this property is set to `true`, there will be returned a list of message correlation result objects. Depending on the all property, there will be either one ore more returned results in the list.  The default value is `false`, which means no result will be returned.  # noqa: E501

        :param result_enabled: The result_enabled of this CorrelationMessageDto.  # noqa: E501
        :type: bool
        """

        self._result_enabled = result_enabled

    @property
    def variables_in_result_enabled(self):
        """Gets the variables_in_result_enabled of this CorrelationMessageDto.  # noqa: E501

        A Boolean value that indicates whether the result of the correlation should contain process variables or not. The parameter resultEnabled should be set to `true` in order to use this it.  The default value is `false`, which means the variables will not be returned.  # noqa: E501

        :return: The variables_in_result_enabled of this CorrelationMessageDto.  # noqa: E501
        :rtype: bool
        """
        return self._variables_in_result_enabled

    @variables_in_result_enabled.setter
    def variables_in_result_enabled(self, variables_in_result_enabled):
        """Sets the variables_in_result_enabled of this CorrelationMessageDto.

        A Boolean value that indicates whether the result of the correlation should contain process variables or not. The parameter resultEnabled should be set to `true` in order to use this it.  The default value is `false`, which means the variables will not be returned.  # noqa: E501

        :param variables_in_result_enabled: The variables_in_result_enabled of this CorrelationMessageDto.  # noqa: E501
        :type: bool
        """

        self._variables_in_result_enabled = variables_in_result_enabled

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CorrelationMessageDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CorrelationMessageDto):
            return True

        return self.to_dict() != other.to_dict()
