# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TaskApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def claim(self, id, **kwargs):  # noqa: E501
        """Claim  # noqa: E501

        Claims a task for a specific user.  **Note:** The difference with the [Set Assignee](https://docs.camunda.org/manual/7.15/reference/rest/task/post-assignee/) method is that here a check is performed to see if the task already has a user assigned to it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.claim(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to claim. (required)
        :param UserIdDto user_id_dto: Provide the id of the user that claims the task.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.claim_with_http_info(id, **kwargs)  # noqa: E501

    def claim_with_http_info(self, id, **kwargs):  # noqa: E501
        """Claim  # noqa: E501

        Claims a task for a specific user.  **Note:** The difference with the [Set Assignee](https://docs.camunda.org/manual/7.15/reference/rest/task/post-assignee/) method is that here a check is performed to see if the task already has a user assigned to it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.claim_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to claim. (required)
        :param UserIdDto user_id_dto: Provide the id of the user that claims the task.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'user_id_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method claim" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `claim`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_id_dto' in local_var_params:
            body_params = local_var_params['user_id_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/claim', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def complete(self, id, **kwargs):  # noqa: E501
        """Complete  # noqa: E501

        Completes a task and updates process variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to complete. (required)
        :param CompleteTaskDto complete_task_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, VariableValueDto)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.complete_with_http_info(id, **kwargs)  # noqa: E501

    def complete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Complete  # noqa: E501

        Completes a task and updates process variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to complete. (required)
        :param CompleteTaskDto complete_task_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, VariableValueDto), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'complete_task_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `complete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'complete_task_dto' in local_var_params:
            body_params = local_var_params['complete_task_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/complete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, VariableValueDto)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_task(self, **kwargs):  # noqa: E501
        """Create  # noqa: E501

        Creates a new task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_task(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TaskDto task_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_task_with_http_info(**kwargs)  # noqa: E501

    def create_task_with_http_info(self, **kwargs):  # noqa: E501
        """Create  # noqa: E501

        Creates a new task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_task_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TaskDto task_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'task_dto' in local_var_params:
            body_params = local_var_params['task_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delegate_task(self, id, **kwargs):  # noqa: E501
        """Delegate  # noqa: E501

        Delegates a task to another user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delegate_task(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to delegate. (required)
        :param UserIdDto user_id_dto: Provide the id of the user that the task should be delegated to.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delegate_task_with_http_info(id, **kwargs)  # noqa: E501

    def delegate_task_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delegate  # noqa: E501

        Delegates a task to another user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delegate_task_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to delegate. (required)
        :param UserIdDto user_id_dto: Provide the id of the user that the task should be delegated to.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'user_id_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delegate_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delegate_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_id_dto' in local_var_params:
            body_params = local_var_params['user_id_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/delegate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_task(self, id, **kwargs):  # noqa: E501
        """Delete  # noqa: E501

        Removes a task by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_task(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to be removed. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_task_with_http_info(id, **kwargs)  # noqa: E501

    def delete_task_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete  # noqa: E501

        Removes a task by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_task_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to be removed. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_deployed_form(self, id, **kwargs):  # noqa: E501
        """Get Deployed Form  # noqa: E501

        Retrieves the deployed form that is referenced from a given task. For further information please refer to the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/task-forms/#embedded-task-forms).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_form(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to get the deployed form for. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_deployed_form_with_http_info(id, **kwargs)  # noqa: E501

    def get_deployed_form_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Deployed Form  # noqa: E501

        Retrieves the deployed form that is referenced from a given task. For further information please refer to the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/task-forms/#embedded-task-forms).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_form_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to get the deployed form for. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_form" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_deployed_form`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/xhtml+xml', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/deployed-form', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_form(self, id, **kwargs):  # noqa: E501
        """Get Form Key  # noqa: E501

        Retrieves the form key for a task. The form key corresponds to the `FormData#formKey` property in the engine. This key can be used to do task-specific form rendering in client applications. Additionally, the context path of the containing process application is returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_form(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to retrieve the form for. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FormDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_form_with_http_info(id, **kwargs)  # noqa: E501

    def get_form_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Form Key  # noqa: E501

        Retrieves the form key for a task. The form key corresponds to the `FormData#formKey` property in the engine. This key can be used to do task-specific form rendering in client applications. Additionally, the context path of the containing process application is returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_form_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to retrieve the form for. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FormDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_form" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_form`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/form', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FormDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_form_variables(self, id, **kwargs):  # noqa: E501
        """Get Task Form Variables  # noqa: E501

        Retrieves the form variables for a task. The form variables take form data specified on the task into account. If form fields are defined, the variable types and default values of the form fields are taken into account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_form_variables(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to retrieve the variables for. (required)
        :param str variable_names: A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored.
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, VariableValueDto)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_form_variables_with_http_info(id, **kwargs)  # noqa: E501

    def get_form_variables_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Task Form Variables  # noqa: E501

        Retrieves the form variables for a task. The form variables take form data specified on the task into account. If form fields are defined, the variable types and default values of the form fields are taken into account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_form_variables_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to retrieve the variables for. (required)
        :param str variable_names: A comma-separated list of variable names. Allows restricting the list of requested variables to the variable names in the list. It is best practice to restrict the list of variables to the variables actually required by the form in order to minimize fetching of data. If the query parameter is ommitted all variables are fetched. If the query parameter contains non-existent variable names, the variable names are ignored.
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](http://jackson.codehaus.org/) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, VariableValueDto), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'variable_names',
            'deserialize_values'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_form_variables" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_form_variables`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'variable_names' in local_var_params and local_var_params['variable_names'] is not None:  # noqa: E501
            query_params.append(('variableNames', local_var_params['variable_names']))  # noqa: E501
        if 'deserialize_values' in local_var_params and local_var_params['deserialize_values'] is not None:  # noqa: E501
            query_params.append(('deserializeValues', local_var_params['deserialize_values']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/form-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, VariableValueDto)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rendered_form(self, id, **kwargs):  # noqa: E501
        """Get Rendered Form  # noqa: E501

        Retrieves the rendered form for a task. This method can be used to get the HTML rendering of a [Generated Task Form](https://docs.camunda.org/manual/7.15/user-guide/task-forms/#generated-task-forms).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rendered_form(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to get the rendered form for. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_rendered_form_with_http_info(id, **kwargs)  # noqa: E501

    def get_rendered_form_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Rendered Form  # noqa: E501

        Retrieves the rendered form for a task. This method can be used to get the HTML rendering of a [Generated Task Form](https://docs.camunda.org/manual/7.15/user-guide/task-forms/#generated-task-forms).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rendered_form_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to get the rendered form for. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rendered_form" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_rendered_form`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/xhtml+xml', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/rendered-form', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task(self, id, **kwargs):  # noqa: E501
        """Get  # noqa: E501

        Retrieves a task by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to be retrieved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_with_http_info(id, **kwargs)  # noqa: E501

    def get_task_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get  # noqa: E501

        Retrieves a task by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to be retrieved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tasks(self, **kwargs):  # noqa: E501
        """Get List  # noqa: E501

        Queries for tasks that fulfill a given filter. The size of the result set can be retrieved by using the Get Task Count method.  **Security Consideration:** There are several query parameters (such as assigneeExpression) for specifying an EL expression. These are disabled by default to prevent remote code execution. See the section on [security considerations](https://docs.camunda.org/manual/7.15/user-guide/process-engine/securing-custom-code/) for custom code in the user guide for details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Restrict to task with the given id.
        :param str task_id_in: Restrict to tasks with any of the given ids.
        :param str process_instance_id: Restrict to tasks that belong to process instances with the given id.
        :param str process_instance_id_in: Restrict to tasks that belong to process instances with the given ids.
        :param str process_instance_business_key: Restrict to tasks that belong to process instances with the given business key.
        :param str process_instance_business_key_expression: Restrict to tasks that belong to process instances with the given business key which  is described by an expression. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.
        :param str process_instance_business_key_in: Restrict to tasks that belong to process instances with one of the give business keys.  The keys need to be in a comma-separated list.
        :param str process_instance_business_key_like: Restrict to tasks that have a process instance business key that has the parameter  value as a substring.
        :param str process_instance_business_key_like_expression: Restrict to tasks that have a process instance business key that has the parameter  value as a substring and is described by an expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str process_definition_id: Restrict to tasks that belong to a process definition with the given id.
        :param str process_definition_key: Restrict to tasks that belong to a process definition with the given key.
        :param str process_definition_key_in: Restrict to tasks that belong to a process definition with one of the given keys. The  keys need to be in a comma-separated list.
        :param str process_definition_name: Restrict to tasks that belong to a process definition with the given name.
        :param str process_definition_name_like: Restrict to tasks that have a process definition name that has the parameter value as  a substring.
        :param str execution_id: Restrict to tasks that belong to an execution with the given id.
        :param str case_instance_id: Restrict to tasks that belong to case instances with the given id.
        :param str case_instance_business_key: Restrict to tasks that belong to case instances with the given business key.
        :param str case_instance_business_key_like: Restrict to tasks that have a case instance business key that has the parameter value  as a substring.
        :param str case_definition_id: Restrict to tasks that belong to a case definition with the given id.
        :param str case_definition_key: Restrict to tasks that belong to a case definition with the given key.
        :param str case_definition_name: Restrict to tasks that belong to a case definition with the given name.
        :param str case_definition_name_like: Restrict to tasks that have a case definition name that has the parameter value as a  substring.
        :param str case_execution_id: Restrict to tasks that belong to a case execution with the given id.
        :param str activity_instance_id_in: Only include tasks which belong to one of the passed and comma-separated activity  instance ids.
        :param str tenant_id_in: Only include tasks which belong to one of the passed and comma-separated  tenant ids.
        :param bool without_tenant_id: Only include tasks which belong to no tenant. Value may only be `true`,  as `false` is the default behavior.
        :param str assignee: Restrict to tasks that the given user is assigned to.
        :param str assignee_expression: Restrict to tasks that the user described by the given expression is assigned to.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str assignee_like: Restrict to tasks that have an assignee that has the parameter  value as a substring.
        :param str assignee_like_expression: Restrict to tasks that have an assignee that has the parameter value described by the  given expression as a substring. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str assignee_in: Only include tasks which are assigned to one of the passed and  comma-separated user ids.
        :param str owner: Restrict to tasks that the given user owns.
        :param str owner_expression: Restrict to tasks that the user described by the given expression owns. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str candidate_group: Only include tasks that are offered to the given group.
        :param str candidate_group_expression: Only include tasks that are offered to the group described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str candidate_user: Only include tasks that are offered to the given user or to one of his groups.
        :param str candidate_user_expression: Only include tasks that are offered to the user described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param bool include_assigned_tasks: Also include tasks that are assigned to users in candidate queries. Default is to only  include tasks that are not assigned to any user if you query by candidate user or group(s).
        :param str involved_user: Only include tasks that the given user is involved in. A user is involved in a task if  an identity link exists between task and user (e.g., the user is the assignee).
        :param str involved_user_expression: Only include tasks that the user described by the given expression is involved in. A user is involved in a task if an identity link exists between task and user (e.g., the user is the assignee). See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.
        :param bool assigned: If set to `true`, restricts the query to all tasks that are assigned.
        :param bool unassigned: If set to `true`, restricts the query to all tasks that are unassigned.
        :param str task_definition_key: Restrict to tasks that have the given key.
        :param str task_definition_key_in: Restrict to tasks that have one of the given keys. The keys need to be in a comma-separated list.
        :param str task_definition_key_like: Restrict to tasks that have a key that has the parameter value as a substring.
        :param str name: Restrict to tasks that have the given name.
        :param str name_not_equal: Restrict to tasks that do not have the given name.
        :param str name_like: Restrict to tasks that have a name with the given parameter value as substring.
        :param str name_not_like: Restrict to tasks that do not have a name with the given parameter value as substring.
        :param str description: Restrict to tasks that have the given description.
        :param str description_like: Restrict to tasks that have a description that has the parameter value as a substring.
        :param int priority: Restrict to tasks that have the given priority.
        :param int max_priority: Restrict to tasks that have a lower or equal priority.
        :param int min_priority: Restrict to tasks that have a higher or equal priority.
        :param str due_date: Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.546+0200`.
        :param str due_date_expression: Restrict to tasks that are due on the date described by the given expression. See the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str due_after: Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.435+0200`.
        :param str due_after_expression: Restrict to tasks that are due after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str due_before: Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.243+0200`.
        :param str due_before_expression: Restrict to tasks that are due before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param bool without_due_date: Only include tasks which have no due date. Value may only be `true`,  as `false` is the default behavior.
        :param str follow_up_date: Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.
        :param str follow_up_date_expression: Restrict to tasks that have a followUp date on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_after: Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.542+0200`.
        :param str follow_up_after_expression: Restrict to tasks that have a followUp date after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_before: Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.234+0200`.
        :param str follow_up_before_expression: Restrict to tasks that have a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_before_or_not_existent: Restrict to tasks that have no followUp date or a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.432+0200`. The typical use case is to query all `active` tasks for a user for a given date.
        :param str follow_up_before_or_not_existent_expression: Restrict to tasks that have no followUp date or a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_on: Restrict to tasks that were created on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.324+0200`.
        :param str created_on_expression: Restrict to tasks that were created on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_after: Restrict to tasks that were created after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.
        :param str created_after_expression: Restrict to tasks that were created after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_before: Restrict to tasks that were created before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.332+0200`.
        :param str created_before_expression: Restrict to tasks that were created before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str delegation_state: Restrict to tasks that are in the given delegation state. Valid values are `PENDING` and `RESOLVED`.
        :param str candidate_groups: Restrict to tasks that are offered to any of the given candidate groups. Takes a comma-separated list of group names, so for example `developers,support,sales`.
        :param str candidate_groups_expression: Restrict to tasks that are offered to any of the candidate groups described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to `java.util.List` of Strings.
        :param bool with_candidate_groups: Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_groups: Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool with_candidate_users: Only include tasks which have a candidate user. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_users: Only include tasks which have no candidate users. Value may only be `true`, as `false` is the default behavior.
        :param bool active: Only include active tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool suspended: Only include suspended tasks. Value may only be `true`, as `false` is the default behavior.
        :param str task_variables: Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param str process_variables: Only include tasks that belong to process instances that have variables with certain  values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`; `notLike`. `key` and `value` may not contain underscore or comma characters.
        :param str case_instance_variables: Only include tasks that belong to case instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match all variable names in this query case-insensitively. If set `variableName` and `variablename` are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values in this query case-insensitively. If set `variableValue` and `variablevalue` are treated as equal.
        :param str parent_task_id: Restrict query to all tasks that are sub tasks of the given task. Takes a task id.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[TaskDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_tasks_with_http_info(**kwargs)  # noqa: E501

    def get_tasks_with_http_info(self, **kwargs):  # noqa: E501
        """Get List  # noqa: E501

        Queries for tasks that fulfill a given filter. The size of the result set can be retrieved by using the Get Task Count method.  **Security Consideration:** There are several query parameters (such as assigneeExpression) for specifying an EL expression. These are disabled by default to prevent remote code execution. See the section on [security considerations](https://docs.camunda.org/manual/7.15/user-guide/process-engine/securing-custom-code/) for custom code in the user guide for details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Restrict to task with the given id.
        :param str task_id_in: Restrict to tasks with any of the given ids.
        :param str process_instance_id: Restrict to tasks that belong to process instances with the given id.
        :param str process_instance_id_in: Restrict to tasks that belong to process instances with the given ids.
        :param str process_instance_business_key: Restrict to tasks that belong to process instances with the given business key.
        :param str process_instance_business_key_expression: Restrict to tasks that belong to process instances with the given business key which  is described by an expression. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.
        :param str process_instance_business_key_in: Restrict to tasks that belong to process instances with one of the give business keys.  The keys need to be in a comma-separated list.
        :param str process_instance_business_key_like: Restrict to tasks that have a process instance business key that has the parameter  value as a substring.
        :param str process_instance_business_key_like_expression: Restrict to tasks that have a process instance business key that has the parameter  value as a substring and is described by an expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str process_definition_id: Restrict to tasks that belong to a process definition with the given id.
        :param str process_definition_key: Restrict to tasks that belong to a process definition with the given key.
        :param str process_definition_key_in: Restrict to tasks that belong to a process definition with one of the given keys. The  keys need to be in a comma-separated list.
        :param str process_definition_name: Restrict to tasks that belong to a process definition with the given name.
        :param str process_definition_name_like: Restrict to tasks that have a process definition name that has the parameter value as  a substring.
        :param str execution_id: Restrict to tasks that belong to an execution with the given id.
        :param str case_instance_id: Restrict to tasks that belong to case instances with the given id.
        :param str case_instance_business_key: Restrict to tasks that belong to case instances with the given business key.
        :param str case_instance_business_key_like: Restrict to tasks that have a case instance business key that has the parameter value  as a substring.
        :param str case_definition_id: Restrict to tasks that belong to a case definition with the given id.
        :param str case_definition_key: Restrict to tasks that belong to a case definition with the given key.
        :param str case_definition_name: Restrict to tasks that belong to a case definition with the given name.
        :param str case_definition_name_like: Restrict to tasks that have a case definition name that has the parameter value as a  substring.
        :param str case_execution_id: Restrict to tasks that belong to a case execution with the given id.
        :param str activity_instance_id_in: Only include tasks which belong to one of the passed and comma-separated activity  instance ids.
        :param str tenant_id_in: Only include tasks which belong to one of the passed and comma-separated  tenant ids.
        :param bool without_tenant_id: Only include tasks which belong to no tenant. Value may only be `true`,  as `false` is the default behavior.
        :param str assignee: Restrict to tasks that the given user is assigned to.
        :param str assignee_expression: Restrict to tasks that the user described by the given expression is assigned to.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str assignee_like: Restrict to tasks that have an assignee that has the parameter  value as a substring.
        :param str assignee_like_expression: Restrict to tasks that have an assignee that has the parameter value described by the  given expression as a substring. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str assignee_in: Only include tasks which are assigned to one of the passed and  comma-separated user ids.
        :param str owner: Restrict to tasks that the given user owns.
        :param str owner_expression: Restrict to tasks that the user described by the given expression owns. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str candidate_group: Only include tasks that are offered to the given group.
        :param str candidate_group_expression: Only include tasks that are offered to the group described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str candidate_user: Only include tasks that are offered to the given user or to one of his groups.
        :param str candidate_user_expression: Only include tasks that are offered to the user described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param bool include_assigned_tasks: Also include tasks that are assigned to users in candidate queries. Default is to only  include tasks that are not assigned to any user if you query by candidate user or group(s).
        :param str involved_user: Only include tasks that the given user is involved in. A user is involved in a task if  an identity link exists between task and user (e.g., the user is the assignee).
        :param str involved_user_expression: Only include tasks that the user described by the given expression is involved in. A user is involved in a task if an identity link exists between task and user (e.g., the user is the assignee). See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.
        :param bool assigned: If set to `true`, restricts the query to all tasks that are assigned.
        :param bool unassigned: If set to `true`, restricts the query to all tasks that are unassigned.
        :param str task_definition_key: Restrict to tasks that have the given key.
        :param str task_definition_key_in: Restrict to tasks that have one of the given keys. The keys need to be in a comma-separated list.
        :param str task_definition_key_like: Restrict to tasks that have a key that has the parameter value as a substring.
        :param str name: Restrict to tasks that have the given name.
        :param str name_not_equal: Restrict to tasks that do not have the given name.
        :param str name_like: Restrict to tasks that have a name with the given parameter value as substring.
        :param str name_not_like: Restrict to tasks that do not have a name with the given parameter value as substring.
        :param str description: Restrict to tasks that have the given description.
        :param str description_like: Restrict to tasks that have a description that has the parameter value as a substring.
        :param int priority: Restrict to tasks that have the given priority.
        :param int max_priority: Restrict to tasks that have a lower or equal priority.
        :param int min_priority: Restrict to tasks that have a higher or equal priority.
        :param str due_date: Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.546+0200`.
        :param str due_date_expression: Restrict to tasks that are due on the date described by the given expression. See the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str due_after: Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.435+0200`.
        :param str due_after_expression: Restrict to tasks that are due after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str due_before: Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.243+0200`.
        :param str due_before_expression: Restrict to tasks that are due before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param bool without_due_date: Only include tasks which have no due date. Value may only be `true`,  as `false` is the default behavior.
        :param str follow_up_date: Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.
        :param str follow_up_date_expression: Restrict to tasks that have a followUp date on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_after: Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.542+0200`.
        :param str follow_up_after_expression: Restrict to tasks that have a followUp date after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_before: Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.234+0200`.
        :param str follow_up_before_expression: Restrict to tasks that have a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_before_or_not_existent: Restrict to tasks that have no followUp date or a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.432+0200`. The typical use case is to query all `active` tasks for a user for a given date.
        :param str follow_up_before_or_not_existent_expression: Restrict to tasks that have no followUp date or a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_on: Restrict to tasks that were created on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.324+0200`.
        :param str created_on_expression: Restrict to tasks that were created on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_after: Restrict to tasks that were created after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.
        :param str created_after_expression: Restrict to tasks that were created after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_before: Restrict to tasks that were created before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.332+0200`.
        :param str created_before_expression: Restrict to tasks that were created before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str delegation_state: Restrict to tasks that are in the given delegation state. Valid values are `PENDING` and `RESOLVED`.
        :param str candidate_groups: Restrict to tasks that are offered to any of the given candidate groups. Takes a comma-separated list of group names, so for example `developers,support,sales`.
        :param str candidate_groups_expression: Restrict to tasks that are offered to any of the candidate groups described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to `java.util.List` of Strings.
        :param bool with_candidate_groups: Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_groups: Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool with_candidate_users: Only include tasks which have a candidate user. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_users: Only include tasks which have no candidate users. Value may only be `true`, as `false` is the default behavior.
        :param bool active: Only include active tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool suspended: Only include suspended tasks. Value may only be `true`, as `false` is the default behavior.
        :param str task_variables: Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param str process_variables: Only include tasks that belong to process instances that have variables with certain  values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`; `notLike`. `key` and `value` may not contain underscore or comma characters.
        :param str case_instance_variables: Only include tasks that belong to case instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match all variable names in this query case-insensitively. If set `variableName` and `variablename` are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values in this query case-insensitively. If set `variableValue` and `variablevalue` are treated as equal.
        :param str parent_task_id: Restrict query to all tasks that are sub tasks of the given task. Takes a task id.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[TaskDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'task_id_in',
            'process_instance_id',
            'process_instance_id_in',
            'process_instance_business_key',
            'process_instance_business_key_expression',
            'process_instance_business_key_in',
            'process_instance_business_key_like',
            'process_instance_business_key_like_expression',
            'process_definition_id',
            'process_definition_key',
            'process_definition_key_in',
            'process_definition_name',
            'process_definition_name_like',
            'execution_id',
            'case_instance_id',
            'case_instance_business_key',
            'case_instance_business_key_like',
            'case_definition_id',
            'case_definition_key',
            'case_definition_name',
            'case_definition_name_like',
            'case_execution_id',
            'activity_instance_id_in',
            'tenant_id_in',
            'without_tenant_id',
            'assignee',
            'assignee_expression',
            'assignee_like',
            'assignee_like_expression',
            'assignee_in',
            'owner',
            'owner_expression',
            'candidate_group',
            'candidate_group_expression',
            'candidate_user',
            'candidate_user_expression',
            'include_assigned_tasks',
            'involved_user',
            'involved_user_expression',
            'assigned',
            'unassigned',
            'task_definition_key',
            'task_definition_key_in',
            'task_definition_key_like',
            'name',
            'name_not_equal',
            'name_like',
            'name_not_like',
            'description',
            'description_like',
            'priority',
            'max_priority',
            'min_priority',
            'due_date',
            'due_date_expression',
            'due_after',
            'due_after_expression',
            'due_before',
            'due_before_expression',
            'without_due_date',
            'follow_up_date',
            'follow_up_date_expression',
            'follow_up_after',
            'follow_up_after_expression',
            'follow_up_before',
            'follow_up_before_expression',
            'follow_up_before_or_not_existent',
            'follow_up_before_or_not_existent_expression',
            'created_on',
            'created_on_expression',
            'created_after',
            'created_after_expression',
            'created_before',
            'created_before_expression',
            'delegation_state',
            'candidate_groups',
            'candidate_groups_expression',
            'with_candidate_groups',
            'without_candidate_groups',
            'with_candidate_users',
            'without_candidate_users',
            'active',
            'suspended',
            'task_variables',
            'process_variables',
            'case_instance_variables',
            'variable_names_ignore_case',
            'variable_values_ignore_case',
            'parent_task_id',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tasks" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('taskId', local_var_params['task_id']))  # noqa: E501
        if 'task_id_in' in local_var_params and local_var_params['task_id_in'] is not None:  # noqa: E501
            query_params.append(('taskIdIn', local_var_params['task_id_in']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_id_in' in local_var_params and local_var_params['process_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceIdIn', local_var_params['process_instance_id_in']))  # noqa: E501
        if 'process_instance_business_key' in local_var_params and local_var_params['process_instance_business_key'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKey', local_var_params['process_instance_business_key']))  # noqa: E501
        if 'process_instance_business_key_expression' in local_var_params and local_var_params['process_instance_business_key_expression'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyExpression', local_var_params['process_instance_business_key_expression']))  # noqa: E501
        if 'process_instance_business_key_in' in local_var_params and local_var_params['process_instance_business_key_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyIn', local_var_params['process_instance_business_key_in']))  # noqa: E501
        if 'process_instance_business_key_like' in local_var_params and local_var_params['process_instance_business_key_like'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyLike', local_var_params['process_instance_business_key_like']))  # noqa: E501
        if 'process_instance_business_key_like_expression' in local_var_params and local_var_params['process_instance_business_key_like_expression'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyLikeExpression', local_var_params['process_instance_business_key_like_expression']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'process_definition_name' in local_var_params and local_var_params['process_definition_name'] is not None:  # noqa: E501
            query_params.append(('processDefinitionName', local_var_params['process_definition_name']))  # noqa: E501
        if 'process_definition_name_like' in local_var_params and local_var_params['process_definition_name_like'] is not None:  # noqa: E501
            query_params.append(('processDefinitionNameLike', local_var_params['process_definition_name_like']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'case_instance_business_key' in local_var_params and local_var_params['case_instance_business_key'] is not None:  # noqa: E501
            query_params.append(('caseInstanceBusinessKey', local_var_params['case_instance_business_key']))  # noqa: E501
        if 'case_instance_business_key_like' in local_var_params and local_var_params['case_instance_business_key_like'] is not None:  # noqa: E501
            query_params.append(('caseInstanceBusinessKeyLike', local_var_params['case_instance_business_key_like']))  # noqa: E501
        if 'case_definition_id' in local_var_params and local_var_params['case_definition_id'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionId', local_var_params['case_definition_id']))  # noqa: E501
        if 'case_definition_key' in local_var_params and local_var_params['case_definition_key'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionKey', local_var_params['case_definition_key']))  # noqa: E501
        if 'case_definition_name' in local_var_params and local_var_params['case_definition_name'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionName', local_var_params['case_definition_name']))  # noqa: E501
        if 'case_definition_name_like' in local_var_params and local_var_params['case_definition_name_like'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionNameLike', local_var_params['case_definition_name_like']))  # noqa: E501
        if 'case_execution_id' in local_var_params and local_var_params['case_execution_id'] is not None:  # noqa: E501
            query_params.append(('caseExecutionId', local_var_params['case_execution_id']))  # noqa: E501
        if 'activity_instance_id_in' in local_var_params and local_var_params['activity_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('activityInstanceIdIn', local_var_params['activity_instance_id_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'assignee' in local_var_params and local_var_params['assignee'] is not None:  # noqa: E501
            query_params.append(('assignee', local_var_params['assignee']))  # noqa: E501
        if 'assignee_expression' in local_var_params and local_var_params['assignee_expression'] is not None:  # noqa: E501
            query_params.append(('assigneeExpression', local_var_params['assignee_expression']))  # noqa: E501
        if 'assignee_like' in local_var_params and local_var_params['assignee_like'] is not None:  # noqa: E501
            query_params.append(('assigneeLike', local_var_params['assignee_like']))  # noqa: E501
        if 'assignee_like_expression' in local_var_params and local_var_params['assignee_like_expression'] is not None:  # noqa: E501
            query_params.append(('assigneeLikeExpression', local_var_params['assignee_like_expression']))  # noqa: E501
        if 'assignee_in' in local_var_params and local_var_params['assignee_in'] is not None:  # noqa: E501
            query_params.append(('assigneeIn', local_var_params['assignee_in']))  # noqa: E501
        if 'owner' in local_var_params and local_var_params['owner'] is not None:  # noqa: E501
            query_params.append(('owner', local_var_params['owner']))  # noqa: E501
        if 'owner_expression' in local_var_params and local_var_params['owner_expression'] is not None:  # noqa: E501
            query_params.append(('ownerExpression', local_var_params['owner_expression']))  # noqa: E501
        if 'candidate_group' in local_var_params and local_var_params['candidate_group'] is not None:  # noqa: E501
            query_params.append(('candidateGroup', local_var_params['candidate_group']))  # noqa: E501
        if 'candidate_group_expression' in local_var_params and local_var_params['candidate_group_expression'] is not None:  # noqa: E501
            query_params.append(('candidateGroupExpression', local_var_params['candidate_group_expression']))  # noqa: E501
        if 'candidate_user' in local_var_params and local_var_params['candidate_user'] is not None:  # noqa: E501
            query_params.append(('candidateUser', local_var_params['candidate_user']))  # noqa: E501
        if 'candidate_user_expression' in local_var_params and local_var_params['candidate_user_expression'] is not None:  # noqa: E501
            query_params.append(('candidateUserExpression', local_var_params['candidate_user_expression']))  # noqa: E501
        if 'include_assigned_tasks' in local_var_params and local_var_params['include_assigned_tasks'] is not None:  # noqa: E501
            query_params.append(('includeAssignedTasks', local_var_params['include_assigned_tasks']))  # noqa: E501
        if 'involved_user' in local_var_params and local_var_params['involved_user'] is not None:  # noqa: E501
            query_params.append(('involvedUser', local_var_params['involved_user']))  # noqa: E501
        if 'involved_user_expression' in local_var_params and local_var_params['involved_user_expression'] is not None:  # noqa: E501
            query_params.append(('involvedUserExpression', local_var_params['involved_user_expression']))  # noqa: E501
        if 'assigned' in local_var_params and local_var_params['assigned'] is not None:  # noqa: E501
            query_params.append(('assigned', local_var_params['assigned']))  # noqa: E501
        if 'unassigned' in local_var_params and local_var_params['unassigned'] is not None:  # noqa: E501
            query_params.append(('unassigned', local_var_params['unassigned']))  # noqa: E501
        if 'task_definition_key' in local_var_params and local_var_params['task_definition_key'] is not None:  # noqa: E501
            query_params.append(('taskDefinitionKey', local_var_params['task_definition_key']))  # noqa: E501
        if 'task_definition_key_in' in local_var_params and local_var_params['task_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('taskDefinitionKeyIn', local_var_params['task_definition_key_in']))  # noqa: E501
        if 'task_definition_key_like' in local_var_params and local_var_params['task_definition_key_like'] is not None:  # noqa: E501
            query_params.append(('taskDefinitionKeyLike', local_var_params['task_definition_key_like']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name_not_equal' in local_var_params and local_var_params['name_not_equal'] is not None:  # noqa: E501
            query_params.append(('nameNotEqual', local_var_params['name_not_equal']))  # noqa: E501
        if 'name_like' in local_var_params and local_var_params['name_like'] is not None:  # noqa: E501
            query_params.append(('nameLike', local_var_params['name_like']))  # noqa: E501
        if 'name_not_like' in local_var_params and local_var_params['name_not_like'] is not None:  # noqa: E501
            query_params.append(('nameNotLike', local_var_params['name_not_like']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'description_like' in local_var_params and local_var_params['description_like'] is not None:  # noqa: E501
            query_params.append(('descriptionLike', local_var_params['description_like']))  # noqa: E501
        if 'priority' in local_var_params and local_var_params['priority'] is not None:  # noqa: E501
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'max_priority' in local_var_params and local_var_params['max_priority'] is not None:  # noqa: E501
            query_params.append(('maxPriority', local_var_params['max_priority']))  # noqa: E501
        if 'min_priority' in local_var_params and local_var_params['min_priority'] is not None:  # noqa: E501
            query_params.append(('minPriority', local_var_params['min_priority']))  # noqa: E501
        if 'due_date' in local_var_params and local_var_params['due_date'] is not None:  # noqa: E501
            query_params.append(('dueDate', local_var_params['due_date']))  # noqa: E501
        if 'due_date_expression' in local_var_params and local_var_params['due_date_expression'] is not None:  # noqa: E501
            query_params.append(('dueDateExpression', local_var_params['due_date_expression']))  # noqa: E501
        if 'due_after' in local_var_params and local_var_params['due_after'] is not None:  # noqa: E501
            query_params.append(('dueAfter', local_var_params['due_after']))  # noqa: E501
        if 'due_after_expression' in local_var_params and local_var_params['due_after_expression'] is not None:  # noqa: E501
            query_params.append(('dueAfterExpression', local_var_params['due_after_expression']))  # noqa: E501
        if 'due_before' in local_var_params and local_var_params['due_before'] is not None:  # noqa: E501
            query_params.append(('dueBefore', local_var_params['due_before']))  # noqa: E501
        if 'due_before_expression' in local_var_params and local_var_params['due_before_expression'] is not None:  # noqa: E501
            query_params.append(('dueBeforeExpression', local_var_params['due_before_expression']))  # noqa: E501
        if 'without_due_date' in local_var_params and local_var_params['without_due_date'] is not None:  # noqa: E501
            query_params.append(('withoutDueDate', local_var_params['without_due_date']))  # noqa: E501
        if 'follow_up_date' in local_var_params and local_var_params['follow_up_date'] is not None:  # noqa: E501
            query_params.append(('followUpDate', local_var_params['follow_up_date']))  # noqa: E501
        if 'follow_up_date_expression' in local_var_params and local_var_params['follow_up_date_expression'] is not None:  # noqa: E501
            query_params.append(('followUpDateExpression', local_var_params['follow_up_date_expression']))  # noqa: E501
        if 'follow_up_after' in local_var_params and local_var_params['follow_up_after'] is not None:  # noqa: E501
            query_params.append(('followUpAfter', local_var_params['follow_up_after']))  # noqa: E501
        if 'follow_up_after_expression' in local_var_params and local_var_params['follow_up_after_expression'] is not None:  # noqa: E501
            query_params.append(('followUpAfterExpression', local_var_params['follow_up_after_expression']))  # noqa: E501
        if 'follow_up_before' in local_var_params and local_var_params['follow_up_before'] is not None:  # noqa: E501
            query_params.append(('followUpBefore', local_var_params['follow_up_before']))  # noqa: E501
        if 'follow_up_before_expression' in local_var_params and local_var_params['follow_up_before_expression'] is not None:  # noqa: E501
            query_params.append(('followUpBeforeExpression', local_var_params['follow_up_before_expression']))  # noqa: E501
        if 'follow_up_before_or_not_existent' in local_var_params and local_var_params['follow_up_before_or_not_existent'] is not None:  # noqa: E501
            query_params.append(('followUpBeforeOrNotExistent', local_var_params['follow_up_before_or_not_existent']))  # noqa: E501
        if 'follow_up_before_or_not_existent_expression' in local_var_params and local_var_params['follow_up_before_or_not_existent_expression'] is not None:  # noqa: E501
            query_params.append(('followUpBeforeOrNotExistentExpression', local_var_params['follow_up_before_or_not_existent_expression']))  # noqa: E501
        if 'created_on' in local_var_params and local_var_params['created_on'] is not None:  # noqa: E501
            query_params.append(('createdOn', local_var_params['created_on']))  # noqa: E501
        if 'created_on_expression' in local_var_params and local_var_params['created_on_expression'] is not None:  # noqa: E501
            query_params.append(('createdOnExpression', local_var_params['created_on_expression']))  # noqa: E501
        if 'created_after' in local_var_params and local_var_params['created_after'] is not None:  # noqa: E501
            query_params.append(('createdAfter', local_var_params['created_after']))  # noqa: E501
        if 'created_after_expression' in local_var_params and local_var_params['created_after_expression'] is not None:  # noqa: E501
            query_params.append(('createdAfterExpression', local_var_params['created_after_expression']))  # noqa: E501
        if 'created_before' in local_var_params and local_var_params['created_before'] is not None:  # noqa: E501
            query_params.append(('createdBefore', local_var_params['created_before']))  # noqa: E501
        if 'created_before_expression' in local_var_params and local_var_params['created_before_expression'] is not None:  # noqa: E501
            query_params.append(('createdBeforeExpression', local_var_params['created_before_expression']))  # noqa: E501
        if 'delegation_state' in local_var_params and local_var_params['delegation_state'] is not None:  # noqa: E501
            query_params.append(('delegationState', local_var_params['delegation_state']))  # noqa: E501
        if 'candidate_groups' in local_var_params and local_var_params['candidate_groups'] is not None:  # noqa: E501
            query_params.append(('candidateGroups', local_var_params['candidate_groups']))  # noqa: E501
        if 'candidate_groups_expression' in local_var_params and local_var_params['candidate_groups_expression'] is not None:  # noqa: E501
            query_params.append(('candidateGroupsExpression', local_var_params['candidate_groups_expression']))  # noqa: E501
        if 'with_candidate_groups' in local_var_params and local_var_params['with_candidate_groups'] is not None:  # noqa: E501
            query_params.append(('withCandidateGroups', local_var_params['with_candidate_groups']))  # noqa: E501
        if 'without_candidate_groups' in local_var_params and local_var_params['without_candidate_groups'] is not None:  # noqa: E501
            query_params.append(('withoutCandidateGroups', local_var_params['without_candidate_groups']))  # noqa: E501
        if 'with_candidate_users' in local_var_params and local_var_params['with_candidate_users'] is not None:  # noqa: E501
            query_params.append(('withCandidateUsers', local_var_params['with_candidate_users']))  # noqa: E501
        if 'without_candidate_users' in local_var_params and local_var_params['without_candidate_users'] is not None:  # noqa: E501
            query_params.append(('withoutCandidateUsers', local_var_params['without_candidate_users']))  # noqa: E501
        if 'active' in local_var_params and local_var_params['active'] is not None:  # noqa: E501
            query_params.append(('active', local_var_params['active']))  # noqa: E501
        if 'suspended' in local_var_params and local_var_params['suspended'] is not None:  # noqa: E501
            query_params.append(('suspended', local_var_params['suspended']))  # noqa: E501
        if 'task_variables' in local_var_params and local_var_params['task_variables'] is not None:  # noqa: E501
            query_params.append(('taskVariables', local_var_params['task_variables']))  # noqa: E501
        if 'process_variables' in local_var_params and local_var_params['process_variables'] is not None:  # noqa: E501
            query_params.append(('processVariables', local_var_params['process_variables']))  # noqa: E501
        if 'case_instance_variables' in local_var_params and local_var_params['case_instance_variables'] is not None:  # noqa: E501
            query_params.append(('caseInstanceVariables', local_var_params['case_instance_variables']))  # noqa: E501
        if 'variable_names_ignore_case' in local_var_params and local_var_params['variable_names_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableNamesIgnoreCase', local_var_params['variable_names_ignore_case']))  # noqa: E501
        if 'variable_values_ignore_case' in local_var_params and local_var_params['variable_values_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableValuesIgnoreCase', local_var_params['variable_values_ignore_case']))  # noqa: E501
        if 'parent_task_id' in local_var_params and local_var_params['parent_task_id'] is not None:  # noqa: E501
            query_params.append(('parentTaskId', local_var_params['parent_task_id']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TaskDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tasks_count(self, **kwargs):  # noqa: E501
        """Get List Count  # noqa: E501

        Retrieves the number of tasks that fulfill a provided filter. Corresponds to the size of the result set when using the [Get Tasks](https://docs.camunda.org/manual/7.15/reference/rest/task/) method.  **Security Consideration:** There are several query parameters (such as assigneeExpression) for specifying an EL expression. These are disabled by default to prevent remote code execution. See the section on [security considerations](https://docs.camunda.org/manual/7.15/user-guide/process-engine/securing-custom-code/) for custom code in the user guide for details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Restrict to task with the given id.
        :param str task_id_in: Restrict to tasks with any of the given ids.
        :param str process_instance_id: Restrict to tasks that belong to process instances with the given id.
        :param str process_instance_id_in: Restrict to tasks that belong to process instances with the given ids.
        :param str process_instance_business_key: Restrict to tasks that belong to process instances with the given business key.
        :param str process_instance_business_key_expression: Restrict to tasks that belong to process instances with the given business key which  is described by an expression. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.
        :param str process_instance_business_key_in: Restrict to tasks that belong to process instances with one of the give business keys.  The keys need to be in a comma-separated list.
        :param str process_instance_business_key_like: Restrict to tasks that have a process instance business key that has the parameter  value as a substring.
        :param str process_instance_business_key_like_expression: Restrict to tasks that have a process instance business key that has the parameter  value as a substring and is described by an expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str process_definition_id: Restrict to tasks that belong to a process definition with the given id.
        :param str process_definition_key: Restrict to tasks that belong to a process definition with the given key.
        :param str process_definition_key_in: Restrict to tasks that belong to a process definition with one of the given keys. The  keys need to be in a comma-separated list.
        :param str process_definition_name: Restrict to tasks that belong to a process definition with the given name.
        :param str process_definition_name_like: Restrict to tasks that have a process definition name that has the parameter value as  a substring.
        :param str execution_id: Restrict to tasks that belong to an execution with the given id.
        :param str case_instance_id: Restrict to tasks that belong to case instances with the given id.
        :param str case_instance_business_key: Restrict to tasks that belong to case instances with the given business key.
        :param str case_instance_business_key_like: Restrict to tasks that have a case instance business key that has the parameter value  as a substring.
        :param str case_definition_id: Restrict to tasks that belong to a case definition with the given id.
        :param str case_definition_key: Restrict to tasks that belong to a case definition with the given key.
        :param str case_definition_name: Restrict to tasks that belong to a case definition with the given name.
        :param str case_definition_name_like: Restrict to tasks that have a case definition name that has the parameter value as a  substring.
        :param str case_execution_id: Restrict to tasks that belong to a case execution with the given id.
        :param str activity_instance_id_in: Only include tasks which belong to one of the passed and comma-separated activity  instance ids.
        :param str tenant_id_in: Only include tasks which belong to one of the passed and comma-separated  tenant ids.
        :param bool without_tenant_id: Only include tasks which belong to no tenant. Value may only be `true`,  as `false` is the default behavior.
        :param str assignee: Restrict to tasks that the given user is assigned to.
        :param str assignee_expression: Restrict to tasks that the user described by the given expression is assigned to.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str assignee_like: Restrict to tasks that have an assignee that has the parameter  value as a substring.
        :param str assignee_like_expression: Restrict to tasks that have an assignee that has the parameter value described by the  given expression as a substring. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str assignee_in: Only include tasks which are assigned to one of the passed and  comma-separated user ids.
        :param str owner: Restrict to tasks that the given user owns.
        :param str owner_expression: Restrict to tasks that the user described by the given expression owns. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str candidate_group: Only include tasks that are offered to the given group.
        :param str candidate_group_expression: Only include tasks that are offered to the group described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str candidate_user: Only include tasks that are offered to the given user or to one of his groups.
        :param str candidate_user_expression: Only include tasks that are offered to the user described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param bool include_assigned_tasks: Also include tasks that are assigned to users in candidate queries. Default is to only  include tasks that are not assigned to any user if you query by candidate user or group(s).
        :param str involved_user: Only include tasks that the given user is involved in. A user is involved in a task if  an identity link exists between task and user (e.g., the user is the assignee).
        :param str involved_user_expression: Only include tasks that the user described by the given expression is involved in. A user is involved in a task if an identity link exists between task and user (e.g., the user is the assignee). See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.
        :param bool assigned: If set to `true`, restricts the query to all tasks that are assigned.
        :param bool unassigned: If set to `true`, restricts the query to all tasks that are unassigned.
        :param str task_definition_key: Restrict to tasks that have the given key.
        :param str task_definition_key_in: Restrict to tasks that have one of the given keys. The keys need to be in a comma-separated list.
        :param str task_definition_key_like: Restrict to tasks that have a key that has the parameter value as a substring.
        :param str name: Restrict to tasks that have the given name.
        :param str name_not_equal: Restrict to tasks that do not have the given name.
        :param str name_like: Restrict to tasks that have a name with the given parameter value as substring.
        :param str name_not_like: Restrict to tasks that do not have a name with the given parameter value as substring.
        :param str description: Restrict to tasks that have the given description.
        :param str description_like: Restrict to tasks that have a description that has the parameter value as a substring.
        :param int priority: Restrict to tasks that have the given priority.
        :param int max_priority: Restrict to tasks that have a lower or equal priority.
        :param int min_priority: Restrict to tasks that have a higher or equal priority.
        :param str due_date: Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.546+0200`.
        :param str due_date_expression: Restrict to tasks that are due on the date described by the given expression. See the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str due_after: Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.435+0200`.
        :param str due_after_expression: Restrict to tasks that are due after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str due_before: Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.243+0200`.
        :param str due_before_expression: Restrict to tasks that are due before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param bool without_due_date: Only include tasks which have no due date. Value may only be `true`,  as `false` is the default behavior.
        :param str follow_up_date: Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.
        :param str follow_up_date_expression: Restrict to tasks that have a followUp date on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_after: Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.542+0200`.
        :param str follow_up_after_expression: Restrict to tasks that have a followUp date after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_before: Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.234+0200`.
        :param str follow_up_before_expression: Restrict to tasks that have a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_before_or_not_existent: Restrict to tasks that have no followUp date or a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.432+0200`. The typical use case is to query all `active` tasks for a user for a given date.
        :param str follow_up_before_or_not_existent_expression: Restrict to tasks that have no followUp date or a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_on: Restrict to tasks that were created on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.324+0200`.
        :param str created_on_expression: Restrict to tasks that were created on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_after: Restrict to tasks that were created after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.
        :param str created_after_expression: Restrict to tasks that were created after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_before: Restrict to tasks that were created before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.332+0200`.
        :param str created_before_expression: Restrict to tasks that were created before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str delegation_state: Restrict to tasks that are in the given delegation state. Valid values are `PENDING` and `RESOLVED`.
        :param str candidate_groups: Restrict to tasks that are offered to any of the given candidate groups. Takes a comma-separated list of group names, so for example `developers,support,sales`.
        :param str candidate_groups_expression: Restrict to tasks that are offered to any of the candidate groups described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to `java.util.List` of Strings.
        :param bool with_candidate_groups: Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_groups: Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool with_candidate_users: Only include tasks which have a candidate user. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_users: Only include tasks which have no candidate users. Value may only be `true`, as `false` is the default behavior.
        :param bool active: Only include active tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool suspended: Only include suspended tasks. Value may only be `true`, as `false` is the default behavior.
        :param str task_variables: Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param str process_variables: Only include tasks that belong to process instances that have variables with certain  values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`; `notLike`. `key` and `value` may not contain underscore or comma characters.
        :param str case_instance_variables: Only include tasks that belong to case instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match all variable names in this query case-insensitively. If set `variableName` and `variablename` are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values in this query case-insensitively. If set `variableValue` and `variablevalue` are treated as equal.
        :param str parent_task_id: Restrict query to all tasks that are sub tasks of the given task. Takes a task id.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_tasks_count_with_http_info(**kwargs)  # noqa: E501

    def get_tasks_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get List Count  # noqa: E501

        Retrieves the number of tasks that fulfill a provided filter. Corresponds to the size of the result set when using the [Get Tasks](https://docs.camunda.org/manual/7.15/reference/rest/task/) method.  **Security Consideration:** There are several query parameters (such as assigneeExpression) for specifying an EL expression. These are disabled by default to prevent remote code execution. See the section on [security considerations](https://docs.camunda.org/manual/7.15/user-guide/process-engine/securing-custom-code/) for custom code in the user guide for details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Restrict to task with the given id.
        :param str task_id_in: Restrict to tasks with any of the given ids.
        :param str process_instance_id: Restrict to tasks that belong to process instances with the given id.
        :param str process_instance_id_in: Restrict to tasks that belong to process instances with the given ids.
        :param str process_instance_business_key: Restrict to tasks that belong to process instances with the given business key.
        :param str process_instance_business_key_expression: Restrict to tasks that belong to process instances with the given business key which  is described by an expression. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.
        :param str process_instance_business_key_in: Restrict to tasks that belong to process instances with one of the give business keys.  The keys need to be in a comma-separated list.
        :param str process_instance_business_key_like: Restrict to tasks that have a process instance business key that has the parameter  value as a substring.
        :param str process_instance_business_key_like_expression: Restrict to tasks that have a process instance business key that has the parameter  value as a substring and is described by an expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str process_definition_id: Restrict to tasks that belong to a process definition with the given id.
        :param str process_definition_key: Restrict to tasks that belong to a process definition with the given key.
        :param str process_definition_key_in: Restrict to tasks that belong to a process definition with one of the given keys. The  keys need to be in a comma-separated list.
        :param str process_definition_name: Restrict to tasks that belong to a process definition with the given name.
        :param str process_definition_name_like: Restrict to tasks that have a process definition name that has the parameter value as  a substring.
        :param str execution_id: Restrict to tasks that belong to an execution with the given id.
        :param str case_instance_id: Restrict to tasks that belong to case instances with the given id.
        :param str case_instance_business_key: Restrict to tasks that belong to case instances with the given business key.
        :param str case_instance_business_key_like: Restrict to tasks that have a case instance business key that has the parameter value  as a substring.
        :param str case_definition_id: Restrict to tasks that belong to a case definition with the given id.
        :param str case_definition_key: Restrict to tasks that belong to a case definition with the given key.
        :param str case_definition_name: Restrict to tasks that belong to a case definition with the given name.
        :param str case_definition_name_like: Restrict to tasks that have a case definition name that has the parameter value as a  substring.
        :param str case_execution_id: Restrict to tasks that belong to a case execution with the given id.
        :param str activity_instance_id_in: Only include tasks which belong to one of the passed and comma-separated activity  instance ids.
        :param str tenant_id_in: Only include tasks which belong to one of the passed and comma-separated  tenant ids.
        :param bool without_tenant_id: Only include tasks which belong to no tenant. Value may only be `true`,  as `false` is the default behavior.
        :param str assignee: Restrict to tasks that the given user is assigned to.
        :param str assignee_expression: Restrict to tasks that the user described by the given expression is assigned to.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str assignee_like: Restrict to tasks that have an assignee that has the parameter  value as a substring.
        :param str assignee_like_expression: Restrict to tasks that have an assignee that has the parameter value described by the  given expression as a substring. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str assignee_in: Only include tasks which are assigned to one of the passed and  comma-separated user ids.
        :param str owner: Restrict to tasks that the given user owns.
        :param str owner_expression: Restrict to tasks that the user described by the given expression owns. See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str candidate_group: Only include tasks that are offered to the given group.
        :param str candidate_group_expression: Only include tasks that are offered to the group described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param str candidate_user: Only include tasks that are offered to the given user or to one of his groups.
        :param str candidate_user_expression: Only include tasks that are offered to the user described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
        :param bool include_assigned_tasks: Also include tasks that are assigned to users in candidate queries. Default is to only  include tasks that are not assigned to any user if you query by candidate user or group(s).
        :param str involved_user: Only include tasks that the given user is involved in. A user is involved in a task if  an identity link exists between task and user (e.g., the user is the assignee).
        :param str involved_user_expression: Only include tasks that the user described by the given expression is involved in. A user is involved in a task if an identity link exists between task and user (e.g., the user is the assignee). See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.
        :param bool assigned: If set to `true`, restricts the query to all tasks that are assigned.
        :param bool unassigned: If set to `true`, restricts the query to all tasks that are unassigned.
        :param str task_definition_key: Restrict to tasks that have the given key.
        :param str task_definition_key_in: Restrict to tasks that have one of the given keys. The keys need to be in a comma-separated list.
        :param str task_definition_key_like: Restrict to tasks that have a key that has the parameter value as a substring.
        :param str name: Restrict to tasks that have the given name.
        :param str name_not_equal: Restrict to tasks that do not have the given name.
        :param str name_like: Restrict to tasks that have a name with the given parameter value as substring.
        :param str name_not_like: Restrict to tasks that do not have a name with the given parameter value as substring.
        :param str description: Restrict to tasks that have the given description.
        :param str description_like: Restrict to tasks that have a description that has the parameter value as a substring.
        :param int priority: Restrict to tasks that have the given priority.
        :param int max_priority: Restrict to tasks that have a lower or equal priority.
        :param int min_priority: Restrict to tasks that have a higher or equal priority.
        :param str due_date: Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.546+0200`.
        :param str due_date_expression: Restrict to tasks that are due on the date described by the given expression. See the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str due_after: Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.435+0200`.
        :param str due_after_expression: Restrict to tasks that are due after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str due_before: Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.243+0200`.
        :param str due_before_expression: Restrict to tasks that are due before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param bool without_due_date: Only include tasks which have no due date. Value may only be `true`,  as `false` is the default behavior.
        :param str follow_up_date: Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.
        :param str follow_up_date_expression: Restrict to tasks that have a followUp date on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_after: Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.542+0200`.
        :param str follow_up_after_expression: Restrict to tasks that have a followUp date after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_before: Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.234+0200`.
        :param str follow_up_before_expression: Restrict to tasks that have a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str follow_up_before_or_not_existent: Restrict to tasks that have no followUp date or a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.432+0200`. The typical use case is to query all `active` tasks for a user for a given date.
        :param str follow_up_before_or_not_existent_expression: Restrict to tasks that have no followUp date or a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_on: Restrict to tasks that were created on the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.324+0200`.
        :param str created_on_expression: Restrict to tasks that were created on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_after: Restrict to tasks that were created after the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.
        :param str created_after_expression: Restrict to tasks that were created after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str created_before: Restrict to tasks that were created before the given date. By [default](https://docs.camunda.org/manual/7.15/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.332+0200`.
        :param str created_before_expression: Restrict to tasks that were created before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.
        :param str delegation_state: Restrict to tasks that are in the given delegation state. Valid values are `PENDING` and `RESOLVED`.
        :param str candidate_groups: Restrict to tasks that are offered to any of the given candidate groups. Takes a comma-separated list of group names, so for example `developers,support,sales`.
        :param str candidate_groups_expression: Restrict to tasks that are offered to any of the candidate groups described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to `java.util.List` of Strings.
        :param bool with_candidate_groups: Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_groups: Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool with_candidate_users: Only include tasks which have a candidate user. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_users: Only include tasks which have no candidate users. Value may only be `true`, as `false` is the default behavior.
        :param bool active: Only include active tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool suspended: Only include suspended tasks. Value may only be `true`, as `false` is the default behavior.
        :param str task_variables: Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param str process_variables: Only include tasks that belong to process instances that have variables with certain  values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`; `notLike`. `key` and `value` may not contain underscore or comma characters.
        :param str case_instance_variables: Only include tasks that belong to case instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match all variable names in this query case-insensitively. If set `variableName` and `variablename` are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values in this query case-insensitively. If set `variableValue` and `variablevalue` are treated as equal.
        :param str parent_task_id: Restrict query to all tasks that are sub tasks of the given task. Takes a task id.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'task_id_in',
            'process_instance_id',
            'process_instance_id_in',
            'process_instance_business_key',
            'process_instance_business_key_expression',
            'process_instance_business_key_in',
            'process_instance_business_key_like',
            'process_instance_business_key_like_expression',
            'process_definition_id',
            'process_definition_key',
            'process_definition_key_in',
            'process_definition_name',
            'process_definition_name_like',
            'execution_id',
            'case_instance_id',
            'case_instance_business_key',
            'case_instance_business_key_like',
            'case_definition_id',
            'case_definition_key',
            'case_definition_name',
            'case_definition_name_like',
            'case_execution_id',
            'activity_instance_id_in',
            'tenant_id_in',
            'without_tenant_id',
            'assignee',
            'assignee_expression',
            'assignee_like',
            'assignee_like_expression',
            'assignee_in',
            'owner',
            'owner_expression',
            'candidate_group',
            'candidate_group_expression',
            'candidate_user',
            'candidate_user_expression',
            'include_assigned_tasks',
            'involved_user',
            'involved_user_expression',
            'assigned',
            'unassigned',
            'task_definition_key',
            'task_definition_key_in',
            'task_definition_key_like',
            'name',
            'name_not_equal',
            'name_like',
            'name_not_like',
            'description',
            'description_like',
            'priority',
            'max_priority',
            'min_priority',
            'due_date',
            'due_date_expression',
            'due_after',
            'due_after_expression',
            'due_before',
            'due_before_expression',
            'without_due_date',
            'follow_up_date',
            'follow_up_date_expression',
            'follow_up_after',
            'follow_up_after_expression',
            'follow_up_before',
            'follow_up_before_expression',
            'follow_up_before_or_not_existent',
            'follow_up_before_or_not_existent_expression',
            'created_on',
            'created_on_expression',
            'created_after',
            'created_after_expression',
            'created_before',
            'created_before_expression',
            'delegation_state',
            'candidate_groups',
            'candidate_groups_expression',
            'with_candidate_groups',
            'without_candidate_groups',
            'with_candidate_users',
            'without_candidate_users',
            'active',
            'suspended',
            'task_variables',
            'process_variables',
            'case_instance_variables',
            'variable_names_ignore_case',
            'variable_values_ignore_case',
            'parent_task_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tasks_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('taskId', local_var_params['task_id']))  # noqa: E501
        if 'task_id_in' in local_var_params and local_var_params['task_id_in'] is not None:  # noqa: E501
            query_params.append(('taskIdIn', local_var_params['task_id_in']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_id_in' in local_var_params and local_var_params['process_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceIdIn', local_var_params['process_instance_id_in']))  # noqa: E501
        if 'process_instance_business_key' in local_var_params and local_var_params['process_instance_business_key'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKey', local_var_params['process_instance_business_key']))  # noqa: E501
        if 'process_instance_business_key_expression' in local_var_params and local_var_params['process_instance_business_key_expression'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyExpression', local_var_params['process_instance_business_key_expression']))  # noqa: E501
        if 'process_instance_business_key_in' in local_var_params and local_var_params['process_instance_business_key_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyIn', local_var_params['process_instance_business_key_in']))  # noqa: E501
        if 'process_instance_business_key_like' in local_var_params and local_var_params['process_instance_business_key_like'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyLike', local_var_params['process_instance_business_key_like']))  # noqa: E501
        if 'process_instance_business_key_like_expression' in local_var_params and local_var_params['process_instance_business_key_like_expression'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyLikeExpression', local_var_params['process_instance_business_key_like_expression']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'process_definition_name' in local_var_params and local_var_params['process_definition_name'] is not None:  # noqa: E501
            query_params.append(('processDefinitionName', local_var_params['process_definition_name']))  # noqa: E501
        if 'process_definition_name_like' in local_var_params and local_var_params['process_definition_name_like'] is not None:  # noqa: E501
            query_params.append(('processDefinitionNameLike', local_var_params['process_definition_name_like']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'case_instance_business_key' in local_var_params and local_var_params['case_instance_business_key'] is not None:  # noqa: E501
            query_params.append(('caseInstanceBusinessKey', local_var_params['case_instance_business_key']))  # noqa: E501
        if 'case_instance_business_key_like' in local_var_params and local_var_params['case_instance_business_key_like'] is not None:  # noqa: E501
            query_params.append(('caseInstanceBusinessKeyLike', local_var_params['case_instance_business_key_like']))  # noqa: E501
        if 'case_definition_id' in local_var_params and local_var_params['case_definition_id'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionId', local_var_params['case_definition_id']))  # noqa: E501
        if 'case_definition_key' in local_var_params and local_var_params['case_definition_key'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionKey', local_var_params['case_definition_key']))  # noqa: E501
        if 'case_definition_name' in local_var_params and local_var_params['case_definition_name'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionName', local_var_params['case_definition_name']))  # noqa: E501
        if 'case_definition_name_like' in local_var_params and local_var_params['case_definition_name_like'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionNameLike', local_var_params['case_definition_name_like']))  # noqa: E501
        if 'case_execution_id' in local_var_params and local_var_params['case_execution_id'] is not None:  # noqa: E501
            query_params.append(('caseExecutionId', local_var_params['case_execution_id']))  # noqa: E501
        if 'activity_instance_id_in' in local_var_params and local_var_params['activity_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('activityInstanceIdIn', local_var_params['activity_instance_id_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'assignee' in local_var_params and local_var_params['assignee'] is not None:  # noqa: E501
            query_params.append(('assignee', local_var_params['assignee']))  # noqa: E501
        if 'assignee_expression' in local_var_params and local_var_params['assignee_expression'] is not None:  # noqa: E501
            query_params.append(('assigneeExpression', local_var_params['assignee_expression']))  # noqa: E501
        if 'assignee_like' in local_var_params and local_var_params['assignee_like'] is not None:  # noqa: E501
            query_params.append(('assigneeLike', local_var_params['assignee_like']))  # noqa: E501
        if 'assignee_like_expression' in local_var_params and local_var_params['assignee_like_expression'] is not None:  # noqa: E501
            query_params.append(('assigneeLikeExpression', local_var_params['assignee_like_expression']))  # noqa: E501
        if 'assignee_in' in local_var_params and local_var_params['assignee_in'] is not None:  # noqa: E501
            query_params.append(('assigneeIn', local_var_params['assignee_in']))  # noqa: E501
        if 'owner' in local_var_params and local_var_params['owner'] is not None:  # noqa: E501
            query_params.append(('owner', local_var_params['owner']))  # noqa: E501
        if 'owner_expression' in local_var_params and local_var_params['owner_expression'] is not None:  # noqa: E501
            query_params.append(('ownerExpression', local_var_params['owner_expression']))  # noqa: E501
        if 'candidate_group' in local_var_params and local_var_params['candidate_group'] is not None:  # noqa: E501
            query_params.append(('candidateGroup', local_var_params['candidate_group']))  # noqa: E501
        if 'candidate_group_expression' in local_var_params and local_var_params['candidate_group_expression'] is not None:  # noqa: E501
            query_params.append(('candidateGroupExpression', local_var_params['candidate_group_expression']))  # noqa: E501
        if 'candidate_user' in local_var_params and local_var_params['candidate_user'] is not None:  # noqa: E501
            query_params.append(('candidateUser', local_var_params['candidate_user']))  # noqa: E501
        if 'candidate_user_expression' in local_var_params and local_var_params['candidate_user_expression'] is not None:  # noqa: E501
            query_params.append(('candidateUserExpression', local_var_params['candidate_user_expression']))  # noqa: E501
        if 'include_assigned_tasks' in local_var_params and local_var_params['include_assigned_tasks'] is not None:  # noqa: E501
            query_params.append(('includeAssignedTasks', local_var_params['include_assigned_tasks']))  # noqa: E501
        if 'involved_user' in local_var_params and local_var_params['involved_user'] is not None:  # noqa: E501
            query_params.append(('involvedUser', local_var_params['involved_user']))  # noqa: E501
        if 'involved_user_expression' in local_var_params and local_var_params['involved_user_expression'] is not None:  # noqa: E501
            query_params.append(('involvedUserExpression', local_var_params['involved_user_expression']))  # noqa: E501
        if 'assigned' in local_var_params and local_var_params['assigned'] is not None:  # noqa: E501
            query_params.append(('assigned', local_var_params['assigned']))  # noqa: E501
        if 'unassigned' in local_var_params and local_var_params['unassigned'] is not None:  # noqa: E501
            query_params.append(('unassigned', local_var_params['unassigned']))  # noqa: E501
        if 'task_definition_key' in local_var_params and local_var_params['task_definition_key'] is not None:  # noqa: E501
            query_params.append(('taskDefinitionKey', local_var_params['task_definition_key']))  # noqa: E501
        if 'task_definition_key_in' in local_var_params and local_var_params['task_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('taskDefinitionKeyIn', local_var_params['task_definition_key_in']))  # noqa: E501
        if 'task_definition_key_like' in local_var_params and local_var_params['task_definition_key_like'] is not None:  # noqa: E501
            query_params.append(('taskDefinitionKeyLike', local_var_params['task_definition_key_like']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name_not_equal' in local_var_params and local_var_params['name_not_equal'] is not None:  # noqa: E501
            query_params.append(('nameNotEqual', local_var_params['name_not_equal']))  # noqa: E501
        if 'name_like' in local_var_params and local_var_params['name_like'] is not None:  # noqa: E501
            query_params.append(('nameLike', local_var_params['name_like']))  # noqa: E501
        if 'name_not_like' in local_var_params and local_var_params['name_not_like'] is not None:  # noqa: E501
            query_params.append(('nameNotLike', local_var_params['name_not_like']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'description_like' in local_var_params and local_var_params['description_like'] is not None:  # noqa: E501
            query_params.append(('descriptionLike', local_var_params['description_like']))  # noqa: E501
        if 'priority' in local_var_params and local_var_params['priority'] is not None:  # noqa: E501
            query_params.append(('priority', local_var_params['priority']))  # noqa: E501
        if 'max_priority' in local_var_params and local_var_params['max_priority'] is not None:  # noqa: E501
            query_params.append(('maxPriority', local_var_params['max_priority']))  # noqa: E501
        if 'min_priority' in local_var_params and local_var_params['min_priority'] is not None:  # noqa: E501
            query_params.append(('minPriority', local_var_params['min_priority']))  # noqa: E501
        if 'due_date' in local_var_params and local_var_params['due_date'] is not None:  # noqa: E501
            query_params.append(('dueDate', local_var_params['due_date']))  # noqa: E501
        if 'due_date_expression' in local_var_params and local_var_params['due_date_expression'] is not None:  # noqa: E501
            query_params.append(('dueDateExpression', local_var_params['due_date_expression']))  # noqa: E501
        if 'due_after' in local_var_params and local_var_params['due_after'] is not None:  # noqa: E501
            query_params.append(('dueAfter', local_var_params['due_after']))  # noqa: E501
        if 'due_after_expression' in local_var_params and local_var_params['due_after_expression'] is not None:  # noqa: E501
            query_params.append(('dueAfterExpression', local_var_params['due_after_expression']))  # noqa: E501
        if 'due_before' in local_var_params and local_var_params['due_before'] is not None:  # noqa: E501
            query_params.append(('dueBefore', local_var_params['due_before']))  # noqa: E501
        if 'due_before_expression' in local_var_params and local_var_params['due_before_expression'] is not None:  # noqa: E501
            query_params.append(('dueBeforeExpression', local_var_params['due_before_expression']))  # noqa: E501
        if 'without_due_date' in local_var_params and local_var_params['without_due_date'] is not None:  # noqa: E501
            query_params.append(('withoutDueDate', local_var_params['without_due_date']))  # noqa: E501
        if 'follow_up_date' in local_var_params and local_var_params['follow_up_date'] is not None:  # noqa: E501
            query_params.append(('followUpDate', local_var_params['follow_up_date']))  # noqa: E501
        if 'follow_up_date_expression' in local_var_params and local_var_params['follow_up_date_expression'] is not None:  # noqa: E501
            query_params.append(('followUpDateExpression', local_var_params['follow_up_date_expression']))  # noqa: E501
        if 'follow_up_after' in local_var_params and local_var_params['follow_up_after'] is not None:  # noqa: E501
            query_params.append(('followUpAfter', local_var_params['follow_up_after']))  # noqa: E501
        if 'follow_up_after_expression' in local_var_params and local_var_params['follow_up_after_expression'] is not None:  # noqa: E501
            query_params.append(('followUpAfterExpression', local_var_params['follow_up_after_expression']))  # noqa: E501
        if 'follow_up_before' in local_var_params and local_var_params['follow_up_before'] is not None:  # noqa: E501
            query_params.append(('followUpBefore', local_var_params['follow_up_before']))  # noqa: E501
        if 'follow_up_before_expression' in local_var_params and local_var_params['follow_up_before_expression'] is not None:  # noqa: E501
            query_params.append(('followUpBeforeExpression', local_var_params['follow_up_before_expression']))  # noqa: E501
        if 'follow_up_before_or_not_existent' in local_var_params and local_var_params['follow_up_before_or_not_existent'] is not None:  # noqa: E501
            query_params.append(('followUpBeforeOrNotExistent', local_var_params['follow_up_before_or_not_existent']))  # noqa: E501
        if 'follow_up_before_or_not_existent_expression' in local_var_params and local_var_params['follow_up_before_or_not_existent_expression'] is not None:  # noqa: E501
            query_params.append(('followUpBeforeOrNotExistentExpression', local_var_params['follow_up_before_or_not_existent_expression']))  # noqa: E501
        if 'created_on' in local_var_params and local_var_params['created_on'] is not None:  # noqa: E501
            query_params.append(('createdOn', local_var_params['created_on']))  # noqa: E501
        if 'created_on_expression' in local_var_params and local_var_params['created_on_expression'] is not None:  # noqa: E501
            query_params.append(('createdOnExpression', local_var_params['created_on_expression']))  # noqa: E501
        if 'created_after' in local_var_params and local_var_params['created_after'] is not None:  # noqa: E501
            query_params.append(('createdAfter', local_var_params['created_after']))  # noqa: E501
        if 'created_after_expression' in local_var_params and local_var_params['created_after_expression'] is not None:  # noqa: E501
            query_params.append(('createdAfterExpression', local_var_params['created_after_expression']))  # noqa: E501
        if 'created_before' in local_var_params and local_var_params['created_before'] is not None:  # noqa: E501
            query_params.append(('createdBefore', local_var_params['created_before']))  # noqa: E501
        if 'created_before_expression' in local_var_params and local_var_params['created_before_expression'] is not None:  # noqa: E501
            query_params.append(('createdBeforeExpression', local_var_params['created_before_expression']))  # noqa: E501
        if 'delegation_state' in local_var_params and local_var_params['delegation_state'] is not None:  # noqa: E501
            query_params.append(('delegationState', local_var_params['delegation_state']))  # noqa: E501
        if 'candidate_groups' in local_var_params and local_var_params['candidate_groups'] is not None:  # noqa: E501
            query_params.append(('candidateGroups', local_var_params['candidate_groups']))  # noqa: E501
        if 'candidate_groups_expression' in local_var_params and local_var_params['candidate_groups_expression'] is not None:  # noqa: E501
            query_params.append(('candidateGroupsExpression', local_var_params['candidate_groups_expression']))  # noqa: E501
        if 'with_candidate_groups' in local_var_params and local_var_params['with_candidate_groups'] is not None:  # noqa: E501
            query_params.append(('withCandidateGroups', local_var_params['with_candidate_groups']))  # noqa: E501
        if 'without_candidate_groups' in local_var_params and local_var_params['without_candidate_groups'] is not None:  # noqa: E501
            query_params.append(('withoutCandidateGroups', local_var_params['without_candidate_groups']))  # noqa: E501
        if 'with_candidate_users' in local_var_params and local_var_params['with_candidate_users'] is not None:  # noqa: E501
            query_params.append(('withCandidateUsers', local_var_params['with_candidate_users']))  # noqa: E501
        if 'without_candidate_users' in local_var_params and local_var_params['without_candidate_users'] is not None:  # noqa: E501
            query_params.append(('withoutCandidateUsers', local_var_params['without_candidate_users']))  # noqa: E501
        if 'active' in local_var_params and local_var_params['active'] is not None:  # noqa: E501
            query_params.append(('active', local_var_params['active']))  # noqa: E501
        if 'suspended' in local_var_params and local_var_params['suspended'] is not None:  # noqa: E501
            query_params.append(('suspended', local_var_params['suspended']))  # noqa: E501
        if 'task_variables' in local_var_params and local_var_params['task_variables'] is not None:  # noqa: E501
            query_params.append(('taskVariables', local_var_params['task_variables']))  # noqa: E501
        if 'process_variables' in local_var_params and local_var_params['process_variables'] is not None:  # noqa: E501
            query_params.append(('processVariables', local_var_params['process_variables']))  # noqa: E501
        if 'case_instance_variables' in local_var_params and local_var_params['case_instance_variables'] is not None:  # noqa: E501
            query_params.append(('caseInstanceVariables', local_var_params['case_instance_variables']))  # noqa: E501
        if 'variable_names_ignore_case' in local_var_params and local_var_params['variable_names_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableNamesIgnoreCase', local_var_params['variable_names_ignore_case']))  # noqa: E501
        if 'variable_values_ignore_case' in local_var_params and local_var_params['variable_values_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableValuesIgnoreCase', local_var_params['variable_values_ignore_case']))  # noqa: E501
        if 'parent_task_id' in local_var_params and local_var_params['parent_task_id'] is not None:  # noqa: E501
            query_params.append(('parentTaskId', local_var_params['parent_task_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_bpmn_error(self, id, **kwargs):  # noqa: E501
        """Handle BPMN Error  # noqa: E501

        Reports a business error in the context of a running task by id. The error code must be specified to identify the BPMN error handler. See the documentation for [Reporting Bpmn Error](https://docs.camunda.org/manual/7.15/reference/bpmn20/tasks/user-task/#reporting-bpmn-error) in User Tasks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_bpmn_error(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task a BPMN error is reported for. (required)
        :param TaskBpmnErrorDto task_bpmn_error_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.handle_bpmn_error_with_http_info(id, **kwargs)  # noqa: E501

    def handle_bpmn_error_with_http_info(self, id, **kwargs):  # noqa: E501
        """Handle BPMN Error  # noqa: E501

        Reports a business error in the context of a running task by id. The error code must be specified to identify the BPMN error handler. See the documentation for [Reporting Bpmn Error](https://docs.camunda.org/manual/7.15/reference/bpmn20/tasks/user-task/#reporting-bpmn-error) in User Tasks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_bpmn_error_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task a BPMN error is reported for. (required)
        :param TaskBpmnErrorDto task_bpmn_error_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'task_bpmn_error_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_bpmn_error" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `handle_bpmn_error`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'task_bpmn_error_dto' in local_var_params:
            body_params = local_var_params['task_bpmn_error_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/bpmnError', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_escalation(self, id, **kwargs):  # noqa: E501
        """Handle BPMN Escalation  # noqa: E501

        Reports an escalation in the context of a running task by id. The escalation code must be specified to identify the escalation handler. See the documentation for [Reporting Bpmn Escalation](https://docs.camunda.org/manual/7.15/reference/bpmn20/tasks/user-task/#reporting-bpmn-escalation) in User Tasks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_escalation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task in which context a BPMN escalation is reported. (required)
        :param TaskEscalationDto task_escalation_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.handle_escalation_with_http_info(id, **kwargs)  # noqa: E501

    def handle_escalation_with_http_info(self, id, **kwargs):  # noqa: E501
        """Handle BPMN Escalation  # noqa: E501

        Reports an escalation in the context of a running task by id. The escalation code must be specified to identify the escalation handler. See the documentation for [Reporting Bpmn Escalation](https://docs.camunda.org/manual/7.15/reference/bpmn20/tasks/user-task/#reporting-bpmn-escalation) in User Tasks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_escalation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task in which context a BPMN escalation is reported. (required)
        :param TaskEscalationDto task_escalation_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'task_escalation_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_escalation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `handle_escalation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'task_escalation_dto' in local_var_params:
            body_params = local_var_params['task_escalation_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/bpmnEscalation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_tasks(self, **kwargs):  # noqa: E501
        """Get List (POST)  # noqa: E501

        Queries for tasks that fulfill a given filter. This method is slightly more powerful than the [Get Tasks](https://docs.camunda.org/manual/7.15/reference/rest/task/get-query/) method because it allows filtering by multiple process or task variables of types `String`, `Number` or `Boolean`. The size of the result set can be retrieved by using the [Get Task Count (POST)](https://docs.camunda.org/manual/7.15/reference/rest/task/post-query-count/) method.  **Security Consideration**: There are several parameters (such as `assigneeExpression`) for specifying an EL expression. These are disabled by default to prevent remote code execution. See the section on [security considerations for custom code](https://docs.camunda.org/manual/7.15/user-guide/process-engine/securing-custom-code/) in the user guide for details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_tasks(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param TaskQueryDto task_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[TaskDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_tasks_with_http_info(**kwargs)  # noqa: E501

    def query_tasks_with_http_info(self, **kwargs):  # noqa: E501
        """Get List (POST)  # noqa: E501

        Queries for tasks that fulfill a given filter. This method is slightly more powerful than the [Get Tasks](https://docs.camunda.org/manual/7.15/reference/rest/task/get-query/) method because it allows filtering by multiple process or task variables of types `String`, `Number` or `Boolean`. The size of the result set can be retrieved by using the [Get Task Count (POST)](https://docs.camunda.org/manual/7.15/reference/rest/task/post-query-count/) method.  **Security Consideration**: There are several parameters (such as `assigneeExpression`) for specifying an EL expression. These are disabled by default to prevent remote code execution. See the section on [security considerations for custom code](https://docs.camunda.org/manual/7.15/user-guide/process-engine/securing-custom-code/) in the user guide for details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_tasks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param TaskQueryDto task_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[TaskDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'first_result',
            'max_results',
            'task_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_tasks" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'task_query_dto' in local_var_params:
            body_params = local_var_params['task_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TaskDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_tasks_count(self, **kwargs):  # noqa: E501
        """Get List Count (POST)  # noqa: E501

        Retrieves the number of tasks that fulfill the given filter. Corresponds to the size of the result set of the [Get Tasks (POST)](https://docs.camunda.org/manual/7.15/reference/rest/task/post-query/) method and takes the same parameters.  **Security Consideration**: There are several parameters (such as `assigneeExpression`) for specifying an EL expression. These are disabled by default to prevent remote code execution. See the section on [security considerations for custom code](https://docs.camunda.org/manual/7.15/user-guide/process-engine/securing-custom-code/) in the user guide for details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_tasks_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TaskQueryDto task_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_tasks_count_with_http_info(**kwargs)  # noqa: E501

    def query_tasks_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get List Count (POST)  # noqa: E501

        Retrieves the number of tasks that fulfill the given filter. Corresponds to the size of the result set of the [Get Tasks (POST)](https://docs.camunda.org/manual/7.15/reference/rest/task/post-query/) method and takes the same parameters.  **Security Consideration**: There are several parameters (such as `assigneeExpression`) for specifying an EL expression. These are disabled by default to prevent remote code execution. See the section on [security considerations for custom code](https://docs.camunda.org/manual/7.15/user-guide/process-engine/securing-custom-code/) in the user guide for details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_tasks_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param TaskQueryDto task_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_tasks_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'task_query_dto' in local_var_params:
            body_params = local_var_params['task_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/count', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resolve(self, id, **kwargs):  # noqa: E501
        """Resolve  # noqa: E501

        Resolves a task and updates execution variables.  Resolving a task marks that the assignee is done with the task delegated to them, and that it can be sent back to the owner. Can only be executed when the task has been delegated. The assignee will be set to the owner, who performed the delegation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resolve(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to resolve. (required)
        :param CompleteTaskDto complete_task_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.resolve_with_http_info(id, **kwargs)  # noqa: E501

    def resolve_with_http_info(self, id, **kwargs):  # noqa: E501
        """Resolve  # noqa: E501

        Resolves a task and updates execution variables.  Resolving a task marks that the assignee is done with the task delegated to them, and that it can be sent back to the owner. Can only be executed when the task has been delegated. The assignee will be set to the owner, who performed the delegation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resolve_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to resolve. (required)
        :param CompleteTaskDto complete_task_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'complete_task_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resolve" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `resolve`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'complete_task_dto' in local_var_params:
            body_params = local_var_params['complete_task_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/resolve', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_assignee(self, id, **kwargs):  # noqa: E501
        """Set Assignee  # noqa: E501

        Changes the assignee of a task to a specific user.  **Note:** The difference with the [Claim Task](https://docs.camunda.org/manual/7.15/reference/rest/task/post-claim/) method is that this method does not check if the task already has a user assigned to it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_assignee(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to set the assignee for. (required)
        :param UserIdDto user_id_dto: Provide the id of the user that will be the assignee of the task.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_assignee_with_http_info(id, **kwargs)  # noqa: E501

    def set_assignee_with_http_info(self, id, **kwargs):  # noqa: E501
        """Set Assignee  # noqa: E501

        Changes the assignee of a task to a specific user.  **Note:** The difference with the [Claim Task](https://docs.camunda.org/manual/7.15/reference/rest/task/post-claim/) method is that this method does not check if the task already has a user assigned to it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_assignee_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to set the assignee for. (required)
        :param UserIdDto user_id_dto: Provide the id of the user that will be the assignee of the task.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'user_id_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_assignee" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `set_assignee`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_id_dto' in local_var_params:
            body_params = local_var_params['user_id_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/assignee', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def submit(self, id, **kwargs):  # noqa: E501
        """Submit Form  # noqa: E501

        Completes a task and updates process variables using a form submit. There are two difference between this method and the `complete` method:  * If the task is in state `PENDING` - i.e., has been delegated before, it is not completed but resolved. Otherwise it will be completed. * If the task has Form Field Metadata defined, the process engine will perform backend validation for any form fields which have validators defined. See the [Generated Task Forms](https://docs.camunda.org/manual/7.15/user-guide/task-forms/_index/#generated-task-forms) section of the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/) for more information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to submit the form for. (required)
        :param CompleteTaskDto complete_task_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, VariableValueDto)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.submit_with_http_info(id, **kwargs)  # noqa: E501

    def submit_with_http_info(self, id, **kwargs):  # noqa: E501
        """Submit Form  # noqa: E501

        Completes a task and updates process variables using a form submit. There are two difference between this method and the `complete` method:  * If the task is in state `PENDING` - i.e., has been delegated before, it is not completed but resolved. Otherwise it will be completed. * If the task has Form Field Metadata defined, the process engine will perform backend validation for any form fields which have validators defined. See the [Generated Task Forms](https://docs.camunda.org/manual/7.15/user-guide/task-forms/_index/#generated-task-forms) section of the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/) for more information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to submit the form for. (required)
        :param CompleteTaskDto complete_task_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, VariableValueDto), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'complete_task_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `submit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'complete_task_dto' in local_var_params:
            body_params = local_var_params['complete_task_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/submit-form', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, VariableValueDto)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unclaim(self, id, **kwargs):  # noqa: E501
        """Unclaim  # noqa: E501

        Resets a task's assignee. If successful, the task is not assigned to a user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unclaim(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to unclaim. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.unclaim_with_http_info(id, **kwargs)  # noqa: E501

    def unclaim_with_http_info(self, id, **kwargs):  # noqa: E501
        """Unclaim  # noqa: E501

        Resets a task's assignee. If successful, the task is not assigned to a user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unclaim_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to unclaim. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unclaim" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `unclaim`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}/unclaim', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_task(self, id, **kwargs):  # noqa: E501
        """Update  # noqa: E501

        Updates a task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_task(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to be updated. (required)
        :param TaskDto task_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_task_with_http_info(id, **kwargs)  # noqa: E501

    def update_task_with_http_info(self, id, **kwargs):  # noqa: E501
        """Update  # noqa: E501

        Updates a task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_task_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to be updated. (required)
        :param TaskDto task_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'task_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'task_dto' in local_var_params:
            body_params = local_var_params['task_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/task/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
