# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.15.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class IncidentApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def clear_incident_annotation(self, id, **kwargs):  # noqa: E501
        """Clear Incident Annotation  # noqa: E501

        Clears the annotation of an incident with given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_incident_annotation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the incident to clear the annotation at. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clear_incident_annotation_with_http_info(id, **kwargs)  # noqa: E501

    def clear_incident_annotation_with_http_info(self, id, **kwargs):  # noqa: E501
        """Clear Incident Annotation  # noqa: E501

        Clears the annotation of an incident with given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_incident_annotation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the incident to clear the annotation at. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clear_incident_annotation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `clear_incident_annotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/incident/{id}/annotation', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_incident(self, id, **kwargs):  # noqa: E501
        """Get Incident  # noqa: E501

        Retrieves an incident by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incident(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the incident to be retrieved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IncidentDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_incident_with_http_info(id, **kwargs)  # noqa: E501

    def get_incident_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Incident  # noqa: E501

        Retrieves an incident by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incident_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the incident to be retrieved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IncidentDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_incident" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_incident`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/incident/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncidentDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_incidents(self, **kwargs):  # noqa: E501
        """Get List  # noqa: E501

        Queries for incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.15/reference/rest/incident/get-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incidents(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str incident_id: Restricts to incidents that have the given id.
        :param str incident_type: Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Restricts to incidents that have the given incident message.
        :param str incident_message_like: Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character '%' to express like-strategy: starts with (`string%`), ends with (`%string`) or contains (`%string%`).
        :param str process_definition_id: Restricts to incidents that belong to a process definition with the given id.
        :param str process_definition_key_in: Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list.
        :param str process_instance_id: Restricts to incidents that belong to a process instance with the given id.
        :param str execution_id: Restricts to incidents that belong to an execution with the given id.
        :param datetime incident_timestamp_before: Restricts to incidents that have an incidentTimestamp date before the given date. By default, the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime incident_timestamp_after: Restricts to incidents that have an incidentTimestamp date after the given date. By default*, the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Restricts to incidents that belong to an activity with the given id.
        :param str failed_activity_id: Restricts to incidents that were created due to the failure of an activity with the given id.
        :param str cause_incident_id: Restricts to incidents that have the given incident id as cause incident.
        :param str root_cause_incident_id: Restricts to incidents that have the given incident id as root cause incident.
        :param str configuration: Restricts to incidents that have the given parameter set as configuration.
        :param str tenant_id_in: Restricts to incidents that have one of the given comma-separated tenant ids.
        :param str job_definition_id_in: Restricts to incidents that have one of the given comma-separated job definition ids.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[IncidentDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_incidents_with_http_info(**kwargs)  # noqa: E501

    def get_incidents_with_http_info(self, **kwargs):  # noqa: E501
        """Get List  # noqa: E501

        Queries for incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.15/reference/rest/incident/get-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incidents_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str incident_id: Restricts to incidents that have the given id.
        :param str incident_type: Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Restricts to incidents that have the given incident message.
        :param str incident_message_like: Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character '%' to express like-strategy: starts with (`string%`), ends with (`%string`) or contains (`%string%`).
        :param str process_definition_id: Restricts to incidents that belong to a process definition with the given id.
        :param str process_definition_key_in: Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list.
        :param str process_instance_id: Restricts to incidents that belong to a process instance with the given id.
        :param str execution_id: Restricts to incidents that belong to an execution with the given id.
        :param datetime incident_timestamp_before: Restricts to incidents that have an incidentTimestamp date before the given date. By default, the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime incident_timestamp_after: Restricts to incidents that have an incidentTimestamp date after the given date. By default*, the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Restricts to incidents that belong to an activity with the given id.
        :param str failed_activity_id: Restricts to incidents that were created due to the failure of an activity with the given id.
        :param str cause_incident_id: Restricts to incidents that have the given incident id as cause incident.
        :param str root_cause_incident_id: Restricts to incidents that have the given incident id as root cause incident.
        :param str configuration: Restricts to incidents that have the given parameter set as configuration.
        :param str tenant_id_in: Restricts to incidents that have one of the given comma-separated tenant ids.
        :param str job_definition_id_in: Restricts to incidents that have one of the given comma-separated job definition ids.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[IncidentDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'incident_id',
            'incident_type',
            'incident_message',
            'incident_message_like',
            'process_definition_id',
            'process_definition_key_in',
            'process_instance_id',
            'execution_id',
            'incident_timestamp_before',
            'incident_timestamp_after',
            'activity_id',
            'failed_activity_id',
            'cause_incident_id',
            'root_cause_incident_id',
            'configuration',
            'tenant_id_in',
            'job_definition_id_in',
            'sort_by',
            'sort_order'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_incidents" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'incident_id' in local_var_params and local_var_params['incident_id'] is not None:  # noqa: E501
            query_params.append(('incidentId', local_var_params['incident_id']))  # noqa: E501
        if 'incident_type' in local_var_params and local_var_params['incident_type'] is not None:  # noqa: E501
            query_params.append(('incidentType', local_var_params['incident_type']))  # noqa: E501
        if 'incident_message' in local_var_params and local_var_params['incident_message'] is not None:  # noqa: E501
            query_params.append(('incidentMessage', local_var_params['incident_message']))  # noqa: E501
        if 'incident_message_like' in local_var_params and local_var_params['incident_message_like'] is not None:  # noqa: E501
            query_params.append(('incidentMessageLike', local_var_params['incident_message_like']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'incident_timestamp_before' in local_var_params and local_var_params['incident_timestamp_before'] is not None:  # noqa: E501
            query_params.append(('incidentTimestampBefore', local_var_params['incident_timestamp_before']))  # noqa: E501
        if 'incident_timestamp_after' in local_var_params and local_var_params['incident_timestamp_after'] is not None:  # noqa: E501
            query_params.append(('incidentTimestampAfter', local_var_params['incident_timestamp_after']))  # noqa: E501
        if 'activity_id' in local_var_params and local_var_params['activity_id'] is not None:  # noqa: E501
            query_params.append(('activityId', local_var_params['activity_id']))  # noqa: E501
        if 'failed_activity_id' in local_var_params and local_var_params['failed_activity_id'] is not None:  # noqa: E501
            query_params.append(('failedActivityId', local_var_params['failed_activity_id']))  # noqa: E501
        if 'cause_incident_id' in local_var_params and local_var_params['cause_incident_id'] is not None:  # noqa: E501
            query_params.append(('causeIncidentId', local_var_params['cause_incident_id']))  # noqa: E501
        if 'root_cause_incident_id' in local_var_params and local_var_params['root_cause_incident_id'] is not None:  # noqa: E501
            query_params.append(('rootCauseIncidentId', local_var_params['root_cause_incident_id']))  # noqa: E501
        if 'configuration' in local_var_params and local_var_params['configuration'] is not None:  # noqa: E501
            query_params.append(('configuration', local_var_params['configuration']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'job_definition_id_in' in local_var_params and local_var_params['job_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionIdIn', local_var_params['job_definition_id_in']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/incident', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IncidentDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_incidents_count(self, **kwargs):  # noqa: E501
        """Get List Count  # noqa: E501

        Queries for the number of incidents that fulfill given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.15/reference/rest/incident/get-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incidents_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str incident_id: Restricts to incidents that have the given id.
        :param str incident_type: Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Restricts to incidents that have the given incident message.
        :param str incident_message_like: Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character '%' to express like-strategy: starts with (`string%`), ends with (`%string`) or contains (`%string%`).
        :param str process_definition_id: Restricts to incidents that belong to a process definition with the given id.
        :param str process_definition_key_in: Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list.
        :param str process_instance_id: Restricts to incidents that belong to a process instance with the given id.
        :param str execution_id: Restricts to incidents that belong to an execution with the given id.
        :param datetime incident_timestamp_before: Restricts to incidents that have an incidentTimestamp date before the given date. By default, the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime incident_timestamp_after: Restricts to incidents that have an incidentTimestamp date after the given date. By default*, the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Restricts to incidents that belong to an activity with the given id.
        :param str failed_activity_id: Restricts to incidents that were created due to the failure of an activity with the given id.
        :param str cause_incident_id: Restricts to incidents that have the given incident id as cause incident.
        :param str root_cause_incident_id: Restricts to incidents that have the given incident id as root cause incident.
        :param str configuration: Restricts to incidents that have the given parameter set as configuration.
        :param str tenant_id_in: Restricts to incidents that have one of the given comma-separated tenant ids.
        :param str job_definition_id_in: Restricts to incidents that have one of the given comma-separated job definition ids.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[CountResultDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_incidents_count_with_http_info(**kwargs)  # noqa: E501

    def get_incidents_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get List Count  # noqa: E501

        Queries for the number of incidents that fulfill given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.15/reference/rest/incident/get-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incidents_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str incident_id: Restricts to incidents that have the given id.
        :param str incident_type: Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.15/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Restricts to incidents that have the given incident message.
        :param str incident_message_like: Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character '%' to express like-strategy: starts with (`string%`), ends with (`%string`) or contains (`%string%`).
        :param str process_definition_id: Restricts to incidents that belong to a process definition with the given id.
        :param str process_definition_key_in: Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list.
        :param str process_instance_id: Restricts to incidents that belong to a process instance with the given id.
        :param str execution_id: Restricts to incidents that belong to an execution with the given id.
        :param datetime incident_timestamp_before: Restricts to incidents that have an incidentTimestamp date before the given date. By default, the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime incident_timestamp_after: Restricts to incidents that have an incidentTimestamp date after the given date. By default*, the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Restricts to incidents that belong to an activity with the given id.
        :param str failed_activity_id: Restricts to incidents that were created due to the failure of an activity with the given id.
        :param str cause_incident_id: Restricts to incidents that have the given incident id as cause incident.
        :param str root_cause_incident_id: Restricts to incidents that have the given incident id as root cause incident.
        :param str configuration: Restricts to incidents that have the given parameter set as configuration.
        :param str tenant_id_in: Restricts to incidents that have one of the given comma-separated tenant ids.
        :param str job_definition_id_in: Restricts to incidents that have one of the given comma-separated job definition ids.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[CountResultDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'incident_id',
            'incident_type',
            'incident_message',
            'incident_message_like',
            'process_definition_id',
            'process_definition_key_in',
            'process_instance_id',
            'execution_id',
            'incident_timestamp_before',
            'incident_timestamp_after',
            'activity_id',
            'failed_activity_id',
            'cause_incident_id',
            'root_cause_incident_id',
            'configuration',
            'tenant_id_in',
            'job_definition_id_in'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_incidents_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'incident_id' in local_var_params and local_var_params['incident_id'] is not None:  # noqa: E501
            query_params.append(('incidentId', local_var_params['incident_id']))  # noqa: E501
        if 'incident_type' in local_var_params and local_var_params['incident_type'] is not None:  # noqa: E501
            query_params.append(('incidentType', local_var_params['incident_type']))  # noqa: E501
        if 'incident_message' in local_var_params and local_var_params['incident_message'] is not None:  # noqa: E501
            query_params.append(('incidentMessage', local_var_params['incident_message']))  # noqa: E501
        if 'incident_message_like' in local_var_params and local_var_params['incident_message_like'] is not None:  # noqa: E501
            query_params.append(('incidentMessageLike', local_var_params['incident_message_like']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'incident_timestamp_before' in local_var_params and local_var_params['incident_timestamp_before'] is not None:  # noqa: E501
            query_params.append(('incidentTimestampBefore', local_var_params['incident_timestamp_before']))  # noqa: E501
        if 'incident_timestamp_after' in local_var_params and local_var_params['incident_timestamp_after'] is not None:  # noqa: E501
            query_params.append(('incidentTimestampAfter', local_var_params['incident_timestamp_after']))  # noqa: E501
        if 'activity_id' in local_var_params and local_var_params['activity_id'] is not None:  # noqa: E501
            query_params.append(('activityId', local_var_params['activity_id']))  # noqa: E501
        if 'failed_activity_id' in local_var_params and local_var_params['failed_activity_id'] is not None:  # noqa: E501
            query_params.append(('failedActivityId', local_var_params['failed_activity_id']))  # noqa: E501
        if 'cause_incident_id' in local_var_params and local_var_params['cause_incident_id'] is not None:  # noqa: E501
            query_params.append(('causeIncidentId', local_var_params['cause_incident_id']))  # noqa: E501
        if 'root_cause_incident_id' in local_var_params and local_var_params['root_cause_incident_id'] is not None:  # noqa: E501
            query_params.append(('rootCauseIncidentId', local_var_params['root_cause_incident_id']))  # noqa: E501
        if 'configuration' in local_var_params and local_var_params['configuration'] is not None:  # noqa: E501
            query_params.append(('configuration', local_var_params['configuration']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'job_definition_id_in' in local_var_params and local_var_params['job_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionIdIn', local_var_params['job_definition_id_in']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/incident/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CountResultDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resolve_incident(self, id, **kwargs):  # noqa: E501
        """Resolve Incident  # noqa: E501

        Resolves an incident with given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resolve_incident(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the incident to be resolved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.resolve_incident_with_http_info(id, **kwargs)  # noqa: E501

    def resolve_incident_with_http_info(self, id, **kwargs):  # noqa: E501
        """Resolve Incident  # noqa: E501

        Resolves an incident with given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resolve_incident_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the incident to be resolved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resolve_incident" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `resolve_incident`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/incident/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_incident_annotation(self, id, **kwargs):  # noqa: E501
        """Set Incident Annotation  # noqa: E501

        Sets the annotation of an incident with given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_incident_annotation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the incident to clear the annotation at. (required)
        :param AnnotationDto annotation_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_incident_annotation_with_http_info(id, **kwargs)  # noqa: E501

    def set_incident_annotation_with_http_info(self, id, **kwargs):  # noqa: E501
        """Set Incident Annotation  # noqa: E501

        Sets the annotation of an incident with given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_incident_annotation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the incident to clear the annotation at. (required)
        :param AnnotationDto annotation_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'annotation_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_incident_annotation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `set_incident_annotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'annotation_dto' in local_var_params:
            body_params = local_var_params['annotation_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/incident/{id}/annotation', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
