(this["webpackJsonpmasterful-ai-visualize-frontend"]=this["webpackJsonpmasterful-ai-visualize-frontend"]||[]).push([[0],{395:function(e,a,t){e.exports=t.p+"media/react-logo-transparent.f7d45c01.svg"},398:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABgCAYAAADimHc4AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABPlJREFUeNrsndFxGjEQhgWT96MD/JZHmDQAqcCkAi4VBFfgcwe4Ah8V5FJBoIEMfswbdMBV4GjjvRnGg08St3vi8L8zN3jGRivtJ61WqwX3Xl5eDCSe9GECAAAACAAAAAQAAAACAAAAAQAAgAAAAEAAAAAgAAAAEAAAAAgAXK18iqW4/PJ5yj9ukz9/Dy3qHdiXsX0OVu82NoBeW1URbPDUPvQ6fPtr+6ztU1ij5AoGJ70z+0xO/Mkz615a3burA2ANQLNt+c7gT8nePgtrjEJA98K+ZPZJPN+yYt2HqwBgDZCy8ZMz3r6yhkgbzPoiAPrb1Thtyz2pAWDjPzVsJhgCG59cyqhJ99uC0Fd0O08CTc1tW1nge5YNjW94xa4ZZifD0EKwrXtriBtP8LTRzoX0EoS8cwDY9QyFm80CZr+k3B6Fy51ZAQuFNucud8Bub6igO+0MAHYVI6W+ziIZatalFXCj2FdX22MlvYnvHnQJADT9pavtQUT4FxcFxZBRFzstDeAQcSwbADBma65TBgDgzuusFXWPOwGAs4i/tDrriEaKDw9A6TTqZQhOnG0+PABriLWiIVyhaKakd6h1FtAKQ+lUWrZ9KmX4D106EasA4Ku9qQKEoSs5ZnXTKlgpTaruHMTYJ5Ox9sJNLzx0k7EepQ96GplR1ZMwQxgLG+OWM58u3QTqq3m9dJcS8T2mzaoIMloulDLYWANPA3ST4e6FhvKV95puAWBDDDhMlbi1+hZSOcETgAyXNNRLLnUsVTnRajKOOs3+WWKTzENCQ8E9aSh51omSDRWCQDO5CLk4Zwgzgehszlev3QRwBKFp2mIUOhuPVkJTCE8SUVHs+4BUwCXQbMzPgCBxd11wJUacTZh98LEf3oXWV/Is+i1gDAo3pyGbo9VNm/itgO7v59a0BgM4KrKdvRNR0NKmgWW+MHgGS0RGpHvmGyby/rETiIwMu9M0NDryBsCzfRk4Y7yKXYUNUen1mgDCZ4SSx5uLAmgYQ+95Vm4dOgjuD8ljB8/IomX4/w+KPGbnaugrG7+Km9ce6QPpewTq709XuMhGkr7MmRjP2tK+x+yQOD0mfHAa1BhiJ5y3OQ4X24ZfhchF0xWwFFyaI4/QLzc6UniEpXsFvRP+kEg4AN5058IdWjiW5VoJwNBlCEXdWd2Y61aARpFtYmouNpQ/EOEaj5buxNTcptUBmCp1yNXuRnEVjCMAMHWTru/w2TEAaEqd7p2i3snZYajSkozhi0lcUVjrgk/KRxYAuGAApZJO12FLs8La1fb+kgBo+eJtw993UffmHABaxa6541S6Vlp9pUeaWmvMRTAATqlKL8m9Z65eIzez9DRUeREAqmN0WweSE8aSNETpA4Azo9LwH+tC3L6jQ7QKVoId8dpX2BCpJHjfmyquLZXKyj67JrFPGLoQ6NCKSwX9T2uvFymPQuBDfftUYMylD/i+z2y0T5P6zodzv3aGod01MMJdKPijFdgEQlUg4Iyqgi7l+UI+M37fw0OhVyZRR8l6Q74FhQywENKdsRfwvRd55HF7ubyzylI4qzgzp5NbtNwLjdwK1+BUT3JiyVe6C2G91deepe9MgmfWnYeOu9fl/6RXVaZJVit76r0xr/VQu6YTrYd/ZRhXkIwDAACAAAAAQAAAACAAAAAQAAAACAAAAAQAAAACAAAAAQAAgADA9co/AQYAxFP6eJtSmv0AAAAASUVORK5CYII="},399:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAYUlEQVR4Ae3NwQ1AQBQA0e2ODpSjGnVJbBnC04CNlS/swbvOYVI7fuiQlY3RwawsPsEGhTZgVSejrxiEJkt5EATw/cBNNYP9nUFAWwMXmhyAFPD5YPGc7WzQI3vGlH7NOACG5pfo9HAxcQAAAABJRU5ErkJggg=="},400:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABgCAYAAADimHc4AAACtElEQVR4Ae3cO05VURyFcRuNGh/XRxgCI7CixjAYaOkMN9I4BBgFgxBFwXdotLGSgoTQYKCCnwUkFIjnHtzcfyDr68/OyreS89iPcyNUEkIIAVOYSu4isIKV5C4AkzjEISaTe8xg2SnLyT1GMIF9p+xjIrnHBBadZTG5xwDuYsdZdnA3uS8ZzDqf2eS+JHAHc9h2PtuYw53kbvvgWsSO0dnBIiaS+//el5dw4OIcYAmTyd3vM30Fh9pxiBVMJXcKqM+dW1B97i7yEC4ir6FF5EOsnExFZDIuuTMdnQUZPMcq9rCJIW6OIXeWJLHg76xjcIm5syiPoX+zgUHL3NmW0iG/QQkduUOH/I4SmhP59SVEfn0JkV9fQuTXlxD5W1UlRP6JUAyLSoj8BteGJgL7j7GOWzHfQv7Fx3oZ+Qz1Y7rhmD8ivz+7eNYx7gC/dLMX+WhZAgbYMBprkd+whJ7yjzAT+Y1K6CkfFiK/XQnTPeUPI7/7VXMauxoT+d18wKOT655hN/IL5B9zWkLkF8hvVULkd/PxjPyOEprLj/xuMB35dfIH7V8167elRH79xqzIL92aWCD/U738+s25lfIfjzjuQ6y3l1+/PT3yqw9oFMj/XCK/4IhS5Bcc0ov8gmOqkX+dD2oXyH/fXn79rwoiv/pnHQXyv+DJiOM+aCD/+hRQIP9de/n1t6DIr38IR375a2jkF3yIFcj/Wi+//m8plfKf9pC/ViD/6kzGYSHyi6ajMYMjo/HtessvWJDBWnv57lfKv1JLkvitm62e8t9Wy78yi/L4bjTmr6H8+m0peGF05hvLD7iJ1/1LiPxm4B7e9CqhXn5KOL2mSn5K+FkoPyUUyE8JBfJTQr38lFAvPyXUy08J9fJTQr38lLCafy8Ugtt4hU3sYRXPYyYcE0IIIYQQQvgDlYF75V2EaQoAAAAASUVORK5CYII="},401:function(e,a){e.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAQAAAD9CzEMAAAAkUlEQVRYw+3Xyw2AIBAEUPtAa7UatDL0gjWMJy9emJ2Nv7hzZuclBELousgLg4SMBa2Men0FF41ABh+FQAEuJY5JZo1EmAErIQA2QgIshAjwhAywhAPgCBfAEE4A3wBccwH8EGi9OAFcD8QxjXsQQBzTRwDbB+Sc0gYmF5DbQI9Nrq9IzG4OmLGayxdkqj5ye3ZY2irQOtTXPQAAAABJRU5ErkJggg=="},422:function(e,a,t){e.exports=t(762)},427:function(e,a,t){},762:function(e,a,t){"use strict";t.r(a);var l=t(0),n=t.n(l),r=t(42),i=t.n(r),s=t(96),c=(t(427),t(428),t(429),t(11)),o=t(54),m=t(33),u=t(805),d=t(395),h=t.n(d),f=function(e){var a=e.show;return n.a.createElement("div",{className:"preloader bg-soft flex-column justify-content-center align-items-center ".concat(a?"":"show")},n.a.createElement(u.a,{className:"loader-element animate__animated animate__jackInTheBox",src:h.a,height:40}))},p=t(236),g=(t(828),t(829)),v=t(806),y=t(827),A=t(413),E=t(398),_=t.n(E),b=t(399),k=t.n(b),x=t(400),P=t.n(x),N=t(401),S=t.n(N),M={path:"/policies"},R={path:"/datasets"},B={path:"/docs"},C=function(){var e="v".concat("0.3.5.7"),a=Object(m.g)(),t=a.pathname,r=Object(l.useState)(!1),i=Object(c.a)(r,2),o=i[0],d=i[1],h=o?"show":"",f=function(e){var a=e.title,l=e.link,r=e.external,i=e.target,c=e.icon,o=e.image,m=e.badgeText,h=e.badgeBg,f=void 0===h?"secondary":h,y=e.badgeColor,A=void 0===y?"primary":y,E=m?"d-flex justify-content-start align-items-center justify-content-between":"",_=l===t?"active":"",b=r?{href:l}:{as:s.b,to:l};return n.a.createElement(g.a.Item,{className:_,onClick:function(){return d(!1)}},n.a.createElement(g.a.Link,Object.assign({},b,{target:i,className:E}),n.a.createElement("span",null,c?n.a.createElement("span",{className:"sidebar-icon"},n.a.createElement(p.a,{icon:c})," "):null,o?n.a.createElement(u.a,{src:o,width:20,height:20,className:"sidebar-icon svg-icon"}):null,n.a.createElement("span",{className:"sidebar-text"},a)),m?n.a.createElement(v.a,{pill:!0,bg:f,text:A,className:"badge-md notification-count ms-2"},m):null))};return n.a.createElement(n.a.Fragment,null,n.a.createElement(A.a,{className:"collapse ".concat(h," sidebar d-md-block bg-primary text-white")},n.a.createElement("div",{className:"sidebar-inner px-4 pt-3"},n.a.createElement(g.a,{className:"flex-column pt-3 pt-md-0"},n.a.createElement("div",{className:"masterful-sidebar-div"},n.a.createElement("img",{src:_.a,className:"masterful-sidebar-logo"}),n.a.createElement("p",{className:"masterful-sidebar-text"},"Masterful AI")),n.a.createElement(y.a.Divider,{className:"my-3 border-indigo"}),n.a.createElement(f,{title:"Data Health Check",link:R.path,image:k.a}),n.a.createElement(f,{title:"Training Policies",link:M.path,image:P.a}),n.a.createElement(f,{title:"Docs",link:B.path,image:S.a}),n.a.createElement("div",{className:"sidebar-version-container"},n.a.createElement("p",{className:"sidebar-version"},e))))))},w=t(10),D=t(15),O=t(16),L=t(17),T=t(807),j=t(808),V=t(109),I=t.n(V),F=t(831),W=t(809),Q=function(e){var a=e.policies,t=e.onTableRowClick;"object"!==typeof a&&(a=[]);var l=function(e){var a=e.policy_name,t=e.handleClick,l=e.engine_version;return n.a.createElement("tr",null,n.a.createElement("th",{scope:"row",onClick:function(){return t(a)}}," ",a),n.a.createElement("td",null,l))};return n.a.createElement(F.a,{border:"light",className:"shadow-sm"},n.a.createElement(F.a.Header,null,n.a.createElement(T.a,{className:"align-items-center"},n.a.createElement(j.a,null,n.a.createElement("h5",null,"Training Policies"),n.a.createElement("p",null,"Select a training policy to visualize")))),n.a.createElement(W.a,{responsive:!0,className:"align-items-center table-flush"},n.a.createElement("thead",{className:"thead-light"},n.a.createElement("tr",null,n.a.createElement("th",{scope:"col"},"Policy Name"),n.a.createElement("th",{scope:"col"},"Policy Engine"))),n.a.createElement("tbody",null,a.map((function(e){return n.a.createElement(l,Object.assign({handleClick:t,key:"policy-".concat(e.policy_name)},e))})))))},K=function(e){var a=e.datasets,t=e.onTableRowClick;"object"!==typeof a&&(a=[]);var l=function(e){var a=e.title,t=e.task,l=e.handleClick,r=e.total_cardinality,i=e.train_cardinality,s=e.test_cardinality;return n.a.createElement("tr",null,n.a.createElement("th",{scope:"row",onClick:function(){return l(a)}}," ",a),n.a.createElement("td",null,r),n.a.createElement("td",null,i," / ",s),n.a.createElement("td",null,t))};return n.a.createElement(F.a,{border:"light",className:"shadow-sm"},n.a.createElement(F.a.Header,null,n.a.createElement(T.a,{className:"align-items-center"},n.a.createElement(j.a,null,n.a.createElement("h5",null,"Datasets"),n.a.createElement("p",null,"Select a dataset to visualize")))),n.a.createElement(W.a,{responsive:!0,className:"align-items-center table-flush"},n.a.createElement("thead",{className:"thead-light"},n.a.createElement("tr",null,n.a.createElement("th",{scope:"col"},"Dataset"),n.a.createElement("th",{scope:"col"},"Cardinality"),n.a.createElement("th",{scope:"col"},"Train / Test Split"),n.a.createElement("th",{scope:"col"},"Task"))),n.a.createElement("tbody",null,a.map((function(e){return n.a.createElement(l,Object.assign({handleClick:t,key:"dataset-".concat(e.title)},e))})))))},z=t(100),Y=t(412),U=function(e){var a=e.title,t=e.policyName,l=e.policyEngine,r=e.plotData,i=e.plotVariables;return n.a.createElement(F.a,{className:"shadow-sm"},n.a.createElement(F.a.Header,{className:"d-flex flex-row align-items-center flex-0"},n.a.createElement("div",{className:"d-block"},n.a.createElement("h3",{className:"fw-normal mb-2"},a),n.a.createElement("h6",{className:"fw-normal mb-2"},"Policy: ",t),n.a.createElement("h6",{className:"fw-normal mb-2"},"Policy Engine: ",l))),n.a.createElement(F.a.Body,{className:"p-2",style:{minHeight:1e3,height:1200,minWidth:400}},n.a.createElement(Y.a,{data:r,variables:i.reverse().map((function(e){return"selected"===e.actionKey?{key:e.actionKey,legend:e.actionLegend,type:"point",ticksPosition:"before",legendPosition:"start",legendOffset:20,padding:1,values:e.values}:{key:e.actionKey,legend:e.actionLegend,type:"linear",min:e.min,max:e.max,ticksPosition:"before",legendPosition:"start",legendOffset:20}})),margin:{top:50,right:60,bottom:50,left:60},layout:"vertical",colors:function(e){var a=e.size,t=Array(a);return t.fill("#ef9a9a"),t[a-1]="#00e676",t}({size:r.length}),strokeWidth:3,lineOpacity:.8,curve:"monotoneY",motionConfig:"molasses",theme:{fontSize:14,axis:{domain:{line:{stroke:"#dde1e9",strokeWidth:1}}}}})))},H=function(e){var a=e.title,t=e.policyName,l=e.policyEngine,r=e.data,i=e.min,s=e.max;return n.a.createElement(F.a,{className:"shadow-sm"},n.a.createElement(F.a.Header,{className:"d-flex flex-row align-items-center flex-0"},n.a.createElement("div",{className:"d-block"},n.a.createElement("h3",{className:"fw-normal mb-2"},a),n.a.createElement("h6",{className:"fw-normal mb-2"},"Policy: ",t),n.a.createElement("h6",{className:"fw-normal mb-2"},"Policy Engine: ",l))),n.a.createElement(F.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},n.a.createElement(z.a,{data:r,keys:["Baseline Recall","Better Recall","Worse Recall"],indexBy:"classLabel",margin:{top:50,right:130,bottom:4,left:60},padding:.3,minValue:i,isInteractive:!0,maxValue:s,colors:function(e){var a=e.id;return"Baseline Recall"===a?"#2962ff":"Better Recall"===a?"#64dd17":"#c51162"},label:function(e){var a=e.id,t=e.value,l=e.data;return"Worse Recall"==a?"-".concat(t,"%"):"".concat("Baseline Recall"==a?l["Actual Baseline Recall"]:t,"%")},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisBottom:null,axisRight:null,axisTop:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Class Label",legendPosition:"middle",legendOffset:-32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Recall",legendPosition:"middle",legendOffset:-40},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff",legends:[{dataFrom:"keys",anchor:"bottom-right",direction:"column",justify:!1,translateX:80,translateY:0,itemsSpacing:2,itemWidth:100,itemHeight:20,itemDirection:"left-to-right",itemOpacity:.85,symbolSize:20,effects:[{on:"hover",style:{itemOpacity:1}}]}]})),n.a.createElement("p",{class:"lead chart-description-paragraph"},"Recall is defined as TP / P, or equivalently, TP / (TP + FN). The term Recall has the same meaning as True Positive Rate and sensitivity."))},J=function(e){var a=e.title,t=e.policyName,l=e.policyEngine,r=e.data,i=e.min,s=e.max;return n.a.createElement(F.a,{className:"shadow-sm"},n.a.createElement(F.a.Header,{className:"d-flex flex-row align-items-center flex-0"},n.a.createElement("div",{className:"d-block"},n.a.createElement("h3",{className:"fw-normal mb-2"},a),n.a.createElement("h6",{className:"fw-normal mb-2"},"Policy: ",t),n.a.createElement("h6",{className:"fw-normal mb-2"},"Policy Engine: ",l))),n.a.createElement(F.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},n.a.createElement(z.a,{data:r,keys:["Baseline Precision","Better Precision","Worse Precision"],indexBy:"classLabel",margin:{top:50,right:140,bottom:4,left:60},padding:.3,minValue:i,maxValue:s,theme:{fontSize:16},colors:function(e){var a=e.id;return"Baseline Precision"===a?"#2962ff":"Better Precision"===a?"#64dd17":"#c51162"},label:function(e){var a=e.id,t=e.value,l=e.data;return"Worse Precision"==a?"-".concat(t,"%"):"".concat("Baseline Precision"==a?l["Actual Baseline Precision"]:t,"%")},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisBottom:null,axisRight:null,axisTop:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Class Prediction",legendPosition:"middle",legendOffset:-32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Precision",legendPosition:"middle",legendOffset:-40},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff",legends:[{dataFrom:"keys",anchor:"bottom-right",direction:"column",justify:!1,translateX:80,translateY:0,itemsSpacing:2,itemWidth:100,itemHeight:20,itemDirection:"left-to-right",itemOpacity:.85,symbolSize:20,effects:[{on:"hover",style:{itemOpacity:1}}]}]})),n.a.createElement("p",{class:"lead chart-description-paragraph"},"Precision is defined as TP / PP, where PP means Predicted Positives. Or equivalently, TP / (TP + FP). The term Precision has the same meaning as Positive Predictive Value."))},X=function(e){var a=e.title,t=e.datasetTitle,l=e.keys,r=e.data;return n.a.createElement(F.a,{className:"shadow-sm"},n.a.createElement(F.a.Header,{className:"d-flex flex-row align-items-center flex-0"},n.a.createElement("div",{className:"d-block"},n.a.createElement("h3",{className:"fw-normal mb-2"},a),n.a.createElement("h6",{className:"fw-normal mb-2"},"Dataset: ",t))),n.a.createElement(F.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},n.a.createElement(z.a,{data:r,keys:l,indexBy:"classLabel",margin:{top:50,right:130,bottom:50,left:100},padding:.3,colors:function(e){var a=e.id;return"train"===a?"#64dd17":"test"===a?"#c51162":"val"===a?"#ffd600":"#64dd17"},groupMode:"grouped",layout:"horizontal",valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisTop:null,axisRight:null,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"# Labels",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Class Labels",legendPosition:"middle",legendOffset:-60},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff",legends:[{dataFrom:"keys",anchor:"bottom-right",direction:"column",justify:!1,translateX:120,translateY:0,itemsSpacing:2,itemWidth:100,itemHeight:20,itemDirection:"left-to-right",itemOpacity:.85,symbolSize:20,effects:[{on:"hover",style:{itemOpacity:1}}]}]})))},G=function(e){var a=e.title,t=e.policyName,l=e.policyEngine,r=e.data,i=e.keys,s=e.maxVal;return n.a.createElement(F.a,{className:"shadow-sm"},n.a.createElement(F.a.Header,{className:"d-flex flex-row align-items-center flex-0"},n.a.createElement("div",{className:"d-block"},n.a.createElement("h3",{className:"fw-normal mb-2"},a),n.a.createElement("h6",{className:"fw-normal mb-2"},"Policy: ",t),n.a.createElement("h6",{className:"fw-normal mb-2"},"Policy Engine: ",l))),n.a.createElement(F.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},n.a.createElement(z.a,{data:r,keys:i,indexBy:"technique",margin:{top:50,right:130,bottom:50,left:60},padding:.3,minValue:0,maxValue:s,colors:function(e){var a=e.id,t=e.data;return"lowerPart"===a||"upperPart"===a?"#0000":"original"===t.technique?"#9e9e9e":"with Masterful"===t.technique?"#00796b":"#80cbc4"},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},axisTop:null,axisRight:null,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Technique",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Val loss",legendPosition:"middle",legendOffset:-50},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff"})))},Z=function(e){var a=e.policyName,t=e.policyEngine,l=e.data,r=e.reductionRate;return n.a.createElement(F.a,{className:"shadow-sm"},n.a.createElement(F.a.Header,{className:"d-flex flex-row align-items-center flex-0"},n.a.createElement("div",{className:"d-block"},n.a.createElement("h3",{className:"fw-normal mb-2"},"Error Rate Reduction"),n.a.createElement("h4",{className:"fw-normal mb-2"},"Reduction: ",r,"%"),n.a.createElement("h6",{className:"fw-normal mb-2"},"Policy: ",a),n.a.createElement("h6",{className:"fw-normal mb-2"},"Policy Engine: ",t))),n.a.createElement(F.a.Body,{className:"p-2",style:{minHeight:1e3,height:1e3,minWidth:400}},n.a.createElement(z.a,{data:l,keys:["errorRate"],indexBy:"Model",margin:{top:50,right:130,bottom:50,left:60},padding:.3,minValue:0,colors:function(e){return"original"===e.data.Model?"#80cbc4":"#00796b"},label:function(e){var a=e.value;return"".concat(a,"%")},valueScale:{type:"linear"},indexScale:{type:"band",round:!0},theme:{fontSize:14},axisTop:null,axisRight:null,axisBottom:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Model",legendPosition:"middle",legendOffset:32},axisLeft:{tickSize:5,tickPadding:5,tickRotation:0,legend:"Error Rate",legendPosition:"middle",legendOffset:-40},labelSkipWidth:12,labelSkipHeight:12,labelTextColor:"#ffffff"})))},q="http://127.0.0.1:7007/",$={"Access-Control-Allow-Origin":"*","Access-Control-Allow-Methods":"*","Access-Control-Allow-Headers":"*"},ee=function(e){Object(O.a)(t,e);var a=Object(L.a)(t);function t(e){var l;return Object(w.a)(this,t),(l=a.call(this,e)).state={selectedDatasetIndex:null,datasets:[],intervalId:null},l}return Object(D.a)(t,[{key:"componentDidMount",value:function(){var e=this;this.sync_();var a=setInterval((function(){e.sync_()}),6e5);this.setState({intervalId:a})}},{key:"componentWillUnmount",value:function(){null!==this.state.intervalId&&(clearInterval(this.state.intervalId),this.setState({intervalId:null}))}},{key:"sync_",value:function(){var e=this;I.a.get(String(q+"scan/"),{headers:$}).then((function(e){return I.a.get(String(q+"api/dataset/"),{headers:$})})).then((function(a){if(a.data.length>0){var t=a.data.slice();e.setState({datasets:t})}})).catch((function(e){console.log(e)}))}},{key:"createLabelDistributionKeys_",value:function(e){var a=[];return"ALL"===e.split?(a.push("train"),a.push("test"),e.val_cardinality>0&&a.push("val")):a.push("overall"),a}},{key:"createLabelDistributionWidgetData_",value:function(e){var a=[];if("ALL"===e.split)for(var t=0;t<e.num_classes;t++){var l={};l.classLabel=e.labels_map[t]?e.labels_map[t]:t,l.train=e.train_label_distribution[t],l.test=e.test_label_distribution[t],e.val_cardinality>0&&(l.val=e.val_label_distribution[t]),a.push(l)}else for(var n=0;n<e.num_classes;n++){var r={};r.classLabel=e.labels_map[n],r.overall=e.total_label_distribution[n],a.push(r)}return a}},{key:"render",value:function(){var e=this,a={datasetTitle:"",labelDistributionWidgetKeys:[],labelDistributionWidgetData:[]};if(0!==this.state.datasets.length&&null!==this.state.selectedDatasetIndex){var t=this.state.selectedDatasetIndex,l=this.state.datasets[t];a.datasetTitle=l.title,a.labelDistributionWidgetKeys=this.createLabelDistributionKeys_(l),a.labelDistributionWidgetData=this.createLabelDistributionWidgetData_(l)}var r=function(a){var t=e.state.datasets.findIndex((function(e){return e.title===a}));e.setState({selectedDatasetIndex:t})};return null!==this.state.selectedDatasetIndex?n.a.createElement(n.a.Fragment,null,n.a.createElement(T.a,{className:"justify-content-md-center"},n.a.createElement(j.a,{xs:12,className:"mb-4"},n.a.createElement(K,{datasets:this.state.datasets,onTableRowClick:r})),n.a.createElement(j.a,{xs:12,className:"mb-4 d-none d-sm-block"},n.a.createElement(X,{title:"Label Distribution",datasetTitle:a.datasetTitle,data:a.labelDistributionWidgetData,keys:a.labelDistributionWidgetKeys})))):n.a.createElement(n.a.Fragment,null,n.a.createElement(T.a,{className:"justify-content-md-center"},n.a.createElement(j.a,{xs:12,className:"mb-4"},n.a.createElement(K,{datasets:this.state.datasets,onTableRowClick:r}))))}}]),t}(n.a.Component),ae=t(20),te=t(113),le=t.n(te),ne=[0,10,20,30,40,50,60,70,80,90,100],re=[0,.1,.2,.3,.4,.5,.6,.7,.8,.9,1],ie=function(e){Object(O.a)(t,e);var a=Object(L.a)(t);function t(e){var l;return Object(w.a)(this,t),(l=a.call(this,e)).state={selectedPolicyIndex:null,policySearchTasks:[],intervalId:null},l}return Object(D.a)(t,[{key:"getAxisVals_",value:function(e){var a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"";if("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"===a)return ne;var t,l=re.slice(),n=Object(ae.a)(e);try{for(n.s();!(t=n.n()).done;){var r=t.value;l.includes(r)||l.push(r)}}catch(i){n.e(i)}finally{n.f()}return l.sort(),l.slice()}},{key:"getAxisMinMax_",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",a=0,t=1;return"MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"!==e&&"MASTERFUL_FIXED_MAG_LAYER"!==e||(t=100),{min:a,max:t}}},{key:"getValLossForScalar_",value:function(e,a){var t,l=-1,n=Object(ae.a)(e.val_metrics);try{for(n.s();!(t=n.n()).done;){var r=t.value;if(le.a.isEqual(r.node_scalar_map,a)){l=r.metrics.loss;break}}}catch(i){n.e(i)}finally{n.f()}return-1===l&&console.log("No val_loss found for scalar: ".concat(a," in task: ").concat(e.title)),l}},{key:"getConfusionMatrixForScalar_",value:function(e,a){var t,l=null,n=Object(ae.a)(e.val_metrics);try{for(n.s();!(t=n.n()).done;){var r=t.value;if(le.a.isEqual(r.node_scalar_map,a)){l=r.metrics.confusion_matrix;break}}}catch(i){n.e(i)}finally{n.f()}return null==l&&console.log("No confusion matrix found for scalar: ".concat(a," in task: ").concat(e.title)),l}},{key:"createActionKey_",value:function(e,a){var t=e;if(a.includes(t))for(var l=1;a.includes(t);)t=String(e+"_"+l),l++;return t}},{key:"createActionLegend_",value:function(e,a){var t=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",l=!(arguments.length>3&&void 0!==arguments[3])||arguments[3],n="",r="";if(r=l&&-1!==e.toLowerCase().indexOf("masterful")?e.split("_").slice(1).join(" "):e,"LAYER"===a)n="MASTERFUL_REPLACEMENT_RATE_LAYER"===t?"(rr)":"(m)";else{if("SYNTHETIC_DATA_BLENDING"!==a)return r;n="(r)"}return String(r.toLowerCase()+" "+n)}},{key:"getValLosMinMax_",value:function(e){var a=[],t=e.presearch_model_val_metrics.loss;a.push(t);var l,n=Object(ae.a)(e.node_search_tasks);try{for(n.s();!(l=n.n()).done;){var r,i=l.value,s=this.convertNodeScalarMapToArray_(i),c=Object(ae.a)(s);try{for(c.s();!(r=c.n()).done;){var o=r.value,m=this.getValLossForScalar_(i,o);-1!==m&&a.push(m)}}catch(u){c.e(u)}finally{c.f()}}}catch(u){n.e(u)}finally{n.f()}return a.sort(),{minValLoss:a[0],maxValLoss:a[a.length-1]}}},{key:"createCurrentPlotVariablesWithActionKeys_",value:function(e,a){var t,l=[],n=[],r=Object(ae.a)(e.node_search_tasks);try{for(r.s();!(t=r.n()).done;){var i=t.value,s=i.type;if("LAYER"===s){var c=i.searched_layers[0].layer_type;if(a&&"MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"===c){var o,m=Object(ae.a)(i.searched_layers);try{for(m.s();!(o=m.n()).done;){var u=o.value,d=u.name;n.push(d);var h=this.getAxisMinMax_(c),f=h.min,p=h.max;l.push({actionKey:d,actionLegend:this.createActionLegend_(d.toUpperCase(),s,u.layer_type),min:f,max:p})}}catch(D){m.e(D)}finally{m.f()}}else{var g,v=Object(ae.a)(i.searched_layers);try{for(v.s();!(g=v.n()).done;)for(var y=g.value,A=y.ordered_actions.length,E=0;E<A;E++){var _=y.ordered_actions[E],b=this.createActionKey_(_,n);n.push(b);var k=this.getAxisMinMax_(c),x=k.min,P=k.max;l.push({actionKey:b,actionLegend:this.createActionLegend_(_,s,c),min:x,max:P})}}catch(D){v.e(D)}finally{v.f()}}}else{var N=this.createActionKey_(i.title,n);n.push(N);var S=this.getAxisMinMax_(),M=S.min,R=S.max;l.push({actionKey:N,actionLegend:this.createActionLegend_(i.title,s),min:M,max:R})}}}catch(D){r.e(D)}finally{r.f()}var B=this.getValLosMinMax_(e),C=B.minValLoss,w=B.maxValLoss;return l.push({actionKey:"val_loss",actionLegend:"val_loss",min:C-.05,max:w+.05}),l.push({actionKey:"selected",actionLegend:"Optimal Policy",values:["SELECTED","NOT SELECTED"]}),n.push("val_loss"),n.push("selected"),{currentPlotVariables:l,actionKeysSoFar:n}}},{key:"convertNodeScalarMapToArray_",value:function(e){for(var a=[],t=Object.keys(e.node_scalars_map),l=e.node_scalars_map[t[0]].scalars.length,n=0;n<l;n++){var r,i={},s=Object(ae.a)(t);try{for(s.s();!(r=s.n()).done;){var c=r.value;i[c]=e.node_scalars_map[c].scalars[n]}}catch(o){s.e(o)}finally{s.f()}a.push(i)}return a}},{key:"createParallelCoordinatesPlotData_",value:function(e,a,t){var l=[],n=this.extractOptimalPolicyData_(e,t);l.push(this.buildParallelCoordinatesPlotDataObject_(a,n));var r,i=[],s=Object(ae.a)(e.node_search_tasks);try{for(s.s();!(r=s.n()).done;){var c,o=r.value,m=this.convertNodeScalarMapToArray_(o),u=Object(ae.a)(m);try{for(u.s();!(c=u.n()).done;){var d=c.value;if(!le.a.isEqual(d,o.node_optimal_scalar_map)){var h=[];h=h.concat(i);var f=this.extractValuesForScalar_(o,d,t);h=h.concat(f);var p=a.length-h.length-2;if(p>0){var g=new Array(p).fill(0);h=h.concat(g)}var v=this.getValLossForScalar_(o,d);h.push(v),h.push("NOT SELECTED"),l.push(this.buildParallelCoordinatesPlotDataObject_(a,h))}}}catch(y){u.e(y)}finally{u.f()}i=i.concat(this.extractValuesForScalar_(o,o.node_optimal_scalar_map,t))}}catch(y){s.e(y)}finally{s.f()}return l}},{key:"extractOptimalPolicyData_",value:function(e){var a,t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],l=e.presearch_model_val_metrics.loss,n=[],r=Object(ae.a)(e.node_search_tasks);try{for(r.s();!(a=r.n()).done;){var i=a.value;n=n.concat(this.extractValuesForScalar_(i,i.node_optimal_scalar_map,t))}}catch(o){r.e(o)}finally{r.f()}var s=e.node_search_tasks.length-1,c=this.getValLossForScalar_(e.node_search_tasks[s],e.node_search_tasks[s].node_optimal_scalar_map);if(-1===c)for(;-1===c;){if(-1===(s-=1)){c=l;break}c=this.getValLossForScalar_(e.node_search_tasks[s],e.node_search_tasks[s].node_optimal_scalar_map)}return n.push(c),n.push("SELECTED"),n}},{key:"buildParallelCoordinatesPlotDataObject_",value:function(e,a){if(e.length!==a.length)return console.log("Number of action keys (".concat(e.length,") and values (").concat(a.length,") should be identical.")),[];for(var t=[],l=0;l<e.length;l++){var n=e[l],r=a[l];t[n]=r}return t}},{key:"extractValuesForScalar_",value:function(e,a){var t=arguments.length>2&&void 0!==arguments[2]&&arguments[2],l=[];if("LAYER"===e.type){var n,r=Object(ae.a)(e.searched_layers);try{for(r.s();!(n=r.n()).done;){var i=n.value;l=l.concat(this.extractLayerValuesForScalar_(i,a[i.name],t))}}catch(s){r.e(s)}finally{r.f()}}else l.push(a[e.title]);return l}},{key:"extractLayerValuesForScalar_",value:function(e,a){var t=arguments.length>2&&void 0!==arguments[2]&&arguments[2];if("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"!==e.layer_type)return[a];if(0===a){if(t)return[0];var l=new Array(e.ordered_actions.length).fill(0);return l}for(var n=[],r=a-1,i=0;i<e.ordered_actions.length;i++){var s=e.max_index_grid[i].values[r],c=s-1,o=e.action_mag_grid[i].values[c];n.push(o)}if(t&&n.length>0){var m=0;n.forEach((function(e){return m+=e}));var u=m/n.length;return[Math.floor(100*u)/100]}return n}},{key:"sync_",value:function(){var e=this;I.a.get(String(q+"scan/"),{headers:$}).then((function(e){return I.a.get(String(q+"api/search/"),{headers:$})})).then((function(a){if(a.data.length>0){var t=a.data.slice();e.setState({policySearchTasks:t})}})).catch((function(e){return console.log(e)}))}},{key:"createBarChartKeysAndData_",value:function(e){var a=this.createBarChartImprovementData_(e),t=Object.entries(a).sort((function(e,a){return a[1]-e[1]})).map((function(e){return e[0]}));return a.policy=e.policy_name,{barChartData:a,barChartKeys:t}}},{key:"createWaterfallKeys_",value:function(){return["lowerPart","impValue","upperPart"]}},{key:"createWaterfallData_",value:function(e){var a=[],t=e.presearch_model_val_metrics.loss,l={upperPart:0,lowerPart:0,technique:"original"};l.impValue=Math.floor(1e5*t)/1e5,a.push(l);var n,r=t,i=0,s=Object(ae.a)(e.node_search_tasks);try{for(s.s();!(n=s.n()).done;){var c=n.value,o={};o.upperPart=i,o.technique=this.createBarChartKeyForNodeSearchTask_(c);var m=this.getValLossForScalar_(c,c.node_optimal_scalar_map);if(-1!==m){var u=r-m;if(!(u<=0)){var d=Math.floor(1e5*u)/1e5;o.impValue=d,o.lowerPart=t-i-o.impValue,i+=o.impValue,a.push(o),r=m}}}}catch(g){s.e(g)}finally{s.f()}var h=r,f=t-h,p={};return p.upperPart=Math.floor(1e5*f)/1e5,p.lowerPart=0,p.technique="with Masterful",p.impValue=Math.floor(1e5*h)/1e5,a.push(p),a}},{key:"getWaterfallChartMaxVal",value:function(e){return e.presearch_model_val_metrics.loss}},{key:"createBarChartKeyForNodeSearchTask_",value:function(e){var a="";if("LAYER"!==e.type)a=e.title;else if("MASTERFUL_SAMPLE_MAG_BY_QUANTILE_LAYER"===e.searched_layers[0].layer_type){var t,l=[],n=Object(ae.a)(e.searched_layers);try{for(n.s();!(t=n.n()).done;){var r=t.value.name;if(-1!==r.indexOf("masterful")){var i=r.split("_").slice(1).join(" ");l.push(i)}else l.push(r)}}catch(c){n.e(c)}finally{n.f()}var s=l.join(" & ");a=s.length<=25?s:s.slice(0,25)}else a=e.searched_layers[0].ordered_actions[0];return a.toLowerCase()}},{key:"createBarChartImprovementData_",value:function(e){var a,t={},l=e.presearch_model_val_metrics.loss,n=Object(ae.a)(e.node_search_tasks);try{for(n.s();!(a=n.n()).done;){var r=a.value,i=this.createBarChartKeyForNodeSearchTask_(r),s=this.calculateNodeSearchTaskValLossDeltaPercentage_(r,l),c=Math.floor(100*s)/100;c>0&&(t[i]=c);var o=this.getValLossForScalar_(r,r.optimal_scalar);l=o>0?o:l}}catch(m){n.e(m)}finally{n.f()}return t}},{key:"createRecallImprovementByClassChartData_",value:function(e){var a=e.presearch_model_val_metrics.label_recall_map;if(!a)return console.log("Baseline metrics unavailable. Label recall failed."),[];for(var t=null,l=e.node_search_tasks.length-1;l>=0;l--){var n=e.node_search_tasks[l];if(0!==Object.values(n.node_optimal_scalar_map)[0][0]){var r,i=Object(ae.a)(n.val_metrics);try{for(i.s();!(r=i.n()).done;){var s=r.value;if(le.a.isEqual(s.node_scalar_map,n.node_optimal_scalar_map)){t=s.metrics.label_recall_map;break}}}catch(d){i.e(d)}finally{i.f()}}}if(!t||Object.keys(a).length!==Object.keys(t).length)return[];for(var c=[],o=0;o<Object.keys(a).length;o++){var m={};m.classLabel=o,m["Actual Baseline Recall"]=Math.floor(1e4*a[o])/100;var u=Math.floor(1e4*(t[o]-a[o]))/100;u>0?(m["Better Recall"]=u,m["Baseline Recall"]=m["Actual Baseline Recall"]):(m["Worse Recall"]=Math.abs(u),m["Baseline Recall"]=m["Actual Baseline Recall"]-m["Worse Recall"]),c.push(m)}return c}},{key:"determineRecallMinMaxScaleVals_",value:function(e){if(null===e||0===e.length)return{recallMin:0,recallMax:100};var a,t=100,l=0,n=Object(ae.a)(e);try{for(n.s();!(a=n.n()).done;){var r=a.value;if(0!==r["Baseline Recall"]){r["Baseline Recall"]<t&&(t=r["Baseline Recall"]);var i=0;void 0===r["Worse Recall"]?i+=r["Baseline Recall"]+r["Better Recall"]:i+=r["Actual Baseline Recall"],i>l&&(l=i)}}}catch(s){n.e(s)}finally{n.f()}return{recallMin:t=Math.max(0,t-2),recallMax:l=Math.min(100,l+2)}}},{key:"createPrecisionImprovementByClassChartData_",value:function(e){var a=e.presearch_model_val_metrics.label_precision_map;if(!a)return console.log("Baseline metrics unavailable. Label precision calculation failed."),[];for(var t=null,l=e.node_search_tasks.length-1;l>=0;l--){var n=e.node_search_tasks[l];if(0!==Object.values(n.node_optimal_scalar_map)[0][0]){var r,i=Object(ae.a)(n.val_metrics);try{for(i.s();!(r=i.n()).done;){var s=r.value;if(le.a.isEqual(s.node_scalar_map,n.node_optimal_scalar_map)){t=s.metrics.label_precision_map;break}}}catch(d){i.e(d)}finally{i.f()}}}if(!t||Object.keys(a).length!==Object.keys(t).length)return[];for(var c=[],o=0;o<Object.keys(a).length;o++){var m={};m.classLabel=o,m["Actual Baseline Precision"]=Math.floor(1e4*a[o])/100;var u=Math.floor(1e4*(t[o]-a[o]))/100;u>0?(m["Better Precision"]=u,m["Baseline Precision"]=m["Actual Baseline Precision"]):(m["Worse Precision"]=Math.abs(u),m["Baseline Precision"]=m["Actual Baseline Precision"]-m["Worse Precision"]),c.push(m)}return c}},{key:"determinePrecisionMinMaxScaleVals_",value:function(e){if(null===e||0===e.length)return{precisionMin:0,precisionMax:100};var a,t=100,l=0,n=Object(ae.a)(e);try{for(n.s();!(a=n.n()).done;){var r=a.value;if(0!==r["Baseline Precision"]){r["Baseline Precision"]<t&&(t=r["Baseline Precision"]);var i=0;void 0===r["Worse Precision"]?i+=r["Baseline Precision"]+r["Better Precision"]:i+=r["Actual Baseline Precision"],i>l&&(l=i)}}}catch(s){n.e(s)}finally{n.f()}return{precisionMin:t=Math.max(0,t-2),precisionMax:l=Math.min(100,l+2)}}},{key:"calculateNodeSearchTaskValLossDeltaPercentage_",value:function(e,a){var t=this.getValLossForScalar_(e,e.node_optimal_scalar_map);return-1===t?0:100*(a-t)/a}},{key:"createErrorRateData_",value:function(e){var a={errPlotData:null,errReductionRate:null},t=this.computeErrorRateFromConfusionMatrix_(e.presearch_model_val_metrics.confusion_matrix);if(-1===t)return a;for(var l=e.node_search_tasks.length,n=l-1,r=l-1;r>=0;r--){var i=e.node_search_tasks[r];if(0!==Object.values(i.node_optimal_scalar_map)[0]){console.log("found non zero optimal scalar: ",i.node_optimal_scalar_map),n=r;break}}var s=e.node_search_tasks[n],c=this.getConfusionMatrixForScalar_(s,s.node_optimal_scalar_map),o=this.computeErrorRateFromConfusionMatrix_(c);if(-1===o)return a;var m=100*(t-o)/t;m=Math.floor(10*m)/10;var u=[],d={Model:"original"};d.errorRate=Math.floor(100*t)/100,u.push(d);var h={Model:"with Masterful"};return h.errorRate=Math.floor(100*o)/100,u.push(h),{errPlotData:u,errReductionRate:m}}},{key:"computeErrorRateFromConfusionMatrix_",value:function(e){var a=this.computeTruePositives_(e);if(-1===a)return console.log("Failed computing error rate."),-1;for(var t=Object.keys(e).length,l=0,n=0;n<t;n++){var r=0;e[n].values.forEach((function(e){return r+=e})),l+=r}return 0===l?(console.log("Failed computing error rate, totalSum is 0 for: ",e),-1):100*(1-a/l)}},{key:"computeTruePositives_",value:function(e){if(void 0==e)return console.log("Failed computing true positives, no confusion matrix."),-1;for(var a=0,t=Object.keys(e).length,l=0;l<t;l++){if(void 0==e[l])return console.log("Invalid confusion matrix, no data for class: ",l," in: ",e),-1;a+=e[l].values[l]}return a}},{key:"componentDidMount",value:function(){var e=this;this.sync_();var a=setInterval((function(){e.sync_()}),6e5);this.setState({intervalId:a})}},{key:"componentWillUnmount",value:function(){null!==this.state.intervalId&&(clearInterval(this.state.intervalId),this.setState({intervalId:null}))}},{key:"render",value:function(){var e=this,a={policyName:"",policyEngine:"",plotVariables:[],actionKeys:[],recallByClassData:[],precisionByClassData:[],waterfallChartKeys:[],waterfallChartData:[],waterfallChartMaxVal:1,recallMin:0,recallMax:100,precisionMin:0,precisionMax:100,errorRateReductionValue:0,errorRateReductionData:[]},t=[];if(0!==this.state.policySearchTasks.length&&null!==this.state.selectedPolicyIndex){var l=this.state.selectedPolicyIndex,r=this.state.policySearchTasks[l],i=this.createCurrentPlotVariablesWithActionKeys_(r,!0),s=i.actionKeysSoFar,c=i.currentPlotVariables;a.policyName=r.policy_name,a.policyEngine=r.engine_version,a.plotVariables=c,a.actionKeys=s,a.waterfallChartKeys=this.createWaterfallKeys_(),a.waterfallChartData=this.createWaterfallData_(r),a.waterfallChartMaxVal=this.getWaterfallChartMaxVal(r),t=(t=this.createParallelCoordinatesPlotData_(r,s,!0)).reverse();var o=this.createRecallImprovementByClassChartData_(r);a.recallByClassData=o;var m=this.createPrecisionImprovementByClassChartData_(r);a.precisionByClassData=m;var u=this.determineRecallMinMaxScaleVals_(o),d=u.recallMin,h=u.recallMax,f=this.determinePrecisionMinMaxScaleVals_(m),p=f.precisionMin,g=f.precisionMax;a.recallMin=Math.min(d,p),a.recallMax=Math.max(h,g),a.precisionMin=Math.min(d,p),a.precisionMax=Math.max(h,g);var v=this.createErrorRateData_(r),y=v.errPlotData,A=v.errReductionRate;a.errorRateReductionValue=A,a.errorRateReductionData=y}var E=function(a){var t=e.state.policySearchTasks.findIndex((function(e){return e.policy_name===a}));e.setState({selectedPolicyIndex:t})};return null!==this.state.selectedPolicyIndex?n.a.createElement(n.a.Fragment,null,n.a.createElement(T.a,{className:"justify-content-md-center post-search-parallel-coords-card"},n.a.createElement(j.a,{xs:12,className:"mb-4"},n.a.createElement(Q,{policies:this.state.policySearchTasks,onTableRowClick:E})),n.a.createElement(j.a,{xs:12,className:"mb-4 d-none d-sm-block"},n.a.createElement(U,{title:"Policy Components",policyName:a.policyName,policyEngine:a.policyEngine,plotVariables:a.plotVariables,plotData:t})),n.a.createElement(j.a,{xs:12,className:"mb-4 d-none d-sm-block"},n.a.createElement(G,{title:"Validation Loss Improvement",policyName:a.policyName,policyEngine:a.policyEngine,data:a.waterfallChartData,keys:a.waterfallChartKeys,maxVal:a.waterfallChartMaxVal})),function(){if(a.recallByClassData.length>0)return n.a.createElement(j.a,{xs:12,className:"mb-4 d-none d-sm-block"},n.a.createElement(H,{title:"Recall Improvement",policyName:a.policyName,policyEngine:a.policyEngine,data:a.recallByClassData,min:a.recallMin,max:a.recallMax}))}(),function(){if(a.precisionByClassData.length>0)return n.a.createElement(j.a,{xs:12,className:"mb-4 d-none d-sm-block"},n.a.createElement(J,{title:"Precision Improvement",policyName:a.policyName,policyEngine:a.policyEngine,data:a.precisionByClassData,min:a.precisionMin,max:a.precisionMax}))}(),function(){if(null!=a.errorRateReductionData)return n.a.createElement(j.a,{xs:12,className:"mb-4 d-none d-sm-block"},n.a.createElement(Z,{policyName:a.policyName,policyEngine:a.policyEngine,data:a.errorRateReductionData,reductionRate:a.errorRateReductionValue}))}())):n.a.createElement(n.a.Fragment,null,n.a.createElement(T.a,{className:"justify-content-md-center post-search-parallel-coords-card"},n.a.createElement(j.a,{xs:12,className:"mb-4"},n.a.createElement(Q,{policies:this.state.policySearchTasks,onTableRowClick:E}))))}}]),t}(n.a.Component),se=function(e){Object(O.a)(t,e);var a=Object(L.a)(t);function t(e){return Object(w.a)(this,t),a.call(this,e)}return Object(D.a)(t,[{key:"render",value:function(){return n.a.createElement(n.a.Fragment,null,n.a.createElement("iframe",{src:" https://masterful-public.s3.us-west-1.amazonaws.com/933013963/0.3.5/index.html",title:"Documentation",width:"100%",height:"2000"}))}}]),t}(n.a.Component),ce=function(e){var a=e.component,t=Object(o.a)(e,["component"]),r=Object(l.useState)(!1),i=Object(c.a)(r,2),s=i[0],u=i[1];Object(l.useEffect)((function(){var e=setTimeout((function(){return u(!0)}),1e3);return function(){return clearTimeout(e)}}),[]);var d=Object(l.useState)((function(){return"false"!==localStorage.getItem("settingsVisible")})),h=Object(c.a)(d,2);h[0],h[1];return n.a.createElement(m.b,Object.assign({},t,{render:function(e){return n.a.createElement(n.a.Fragment,null,n.a.createElement(f,{show:!s}),n.a.createElement(C,null),n.a.createElement("main",{className:"content"},n.a.createElement(a,e)))}}))},oe=function(){return n.a.createElement(m.d,null,n.a.createElement(ce,{exact:!0,path:M.path,component:ie}),n.a.createElement(ce,{exact:!0,path:R.path,component:ee}),n.a.createElement(ce,{exact:!0,path:B.path,component:se}),n.a.createElement(m.a,{to:M.path}))},me=function(){var e=Object(m.g)().pathname;return Object(l.useEffect)((function(){window.scrollTo({top:0,left:0,behavior:"auto"})}),[e]),null};i.a.render(n.a.createElement(s.a,null,n.a.createElement(me,null),n.a.createElement(oe,null)),document.getElementById("root"))}},[[422,1,2]]]);
//# sourceMappingURL=main.33fd0c1c.chunk.js.map