/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cogroo.entities.Token;
import org.cogroo.tools.checker.rules.model.TagMask;

public class TagMaskUtils {
    private static final Pattern REPLACE_TAGR2 = Pattern.compile("(\\w+)\\s*=\\s*([\\w-]+)");
    private static final Pattern REPLACE_R2 = Pattern.compile("(\\w+)");

    public static TagMask clone(TagMask tagMask) {
        TagMask clone = new TagMask();
        clone.setCase(tagMask.getCase());
        clone.setChunkFunction(tagMask.getChunkFunction());
        clone.setClazz(tagMask.getClazz());
        clone.setGender(tagMask.getGender());
        clone.setMood(tagMask.getMood());
        clone.setNumber(tagMask.getNumber());
        clone.setPerson(tagMask.getPerson());
        clone.setPunctuation(tagMask.getPunctuation());
        clone.setSyntacticFunction(tagMask.getSyntacticFunction());
        clone.setTense(tagMask.getTense());
        return clone;
    }

    public static TagMask parse(String text) {
        TagMask tm = new TagMask();
        Matcher m = REPLACE_TAGR2.matcher(text);
        block16: while (m.find()) {
            String property = m.group(1);
            String value = m.group(2).replace('-', ' ');
            switch (property) {
                case "number": {
                    tm.setNumber(TagMask.Number.fromValue(value));
                    continue block16;
                }
                case "gender": {
                    tm.setGender(TagMask.Gender.fromValue(value));
                    continue block16;
                }
                case "class": {
                    tm.setClazz(TagMask.Class.fromValue(value));
                    continue block16;
                }
                case "person": {
                    tm.setPerson(TagMask.Person.fromValue(value));
                    continue block16;
                }
                case "tense": {
                    tm.setTense(TagMask.Tense.fromValue(value));
                    continue block16;
                }
                case "mood": {
                    tm.setMood(TagMask.Mood.fromValue(value));
                    continue block16;
                }
            }
            throw new IllegalArgumentException("Invalid property: '" + property + "'");
        }
        return tm;
    }

    public static TagMask createTagMaskFromToken(Token token, String text) {
        TagMask tm = new TagMask();
        Matcher m = REPLACE_R2.matcher(text);
        while (m.find()) {
            String property;
            switch (property = m.group(1)) {
                case "number": {
                    tm.setNumber(token.getMorphologicalTag().getNumberE());
                    break;
                }
                case "gender": {
                    tm.setGender(token.getMorphologicalTag().getGenderE());
                    break;
                }
                case "class": {
                    tm.setClazz(token.getMorphologicalTag().getClazzE());
                    break;
                }
                case "person": {
                    tm.setPerson(token.getMorphologicalTag().getPersonE());
                    break;
                }
                case "tense": {
                    tm.setTense(token.getMorphologicalTag().getTense());
                    break;
                }
                case "mood": {
                    tm.setMood(token.getMorphologicalTag().getMood());
                    break;
                }
            }
        }
        return tm;
    }
}

