/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.formats.ad;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.cogroo.formats.ad.ADChunkBasedShallowParserSampleStream;

public class ADChunkBasedShallowParserSampleStreamFactory
extends LanguageSampleStreamFactory<ChunkSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(ChunkSample.class, "adshallowparser", new ADChunkBasedShallowParserSampleStreamFactory(Parameters.class));
    }

    protected <P> ADChunkBasedShallowParserSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<ChunkSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        this.language = params.getLang();
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory(params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError(e);
        }
        ADChunkBasedShallowParserSampleStream sampleStream = new ADChunkBasedShallowParserSampleStream(lineStream, params.getFunctTags(), params.getIsIncludePOSTags(), params.getUseCGTags(), params.getExpandME());
        if (params.getStart() != null && params.getStart() > -1) {
            sampleStream.setStart(params.getStart());
        }
        if (params.getEnd() != null && params.getEnd() > -1) {
            sampleStream.setEnd(params.getEnd());
        }
        return sampleStream;
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="includePOS", description="true if to include POS Tags. default is true")
        @ArgumentParser.OptionalParameter(defaultValue="true")
        public Boolean getIsIncludePOSTags();

        @ArgumentParser.ParameterDescription(valueName="commaSepFunctTags", description="comma separated functional tags")
        @ArgumentParser.OptionalParameter
        public String getFunctTags();

        @ArgumentParser.ParameterDescription(valueName="start", description="index of first sentence")
        @ArgumentParser.OptionalParameter
        public Integer getStart();

        @ArgumentParser.ParameterDescription(valueName="end", description="index of last sentence")
        @ArgumentParser.OptionalParameter
        public Integer getEnd();

        @ArgumentParser.ParameterDescription(valueName="cgTags", description="use CG tags instead of floresta")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getUseCGTags();

        @ArgumentParser.ParameterDescription(valueName="expandME", description="expand multiword expressions")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getExpandME();
    }
}

