/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.builders.filter;

import org.apache.log4j.bridge.FilterWrapper;
import org.apache.log4j.builders.AbstractBuilder;
import org.apache.log4j.builders.BooleanHolder;
import org.apache.log4j.builders.Holder;
import org.apache.log4j.builders.filter.FilterBuilder;
import org.apache.log4j.config.PropertiesConfiguration;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.xml.XmlConfiguration;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.filter.StringMatchFilter;
import org.apache.logging.log4j.status.StatusLogger;
import org.w3c.dom.Element;

@Plugin(name="org.apache.log4j.varia.StringMatchFilter", category="Log4j Builder")
public class StringMatchFilterBuilder
extends AbstractBuilder
implements FilterBuilder {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String STRING_TO_MATCH = "StringToMatch";
    private static final String ACCEPT_ON_MATCH = "AcceptOnMatch";

    @Override
    public Filter parseFilter(Element filterElement, XmlConfiguration config) {
        BooleanHolder acceptOnMatch = new BooleanHolder();
        Holder text = new Holder();
        XmlConfiguration.forEachElement(filterElement.getElementsByTagName("param"), currentElement -> {
            if (currentElement.getTagName().equals("param")) {
                switch (currentElement.getAttribute("name")) {
                    case "StringToMatch": {
                        text.set(currentElement.getAttribute("value"));
                        break;
                    }
                    case "AcceptOnMatch": {
                        acceptOnMatch.set(Boolean.parseBoolean(currentElement.getAttribute("value")));
                    }
                }
            }
        });
        return this.createFilter((String)text.get(), (Boolean)acceptOnMatch.get());
    }

    @Override
    public Filter parseFilter(PropertiesConfiguration config) {
        String text = this.getProperty(STRING_TO_MATCH);
        boolean acceptOnMatch = this.getBooleanProperty(ACCEPT_ON_MATCH);
        return this.createFilter(text, acceptOnMatch);
    }

    private Filter createFilter(String text, boolean acceptOnMatch) {
        if (text == null) {
            LOGGER.warn("No text provided for StringMatchFilter");
            return null;
        }
        Filter.Result onMatch = acceptOnMatch ? Filter.Result.ACCEPT : Filter.Result.DENY;
        return new FilterWrapper(((StringMatchFilter.Builder)((StringMatchFilter.Builder)StringMatchFilter.newBuilder().setMatchString(text).setOnMatch(onMatch)).setOnMismatch(Filter.Result.NEUTRAL)).build());
    }
}

