/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.util.Collections;
import java.util.Set;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAFlags;

public final class ConstantArcSizeFSA
extends FSA {
    public static final int TARGET_ADDRESS_SIZE = 4;
    public static final int FLAGS_SIZE = 1;
    public static final int LABEL_SIZE = 1;
    public static final int ARC_SIZE = 6;
    public static final int FLAGS_OFFSET = 0;
    public static final int LABEL_OFFSET = 1;
    public static final int ADDRESS_OFFSET = 2;
    static final int TERMINAL_STATE = 0;
    public static final int BIT_ARC_FINAL = 2;
    public static final int BIT_ARC_LAST = 1;
    private final int epsilon;
    private final byte[] data;

    ConstantArcSizeFSA(byte[] data, int epsilon) {
        assert (epsilon == 0) : "Epsilon is not zero?";
        this.epsilon = epsilon;
        this.data = data;
    }

    @Override
    public int getRootNode() {
        return this.getEndNode(this.getFirstArc(this.epsilon));
    }

    @Override
    public int getFirstArc(int node) {
        return node;
    }

    @Override
    public int getArc(int node, byte label) {
        int arc = this.getFirstArc(node);
        while (arc != 0) {
            if (this.getArcLabel(arc) == label) {
                return arc;
            }
            arc = this.getNextArc(arc);
        }
        return 0;
    }

    @Override
    public int getNextArc(int arc) {
        if (this.isArcLast(arc)) {
            return 0;
        }
        return arc + 6;
    }

    @Override
    public byte getArcLabel(int arc) {
        return this.data[arc + 1];
    }

    private int getArcTarget(int arc) {
        return this.data[arc += 2] << 24 | (this.data[arc + 1] & 0xFF) << 16 | (this.data[arc + 2] & 0xFF) << 8 | this.data[arc + 3] & 0xFF;
    }

    @Override
    public boolean isArcFinal(int arc) {
        return (this.data[arc + 0] & 2) != 0;
    }

    @Override
    public boolean isArcTerminal(int arc) {
        return this.getArcTarget(arc) == 0;
    }

    private boolean isArcLast(int arc) {
        return (this.data[arc + 0] & 1) != 0;
    }

    @Override
    public int getEndNode(int arc) {
        return this.getArcTarget(arc);
    }

    @Override
    public Set<FSAFlags> getFlags() {
        return Collections.emptySet();
    }
}

