#!/usr/bin/env python
import sys
import pmagpy.command_line_extractor as extractor
from pmagpy import convert_2_magic as convert

def main():
    """
    NAME
        sufar4-asc_magic.py

    DESCRIPTION
        converts ascii files generated by SUFAR ver.4.0 to MagIC formated
        files for use with PmagPy plotting software

    SYNTAX
        sufar4-asc_magic.py -h [command line options]

    OPTIONS
        -h: prints the help message and quits
        -f FILE: specify .asc input file name
        -fsp SINFILE: specify er_specimens input file with location, sample, site, etc. information
        -F MFILE: specify measurements output file
        -Fa AFILE: specify rmag_anisotropy output file # MagIC 2 only
        -Fsi SFILE: specify specimens output file
        -usr USER: specify who made the measurements
        -loc LOC: specify location name for study
        -ins INST: specify instrument used
        -spc SPEC: specify number of characters to specify specimen from sample
        -ncn NCON:  specify naming convention: default is #2 below
        -k15 : specify static 15 position mode - default is spinning
        -new : replace all existing magic files

    DEFAULTS
        AFILE: rmag_anisotropy.txt  # MagIC 2 only
        SFILE: default is to create new specimen file
        USER: ""
        LOC: "unknown"
        INST: ""
        SPEC: 0  sample name is same as site (if SPEC is 1, sample is all but last character)
        appends to  specimen/sample/site files
       Sample naming convention:
            [1] XXXXY: where XXXX is an arbitrary length site designation and Y
                is the single character sample designation.  e.g., TG001a is the
                first sample from site TG001.    [default]
            [2] XXXX-YY: YY sample from site XXXX (XXX, YY of arbitary length)
            [3] XXXX.YY: YY sample from site XXXX (XXX, YY of arbitary length)
            [4-Z] XXXX[YYY]:  YYY is sample designation with Z characters from site XXX
            [5] site name same as sample
            [6] site name entered in site_name column in the orient.txt format input file  -- NOT CURRENTLY SUPPORTED
            [7-Z] [XXXX]YYY:  XXXX is site designation with Z characters with sample name XXXXYYYY
            NB: all others you will have to customize your self
                 or e-mail ltauxe@ucsd.edu for help.
            [8] This is a synthetic
            [9] ODP naming convention

    """

    args = sys.argv
    if '-h' in args:
        print(main.__doc__)
        sys.exit()

    dataframe = extractor.command_line_dataframe([ ['WD', False, '.'], ['ID', False, ''],
                                                   ['usr', False, ''], ['ncn', False, '1'],
                                                   ['k15', False, False], ['ins', False, ''],
                                                   ['f', True, ''], ['F', False, 'measurements.txt'],
                                                   ['Fa', False, 'rmag_anisotropy.txt'],
                                                   ['Fsi', False, 'specimens.txt'],
                                                   ['loc', False, 'unknown'], ['spc', False, 0],
                                                   ['fsi', False, None], ['DM', False, 3] ])
    #'WD', 'ID', 'usr', 'ncn', 'k15', 'ins', 'f', 'F', 'Fa', 'Fsi', 'loc', 'spc',
    checked_args = extractor.extract_and_check_args(args, dataframe)
    output_dir_path, input_dir_path, user, sample_naming_con, static_15_position_mode, instrument, ascfile, meas_output, aniso_output, spec_outfile, locname, specnum, spec_infile, data_model_num = extractor.get_vars(['WD', 'ID', 'usr', 'ncn', 'k15', 'ins', 'f', 'F', 'Fa', 'Fsi', 'loc', 'spc', 'fsi', 'DM'], checked_args)

    convert.sufar4(ascfile, meas_output, aniso_output, spec_infile,
                   spec_outfile, specnum=specnum, sample_naming_con=sample_naming_con,
                   user=user, locname=locname, instrument=instrument,
                   static_15_position_mode=static_15_position_mode, dir_path=output_dir_path,
                   input_dir_path=input_dir_path, data_model_num=data_model_num)

    # do we need -new flag??
if __name__ == "__main__":
    main()
