/*
 * Decompiled with CFR 0.152.
 */
package bsearch.space;

import bsearch.space.ParameterSpec;
import org.nlogo.api.MersenneTwisterFast;

public strictfp class DoubleDiscreteSpec
extends ParameterSpec {
    private double dMin;
    private double dStep;
    private double dMax;

    public DoubleDiscreteSpec(String string, double d, double d2, double d3) {
        super(string);
        this.dMin = d;
        this.dStep = d2;
        this.dMax = d + d2 * StrictMath.floor((d3 - d) / d2);
    }

    private double enforceValidRange(double d) {
        if (d < this.dMin) {
            d = this.dMin;
        } else if (d > this.dMax) {
            d = this.dMax;
        }
        return this.dMin + (double)StrictMath.round((d - this.dMin) / this.dStep) * this.dStep;
    }

    @Override
    public Double generateRandomValue(MersenneTwisterFast mersenneTwisterFast) {
        return (double)mersenneTwisterFast.nextInt(1 + (int)StrictMath.floor((this.dMax - this.dMin) / this.dStep)) * this.dStep + this.dMin;
    }

    @Override
    public Double mutate(Object object, double d, MersenneTwisterFast mersenneTwisterFast) {
        double d2 = (this.dMax - this.dMin) * d;
        return this.enforceValidRange((Double)object + d2 * mersenneTwisterFast.nextGaussian());
    }

    @Override
    public int choiceCount() {
        return 1 + (int)StrictMath.floor((this.dMax - this.dMin) / this.dStep);
    }

    public String toString() {
        return "[ \"" + this.name + "\" [ " + this.dMin + " " + this.dStep + " " + this.dMax + " ]]";
    }

    @Override
    public Object getValueFromChoice(long l, long l2) {
        if (l < (long)this.choiceCount()) {
            return new Double(this.dMin + this.dStep * (double)l);
        }
        long l3 = StrictMath.round((double)(l % (long)this.choiceCount()) / (double)(l2 - (long)this.choiceCount()) * (double)this.choiceCount());
        return new Double(this.dMin + this.dStep * (double)l3);
    }

    @Override
    public long getChoiceIndexFromValue(Object object, long l) {
        if (!(object instanceof Number)) {
            System.out.println(object);
            throw new IllegalStateException("Type mismatch: can't represent a non-number using this double-valued parameter specification.");
        }
        double d = ((Number)object).doubleValue();
        return StrictMath.round((d - this.dMin) / this.dStep);
    }
}

