# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['deutschland',
 'deutschland.interpol',
 'deutschland.interpol.api',
 'deutschland.interpol.apis',
 'deutschland.interpol.model',
 'deutschland.interpol.models']

package_data = \
{'': ['*']}

install_requires = \
['python-dateutil', 'urllib3>=1.25.3']

setup_kwargs = {
    'name': 'de-interpol',
    'version': '0.1.0',
    'description': 'Interpol: Interpol Red Notices API',
    'long_description': '# interpol\nInterpol Red Notices Website API\n\nThis Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:\n\n- API version: 1.0.0\n- Package version: 0.1.0\n- Build package: org.openapitools.codegen.languages.PythonClientCodegen\n\n## Requirements.\n\nPython >= 3.6\n\n## Installation & Usage\n### pip install\n\n```sh\npip install deutschland[interpol]\n```\n\n### poetry install\n\n```sh\npoetry add deutschland -E interpol\n```\n\n### Setuptools\n\nInstall via [Setuptools](http://pypi.python.org/pypi/setuptools).\n\n```sh\npython setup.py install --user\n```\n(or `sudo python setup.py install` to install the package for all users)\n\n## Usage\n\nImport the package:\n```python\nfrom deutschland import interpol\n```\n\n## Getting Started\n\nPlease follow the [installation procedure](#installation--usage) and then run the following:\n\n```python\n\nimport time\nfrom deutschland import interpol\nfrom pprint import pprint\nfrom deutschland.interpol.api import default_api\nfrom deutschland.interpol.model.red_notice_detail import RedNoticeDetail\nfrom deutschland.interpol.model.red_notice_detail_images import RedNoticeDetailImages\nfrom deutschland.interpol.model.red_notices import RedNotices\n# Defining the host is optional and defaults to https://ws-public.interpol.int\n# See configuration.py for a list of all supported configuration parameters.\nconfiguration = interpol.Configuration(\n    host = "https://ws-public.interpol.int"\n)\n\n\n\n# Enter a context with an instance of the API client\nwith interpol.ApiClient(configuration) as api_client:\n    # Create an instance of the API class\n    api_instance = default_api.DefaultApi(api_client)\n    forename = "DANIELA" # str | First name (optional)\nname = "Klette" # str | Last name (optional)\nnationality = "DE" # str | Two digit country code (optional)\nage_max = 120 # int | maximum age (optional)\nage_min = 18 # int | minimum age (optional)\nfree_text = "" # str | Free text query (optional)\nsex_id = "F" # str | Free text query (optional)\narrest_warrant_country_id = "DE" # str | Two digit country code (optional)\npage = 1 # int | pagination - starts with 1 (optional)\nresult_per_page = 200 # int | resultPerPage (optional)\n\n    try:\n        # Get Red Notices\n        api_response = api_instance.notices_v1_red_get(forename=forename, name=name, nationality=nationality, age_max=age_max, age_min=age_min, free_text=free_text, sex_id=sex_id, arrest_warrant_country_id=arrest_warrant_country_id, page=page, result_per_page=result_per_page)\n        pprint(api_response)\n    except interpol.ApiException as e:\n        print("Exception when calling DefaultApi->notices_v1_red_get: %s\\n" % e)\n```\n\n## Documentation for API Endpoints\n\nAll URIs are relative to *https://ws-public.interpol.int*\n\nClass | Method | HTTP request | Description\n------------ | ------------- | ------------- | -------------\n*DefaultApi* | [**notices_v1_red_get**](docs/DefaultApi.md#notices_v1_red_get) | **GET** /notices/v1/red | Get Red Notices\n*DefaultApi* | [**notices_v1_red_notice_id_get**](docs/DefaultApi.md#notices_v1_red_notice_id_get) | **GET** /notices/v1/red/{noticeID} | Get Red Notice Details\n*DefaultApi* | [**notices_v1_red_notice_id_images_get**](docs/DefaultApi.md#notices_v1_red_notice_id_images_get) | **GET** /notices/v1/red/{noticeID}/images | Get Red Notice Images\n\n\n## Documentation For Models\n\n - [RedNoticeDetail](docs/RedNoticeDetail.md)\n - [RedNoticeDetailArrestWarrants](docs/RedNoticeDetailArrestWarrants.md)\n - [RedNoticeDetailEmbedded](docs/RedNoticeDetailEmbedded.md)\n - [RedNoticeDetailImages](docs/RedNoticeDetailImages.md)\n - [RedNoticeDetailImagesEmbedded](docs/RedNoticeDetailImagesEmbedded.md)\n - [RedNoticeDetailImagesEmbeddedImages](docs/RedNoticeDetailImagesEmbeddedImages.md)\n - [RedNoticeDetailImagesEmbeddedLinks](docs/RedNoticeDetailImagesEmbeddedLinks.md)\n - [RedNoticeDetailImagesEmbeddedLinksSelf](docs/RedNoticeDetailImagesEmbeddedLinksSelf.md)\n - [RedNoticeDetailImagesLinks](docs/RedNoticeDetailImagesLinks.md)\n - [RedNoticeDetailImagesLinksNotice](docs/RedNoticeDetailImagesLinksNotice.md)\n - [RedNoticeDetailImagesLinksSelf](docs/RedNoticeDetailImagesLinksSelf.md)\n - [RedNoticeDetailImagesLinksThumbnail](docs/RedNoticeDetailImagesLinksThumbnail.md)\n - [RedNoticeDetailLinks](docs/RedNoticeDetailLinks.md)\n - [RedNotices](docs/RedNotices.md)\n - [RedNoticesEmbedded](docs/RedNoticesEmbedded.md)\n - [RedNoticesLinks](docs/RedNoticesLinks.md)\n - [RedNoticesLinksSelf](docs/RedNoticesLinksSelf.md)\n - [RedNoticesQuery](docs/RedNoticesQuery.md)\n\n\n## Documentation For Authorization\n\n All endpoints do not require authorization.\n\n## Author\n\nkontakt@bund.dev\n\n\n## Notes for Large OpenAPI documents\nIf the OpenAPI document is large, imports in interpol.apis and interpol.models may fail with a\nRecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:\n\nSolution 1:\nUse specific imports for apis and models like:\n- `from deutschland.interpol.api.default_api import DefaultApi`\n- `from deutschland.interpol.model.pet import Pet`\n\nSolution 2:\nBefore importing the package, adjust the maximum recursion limit as shown below:\n```\nimport sys\nsys.setrecursionlimit(1500)\nfrom deutschland import interpol\nfrom deutschland.interpol.apis import *\nfrom deutschland.interpol.models import *\n```\n\n',
    'author': 'BundesAPI',
    'author_email': 'kontakt@bund.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/bundesAPI/interpol-api',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6',
}


setup(**setup_kwargs)
