# interpol
Interpol Red Notices Website API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 0.1.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

```sh
pip install deutschland[interpol]
```

### poetry install

```sh
poetry add deutschland -E interpol
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

## Usage

Import the package:
```python
from deutschland import interpol
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
from deutschland import interpol
from pprint import pprint
from deutschland.interpol.api import default_api
from deutschland.interpol.model.red_notice_detail import RedNoticeDetail
from deutschland.interpol.model.red_notice_detail_images import RedNoticeDetailImages
from deutschland.interpol.model.red_notices import RedNotices
# Defining the host is optional and defaults to https://ws-public.interpol.int
# See configuration.py for a list of all supported configuration parameters.
configuration = interpol.Configuration(
    host = "https://ws-public.interpol.int"
)



# Enter a context with an instance of the API client
with interpol.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    forename = "DANIELA" # str | First name (optional)
name = "Klette" # str | Last name (optional)
nationality = "DE" # str | Two digit country code (optional)
age_max = 120 # int | maximum age (optional)
age_min = 18 # int | minimum age (optional)
free_text = "" # str | Free text query (optional)
sex_id = "F" # str | Free text query (optional)
arrest_warrant_country_id = "DE" # str | Two digit country code (optional)
page = 1 # int | pagination - starts with 1 (optional)
result_per_page = 200 # int | resultPerPage (optional)

    try:
        # Get Red Notices
        api_response = api_instance.notices_v1_red_get(forename=forename, name=name, nationality=nationality, age_max=age_max, age_min=age_min, free_text=free_text, sex_id=sex_id, arrest_warrant_country_id=arrest_warrant_country_id, page=page, result_per_page=result_per_page)
        pprint(api_response)
    except interpol.ApiException as e:
        print("Exception when calling DefaultApi->notices_v1_red_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://ws-public.interpol.int*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**notices_v1_red_get**](docs/DefaultApi.md#notices_v1_red_get) | **GET** /notices/v1/red | Get Red Notices
*DefaultApi* | [**notices_v1_red_notice_id_get**](docs/DefaultApi.md#notices_v1_red_notice_id_get) | **GET** /notices/v1/red/{noticeID} | Get Red Notice Details
*DefaultApi* | [**notices_v1_red_notice_id_images_get**](docs/DefaultApi.md#notices_v1_red_notice_id_images_get) | **GET** /notices/v1/red/{noticeID}/images | Get Red Notice Images


## Documentation For Models

 - [RedNoticeDetail](docs/RedNoticeDetail.md)
 - [RedNoticeDetailArrestWarrants](docs/RedNoticeDetailArrestWarrants.md)
 - [RedNoticeDetailEmbedded](docs/RedNoticeDetailEmbedded.md)
 - [RedNoticeDetailImages](docs/RedNoticeDetailImages.md)
 - [RedNoticeDetailImagesEmbedded](docs/RedNoticeDetailImagesEmbedded.md)
 - [RedNoticeDetailImagesEmbeddedImages](docs/RedNoticeDetailImagesEmbeddedImages.md)
 - [RedNoticeDetailImagesEmbeddedLinks](docs/RedNoticeDetailImagesEmbeddedLinks.md)
 - [RedNoticeDetailImagesEmbeddedLinksSelf](docs/RedNoticeDetailImagesEmbeddedLinksSelf.md)
 - [RedNoticeDetailImagesLinks](docs/RedNoticeDetailImagesLinks.md)
 - [RedNoticeDetailImagesLinksNotice](docs/RedNoticeDetailImagesLinksNotice.md)
 - [RedNoticeDetailImagesLinksSelf](docs/RedNoticeDetailImagesLinksSelf.md)
 - [RedNoticeDetailImagesLinksThumbnail](docs/RedNoticeDetailImagesLinksThumbnail.md)
 - [RedNoticeDetailLinks](docs/RedNoticeDetailLinks.md)
 - [RedNotices](docs/RedNotices.md)
 - [RedNoticesEmbedded](docs/RedNoticesEmbedded.md)
 - [RedNoticesLinks](docs/RedNoticesLinks.md)
 - [RedNoticesLinksSelf](docs/RedNoticesLinksSelf.md)
 - [RedNoticesQuery](docs/RedNoticesQuery.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

kontakt@bund.dev


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in interpol.apis and interpol.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from deutschland.interpol.api.default_api import DefaultApi`
- `from deutschland.interpol.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
from deutschland import interpol
from deutschland.interpol.apis import *
from deutschland.interpol.models import *
```

