"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EsbuildInstallation = void 0;
const child_process_1 = require("child_process");
const util_1 = require("./util");
/**
 * An esbuild installation
 */
class EsbuildInstallation {
    static detect() {
        try {
            // Check local version first
            const version = util_1.tryGetModuleVersion('esbuild');
            if (version) {
                return {
                    isLocal: true,
                    version,
                };
            }
            // Fallback to a global version
            const esbuild = child_process_1.spawnSync('esbuild', ['--version']);
            if (esbuild.status === 0 && !esbuild.error) {
                return {
                    isLocal: false,
                    version: esbuild.stdout.toString().trim(),
                };
            }
            return undefined;
        }
        catch (err) {
            return undefined;
        }
    }
}
exports.EsbuildInstallation = EsbuildInstallation;
//# sourceMappingURL=data:application/json;base64,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