# Generated by Django 3.1.3 on 2020-12-14 17:10

from django.db import migrations


def grant_moderators_add_abtest_permission(apps, schema_editor):
    ContentType = apps.get_model('contenttypes.ContentType')
    Permission = apps.get_model('auth.Permission')
    Group = apps.get_model('auth.Group')

    abtest_content_type, created = ContentType.objects.get_or_create(app_label='wagtail_ab_testing', model='abtest')
    add_abtest_permission, created = Permission.objects.get_or_create(content_type=abtest_content_type, codename='add_abtest')

    moderators_group = Group.objects.filter(name='Moderators').first()
    if moderators_group:
        moderators_group.permissions.add(add_abtest_permission)


class Migration(migrations.Migration):

    dependencies = [
        ('wagtail_ab_testing', '0006_sample_size_min_value'),
    ]

    operations = [
        migrations.RunPython(grant_moderators_add_abtest_permission, migrations.RunPython.noop),
    ]
