"""
This module contains the common PennyLane footer data.
"""

FOOTER = {
    "footer_about": {
        "title": "Xanadu",
        "description": """\
        Located in the heart of downtown Toronto, we've brought together
        exceptional minds from around the world to build quantum computers
        that are useful and available to people everywhere.
        """,
    },
    "footer_links": [
        {
            "title": "PennyLane",
            "links": [
                {
                    "name": "Home",
                    "href": "https://pennylane.ai/",
                },
                {
                    "name": "Learn",
                    "href": "https://pennylane.ai/qml",
                },
                {
                    "name": "Demonstrations",
                    "href": "https://pennylane.ai/qml/demonstrations.html",
                },
                {
                    "name": "Documentation",
                    "href": "https://docs.pennylane.ai/",
                },
                {
                    "name": "GitHub",
                    "href": "https://github.com/PennyLaneAI/pennylane",
                },
                {
                    "name": "Twitter",
                    "href": "https://twitter.com/pennylaneai",
                },
                {
                    "name": "Blog",
                    "href": "https://pennylane.ai/blog",
                },
            ],
        },
        {
            "title": "Strawberry Fields",
            "links": [
                {
                    "name": "Home",
                    "href": "https://strawberryfields.ai/",
                },
                {
                    "name": "Photonics",
                    "href": "https://strawberryfields.ai/photonics",
                },
                {
                    "name": "Demonstrations",
                    "href": "https://strawberryfields.ai/photonics/demonstrations.html",
                },
                {
                    "name": "Documentation",
                    "href": "https://strawberryfields.readthedocs.io/",
                },
                {
                    "name": "GitHub",
                    "href": "https://github.com/XanaduAI/strawberryfields",
                },
            ],
        },
        {
            "title": "Xanadu",
            "links": [
                {
                    "name": "Home",
                    "href": "https://xanadu.ai/",
                },
                {"name": "About", "href": "https://xanadu.ai/about/"},
                {
                    "name": "Hardware",
                    "href": "https://xanadu.ai/photonics",
                },
                {"name": "Careers", "href": "https://xanadu.ai/careers/"},
                {"name": "Cloud", "href": "https://cloud.xanadu.ai"},
                {
                    "name": "Forum",
                    "href": "https://discuss.pennylane.ai/",
                },
                {
                    "name": "Blog",
                    "href": "https://xanadu.ai/blog",
                },
            ],
        },
    ],
    "footer_socials": [
        {"icon": "fab fa-twitter", "href": "https://twitter.com/xanaduai"},
        {"icon": "fab fa-github", "href": "https://github.com/XanaduAI"},
        {"icon": "fab fa-linkedin-in", "href": "https://linkedin.com/company/xanaduai/"},
        {"icon": "fab fa-discourse", "href": "https://discuss.pennylane.ai"},
        {
            "icon": "fab fa-slack",
            "href": "https://u.strawberryfields.ai/slack",
        },
        {"icon": "fas fa-rss", "href": "https://xanadu.ai/blog"},
    ],
    "footer_tagline": {
        "text": "Stay updated with our newsletter",
        "href": "https://xanadu.us17.list-manage.com/subscribe?u=725f07a1d1a4337416c3129fd&id=294b062630",
    },
}
