# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AviatrixVpcArgs', 'AviatrixVpc']

@pulumi.input_type
class AviatrixVpcArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 cloud_type: pulumi.Input[int],
                 aviatrix_firenet_vpc: Optional[pulumi.Input[bool]] = None,
                 aviatrix_transit_vpc: Optional[pulumi.Input[bool]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 enable_native_gwlb: Optional[pulumi.Input[bool]] = None,
                 enable_private_oob_subnet: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_of_subnet_pairs: Optional[pulumi.Input[int]] = None,
                 private_mode_subnets: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 subnet_size: Optional[pulumi.Input[int]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcSubnetArgs']]]] = None):
        """
        The set of arguments for constructing a AviatrixVpc resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Currently only AWS(1), GCP(4), Azure(8), OCI(16), AzureGov(32), AWSGov(256), AWSChina(1024), AzureChina(2048), Alibaba Cloud(8192) are supported.
        :param pulumi.Input[bool] aviatrix_firenet_vpc: Specify whether it is an Aviatrix FireNet VPC to be used for [Aviatrix FireNet](https://docs.aviatrix.com/HowTos/firewall_network_faq.html) and [Transit FireNet](https://docs.aviatrix.com/HowTos/transit_firenet_faq.html) solutions. **Only AWS, Azure, AzureGov, AWSGov, AWSChina and AzureChina are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        :param pulumi.Input[bool] aviatrix_transit_vpc: Specify whether it is an [Aviatrix Transit VPC](https://docs.aviatrix.com/HowTos/create_vpc.html#aviatrix-transit-vpc) to be used for [Transit Network](https://docs.aviatrix.com/HowTos/transitvpc_faq.html) or [TGW](https://docs.aviatrix.com/HowTos/tgw_faq.html) solutions. **Only AWS, AWSGov, AWSChina, and Alibaba Cloud are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        :param pulumi.Input[str] cidr: CIDR block.
        :param pulumi.Input[bool] enable_native_gwlb: Enable Native AWS Gateway Load Balancer for FireNet Function. Only valid with cloud_type = 1 (AWS). **This option is only applicable to TGW-integrated FireNet**. Currently, AWS Gateway Load Balancer is only supported in AWS regions: us-west-2, us-east-1, eu-west-1, ap-southeast-2 and sa-east-1. Valid values: true or false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[bool] enable_private_oob_subnet: Switch to enable private oob subnet. Only supported for AWS, AWSGov and AWSChina providers. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[str] name: Name of this subnet.
        :param pulumi.Input[int] num_of_subnet_pairs: Number of public subnet and private subnet pair created. Only supported for AWS, Azure provider. Example: 1. Available in provider version R2.17+.
        :param pulumi.Input[bool] private_mode_subnets: Switch to only launch private subnets. Only available when Private Mode is enabled on the Controller. Only AWS, Azure, AzureGov and AWSGov are supported. Available in Provider version R2.23+.
        :param pulumi.Input[str] region: Region of this subnet.
        :param pulumi.Input[str] resource_group: The name of an existing resource group or a new resource group to be created for the Azure VNet.  A new resource group will be created if left blank. Only available for Azure, AzureGov and AzureChina providers. Available as of provider version R2.19+.
        :param pulumi.Input[int] subnet_size: Subnet size. Only supported for AWS, Azure provider. Example: 24. Available in provider version R2.17+.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixVpcSubnetArgs']]] subnets: List of subnets to be specify for GCP provider. Required to be non-empty for GCP provider, and empty for other providers.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "cloud_type", cloud_type)
        if aviatrix_firenet_vpc is not None:
            pulumi.set(__self__, "aviatrix_firenet_vpc", aviatrix_firenet_vpc)
        if aviatrix_transit_vpc is not None:
            pulumi.set(__self__, "aviatrix_transit_vpc", aviatrix_transit_vpc)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if enable_native_gwlb is not None:
            pulumi.set(__self__, "enable_native_gwlb", enable_native_gwlb)
        if enable_private_oob_subnet is not None:
            pulumi.set(__self__, "enable_private_oob_subnet", enable_private_oob_subnet)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_of_subnet_pairs is not None:
            pulumi.set(__self__, "num_of_subnet_pairs", num_of_subnet_pairs)
        if private_mode_subnets is not None:
            pulumi.set(__self__, "private_mode_subnets", private_mode_subnets)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subnet_size is not None:
            pulumi.set(__self__, "subnet_size", subnet_size)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Input[int]:
        """
        Type of cloud service provider, requires an integer value. Currently only AWS(1), GCP(4), Azure(8), OCI(16), AzureGov(32), AWSGov(256), AWSChina(1024), AzureChina(2048), Alibaba Cloud(8192) are supported.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="aviatrixFirenetVpc")
    def aviatrix_firenet_vpc(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether it is an Aviatrix FireNet VPC to be used for [Aviatrix FireNet](https://docs.aviatrix.com/HowTos/firewall_network_faq.html) and [Transit FireNet](https://docs.aviatrix.com/HowTos/transit_firenet_faq.html) solutions. **Only AWS, Azure, AzureGov, AWSGov, AWSChina and AzureChina are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        """
        return pulumi.get(self, "aviatrix_firenet_vpc")

    @aviatrix_firenet_vpc.setter
    def aviatrix_firenet_vpc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aviatrix_firenet_vpc", value)

    @property
    @pulumi.getter(name="aviatrixTransitVpc")
    def aviatrix_transit_vpc(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether it is an [Aviatrix Transit VPC](https://docs.aviatrix.com/HowTos/create_vpc.html#aviatrix-transit-vpc) to be used for [Transit Network](https://docs.aviatrix.com/HowTos/transitvpc_faq.html) or [TGW](https://docs.aviatrix.com/HowTos/tgw_faq.html) solutions. **Only AWS, AWSGov, AWSChina, and Alibaba Cloud are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        """
        return pulumi.get(self, "aviatrix_transit_vpc")

    @aviatrix_transit_vpc.setter
    def aviatrix_transit_vpc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aviatrix_transit_vpc", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR block.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="enableNativeGwlb")
    def enable_native_gwlb(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Native AWS Gateway Load Balancer for FireNet Function. Only valid with cloud_type = 1 (AWS). **This option is only applicable to TGW-integrated FireNet**. Currently, AWS Gateway Load Balancer is only supported in AWS regions: us-west-2, us-east-1, eu-west-1, ap-southeast-2 and sa-east-1. Valid values: true or false. Default value: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_native_gwlb")

    @enable_native_gwlb.setter
    def enable_native_gwlb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_native_gwlb", value)

    @property
    @pulumi.getter(name="enablePrivateOobSubnet")
    def enable_private_oob_subnet(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable private oob subnet. Only supported for AWS, AWSGov and AWSChina providers. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_private_oob_subnet")

    @enable_private_oob_subnet.setter
    def enable_private_oob_subnet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_oob_subnet", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this subnet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numOfSubnetPairs")
    def num_of_subnet_pairs(self) -> Optional[pulumi.Input[int]]:
        """
        Number of public subnet and private subnet pair created. Only supported for AWS, Azure provider. Example: 1. Available in provider version R2.17+.
        """
        return pulumi.get(self, "num_of_subnet_pairs")

    @num_of_subnet_pairs.setter
    def num_of_subnet_pairs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_of_subnet_pairs", value)

    @property
    @pulumi.getter(name="privateModeSubnets")
    def private_mode_subnets(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to only launch private subnets. Only available when Private Mode is enabled on the Controller. Only AWS, Azure, AzureGov and AWSGov are supported. Available in Provider version R2.23+.
        """
        return pulumi.get(self, "private_mode_subnets")

    @private_mode_subnets.setter
    def private_mode_subnets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private_mode_subnets", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of this subnet.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing resource group or a new resource group to be created for the Azure VNet.  A new resource group will be created if left blank. Only available for Azure, AzureGov and AzureChina providers. Available as of provider version R2.19+.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="subnetSize")
    def subnet_size(self) -> Optional[pulumi.Input[int]]:
        """
        Subnet size. Only supported for AWS, Azure provider. Example: 24. Available in provider version R2.17+.
        """
        return pulumi.get(self, "subnet_size")

    @subnet_size.setter
    def subnet_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "subnet_size", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcSubnetArgs']]]]:
        """
        List of subnets to be specify for GCP provider. Required to be non-empty for GCP provider, and empty for other providers.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcSubnetArgs']]]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class _AviatrixVpcState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 availability_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 aviatrix_firenet_vpc: Optional[pulumi.Input[bool]] = None,
                 aviatrix_transit_vpc: Optional[pulumi.Input[bool]] = None,
                 azure_vnet_resource_id: Optional[pulumi.Input[str]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 enable_native_gwlb: Optional[pulumi.Input[bool]] = None,
                 enable_private_oob_subnet: Optional[pulumi.Input[bool]] = None,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_of_subnet_pairs: Optional[pulumi.Input[int]] = None,
                 private_mode_subnets: Optional[pulumi.Input[bool]] = None,
                 private_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcPrivateSubnetArgs']]]] = None,
                 public_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcPublicSubnetArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_size: Optional[pulumi.Input[int]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcSubnetArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixVpc resources.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_domains: List of OCI availability domains.
        :param pulumi.Input[bool] aviatrix_firenet_vpc: Specify whether it is an Aviatrix FireNet VPC to be used for [Aviatrix FireNet](https://docs.aviatrix.com/HowTos/firewall_network_faq.html) and [Transit FireNet](https://docs.aviatrix.com/HowTos/transit_firenet_faq.html) solutions. **Only AWS, Azure, AzureGov, AWSGov, AWSChina and AzureChina are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        :param pulumi.Input[bool] aviatrix_transit_vpc: Specify whether it is an [Aviatrix Transit VPC](https://docs.aviatrix.com/HowTos/create_vpc.html#aviatrix-transit-vpc) to be used for [Transit Network](https://docs.aviatrix.com/HowTos/transitvpc_faq.html) or [TGW](https://docs.aviatrix.com/HowTos/tgw_faq.html) solutions. **Only AWS, AWSGov, AWSChina, and Alibaba Cloud are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        :param pulumi.Input[str] azure_vnet_resource_id: Azure VNet resource ID.
        :param pulumi.Input[str] cidr: CIDR block.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Currently only AWS(1), GCP(4), Azure(8), OCI(16), AzureGov(32), AWSGov(256), AWSChina(1024), AzureChina(2048), Alibaba Cloud(8192) are supported.
        :param pulumi.Input[bool] enable_native_gwlb: Enable Native AWS Gateway Load Balancer for FireNet Function. Only valid with cloud_type = 1 (AWS). **This option is only applicable to TGW-integrated FireNet**. Currently, AWS Gateway Load Balancer is only supported in AWS regions: us-west-2, us-east-1, eu-west-1, ap-southeast-2 and sa-east-1. Valid values: true or false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[bool] enable_private_oob_subnet: Switch to enable private oob subnet. Only supported for AWS, AWSGov and AWSChina providers. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: List of OCI fault domains.
        :param pulumi.Input[str] name: Name of this subnet.
        :param pulumi.Input[int] num_of_subnet_pairs: Number of public subnet and private subnet pair created. Only supported for AWS, Azure provider. Example: 1. Available in provider version R2.17+.
        :param pulumi.Input[bool] private_mode_subnets: Switch to only launch private subnets. Only available when Private Mode is enabled on the Controller. Only AWS, Azure, AzureGov and AWSGov are supported. Available in Provider version R2.23+.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixVpcPrivateSubnetArgs']]] private_subnets: List of private subnet of the VPC(AWS, Azure) to be created.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixVpcPublicSubnetArgs']]] public_subnets: List of public subnet of the VPC(AWS, Azure) to be created.
        :param pulumi.Input[str] region: Region of this subnet.
        :param pulumi.Input[str] resource_group: The name of an existing resource group or a new resource group to be created for the Azure VNet.  A new resource group will be created if left blank. Only available for Azure, AzureGov and AzureChina providers. Available as of provider version R2.19+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_tables: List of route table ids associated with this VPC. Only populated for AWS, AWSGov and Azure VPC.
        :param pulumi.Input[int] subnet_size: Subnet size. Only supported for AWS, Azure provider. Example: 24. Available in provider version R2.17+.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixVpcSubnetArgs']]] subnets: List of subnets to be specify for GCP provider. Required to be non-empty for GCP provider, and empty for other providers.
        :param pulumi.Input[str] vpc_id: ID of the VPC to be created.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if availability_domains is not None:
            pulumi.set(__self__, "availability_domains", availability_domains)
        if aviatrix_firenet_vpc is not None:
            pulumi.set(__self__, "aviatrix_firenet_vpc", aviatrix_firenet_vpc)
        if aviatrix_transit_vpc is not None:
            pulumi.set(__self__, "aviatrix_transit_vpc", aviatrix_transit_vpc)
        if azure_vnet_resource_id is not None:
            pulumi.set(__self__, "azure_vnet_resource_id", azure_vnet_resource_id)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if enable_native_gwlb is not None:
            pulumi.set(__self__, "enable_native_gwlb", enable_native_gwlb)
        if enable_private_oob_subnet is not None:
            pulumi.set(__self__, "enable_private_oob_subnet", enable_private_oob_subnet)
        if fault_domains is not None:
            pulumi.set(__self__, "fault_domains", fault_domains)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_of_subnet_pairs is not None:
            pulumi.set(__self__, "num_of_subnet_pairs", num_of_subnet_pairs)
        if private_mode_subnets is not None:
            pulumi.set(__self__, "private_mode_subnets", private_mode_subnets)
        if private_subnets is not None:
            pulumi.set(__self__, "private_subnets", private_subnets)
        if public_subnets is not None:
            pulumi.set(__self__, "public_subnets", public_subnets)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if route_tables is not None:
            pulumi.set(__self__, "route_tables", route_tables)
        if subnet_size is not None:
            pulumi.set(__self__, "subnet_size", subnet_size)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="availabilityDomains")
    def availability_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OCI availability domains.
        """
        return pulumi.get(self, "availability_domains")

    @availability_domains.setter
    def availability_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_domains", value)

    @property
    @pulumi.getter(name="aviatrixFirenetVpc")
    def aviatrix_firenet_vpc(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether it is an Aviatrix FireNet VPC to be used for [Aviatrix FireNet](https://docs.aviatrix.com/HowTos/firewall_network_faq.html) and [Transit FireNet](https://docs.aviatrix.com/HowTos/transit_firenet_faq.html) solutions. **Only AWS, Azure, AzureGov, AWSGov, AWSChina and AzureChina are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        """
        return pulumi.get(self, "aviatrix_firenet_vpc")

    @aviatrix_firenet_vpc.setter
    def aviatrix_firenet_vpc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aviatrix_firenet_vpc", value)

    @property
    @pulumi.getter(name="aviatrixTransitVpc")
    def aviatrix_transit_vpc(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether it is an [Aviatrix Transit VPC](https://docs.aviatrix.com/HowTos/create_vpc.html#aviatrix-transit-vpc) to be used for [Transit Network](https://docs.aviatrix.com/HowTos/transitvpc_faq.html) or [TGW](https://docs.aviatrix.com/HowTos/tgw_faq.html) solutions. **Only AWS, AWSGov, AWSChina, and Alibaba Cloud are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        """
        return pulumi.get(self, "aviatrix_transit_vpc")

    @aviatrix_transit_vpc.setter
    def aviatrix_transit_vpc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aviatrix_transit_vpc", value)

    @property
    @pulumi.getter(name="azureVnetResourceId")
    def azure_vnet_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure VNet resource ID.
        """
        return pulumi.get(self, "azure_vnet_resource_id")

    @azure_vnet_resource_id.setter
    def azure_vnet_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_vnet_resource_id", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR block.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider, requires an integer value. Currently only AWS(1), GCP(4), Azure(8), OCI(16), AzureGov(32), AWSGov(256), AWSChina(1024), AzureChina(2048), Alibaba Cloud(8192) are supported.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="enableNativeGwlb")
    def enable_native_gwlb(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Native AWS Gateway Load Balancer for FireNet Function. Only valid with cloud_type = 1 (AWS). **This option is only applicable to TGW-integrated FireNet**. Currently, AWS Gateway Load Balancer is only supported in AWS regions: us-west-2, us-east-1, eu-west-1, ap-southeast-2 and sa-east-1. Valid values: true or false. Default value: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_native_gwlb")

    @enable_native_gwlb.setter
    def enable_native_gwlb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_native_gwlb", value)

    @property
    @pulumi.getter(name="enablePrivateOobSubnet")
    def enable_private_oob_subnet(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable private oob subnet. Only supported for AWS, AWSGov and AWSChina providers. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_private_oob_subnet")

    @enable_private_oob_subnet.setter
    def enable_private_oob_subnet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_oob_subnet", value)

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of OCI fault domains.
        """
        return pulumi.get(self, "fault_domains")

    @fault_domains.setter
    def fault_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fault_domains", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this subnet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numOfSubnetPairs")
    def num_of_subnet_pairs(self) -> Optional[pulumi.Input[int]]:
        """
        Number of public subnet and private subnet pair created. Only supported for AWS, Azure provider. Example: 1. Available in provider version R2.17+.
        """
        return pulumi.get(self, "num_of_subnet_pairs")

    @num_of_subnet_pairs.setter
    def num_of_subnet_pairs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_of_subnet_pairs", value)

    @property
    @pulumi.getter(name="privateModeSubnets")
    def private_mode_subnets(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to only launch private subnets. Only available when Private Mode is enabled on the Controller. Only AWS, Azure, AzureGov and AWSGov are supported. Available in Provider version R2.23+.
        """
        return pulumi.get(self, "private_mode_subnets")

    @private_mode_subnets.setter
    def private_mode_subnets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private_mode_subnets", value)

    @property
    @pulumi.getter(name="privateSubnets")
    def private_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcPrivateSubnetArgs']]]]:
        """
        List of private subnet of the VPC(AWS, Azure) to be created.
        """
        return pulumi.get(self, "private_subnets")

    @private_subnets.setter
    def private_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcPrivateSubnetArgs']]]]):
        pulumi.set(self, "private_subnets", value)

    @property
    @pulumi.getter(name="publicSubnets")
    def public_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcPublicSubnetArgs']]]]:
        """
        List of public subnet of the VPC(AWS, Azure) to be created.
        """
        return pulumi.get(self, "public_subnets")

    @public_subnets.setter
    def public_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcPublicSubnetArgs']]]]):
        pulumi.set(self, "public_subnets", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of this subnet.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing resource group or a new resource group to be created for the Azure VNet.  A new resource group will be created if left blank. Only available for Azure, AzureGov and AzureChina providers. Available as of provider version R2.19+.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of route table ids associated with this VPC. Only populated for AWS, AWSGov and Azure VPC.
        """
        return pulumi.get(self, "route_tables")

    @route_tables.setter
    def route_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "route_tables", value)

    @property
    @pulumi.getter(name="subnetSize")
    def subnet_size(self) -> Optional[pulumi.Input[int]]:
        """
        Subnet size. Only supported for AWS, Azure provider. Example: 24. Available in provider version R2.17+.
        """
        return pulumi.get(self, "subnet_size")

    @subnet_size.setter
    def subnet_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "subnet_size", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcSubnetArgs']]]]:
        """
        List of subnets to be specify for GCP provider. Required to be non-empty for GCP provider, and empty for other providers.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixVpcSubnetArgs']]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the VPC to be created.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AviatrixVpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 aviatrix_firenet_vpc: Optional[pulumi.Input[bool]] = None,
                 aviatrix_transit_vpc: Optional[pulumi.Input[bool]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 enable_native_gwlb: Optional[pulumi.Input[bool]] = None,
                 enable_private_oob_subnet: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_of_subnet_pairs: Optional[pulumi.Input[int]] = None,
                 private_mode_subnets: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 subnet_size: Optional[pulumi.Input[int]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpcSubnetArgs']]]]] = None,
                 __props__=None):
        """
        The **aviatrix_vpc** resource allows the creation and management of Aviatrix-created VPCs of various cloud types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an AWS VPC
        aws_vpc = aviatrix.AviatrixVpc("awsVpc",
            account_name="devops",
            aviatrix_firenet_vpc=False,
            aviatrix_transit_vpc=False,
            cidr="10.0.0.0/16",
            cloud_type=1,
            region="us-west-1")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create a GCP VPC
        gcp_vpc = aviatrix.AviatrixVpc("gcpVpc",
            account_name="devops",
            cloud_type=4,
            subnets=[
                aviatrix.AviatrixVpcSubnetArgs(
                    cidr="10.10.0.0/24",
                    name="subnet-1",
                    region="us-west1",
                ),
                aviatrix.AviatrixVpcSubnetArgs(
                    cidr="10.11.0.0/24",
                    name="subnet-2",
                    region="us-west2",
                ),
            ])
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Azure VNet
        azure_vnet = aviatrix.AviatrixVpc("azureVnet",
            account_name="devops",
            aviatrix_firenet_vpc=False,
            cidr="12.0.0.0/16",
            cloud_type=8,
            region="Central US")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an OCI VPC
        oci_vpc = aviatrix.AviatrixVpc("ociVpc",
            account_name="devops",
            cidr="10.0.0.0/24",
            cloud_type=16,
            region="us-ashburn-1")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an AzureGov VNet
        azure_vnet = aviatrix.AviatrixVpc("azureVnet",
            account_name="devops",
            aviatrix_firenet_vpc=False,
            cidr="12.0.0.0/16",
            cloud_type=32,
            region="USGov Arizona")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an AWSGov VPC
        awsgov_vnet = aviatrix.AviatrixVpc("awsgovVnet",
            account_name="devops",
            aviatrix_firenet_vpc=False,
            aviatrix_transit_vpc=False,
            cidr="12.0.0.0/20",
            cloud_type=256,
            region="us-gov-west-1")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an AWS China VPC
        aws_china_vnet = aviatrix.AviatrixVpc("awsChinaVnet",
            account_name="devops",
            aviatrix_transit_vpc=False,
            cidr="12.0.0.0/20",
            cloud_type=1024,
            region="cn-north-1")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Azure China VNet
        azure_china_vnet = aviatrix.AviatrixVpc("azureChinaVnet",
            account_name="devops",
            cidr="12.0.0.0/16",
            cloud_type=2048,
            region="China North")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Alibaba Cloud VPC
        aliyun_vpc = aviatrix.AviatrixVpc("aliyunVpc",
            account_name="devops",
            cidr="10.0.0.0/20",
            cloud_type=8192,
            region="acs-us-west-1 (Silicon Valley)")
        ```

        ## Import

        **vpc** can be imported using the VPC's `name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixVpc:AviatrixVpc test name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[bool] aviatrix_firenet_vpc: Specify whether it is an Aviatrix FireNet VPC to be used for [Aviatrix FireNet](https://docs.aviatrix.com/HowTos/firewall_network_faq.html) and [Transit FireNet](https://docs.aviatrix.com/HowTos/transit_firenet_faq.html) solutions. **Only AWS, Azure, AzureGov, AWSGov, AWSChina and AzureChina are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        :param pulumi.Input[bool] aviatrix_transit_vpc: Specify whether it is an [Aviatrix Transit VPC](https://docs.aviatrix.com/HowTos/create_vpc.html#aviatrix-transit-vpc) to be used for [Transit Network](https://docs.aviatrix.com/HowTos/transitvpc_faq.html) or [TGW](https://docs.aviatrix.com/HowTos/tgw_faq.html) solutions. **Only AWS, AWSGov, AWSChina, and Alibaba Cloud are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        :param pulumi.Input[str] cidr: CIDR block.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Currently only AWS(1), GCP(4), Azure(8), OCI(16), AzureGov(32), AWSGov(256), AWSChina(1024), AzureChina(2048), Alibaba Cloud(8192) are supported.
        :param pulumi.Input[bool] enable_native_gwlb: Enable Native AWS Gateway Load Balancer for FireNet Function. Only valid with cloud_type = 1 (AWS). **This option is only applicable to TGW-integrated FireNet**. Currently, AWS Gateway Load Balancer is only supported in AWS regions: us-west-2, us-east-1, eu-west-1, ap-southeast-2 and sa-east-1. Valid values: true or false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[bool] enable_private_oob_subnet: Switch to enable private oob subnet. Only supported for AWS, AWSGov and AWSChina providers. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[str] name: Name of this subnet.
        :param pulumi.Input[int] num_of_subnet_pairs: Number of public subnet and private subnet pair created. Only supported for AWS, Azure provider. Example: 1. Available in provider version R2.17+.
        :param pulumi.Input[bool] private_mode_subnets: Switch to only launch private subnets. Only available when Private Mode is enabled on the Controller. Only AWS, Azure, AzureGov and AWSGov are supported. Available in Provider version R2.23+.
        :param pulumi.Input[str] region: Region of this subnet.
        :param pulumi.Input[str] resource_group: The name of an existing resource group or a new resource group to be created for the Azure VNet.  A new resource group will be created if left blank. Only available for Azure, AzureGov and AzureChina providers. Available as of provider version R2.19+.
        :param pulumi.Input[int] subnet_size: Subnet size. Only supported for AWS, Azure provider. Example: 24. Available in provider version R2.17+.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpcSubnetArgs']]]] subnets: List of subnets to be specify for GCP provider. Required to be non-empty for GCP provider, and empty for other providers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixVpcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_vpc** resource allows the creation and management of Aviatrix-created VPCs of various cloud types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an AWS VPC
        aws_vpc = aviatrix.AviatrixVpc("awsVpc",
            account_name="devops",
            aviatrix_firenet_vpc=False,
            aviatrix_transit_vpc=False,
            cidr="10.0.0.0/16",
            cloud_type=1,
            region="us-west-1")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create a GCP VPC
        gcp_vpc = aviatrix.AviatrixVpc("gcpVpc",
            account_name="devops",
            cloud_type=4,
            subnets=[
                aviatrix.AviatrixVpcSubnetArgs(
                    cidr="10.10.0.0/24",
                    name="subnet-1",
                    region="us-west1",
                ),
                aviatrix.AviatrixVpcSubnetArgs(
                    cidr="10.11.0.0/24",
                    name="subnet-2",
                    region="us-west2",
                ),
            ])
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Azure VNet
        azure_vnet = aviatrix.AviatrixVpc("azureVnet",
            account_name="devops",
            aviatrix_firenet_vpc=False,
            cidr="12.0.0.0/16",
            cloud_type=8,
            region="Central US")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an OCI VPC
        oci_vpc = aviatrix.AviatrixVpc("ociVpc",
            account_name="devops",
            cidr="10.0.0.0/24",
            cloud_type=16,
            region="us-ashburn-1")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an AzureGov VNet
        azure_vnet = aviatrix.AviatrixVpc("azureVnet",
            account_name="devops",
            aviatrix_firenet_vpc=False,
            cidr="12.0.0.0/16",
            cloud_type=32,
            region="USGov Arizona")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an AWSGov VPC
        awsgov_vnet = aviatrix.AviatrixVpc("awsgovVnet",
            account_name="devops",
            aviatrix_firenet_vpc=False,
            aviatrix_transit_vpc=False,
            cidr="12.0.0.0/20",
            cloud_type=256,
            region="us-gov-west-1")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an AWS China VPC
        aws_china_vnet = aviatrix.AviatrixVpc("awsChinaVnet",
            account_name="devops",
            aviatrix_transit_vpc=False,
            cidr="12.0.0.0/20",
            cloud_type=1024,
            region="cn-north-1")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Azure China VNet
        azure_china_vnet = aviatrix.AviatrixVpc("azureChinaVnet",
            account_name="devops",
            cidr="12.0.0.0/16",
            cloud_type=2048,
            region="China North")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Alibaba Cloud VPC
        aliyun_vpc = aviatrix.AviatrixVpc("aliyunVpc",
            account_name="devops",
            cidr="10.0.0.0/20",
            cloud_type=8192,
            region="acs-us-west-1 (Silicon Valley)")
        ```

        ## Import

        **vpc** can be imported using the VPC's `name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixVpc:AviatrixVpc test name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixVpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixVpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 aviatrix_firenet_vpc: Optional[pulumi.Input[bool]] = None,
                 aviatrix_transit_vpc: Optional[pulumi.Input[bool]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 enable_native_gwlb: Optional[pulumi.Input[bool]] = None,
                 enable_private_oob_subnet: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_of_subnet_pairs: Optional[pulumi.Input[int]] = None,
                 private_mode_subnets: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 subnet_size: Optional[pulumi.Input[int]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpcSubnetArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixVpcArgs.__new__(AviatrixVpcArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["aviatrix_firenet_vpc"] = aviatrix_firenet_vpc
            __props__.__dict__["aviatrix_transit_vpc"] = aviatrix_transit_vpc
            __props__.__dict__["cidr"] = cidr
            if cloud_type is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_type'")
            __props__.__dict__["cloud_type"] = cloud_type
            __props__.__dict__["enable_native_gwlb"] = enable_native_gwlb
            __props__.__dict__["enable_private_oob_subnet"] = enable_private_oob_subnet
            __props__.__dict__["name"] = name
            __props__.__dict__["num_of_subnet_pairs"] = num_of_subnet_pairs
            __props__.__dict__["private_mode_subnets"] = private_mode_subnets
            __props__.__dict__["region"] = region
            __props__.__dict__["resource_group"] = resource_group
            __props__.__dict__["subnet_size"] = subnet_size
            __props__.__dict__["subnets"] = subnets
            __props__.__dict__["availability_domains"] = None
            __props__.__dict__["azure_vnet_resource_id"] = None
            __props__.__dict__["fault_domains"] = None
            __props__.__dict__["private_subnets"] = None
            __props__.__dict__["public_subnets"] = None
            __props__.__dict__["route_tables"] = None
            __props__.__dict__["vpc_id"] = None
        super(AviatrixVpc, __self__).__init__(
            'aviatrix:index/aviatrixVpc:AviatrixVpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            availability_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            aviatrix_firenet_vpc: Optional[pulumi.Input[bool]] = None,
            aviatrix_transit_vpc: Optional[pulumi.Input[bool]] = None,
            azure_vnet_resource_id: Optional[pulumi.Input[str]] = None,
            cidr: Optional[pulumi.Input[str]] = None,
            cloud_type: Optional[pulumi.Input[int]] = None,
            enable_native_gwlb: Optional[pulumi.Input[bool]] = None,
            enable_private_oob_subnet: Optional[pulumi.Input[bool]] = None,
            fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            num_of_subnet_pairs: Optional[pulumi.Input[int]] = None,
            private_mode_subnets: Optional[pulumi.Input[bool]] = None,
            private_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpcPrivateSubnetArgs']]]]] = None,
            public_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpcPublicSubnetArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            resource_group: Optional[pulumi.Input[str]] = None,
            route_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            subnet_size: Optional[pulumi.Input[int]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpcSubnetArgs']]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AviatrixVpc':
        """
        Get an existing AviatrixVpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_domains: List of OCI availability domains.
        :param pulumi.Input[bool] aviatrix_firenet_vpc: Specify whether it is an Aviatrix FireNet VPC to be used for [Aviatrix FireNet](https://docs.aviatrix.com/HowTos/firewall_network_faq.html) and [Transit FireNet](https://docs.aviatrix.com/HowTos/transit_firenet_faq.html) solutions. **Only AWS, Azure, AzureGov, AWSGov, AWSChina and AzureChina are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        :param pulumi.Input[bool] aviatrix_transit_vpc: Specify whether it is an [Aviatrix Transit VPC](https://docs.aviatrix.com/HowTos/create_vpc.html#aviatrix-transit-vpc) to be used for [Transit Network](https://docs.aviatrix.com/HowTos/transitvpc_faq.html) or [TGW](https://docs.aviatrix.com/HowTos/tgw_faq.html) solutions. **Only AWS, AWSGov, AWSChina, and Alibaba Cloud are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        :param pulumi.Input[str] azure_vnet_resource_id: Azure VNet resource ID.
        :param pulumi.Input[str] cidr: CIDR block.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Currently only AWS(1), GCP(4), Azure(8), OCI(16), AzureGov(32), AWSGov(256), AWSChina(1024), AzureChina(2048), Alibaba Cloud(8192) are supported.
        :param pulumi.Input[bool] enable_native_gwlb: Enable Native AWS Gateway Load Balancer for FireNet Function. Only valid with cloud_type = 1 (AWS). **This option is only applicable to TGW-integrated FireNet**. Currently, AWS Gateway Load Balancer is only supported in AWS regions: us-west-2, us-east-1, eu-west-1, ap-southeast-2 and sa-east-1. Valid values: true or false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[bool] enable_private_oob_subnet: Switch to enable private oob subnet. Only supported for AWS, AWSGov and AWSChina providers. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: List of OCI fault domains.
        :param pulumi.Input[str] name: Name of this subnet.
        :param pulumi.Input[int] num_of_subnet_pairs: Number of public subnet and private subnet pair created. Only supported for AWS, Azure provider. Example: 1. Available in provider version R2.17+.
        :param pulumi.Input[bool] private_mode_subnets: Switch to only launch private subnets. Only available when Private Mode is enabled on the Controller. Only AWS, Azure, AzureGov and AWSGov are supported. Available in Provider version R2.23+.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpcPrivateSubnetArgs']]]] private_subnets: List of private subnet of the VPC(AWS, Azure) to be created.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpcPublicSubnetArgs']]]] public_subnets: List of public subnet of the VPC(AWS, Azure) to be created.
        :param pulumi.Input[str] region: Region of this subnet.
        :param pulumi.Input[str] resource_group: The name of an existing resource group or a new resource group to be created for the Azure VNet.  A new resource group will be created if left blank. Only available for Azure, AzureGov and AzureChina providers. Available as of provider version R2.19+.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_tables: List of route table ids associated with this VPC. Only populated for AWS, AWSGov and Azure VPC.
        :param pulumi.Input[int] subnet_size: Subnet size. Only supported for AWS, Azure provider. Example: 24. Available in provider version R2.17+.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixVpcSubnetArgs']]]] subnets: List of subnets to be specify for GCP provider. Required to be non-empty for GCP provider, and empty for other providers.
        :param pulumi.Input[str] vpc_id: ID of the VPC to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixVpcState.__new__(_AviatrixVpcState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["availability_domains"] = availability_domains
        __props__.__dict__["aviatrix_firenet_vpc"] = aviatrix_firenet_vpc
        __props__.__dict__["aviatrix_transit_vpc"] = aviatrix_transit_vpc
        __props__.__dict__["azure_vnet_resource_id"] = azure_vnet_resource_id
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["cloud_type"] = cloud_type
        __props__.__dict__["enable_native_gwlb"] = enable_native_gwlb
        __props__.__dict__["enable_private_oob_subnet"] = enable_private_oob_subnet
        __props__.__dict__["fault_domains"] = fault_domains
        __props__.__dict__["name"] = name
        __props__.__dict__["num_of_subnet_pairs"] = num_of_subnet_pairs
        __props__.__dict__["private_mode_subnets"] = private_mode_subnets
        __props__.__dict__["private_subnets"] = private_subnets
        __props__.__dict__["public_subnets"] = public_subnets
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_group"] = resource_group
        __props__.__dict__["route_tables"] = route_tables
        __props__.__dict__["subnet_size"] = subnet_size
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["vpc_id"] = vpc_id
        return AviatrixVpc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="availabilityDomains")
    def availability_domains(self) -> pulumi.Output[Sequence[str]]:
        """
        List of OCI availability domains.
        """
        return pulumi.get(self, "availability_domains")

    @property
    @pulumi.getter(name="aviatrixFirenetVpc")
    def aviatrix_firenet_vpc(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify whether it is an Aviatrix FireNet VPC to be used for [Aviatrix FireNet](https://docs.aviatrix.com/HowTos/firewall_network_faq.html) and [Transit FireNet](https://docs.aviatrix.com/HowTos/transit_firenet_faq.html) solutions. **Only AWS, Azure, AzureGov, AWSGov, AWSChina and AzureChina are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        """
        return pulumi.get(self, "aviatrix_firenet_vpc")

    @property
    @pulumi.getter(name="aviatrixTransitVpc")
    def aviatrix_transit_vpc(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify whether it is an [Aviatrix Transit VPC](https://docs.aviatrix.com/HowTos/create_vpc.html#aviatrix-transit-vpc) to be used for [Transit Network](https://docs.aviatrix.com/HowTos/transitvpc_faq.html) or [TGW](https://docs.aviatrix.com/HowTos/tgw_faq.html) solutions. **Only AWS, AWSGov, AWSChina, and Alibaba Cloud are supported. Required to be false for other providers.** Valid values: true, false. Default: false.
        """
        return pulumi.get(self, "aviatrix_transit_vpc")

    @property
    @pulumi.getter(name="azureVnetResourceId")
    def azure_vnet_resource_id(self) -> pulumi.Output[str]:
        """
        Azure VNet resource ID.
        """
        return pulumi.get(self, "azure_vnet_resource_id")

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[Optional[str]]:
        """
        CIDR block.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Output[int]:
        """
        Type of cloud service provider, requires an integer value. Currently only AWS(1), GCP(4), Azure(8), OCI(16), AzureGov(32), AWSGov(256), AWSChina(1024), AzureChina(2048), Alibaba Cloud(8192) are supported.
        """
        return pulumi.get(self, "cloud_type")

    @property
    @pulumi.getter(name="enableNativeGwlb")
    def enable_native_gwlb(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Native AWS Gateway Load Balancer for FireNet Function. Only valid with cloud_type = 1 (AWS). **This option is only applicable to TGW-integrated FireNet**. Currently, AWS Gateway Load Balancer is only supported in AWS regions: us-west-2, us-east-1, eu-west-1, ap-southeast-2 and sa-east-1. Valid values: true or false. Default value: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_native_gwlb")

    @property
    @pulumi.getter(name="enablePrivateOobSubnet")
    def enable_private_oob_subnet(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable private oob subnet. Only supported for AWS, AWSGov and AWSChina providers. Valid values: true, false. Default value: false. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "enable_private_oob_subnet")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> pulumi.Output[Sequence[str]]:
        """
        List of OCI fault domains.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of this subnet.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numOfSubnetPairs")
    def num_of_subnet_pairs(self) -> pulumi.Output[Optional[int]]:
        """
        Number of public subnet and private subnet pair created. Only supported for AWS, Azure provider. Example: 1. Available in provider version R2.17+.
        """
        return pulumi.get(self, "num_of_subnet_pairs")

    @property
    @pulumi.getter(name="privateModeSubnets")
    def private_mode_subnets(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to only launch private subnets. Only available when Private Mode is enabled on the Controller. Only AWS, Azure, AzureGov and AWSGov are supported. Available in Provider version R2.23+.
        """
        return pulumi.get(self, "private_mode_subnets")

    @property
    @pulumi.getter(name="privateSubnets")
    def private_subnets(self) -> pulumi.Output[Sequence['outputs.AviatrixVpcPrivateSubnet']]:
        """
        List of private subnet of the VPC(AWS, Azure) to be created.
        """
        return pulumi.get(self, "private_subnets")

    @property
    @pulumi.getter(name="publicSubnets")
    def public_subnets(self) -> pulumi.Output[Sequence['outputs.AviatrixVpcPublicSubnet']]:
        """
        List of public subnet of the VPC(AWS, Azure) to be created.
        """
        return pulumi.get(self, "public_subnets")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        Region of this subnet.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[str]:
        """
        The name of an existing resource group or a new resource group to be created for the Azure VNet.  A new resource group will be created if left blank. Only available for Azure, AzureGov and AzureChina providers. Available as of provider version R2.19+.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> pulumi.Output[Sequence[str]]:
        """
        List of route table ids associated with this VPC. Only populated for AWS, AWSGov and Azure VPC.
        """
        return pulumi.get(self, "route_tables")

    @property
    @pulumi.getter(name="subnetSize")
    def subnet_size(self) -> pulumi.Output[Optional[int]]:
        """
        Subnet size. Only supported for AWS, Azure provider. Example: 24. Available in provider version R2.17+.
        """
        return pulumi.get(self, "subnet_size")

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Sequence['outputs.AviatrixVpcSubnet']]:
        """
        List of subnets to be specify for GCP provider. Required to be non-empty for GCP provider, and empty for other providers.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        ID of the VPC to be created.
        """
        return pulumi.get(self, "vpc_id")

