# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixEdgeSpokeArgs', 'AviatrixEdgeSpoke']

@pulumi.input_type
class AviatrixEdgeSpokeArgs:
    def __init__(__self__, *,
                 gw_name: pulumi.Input[str],
                 lan_interface_ip_prefix: pulumi.Input[str],
                 management_interface_config: pulumi.Input[str],
                 site_id: pulumi.Input[str],
                 wan_default_gateway_ip: pulumi.Input[str],
                 wan_interface_ip_prefix: pulumi.Input[str],
                 ztp_file_download_path: pulumi.Input[str],
                 ztp_file_type: pulumi.Input[str],
                 approved_learned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bgp_hold_time: Optional[pulumi.Input[int]] = None,
                 bgp_polling_time: Optional[pulumi.Input[int]] = None,
                 dns_server_ip: Optional[pulumi.Input[str]] = None,
                 enable_edge_active_standby: Optional[pulumi.Input[bool]] = None,
                 enable_edge_active_standby_preemptive: Optional[pulumi.Input[bool]] = None,
                 enable_edge_transitive_routing: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_management_over_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_preserve_as_path: Optional[pulumi.Input[bool]] = None,
                 latitude: Optional[pulumi.Input[str]] = None,
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 longitude: Optional[pulumi.Input[str]] = None,
                 management_default_gateway_ip: Optional[pulumi.Input[str]] = None,
                 management_egress_ip_prefix: Optional[pulumi.Input[str]] = None,
                 management_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 secondary_dns_server_ip: Optional[pulumi.Input[str]] = None,
                 spoke_bgp_manual_advertise_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wan_public_ip: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixEdgeSpoke resource.
        :param pulumi.Input[str] gw_name: Edge as a Spoke name.
        :param pulumi.Input[str] lan_interface_ip_prefix: LAN interface IP and subnet prefix.
        :param pulumi.Input[str] management_interface_config: Management interface configuration. Valid values: "DHCP", "Static".
        :param pulumi.Input[str] site_id: Site ID.
        :param pulumi.Input[str] wan_default_gateway_ip: WAN default gateway IP.
        :param pulumi.Input[str] wan_interface_ip_prefix: WAN interface IP and subnet prefix.
        :param pulumi.Input[str] ztp_file_download_path: The folder path where the ZTP file will be downloaded.
        :param pulumi.Input[str] ztp_file_type: ZTP file type. Valid values: "iso", "cloud-init".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_learned_cidrs: Set of approved learned CIDRs. Valid only when `enable_learned_cidrs_approval` is set to true. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        :param pulumi.Input[int] bgp_hold_time: BGP hold time. Unit is in seconds. Valid values are between 12 and 360. Default value: 180.
        :param pulumi.Input[int] bgp_polling_time: BGP route polling time. Unit is in seconds. Valid values are between 10 and 50. Default value: 50.
        :param pulumi.Input[str] dns_server_ip: DNS server IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[bool] enable_edge_active_standby: Switch to enable Edge Active-Standby mode. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_edge_active_standby_preemptive: Switch to enable Preemptive Mode for Edge Active-Standby. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_edge_transitive_routing: Switch to enable Edge transitive routing. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Switch to enable jumbo frame. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable learned CIDR approval. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_management_over_private_network: Switch to enable management over the private network. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_preserve_as_path: Switch to enable preserve as_path when advertising manual summary CIDRs. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] latitude: Latitude of Edge as a Spoke. Valid values are between -90 and 90. Example: "47.7511".
        :param pulumi.Input[str] local_as_number: BGP AS Number to assign to Edge as a Spoke.
        :param pulumi.Input[str] longitude: Longitude of Edge as a Spoke. Valid values are between -180 and 180. Example: "120.7401".
        :param pulumi.Input[str] management_default_gateway_ip: Management default gateway IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[str] management_egress_ip_prefix: Management egress gateway IP and subnet prefix.
        :param pulumi.Input[str] management_interface_ip_prefix: Management interface IP and subnet prefix. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: List of AS numbers to prepend gateway BGP AS_Path field. Valid only when `local_as_number` is set. Example: ["65023", "65023"].
        :param pulumi.Input[str] rx_queue_size: Ethernet interface RX queue size. Once set, can't be deleted or disabled. Valid values: "1K", "2K", "4K".
        :param pulumi.Input[str] secondary_dns_server_ip: Secondary DNS server IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_bgp_manual_advertise_cidrs: Set of intended CIDRs to be advertised to external BGP router. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        :param pulumi.Input[str] wan_public_ip: WAN public IP. Required for attaching connections over the Internet.
        """
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "lan_interface_ip_prefix", lan_interface_ip_prefix)
        pulumi.set(__self__, "management_interface_config", management_interface_config)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "wan_default_gateway_ip", wan_default_gateway_ip)
        pulumi.set(__self__, "wan_interface_ip_prefix", wan_interface_ip_prefix)
        pulumi.set(__self__, "ztp_file_download_path", ztp_file_download_path)
        pulumi.set(__self__, "ztp_file_type", ztp_file_type)
        if approved_learned_cidrs is not None:
            pulumi.set(__self__, "approved_learned_cidrs", approved_learned_cidrs)
        if bgp_hold_time is not None:
            pulumi.set(__self__, "bgp_hold_time", bgp_hold_time)
        if bgp_polling_time is not None:
            pulumi.set(__self__, "bgp_polling_time", bgp_polling_time)
        if dns_server_ip is not None:
            pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        if enable_edge_active_standby is not None:
            pulumi.set(__self__, "enable_edge_active_standby", enable_edge_active_standby)
        if enable_edge_active_standby_preemptive is not None:
            pulumi.set(__self__, "enable_edge_active_standby_preemptive", enable_edge_active_standby_preemptive)
        if enable_edge_transitive_routing is not None:
            pulumi.set(__self__, "enable_edge_transitive_routing", enable_edge_transitive_routing)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if enable_management_over_private_network is not None:
            pulumi.set(__self__, "enable_management_over_private_network", enable_management_over_private_network)
        if enable_preserve_as_path is not None:
            pulumi.set(__self__, "enable_preserve_as_path", enable_preserve_as_path)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if local_as_number is not None:
            pulumi.set(__self__, "local_as_number", local_as_number)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)
        if management_default_gateway_ip is not None:
            pulumi.set(__self__, "management_default_gateway_ip", management_default_gateway_ip)
        if management_egress_ip_prefix is not None:
            pulumi.set(__self__, "management_egress_ip_prefix", management_egress_ip_prefix)
        if management_interface_ip_prefix is not None:
            pulumi.set(__self__, "management_interface_ip_prefix", management_interface_ip_prefix)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)
        if rx_queue_size is not None:
            pulumi.set(__self__, "rx_queue_size", rx_queue_size)
        if secondary_dns_server_ip is not None:
            pulumi.set(__self__, "secondary_dns_server_ip", secondary_dns_server_ip)
        if spoke_bgp_manual_advertise_cidrs is not None:
            pulumi.set(__self__, "spoke_bgp_manual_advertise_cidrs", spoke_bgp_manual_advertise_cidrs)
        if wan_public_ip is not None:
            pulumi.set(__self__, "wan_public_ip", wan_public_ip)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Edge as a Spoke name.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="lanInterfaceIpPrefix")
    def lan_interface_ip_prefix(self) -> pulumi.Input[str]:
        """
        LAN interface IP and subnet prefix.
        """
        return pulumi.get(self, "lan_interface_ip_prefix")

    @lan_interface_ip_prefix.setter
    def lan_interface_ip_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "lan_interface_ip_prefix", value)

    @property
    @pulumi.getter(name="managementInterfaceConfig")
    def management_interface_config(self) -> pulumi.Input[str]:
        """
        Management interface configuration. Valid values: "DHCP", "Static".
        """
        return pulumi.get(self, "management_interface_config")

    @management_interface_config.setter
    def management_interface_config(self, value: pulumi.Input[str]):
        pulumi.set(self, "management_interface_config", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[str]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="wanDefaultGatewayIp")
    def wan_default_gateway_ip(self) -> pulumi.Input[str]:
        """
        WAN default gateway IP.
        """
        return pulumi.get(self, "wan_default_gateway_ip")

    @wan_default_gateway_ip.setter
    def wan_default_gateway_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "wan_default_gateway_ip", value)

    @property
    @pulumi.getter(name="wanInterfaceIpPrefix")
    def wan_interface_ip_prefix(self) -> pulumi.Input[str]:
        """
        WAN interface IP and subnet prefix.
        """
        return pulumi.get(self, "wan_interface_ip_prefix")

    @wan_interface_ip_prefix.setter
    def wan_interface_ip_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "wan_interface_ip_prefix", value)

    @property
    @pulumi.getter(name="ztpFileDownloadPath")
    def ztp_file_download_path(self) -> pulumi.Input[str]:
        """
        The folder path where the ZTP file will be downloaded.
        """
        return pulumi.get(self, "ztp_file_download_path")

    @ztp_file_download_path.setter
    def ztp_file_download_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "ztp_file_download_path", value)

    @property
    @pulumi.getter(name="ztpFileType")
    def ztp_file_type(self) -> pulumi.Input[str]:
        """
        ZTP file type. Valid values: "iso", "cloud-init".
        """
        return pulumi.get(self, "ztp_file_type")

    @ztp_file_type.setter
    def ztp_file_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "ztp_file_type", value)

    @property
    @pulumi.getter(name="approvedLearnedCidrs")
    def approved_learned_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of approved learned CIDRs. Valid only when `enable_learned_cidrs_approval` is set to true. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        """
        return pulumi.get(self, "approved_learned_cidrs")

    @approved_learned_cidrs.setter
    def approved_learned_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "approved_learned_cidrs", value)

    @property
    @pulumi.getter(name="bgpHoldTime")
    def bgp_hold_time(self) -> Optional[pulumi.Input[int]]:
        """
        BGP hold time. Unit is in seconds. Valid values are between 12 and 360. Default value: 180.
        """
        return pulumi.get(self, "bgp_hold_time")

    @bgp_hold_time.setter
    def bgp_hold_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bgp_hold_time", value)

    @property
    @pulumi.getter(name="bgpPollingTime")
    def bgp_polling_time(self) -> Optional[pulumi.Input[int]]:
        """
        BGP route polling time. Unit is in seconds. Valid values are between 10 and 50. Default value: 50.
        """
        return pulumi.get(self, "bgp_polling_time")

    @bgp_polling_time.setter
    def bgp_polling_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bgp_polling_time", value)

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> Optional[pulumi.Input[str]]:
        """
        DNS server IP. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "dns_server_ip")

    @dns_server_ip.setter
    def dns_server_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_server_ip", value)

    @property
    @pulumi.getter(name="enableEdgeActiveStandby")
    def enable_edge_active_standby(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable Edge Active-Standby mode. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_edge_active_standby")

    @enable_edge_active_standby.setter
    def enable_edge_active_standby(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_edge_active_standby", value)

    @property
    @pulumi.getter(name="enableEdgeActiveStandbyPreemptive")
    def enable_edge_active_standby_preemptive(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable Preemptive Mode for Edge Active-Standby. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_edge_active_standby_preemptive")

    @enable_edge_active_standby_preemptive.setter
    def enable_edge_active_standby_preemptive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_edge_active_standby_preemptive", value)

    @property
    @pulumi.getter(name="enableEdgeTransitiveRouting")
    def enable_edge_transitive_routing(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable Edge transitive routing. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_edge_transitive_routing")

    @enable_edge_transitive_routing.setter
    def enable_edge_transitive_routing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_edge_transitive_routing", value)

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable jumbo frame. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable learned CIDR approval. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="enableManagementOverPrivateNetwork")
    def enable_management_over_private_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable management over the private network. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_management_over_private_network")

    @enable_management_over_private_network.setter
    def enable_management_over_private_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_management_over_private_network", value)

    @property
    @pulumi.getter(name="enablePreserveAsPath")
    def enable_preserve_as_path(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable preserve as_path when advertising manual summary CIDRs. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_preserve_as_path")

    @enable_preserve_as_path.setter
    def enable_preserve_as_path(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_preserve_as_path", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[str]]:
        """
        Latitude of Edge as a Spoke. Valid values are between -90 and 90. Example: "47.7511".
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter(name="localAsNumber")
    def local_as_number(self) -> Optional[pulumi.Input[str]]:
        """
        BGP AS Number to assign to Edge as a Spoke.
        """
        return pulumi.get(self, "local_as_number")

    @local_as_number.setter
    def local_as_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_as_number", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[str]]:
        """
        Longitude of Edge as a Spoke. Valid values are between -180 and 180. Example: "120.7401".
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "longitude", value)

    @property
    @pulumi.getter(name="managementDefaultGatewayIp")
    def management_default_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Management default gateway IP. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "management_default_gateway_ip")

    @management_default_gateway_ip.setter
    def management_default_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_default_gateway_ip", value)

    @property
    @pulumi.getter(name="managementEgressIpPrefix")
    def management_egress_ip_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Management egress gateway IP and subnet prefix.
        """
        return pulumi.get(self, "management_egress_ip_prefix")

    @management_egress_ip_prefix.setter
    def management_egress_ip_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_egress_ip_prefix", value)

    @property
    @pulumi.getter(name="managementInterfaceIpPrefix")
    def management_interface_ip_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Management interface IP and subnet prefix. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "management_interface_ip_prefix")

    @management_interface_ip_prefix.setter
    def management_interface_ip_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_interface_ip_prefix", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of AS numbers to prepend gateway BGP AS_Path field. Valid only when `local_as_number` is set. Example: ["65023", "65023"].
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)

    @property
    @pulumi.getter(name="rxQueueSize")
    def rx_queue_size(self) -> Optional[pulumi.Input[str]]:
        """
        Ethernet interface RX queue size. Once set, can't be deleted or disabled. Valid values: "1K", "2K", "4K".
        """
        return pulumi.get(self, "rx_queue_size")

    @rx_queue_size.setter
    def rx_queue_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rx_queue_size", value)

    @property
    @pulumi.getter(name="secondaryDnsServerIp")
    def secondary_dns_server_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary DNS server IP. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "secondary_dns_server_ip")

    @secondary_dns_server_ip.setter
    def secondary_dns_server_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns_server_ip", value)

    @property
    @pulumi.getter(name="spokeBgpManualAdvertiseCidrs")
    def spoke_bgp_manual_advertise_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of intended CIDRs to be advertised to external BGP router. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        """
        return pulumi.get(self, "spoke_bgp_manual_advertise_cidrs")

    @spoke_bgp_manual_advertise_cidrs.setter
    def spoke_bgp_manual_advertise_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "spoke_bgp_manual_advertise_cidrs", value)

    @property
    @pulumi.getter(name="wanPublicIp")
    def wan_public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        WAN public IP. Required for attaching connections over the Internet.
        """
        return pulumi.get(self, "wan_public_ip")

    @wan_public_ip.setter
    def wan_public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_public_ip", value)


@pulumi.input_type
class _AviatrixEdgeSpokeState:
    def __init__(__self__, *,
                 approved_learned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bgp_hold_time: Optional[pulumi.Input[int]] = None,
                 bgp_polling_time: Optional[pulumi.Input[int]] = None,
                 dns_server_ip: Optional[pulumi.Input[str]] = None,
                 enable_edge_active_standby: Optional[pulumi.Input[bool]] = None,
                 enable_edge_active_standby_preemptive: Optional[pulumi.Input[bool]] = None,
                 enable_edge_transitive_routing: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_management_over_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_preserve_as_path: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 lan_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
                 latitude: Optional[pulumi.Input[str]] = None,
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 longitude: Optional[pulumi.Input[str]] = None,
                 management_default_gateway_ip: Optional[pulumi.Input[str]] = None,
                 management_egress_ip_prefix: Optional[pulumi.Input[str]] = None,
                 management_interface_config: Optional[pulumi.Input[str]] = None,
                 management_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 secondary_dns_server_ip: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 spoke_bgp_manual_advertise_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 wan_default_gateway_ip: Optional[pulumi.Input[str]] = None,
                 wan_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
                 wan_public_ip: Optional[pulumi.Input[str]] = None,
                 ztp_file_download_path: Optional[pulumi.Input[str]] = None,
                 ztp_file_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixEdgeSpoke resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_learned_cidrs: Set of approved learned CIDRs. Valid only when `enable_learned_cidrs_approval` is set to true. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        :param pulumi.Input[int] bgp_hold_time: BGP hold time. Unit is in seconds. Valid values are between 12 and 360. Default value: 180.
        :param pulumi.Input[int] bgp_polling_time: BGP route polling time. Unit is in seconds. Valid values are between 10 and 50. Default value: 50.
        :param pulumi.Input[str] dns_server_ip: DNS server IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[bool] enable_edge_active_standby: Switch to enable Edge Active-Standby mode. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_edge_active_standby_preemptive: Switch to enable Preemptive Mode for Edge Active-Standby. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_edge_transitive_routing: Switch to enable Edge transitive routing. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Switch to enable jumbo frame. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable learned CIDR approval. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_management_over_private_network: Switch to enable management over the private network. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_preserve_as_path: Switch to enable preserve as_path when advertising manual summary CIDRs. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] gw_name: Edge as a Spoke name.
        :param pulumi.Input[str] lan_interface_ip_prefix: LAN interface IP and subnet prefix.
        :param pulumi.Input[str] latitude: Latitude of Edge as a Spoke. Valid values are between -90 and 90. Example: "47.7511".
        :param pulumi.Input[str] local_as_number: BGP AS Number to assign to Edge as a Spoke.
        :param pulumi.Input[str] longitude: Longitude of Edge as a Spoke. Valid values are between -180 and 180. Example: "120.7401".
        :param pulumi.Input[str] management_default_gateway_ip: Management default gateway IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[str] management_egress_ip_prefix: Management egress gateway IP and subnet prefix.
        :param pulumi.Input[str] management_interface_config: Management interface configuration. Valid values: "DHCP", "Static".
        :param pulumi.Input[str] management_interface_ip_prefix: Management interface IP and subnet prefix. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: List of AS numbers to prepend gateway BGP AS_Path field. Valid only when `local_as_number` is set. Example: ["65023", "65023"].
        :param pulumi.Input[str] rx_queue_size: Ethernet interface RX queue size. Once set, can't be deleted or disabled. Valid values: "1K", "2K", "4K".
        :param pulumi.Input[str] secondary_dns_server_ip: Secondary DNS server IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[str] site_id: Site ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_bgp_manual_advertise_cidrs: Set of intended CIDRs to be advertised to external BGP router. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        :param pulumi.Input[str] state: State of Edge as a Spoke.
        :param pulumi.Input[str] wan_default_gateway_ip: WAN default gateway IP.
        :param pulumi.Input[str] wan_interface_ip_prefix: WAN interface IP and subnet prefix.
        :param pulumi.Input[str] wan_public_ip: WAN public IP. Required for attaching connections over the Internet.
        :param pulumi.Input[str] ztp_file_download_path: The folder path where the ZTP file will be downloaded.
        :param pulumi.Input[str] ztp_file_type: ZTP file type. Valid values: "iso", "cloud-init".
        """
        if approved_learned_cidrs is not None:
            pulumi.set(__self__, "approved_learned_cidrs", approved_learned_cidrs)
        if bgp_hold_time is not None:
            pulumi.set(__self__, "bgp_hold_time", bgp_hold_time)
        if bgp_polling_time is not None:
            pulumi.set(__self__, "bgp_polling_time", bgp_polling_time)
        if dns_server_ip is not None:
            pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        if enable_edge_active_standby is not None:
            pulumi.set(__self__, "enable_edge_active_standby", enable_edge_active_standby)
        if enable_edge_active_standby_preemptive is not None:
            pulumi.set(__self__, "enable_edge_active_standby_preemptive", enable_edge_active_standby_preemptive)
        if enable_edge_transitive_routing is not None:
            pulumi.set(__self__, "enable_edge_transitive_routing", enable_edge_transitive_routing)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if enable_management_over_private_network is not None:
            pulumi.set(__self__, "enable_management_over_private_network", enable_management_over_private_network)
        if enable_preserve_as_path is not None:
            pulumi.set(__self__, "enable_preserve_as_path", enable_preserve_as_path)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if lan_interface_ip_prefix is not None:
            pulumi.set(__self__, "lan_interface_ip_prefix", lan_interface_ip_prefix)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if local_as_number is not None:
            pulumi.set(__self__, "local_as_number", local_as_number)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)
        if management_default_gateway_ip is not None:
            pulumi.set(__self__, "management_default_gateway_ip", management_default_gateway_ip)
        if management_egress_ip_prefix is not None:
            pulumi.set(__self__, "management_egress_ip_prefix", management_egress_ip_prefix)
        if management_interface_config is not None:
            pulumi.set(__self__, "management_interface_config", management_interface_config)
        if management_interface_ip_prefix is not None:
            pulumi.set(__self__, "management_interface_ip_prefix", management_interface_ip_prefix)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)
        if rx_queue_size is not None:
            pulumi.set(__self__, "rx_queue_size", rx_queue_size)
        if secondary_dns_server_ip is not None:
            pulumi.set(__self__, "secondary_dns_server_ip", secondary_dns_server_ip)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if spoke_bgp_manual_advertise_cidrs is not None:
            pulumi.set(__self__, "spoke_bgp_manual_advertise_cidrs", spoke_bgp_manual_advertise_cidrs)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if wan_default_gateway_ip is not None:
            pulumi.set(__self__, "wan_default_gateway_ip", wan_default_gateway_ip)
        if wan_interface_ip_prefix is not None:
            pulumi.set(__self__, "wan_interface_ip_prefix", wan_interface_ip_prefix)
        if wan_public_ip is not None:
            pulumi.set(__self__, "wan_public_ip", wan_public_ip)
        if ztp_file_download_path is not None:
            pulumi.set(__self__, "ztp_file_download_path", ztp_file_download_path)
        if ztp_file_type is not None:
            pulumi.set(__self__, "ztp_file_type", ztp_file_type)

    @property
    @pulumi.getter(name="approvedLearnedCidrs")
    def approved_learned_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of approved learned CIDRs. Valid only when `enable_learned_cidrs_approval` is set to true. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        """
        return pulumi.get(self, "approved_learned_cidrs")

    @approved_learned_cidrs.setter
    def approved_learned_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "approved_learned_cidrs", value)

    @property
    @pulumi.getter(name="bgpHoldTime")
    def bgp_hold_time(self) -> Optional[pulumi.Input[int]]:
        """
        BGP hold time. Unit is in seconds. Valid values are between 12 and 360. Default value: 180.
        """
        return pulumi.get(self, "bgp_hold_time")

    @bgp_hold_time.setter
    def bgp_hold_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bgp_hold_time", value)

    @property
    @pulumi.getter(name="bgpPollingTime")
    def bgp_polling_time(self) -> Optional[pulumi.Input[int]]:
        """
        BGP route polling time. Unit is in seconds. Valid values are between 10 and 50. Default value: 50.
        """
        return pulumi.get(self, "bgp_polling_time")

    @bgp_polling_time.setter
    def bgp_polling_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bgp_polling_time", value)

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> Optional[pulumi.Input[str]]:
        """
        DNS server IP. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "dns_server_ip")

    @dns_server_ip.setter
    def dns_server_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_server_ip", value)

    @property
    @pulumi.getter(name="enableEdgeActiveStandby")
    def enable_edge_active_standby(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable Edge Active-Standby mode. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_edge_active_standby")

    @enable_edge_active_standby.setter
    def enable_edge_active_standby(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_edge_active_standby", value)

    @property
    @pulumi.getter(name="enableEdgeActiveStandbyPreemptive")
    def enable_edge_active_standby_preemptive(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable Preemptive Mode for Edge Active-Standby. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_edge_active_standby_preemptive")

    @enable_edge_active_standby_preemptive.setter
    def enable_edge_active_standby_preemptive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_edge_active_standby_preemptive", value)

    @property
    @pulumi.getter(name="enableEdgeTransitiveRouting")
    def enable_edge_transitive_routing(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable Edge transitive routing. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_edge_transitive_routing")

    @enable_edge_transitive_routing.setter
    def enable_edge_transitive_routing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_edge_transitive_routing", value)

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable jumbo frame. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable learned CIDR approval. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="enableManagementOverPrivateNetwork")
    def enable_management_over_private_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable management over the private network. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_management_over_private_network")

    @enable_management_over_private_network.setter
    def enable_management_over_private_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_management_over_private_network", value)

    @property
    @pulumi.getter(name="enablePreserveAsPath")
    def enable_preserve_as_path(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable preserve as_path when advertising manual summary CIDRs. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_preserve_as_path")

    @enable_preserve_as_path.setter
    def enable_preserve_as_path(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_preserve_as_path", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Edge as a Spoke name.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="lanInterfaceIpPrefix")
    def lan_interface_ip_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        LAN interface IP and subnet prefix.
        """
        return pulumi.get(self, "lan_interface_ip_prefix")

    @lan_interface_ip_prefix.setter
    def lan_interface_ip_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lan_interface_ip_prefix", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[str]]:
        """
        Latitude of Edge as a Spoke. Valid values are between -90 and 90. Example: "47.7511".
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter(name="localAsNumber")
    def local_as_number(self) -> Optional[pulumi.Input[str]]:
        """
        BGP AS Number to assign to Edge as a Spoke.
        """
        return pulumi.get(self, "local_as_number")

    @local_as_number.setter
    def local_as_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_as_number", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[str]]:
        """
        Longitude of Edge as a Spoke. Valid values are between -180 and 180. Example: "120.7401".
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "longitude", value)

    @property
    @pulumi.getter(name="managementDefaultGatewayIp")
    def management_default_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Management default gateway IP. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "management_default_gateway_ip")

    @management_default_gateway_ip.setter
    def management_default_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_default_gateway_ip", value)

    @property
    @pulumi.getter(name="managementEgressIpPrefix")
    def management_egress_ip_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Management egress gateway IP and subnet prefix.
        """
        return pulumi.get(self, "management_egress_ip_prefix")

    @management_egress_ip_prefix.setter
    def management_egress_ip_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_egress_ip_prefix", value)

    @property
    @pulumi.getter(name="managementInterfaceConfig")
    def management_interface_config(self) -> Optional[pulumi.Input[str]]:
        """
        Management interface configuration. Valid values: "DHCP", "Static".
        """
        return pulumi.get(self, "management_interface_config")

    @management_interface_config.setter
    def management_interface_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_interface_config", value)

    @property
    @pulumi.getter(name="managementInterfaceIpPrefix")
    def management_interface_ip_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Management interface IP and subnet prefix. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "management_interface_ip_prefix")

    @management_interface_ip_prefix.setter
    def management_interface_ip_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_interface_ip_prefix", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of AS numbers to prepend gateway BGP AS_Path field. Valid only when `local_as_number` is set. Example: ["65023", "65023"].
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)

    @property
    @pulumi.getter(name="rxQueueSize")
    def rx_queue_size(self) -> Optional[pulumi.Input[str]]:
        """
        Ethernet interface RX queue size. Once set, can't be deleted or disabled. Valid values: "1K", "2K", "4K".
        """
        return pulumi.get(self, "rx_queue_size")

    @rx_queue_size.setter
    def rx_queue_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rx_queue_size", value)

    @property
    @pulumi.getter(name="secondaryDnsServerIp")
    def secondary_dns_server_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary DNS server IP. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "secondary_dns_server_ip")

    @secondary_dns_server_ip.setter
    def secondary_dns_server_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_dns_server_ip", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[str]]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="spokeBgpManualAdvertiseCidrs")
    def spoke_bgp_manual_advertise_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of intended CIDRs to be advertised to external BGP router. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        """
        return pulumi.get(self, "spoke_bgp_manual_advertise_cidrs")

    @spoke_bgp_manual_advertise_cidrs.setter
    def spoke_bgp_manual_advertise_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "spoke_bgp_manual_advertise_cidrs", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of Edge as a Spoke.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="wanDefaultGatewayIp")
    def wan_default_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        WAN default gateway IP.
        """
        return pulumi.get(self, "wan_default_gateway_ip")

    @wan_default_gateway_ip.setter
    def wan_default_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_default_gateway_ip", value)

    @property
    @pulumi.getter(name="wanInterfaceIpPrefix")
    def wan_interface_ip_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        WAN interface IP and subnet prefix.
        """
        return pulumi.get(self, "wan_interface_ip_prefix")

    @wan_interface_ip_prefix.setter
    def wan_interface_ip_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_interface_ip_prefix", value)

    @property
    @pulumi.getter(name="wanPublicIp")
    def wan_public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        WAN public IP. Required for attaching connections over the Internet.
        """
        return pulumi.get(self, "wan_public_ip")

    @wan_public_ip.setter
    def wan_public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_public_ip", value)

    @property
    @pulumi.getter(name="ztpFileDownloadPath")
    def ztp_file_download_path(self) -> Optional[pulumi.Input[str]]:
        """
        The folder path where the ZTP file will be downloaded.
        """
        return pulumi.get(self, "ztp_file_download_path")

    @ztp_file_download_path.setter
    def ztp_file_download_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ztp_file_download_path", value)

    @property
    @pulumi.getter(name="ztpFileType")
    def ztp_file_type(self) -> Optional[pulumi.Input[str]]:
        """
        ZTP file type. Valid values: "iso", "cloud-init".
        """
        return pulumi.get(self, "ztp_file_type")

    @ztp_file_type.setter
    def ztp_file_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ztp_file_type", value)


class AviatrixEdgeSpoke(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approved_learned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bgp_hold_time: Optional[pulumi.Input[int]] = None,
                 bgp_polling_time: Optional[pulumi.Input[int]] = None,
                 dns_server_ip: Optional[pulumi.Input[str]] = None,
                 enable_edge_active_standby: Optional[pulumi.Input[bool]] = None,
                 enable_edge_active_standby_preemptive: Optional[pulumi.Input[bool]] = None,
                 enable_edge_transitive_routing: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_management_over_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_preserve_as_path: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 lan_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
                 latitude: Optional[pulumi.Input[str]] = None,
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 longitude: Optional[pulumi.Input[str]] = None,
                 management_default_gateway_ip: Optional[pulumi.Input[str]] = None,
                 management_egress_ip_prefix: Optional[pulumi.Input[str]] = None,
                 management_interface_config: Optional[pulumi.Input[str]] = None,
                 management_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 secondary_dns_server_ip: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 spoke_bgp_manual_advertise_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wan_default_gateway_ip: Optional[pulumi.Input[str]] = None,
                 wan_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
                 wan_public_ip: Optional[pulumi.Input[str]] = None,
                 ztp_file_download_path: Optional[pulumi.Input[str]] = None,
                 ztp_file_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_edge_spoke** resource creates the Aviatrix Edge as a Spoke. This resource is available as of provider version R2.23+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create a DHCP Edge as a Spoke
        test = aviatrix.AviatrixEdgeSpoke("test",
            gw_name="edge-test",
            lan_interface_ip_prefix="10.60.0.0/24",
            local_as_number="65000",
            management_interface_config="DHCP",
            prepend_as_paths=[
                "65000",
                "65000",
            ],
            site_id="site-123",
            wan_default_gateway_ip="10.60.0.0",
            wan_interface_ip_prefix="10.60.0.0/24",
            ztp_file_download_path="/ztp/download/path",
            ztp_file_type="iso")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create a Static Edge as a Spoke
        test = aviatrix.AviatrixEdgeSpoke("test",
            dns_server_ip="10.60.0.0",
            gw_name="edge-test",
            lan_interface_ip_prefix="10.60.0.0/24",
            local_as_number="65000",
            management_default_gateway_ip="10.60.0.0",
            management_interface_config="Static",
            management_interface_ip_prefix="10.60.0.0/24",
            prepend_as_paths=[
                "65000",
                "65000",
            ],
            secondary_dns_server_ip="10.60.0.0",
            site_id="site-123",
            wan_default_gateway_ip="10.60.0.0",
            wan_interface_ip_prefix="10.60.0.0/24",
            ztp_file_download_path="/ztp/download/path",
            ztp_file_type="iso")
        ```

        ## Import

        **edge_spoke** can be imported using the `gw_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixEdgeSpoke:AviatrixEdgeSpoke test gw_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_learned_cidrs: Set of approved learned CIDRs. Valid only when `enable_learned_cidrs_approval` is set to true. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        :param pulumi.Input[int] bgp_hold_time: BGP hold time. Unit is in seconds. Valid values are between 12 and 360. Default value: 180.
        :param pulumi.Input[int] bgp_polling_time: BGP route polling time. Unit is in seconds. Valid values are between 10 and 50. Default value: 50.
        :param pulumi.Input[str] dns_server_ip: DNS server IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[bool] enable_edge_active_standby: Switch to enable Edge Active-Standby mode. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_edge_active_standby_preemptive: Switch to enable Preemptive Mode for Edge Active-Standby. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_edge_transitive_routing: Switch to enable Edge transitive routing. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Switch to enable jumbo frame. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable learned CIDR approval. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_management_over_private_network: Switch to enable management over the private network. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_preserve_as_path: Switch to enable preserve as_path when advertising manual summary CIDRs. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] gw_name: Edge as a Spoke name.
        :param pulumi.Input[str] lan_interface_ip_prefix: LAN interface IP and subnet prefix.
        :param pulumi.Input[str] latitude: Latitude of Edge as a Spoke. Valid values are between -90 and 90. Example: "47.7511".
        :param pulumi.Input[str] local_as_number: BGP AS Number to assign to Edge as a Spoke.
        :param pulumi.Input[str] longitude: Longitude of Edge as a Spoke. Valid values are between -180 and 180. Example: "120.7401".
        :param pulumi.Input[str] management_default_gateway_ip: Management default gateway IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[str] management_egress_ip_prefix: Management egress gateway IP and subnet prefix.
        :param pulumi.Input[str] management_interface_config: Management interface configuration. Valid values: "DHCP", "Static".
        :param pulumi.Input[str] management_interface_ip_prefix: Management interface IP and subnet prefix. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: List of AS numbers to prepend gateway BGP AS_Path field. Valid only when `local_as_number` is set. Example: ["65023", "65023"].
        :param pulumi.Input[str] rx_queue_size: Ethernet interface RX queue size. Once set, can't be deleted or disabled. Valid values: "1K", "2K", "4K".
        :param pulumi.Input[str] secondary_dns_server_ip: Secondary DNS server IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[str] site_id: Site ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_bgp_manual_advertise_cidrs: Set of intended CIDRs to be advertised to external BGP router. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        :param pulumi.Input[str] wan_default_gateway_ip: WAN default gateway IP.
        :param pulumi.Input[str] wan_interface_ip_prefix: WAN interface IP and subnet prefix.
        :param pulumi.Input[str] wan_public_ip: WAN public IP. Required for attaching connections over the Internet.
        :param pulumi.Input[str] ztp_file_download_path: The folder path where the ZTP file will be downloaded.
        :param pulumi.Input[str] ztp_file_type: ZTP file type. Valid values: "iso", "cloud-init".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixEdgeSpokeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_edge_spoke** resource creates the Aviatrix Edge as a Spoke. This resource is available as of provider version R2.23+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create a DHCP Edge as a Spoke
        test = aviatrix.AviatrixEdgeSpoke("test",
            gw_name="edge-test",
            lan_interface_ip_prefix="10.60.0.0/24",
            local_as_number="65000",
            management_interface_config="DHCP",
            prepend_as_paths=[
                "65000",
                "65000",
            ],
            site_id="site-123",
            wan_default_gateway_ip="10.60.0.0",
            wan_interface_ip_prefix="10.60.0.0/24",
            ztp_file_download_path="/ztp/download/path",
            ztp_file_type="iso")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create a Static Edge as a Spoke
        test = aviatrix.AviatrixEdgeSpoke("test",
            dns_server_ip="10.60.0.0",
            gw_name="edge-test",
            lan_interface_ip_prefix="10.60.0.0/24",
            local_as_number="65000",
            management_default_gateway_ip="10.60.0.0",
            management_interface_config="Static",
            management_interface_ip_prefix="10.60.0.0/24",
            prepend_as_paths=[
                "65000",
                "65000",
            ],
            secondary_dns_server_ip="10.60.0.0",
            site_id="site-123",
            wan_default_gateway_ip="10.60.0.0",
            wan_interface_ip_prefix="10.60.0.0/24",
            ztp_file_download_path="/ztp/download/path",
            ztp_file_type="iso")
        ```

        ## Import

        **edge_spoke** can be imported using the `gw_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixEdgeSpoke:AviatrixEdgeSpoke test gw_name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixEdgeSpokeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixEdgeSpokeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approved_learned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bgp_hold_time: Optional[pulumi.Input[int]] = None,
                 bgp_polling_time: Optional[pulumi.Input[int]] = None,
                 dns_server_ip: Optional[pulumi.Input[str]] = None,
                 enable_edge_active_standby: Optional[pulumi.Input[bool]] = None,
                 enable_edge_active_standby_preemptive: Optional[pulumi.Input[bool]] = None,
                 enable_edge_transitive_routing: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 enable_management_over_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_preserve_as_path: Optional[pulumi.Input[bool]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 lan_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
                 latitude: Optional[pulumi.Input[str]] = None,
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 longitude: Optional[pulumi.Input[str]] = None,
                 management_default_gateway_ip: Optional[pulumi.Input[str]] = None,
                 management_egress_ip_prefix: Optional[pulumi.Input[str]] = None,
                 management_interface_config: Optional[pulumi.Input[str]] = None,
                 management_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rx_queue_size: Optional[pulumi.Input[str]] = None,
                 secondary_dns_server_ip: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 spoke_bgp_manual_advertise_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wan_default_gateway_ip: Optional[pulumi.Input[str]] = None,
                 wan_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
                 wan_public_ip: Optional[pulumi.Input[str]] = None,
                 ztp_file_download_path: Optional[pulumi.Input[str]] = None,
                 ztp_file_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixEdgeSpokeArgs.__new__(AviatrixEdgeSpokeArgs)

            __props__.__dict__["approved_learned_cidrs"] = approved_learned_cidrs
            __props__.__dict__["bgp_hold_time"] = bgp_hold_time
            __props__.__dict__["bgp_polling_time"] = bgp_polling_time
            __props__.__dict__["dns_server_ip"] = dns_server_ip
            __props__.__dict__["enable_edge_active_standby"] = enable_edge_active_standby
            __props__.__dict__["enable_edge_active_standby_preemptive"] = enable_edge_active_standby_preemptive
            __props__.__dict__["enable_edge_transitive_routing"] = enable_edge_transitive_routing
            __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
            __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
            __props__.__dict__["enable_management_over_private_network"] = enable_management_over_private_network
            __props__.__dict__["enable_preserve_as_path"] = enable_preserve_as_path
            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            if lan_interface_ip_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'lan_interface_ip_prefix'")
            __props__.__dict__["lan_interface_ip_prefix"] = lan_interface_ip_prefix
            __props__.__dict__["latitude"] = latitude
            __props__.__dict__["local_as_number"] = local_as_number
            __props__.__dict__["longitude"] = longitude
            __props__.__dict__["management_default_gateway_ip"] = management_default_gateway_ip
            __props__.__dict__["management_egress_ip_prefix"] = management_egress_ip_prefix
            if management_interface_config is None and not opts.urn:
                raise TypeError("Missing required property 'management_interface_config'")
            __props__.__dict__["management_interface_config"] = management_interface_config
            __props__.__dict__["management_interface_ip_prefix"] = management_interface_ip_prefix
            __props__.__dict__["prepend_as_paths"] = prepend_as_paths
            __props__.__dict__["rx_queue_size"] = rx_queue_size
            __props__.__dict__["secondary_dns_server_ip"] = secondary_dns_server_ip
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["spoke_bgp_manual_advertise_cidrs"] = spoke_bgp_manual_advertise_cidrs
            if wan_default_gateway_ip is None and not opts.urn:
                raise TypeError("Missing required property 'wan_default_gateway_ip'")
            __props__.__dict__["wan_default_gateway_ip"] = wan_default_gateway_ip
            if wan_interface_ip_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'wan_interface_ip_prefix'")
            __props__.__dict__["wan_interface_ip_prefix"] = wan_interface_ip_prefix
            __props__.__dict__["wan_public_ip"] = wan_public_ip
            if ztp_file_download_path is None and not opts.urn:
                raise TypeError("Missing required property 'ztp_file_download_path'")
            __props__.__dict__["ztp_file_download_path"] = ztp_file_download_path
            if ztp_file_type is None and not opts.urn:
                raise TypeError("Missing required property 'ztp_file_type'")
            __props__.__dict__["ztp_file_type"] = ztp_file_type
            __props__.__dict__["state"] = None
        super(AviatrixEdgeSpoke, __self__).__init__(
            'aviatrix:index/aviatrixEdgeSpoke:AviatrixEdgeSpoke',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approved_learned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            bgp_hold_time: Optional[pulumi.Input[int]] = None,
            bgp_polling_time: Optional[pulumi.Input[int]] = None,
            dns_server_ip: Optional[pulumi.Input[str]] = None,
            enable_edge_active_standby: Optional[pulumi.Input[bool]] = None,
            enable_edge_active_standby_preemptive: Optional[pulumi.Input[bool]] = None,
            enable_edge_transitive_routing: Optional[pulumi.Input[bool]] = None,
            enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
            enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
            enable_management_over_private_network: Optional[pulumi.Input[bool]] = None,
            enable_preserve_as_path: Optional[pulumi.Input[bool]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            lan_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
            latitude: Optional[pulumi.Input[str]] = None,
            local_as_number: Optional[pulumi.Input[str]] = None,
            longitude: Optional[pulumi.Input[str]] = None,
            management_default_gateway_ip: Optional[pulumi.Input[str]] = None,
            management_egress_ip_prefix: Optional[pulumi.Input[str]] = None,
            management_interface_config: Optional[pulumi.Input[str]] = None,
            management_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
            prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rx_queue_size: Optional[pulumi.Input[str]] = None,
            secondary_dns_server_ip: Optional[pulumi.Input[str]] = None,
            site_id: Optional[pulumi.Input[str]] = None,
            spoke_bgp_manual_advertise_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            wan_default_gateway_ip: Optional[pulumi.Input[str]] = None,
            wan_interface_ip_prefix: Optional[pulumi.Input[str]] = None,
            wan_public_ip: Optional[pulumi.Input[str]] = None,
            ztp_file_download_path: Optional[pulumi.Input[str]] = None,
            ztp_file_type: Optional[pulumi.Input[str]] = None) -> 'AviatrixEdgeSpoke':
        """
        Get an existing AviatrixEdgeSpoke resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] approved_learned_cidrs: Set of approved learned CIDRs. Valid only when `enable_learned_cidrs_approval` is set to true. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        :param pulumi.Input[int] bgp_hold_time: BGP hold time. Unit is in seconds. Valid values are between 12 and 360. Default value: 180.
        :param pulumi.Input[int] bgp_polling_time: BGP route polling time. Unit is in seconds. Valid values are between 10 and 50. Default value: 50.
        :param pulumi.Input[str] dns_server_ip: DNS server IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[bool] enable_edge_active_standby: Switch to enable Edge Active-Standby mode. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_edge_active_standby_preemptive: Switch to enable Preemptive Mode for Edge Active-Standby. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_edge_transitive_routing: Switch to enable Edge transitive routing. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_jumbo_frame: Switch to enable jumbo frame. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable learned CIDR approval. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_management_over_private_network: Switch to enable management over the private network. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] enable_preserve_as_path: Switch to enable preserve as_path when advertising manual summary CIDRs. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] gw_name: Edge as a Spoke name.
        :param pulumi.Input[str] lan_interface_ip_prefix: LAN interface IP and subnet prefix.
        :param pulumi.Input[str] latitude: Latitude of Edge as a Spoke. Valid values are between -90 and 90. Example: "47.7511".
        :param pulumi.Input[str] local_as_number: BGP AS Number to assign to Edge as a Spoke.
        :param pulumi.Input[str] longitude: Longitude of Edge as a Spoke. Valid values are between -180 and 180. Example: "120.7401".
        :param pulumi.Input[str] management_default_gateway_ip: Management default gateway IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[str] management_egress_ip_prefix: Management egress gateway IP and subnet prefix.
        :param pulumi.Input[str] management_interface_config: Management interface configuration. Valid values: "DHCP", "Static".
        :param pulumi.Input[str] management_interface_ip_prefix: Management interface IP and subnet prefix. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: List of AS numbers to prepend gateway BGP AS_Path field. Valid only when `local_as_number` is set. Example: ["65023", "65023"].
        :param pulumi.Input[str] rx_queue_size: Ethernet interface RX queue size. Once set, can't be deleted or disabled. Valid values: "1K", "2K", "4K".
        :param pulumi.Input[str] secondary_dns_server_ip: Secondary DNS server IP. Required and valid when `management_interface_config` is "Static".
        :param pulumi.Input[str] site_id: Site ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_bgp_manual_advertise_cidrs: Set of intended CIDRs to be advertised to external BGP router. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        :param pulumi.Input[str] state: State of Edge as a Spoke.
        :param pulumi.Input[str] wan_default_gateway_ip: WAN default gateway IP.
        :param pulumi.Input[str] wan_interface_ip_prefix: WAN interface IP and subnet prefix.
        :param pulumi.Input[str] wan_public_ip: WAN public IP. Required for attaching connections over the Internet.
        :param pulumi.Input[str] ztp_file_download_path: The folder path where the ZTP file will be downloaded.
        :param pulumi.Input[str] ztp_file_type: ZTP file type. Valid values: "iso", "cloud-init".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixEdgeSpokeState.__new__(_AviatrixEdgeSpokeState)

        __props__.__dict__["approved_learned_cidrs"] = approved_learned_cidrs
        __props__.__dict__["bgp_hold_time"] = bgp_hold_time
        __props__.__dict__["bgp_polling_time"] = bgp_polling_time
        __props__.__dict__["dns_server_ip"] = dns_server_ip
        __props__.__dict__["enable_edge_active_standby"] = enable_edge_active_standby
        __props__.__dict__["enable_edge_active_standby_preemptive"] = enable_edge_active_standby_preemptive
        __props__.__dict__["enable_edge_transitive_routing"] = enable_edge_transitive_routing
        __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
        __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
        __props__.__dict__["enable_management_over_private_network"] = enable_management_over_private_network
        __props__.__dict__["enable_preserve_as_path"] = enable_preserve_as_path
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["lan_interface_ip_prefix"] = lan_interface_ip_prefix
        __props__.__dict__["latitude"] = latitude
        __props__.__dict__["local_as_number"] = local_as_number
        __props__.__dict__["longitude"] = longitude
        __props__.__dict__["management_default_gateway_ip"] = management_default_gateway_ip
        __props__.__dict__["management_egress_ip_prefix"] = management_egress_ip_prefix
        __props__.__dict__["management_interface_config"] = management_interface_config
        __props__.__dict__["management_interface_ip_prefix"] = management_interface_ip_prefix
        __props__.__dict__["prepend_as_paths"] = prepend_as_paths
        __props__.__dict__["rx_queue_size"] = rx_queue_size
        __props__.__dict__["secondary_dns_server_ip"] = secondary_dns_server_ip
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["spoke_bgp_manual_advertise_cidrs"] = spoke_bgp_manual_advertise_cidrs
        __props__.__dict__["state"] = state
        __props__.__dict__["wan_default_gateway_ip"] = wan_default_gateway_ip
        __props__.__dict__["wan_interface_ip_prefix"] = wan_interface_ip_prefix
        __props__.__dict__["wan_public_ip"] = wan_public_ip
        __props__.__dict__["ztp_file_download_path"] = ztp_file_download_path
        __props__.__dict__["ztp_file_type"] = ztp_file_type
        return AviatrixEdgeSpoke(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approvedLearnedCidrs")
    def approved_learned_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Set of approved learned CIDRs. Valid only when `enable_learned_cidrs_approval` is set to true. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        """
        return pulumi.get(self, "approved_learned_cidrs")

    @property
    @pulumi.getter(name="bgpHoldTime")
    def bgp_hold_time(self) -> pulumi.Output[Optional[int]]:
        """
        BGP hold time. Unit is in seconds. Valid values are between 12 and 360. Default value: 180.
        """
        return pulumi.get(self, "bgp_hold_time")

    @property
    @pulumi.getter(name="bgpPollingTime")
    def bgp_polling_time(self) -> pulumi.Output[Optional[int]]:
        """
        BGP route polling time. Unit is in seconds. Valid values are between 10 and 50. Default value: 50.
        """
        return pulumi.get(self, "bgp_polling_time")

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> pulumi.Output[Optional[str]]:
        """
        DNS server IP. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "dns_server_ip")

    @property
    @pulumi.getter(name="enableEdgeActiveStandby")
    def enable_edge_active_standby(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable Edge Active-Standby mode. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_edge_active_standby")

    @property
    @pulumi.getter(name="enableEdgeActiveStandbyPreemptive")
    def enable_edge_active_standby_preemptive(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable Preemptive Mode for Edge Active-Standby. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_edge_active_standby_preemptive")

    @property
    @pulumi.getter(name="enableEdgeTransitiveRouting")
    def enable_edge_transitive_routing(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable Edge transitive routing. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_edge_transitive_routing")

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable jumbo frame. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable learned CIDR approval. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @property
    @pulumi.getter(name="enableManagementOverPrivateNetwork")
    def enable_management_over_private_network(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable management over the private network. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_management_over_private_network")

    @property
    @pulumi.getter(name="enablePreserveAsPath")
    def enable_preserve_as_path(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable preserve as_path when advertising manual summary CIDRs. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_preserve_as_path")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Edge as a Spoke name.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="lanInterfaceIpPrefix")
    def lan_interface_ip_prefix(self) -> pulumi.Output[str]:
        """
        LAN interface IP and subnet prefix.
        """
        return pulumi.get(self, "lan_interface_ip_prefix")

    @property
    @pulumi.getter
    def latitude(self) -> pulumi.Output[str]:
        """
        Latitude of Edge as a Spoke. Valid values are between -90 and 90. Example: "47.7511".
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter(name="localAsNumber")
    def local_as_number(self) -> pulumi.Output[str]:
        """
        BGP AS Number to assign to Edge as a Spoke.
        """
        return pulumi.get(self, "local_as_number")

    @property
    @pulumi.getter
    def longitude(self) -> pulumi.Output[str]:
        """
        Longitude of Edge as a Spoke. Valid values are between -180 and 180. Example: "120.7401".
        """
        return pulumi.get(self, "longitude")

    @property
    @pulumi.getter(name="managementDefaultGatewayIp")
    def management_default_gateway_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Management default gateway IP. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "management_default_gateway_ip")

    @property
    @pulumi.getter(name="managementEgressIpPrefix")
    def management_egress_ip_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        Management egress gateway IP and subnet prefix.
        """
        return pulumi.get(self, "management_egress_ip_prefix")

    @property
    @pulumi.getter(name="managementInterfaceConfig")
    def management_interface_config(self) -> pulumi.Output[str]:
        """
        Management interface configuration. Valid values: "DHCP", "Static".
        """
        return pulumi.get(self, "management_interface_config")

    @property
    @pulumi.getter(name="managementInterfaceIpPrefix")
    def management_interface_ip_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        Management interface IP and subnet prefix. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "management_interface_ip_prefix")

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of AS numbers to prepend gateway BGP AS_Path field. Valid only when `local_as_number` is set. Example: ["65023", "65023"].
        """
        return pulumi.get(self, "prepend_as_paths")

    @property
    @pulumi.getter(name="rxQueueSize")
    def rx_queue_size(self) -> pulumi.Output[Optional[str]]:
        """
        Ethernet interface RX queue size. Once set, can't be deleted or disabled. Valid values: "1K", "2K", "4K".
        """
        return pulumi.get(self, "rx_queue_size")

    @property
    @pulumi.getter(name="secondaryDnsServerIp")
    def secondary_dns_server_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Secondary DNS server IP. Required and valid when `management_interface_config` is "Static".
        """
        return pulumi.get(self, "secondary_dns_server_ip")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[str]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="spokeBgpManualAdvertiseCidrs")
    def spoke_bgp_manual_advertise_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Set of intended CIDRs to be advertised to external BGP router. Example: ["10.1.0.0/116", "10.2.0.0/16"].
        """
        return pulumi.get(self, "spoke_bgp_manual_advertise_cidrs")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of Edge as a Spoke.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="wanDefaultGatewayIp")
    def wan_default_gateway_ip(self) -> pulumi.Output[str]:
        """
        WAN default gateway IP.
        """
        return pulumi.get(self, "wan_default_gateway_ip")

    @property
    @pulumi.getter(name="wanInterfaceIpPrefix")
    def wan_interface_ip_prefix(self) -> pulumi.Output[str]:
        """
        WAN interface IP and subnet prefix.
        """
        return pulumi.get(self, "wan_interface_ip_prefix")

    @property
    @pulumi.getter(name="wanPublicIp")
    def wan_public_ip(self) -> pulumi.Output[str]:
        """
        WAN public IP. Required for attaching connections over the Internet.
        """
        return pulumi.get(self, "wan_public_ip")

    @property
    @pulumi.getter(name="ztpFileDownloadPath")
    def ztp_file_download_path(self) -> pulumi.Output[str]:
        """
        The folder path where the ZTP file will be downloaded.
        """
        return pulumi.get(self, "ztp_file_download_path")

    @property
    @pulumi.getter(name="ztpFileType")
    def ztp_file_type(self) -> pulumi.Output[str]:
        """
        ZTP file type. Valid values: "iso", "cloud-init".
        """
        return pulumi.get(self, "ztp_file_type")

