# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixAwsTgwSecurityDomainConnArgs', 'AviatrixAwsTgwSecurityDomainConn']

@pulumi.input_type
class AviatrixAwsTgwSecurityDomainConnArgs:
    def __init__(__self__, *,
                 domain_name1: pulumi.Input[str],
                 domain_name2: pulumi.Input[str],
                 tgw_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixAwsTgwSecurityDomainConn resource.
        :param pulumi.Input[str] domain_name1: The name of a security domain to make a connection.
        :param pulumi.Input[str] domain_name2: The name of another security domain to make a connection.
        :param pulumi.Input[str] tgw_name: The AWS TGW name.
        """
        pulumi.set(__self__, "domain_name1", domain_name1)
        pulumi.set(__self__, "domain_name2", domain_name2)
        pulumi.set(__self__, "tgw_name", tgw_name)

    @property
    @pulumi.getter(name="domainName1")
    def domain_name1(self) -> pulumi.Input[str]:
        """
        The name of a security domain to make a connection.
        """
        return pulumi.get(self, "domain_name1")

    @domain_name1.setter
    def domain_name1(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name1", value)

    @property
    @pulumi.getter(name="domainName2")
    def domain_name2(self) -> pulumi.Input[str]:
        """
        The name of another security domain to make a connection.
        """
        return pulumi.get(self, "domain_name2")

    @domain_name2.setter
    def domain_name2(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name2", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Input[str]:
        """
        The AWS TGW name.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tgw_name", value)


@pulumi.input_type
class _AviatrixAwsTgwSecurityDomainConnState:
    def __init__(__self__, *,
                 domain_name1: Optional[pulumi.Input[str]] = None,
                 domain_name2: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAwsTgwSecurityDomainConn resources.
        :param pulumi.Input[str] domain_name1: The name of a security domain to make a connection.
        :param pulumi.Input[str] domain_name2: The name of another security domain to make a connection.
        :param pulumi.Input[str] tgw_name: The AWS TGW name.
        """
        if domain_name1 is not None:
            pulumi.set(__self__, "domain_name1", domain_name1)
        if domain_name2 is not None:
            pulumi.set(__self__, "domain_name2", domain_name2)
        if tgw_name is not None:
            pulumi.set(__self__, "tgw_name", tgw_name)

    @property
    @pulumi.getter(name="domainName1")
    def domain_name1(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a security domain to make a connection.
        """
        return pulumi.get(self, "domain_name1")

    @domain_name1.setter
    def domain_name1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name1", value)

    @property
    @pulumi.getter(name="domainName2")
    def domain_name2(self) -> Optional[pulumi.Input[str]]:
        """
        The name of another security domain to make a connection.
        """
        return pulumi.get(self, "domain_name2")

    @domain_name2.setter
    def domain_name2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name2", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS TGW name.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_name", value)


class AviatrixAwsTgwSecurityDomainConn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name1: Optional[pulumi.Input[str]] = None,
                 domain_name2: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        !> **WARNING:** Resource 'aviatrix_aws_tgw_security_domain_connection' will be deprecated in future releases. Please use resource 'aviatrix_aws_tgw_peering_domain_conn' instead.

        The **aviatrix_aws_tgw_security_domain_connection** resource allows the creation and management of the connections between security domains in an AWS TGW.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Security Domain Connection
        test = aviatrix.AviatrixAwsTgwSecurityDomainConn("test",
            domain_name1="domain1",
            domain_name2="domain2",
            tgw_name="tgw")
        ```

        ## Import

        **aws_tgw_security_domain_connection** can be imported using the `tgw_name`, `domain_name1` and `domain_name2`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixAwsTgwSecurityDomainConn:AviatrixAwsTgwSecurityDomainConn test tgw_name~domain_name1~domain_name2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name1: The name of a security domain to make a connection.
        :param pulumi.Input[str] domain_name2: The name of another security domain to make a connection.
        :param pulumi.Input[str] tgw_name: The AWS TGW name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAwsTgwSecurityDomainConnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> **WARNING:** Resource 'aviatrix_aws_tgw_security_domain_connection' will be deprecated in future releases. Please use resource 'aviatrix_aws_tgw_peering_domain_conn' instead.

        The **aviatrix_aws_tgw_security_domain_connection** resource allows the creation and management of the connections between security domains in an AWS TGW.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Security Domain Connection
        test = aviatrix.AviatrixAwsTgwSecurityDomainConn("test",
            domain_name1="domain1",
            domain_name2="domain2",
            tgw_name="tgw")
        ```

        ## Import

        **aws_tgw_security_domain_connection** can be imported using the `tgw_name`, `domain_name1` and `domain_name2`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixAwsTgwSecurityDomainConn:AviatrixAwsTgwSecurityDomainConn test tgw_name~domain_name1~domain_name2
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixAwsTgwSecurityDomainConnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAwsTgwSecurityDomainConnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name1: Optional[pulumi.Input[str]] = None,
                 domain_name2: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAwsTgwSecurityDomainConnArgs.__new__(AviatrixAwsTgwSecurityDomainConnArgs)

            if domain_name1 is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name1'")
            __props__.__dict__["domain_name1"] = domain_name1
            if domain_name2 is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name2'")
            __props__.__dict__["domain_name2"] = domain_name2
            if tgw_name is None and not opts.urn:
                raise TypeError("Missing required property 'tgw_name'")
            __props__.__dict__["tgw_name"] = tgw_name
        super(AviatrixAwsTgwSecurityDomainConn, __self__).__init__(
            'aviatrix:index/aviatrixAwsTgwSecurityDomainConn:AviatrixAwsTgwSecurityDomainConn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_name1: Optional[pulumi.Input[str]] = None,
            domain_name2: Optional[pulumi.Input[str]] = None,
            tgw_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixAwsTgwSecurityDomainConn':
        """
        Get an existing AviatrixAwsTgwSecurityDomainConn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name1: The name of a security domain to make a connection.
        :param pulumi.Input[str] domain_name2: The name of another security domain to make a connection.
        :param pulumi.Input[str] tgw_name: The AWS TGW name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAwsTgwSecurityDomainConnState.__new__(_AviatrixAwsTgwSecurityDomainConnState)

        __props__.__dict__["domain_name1"] = domain_name1
        __props__.__dict__["domain_name2"] = domain_name2
        __props__.__dict__["tgw_name"] = tgw_name
        return AviatrixAwsTgwSecurityDomainConn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="domainName1")
    def domain_name1(self) -> pulumi.Output[str]:
        """
        The name of a security domain to make a connection.
        """
        return pulumi.get(self, "domain_name1")

    @property
    @pulumi.getter(name="domainName2")
    def domain_name2(self) -> pulumi.Output[str]:
        """
        The name of another security domain to make a connection.
        """
        return pulumi.get(self, "domain_name2")

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Output[str]:
        """
        The AWS TGW name.
        """
        return pulumi.get(self, "tgw_name")

