# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gator', 'gator.checks']

package_data = \
{'': ['*']}

modules = \
['gatorgrader']
install_requires = \
['GitPython>=3.1.26,<4.0.0',
 'commonmark>=0.9.1,<0.10.0',
 'num2words>=0.5.10,<0.6.0',
 'pluginbase>=1.0.1,<2.0.0',
 'requests>=2.27.1,<3.0.0']

entry_points = \
{'console_scripts': ['gatorgrader = gatorgrader:main']}

setup_kwargs = {
    'name': 'gatorgrader',
    'version': '1.1.0',
    'description': 'Automated Grading Tool that Checks the Work of Writers and Programmers',
    'long_description': '# GatorGrader\n\n![Image of Logo](.github/gatorgraderlogotitled.png)\n\n<p align="center">\n<b>\nThe only tool you\'ll need to ensure your student\'s code and writing is up to\nspeed!\n</b>\n</p>\n\n[![Lint and Test](https://github.com/GatorEducator/gatorgrader/workflows/Lint%20and%20Test/badge.svg?branch=master)](https://github.com/GatorEducator/gatorgrader/actions?query=workflow%3A%22Lint+and+Test%22+branch%3Amaster) [![codecov.io](https://codecov.io/gh/GatorEducator/gatorgrader/branch/master/graph/badge.svg?token=UKBOlE7kG6)](https://codecov.io/gh/GatorEducator/gatorgrader) [![codacy.com](https://api.codacy.com/project/badge/Grade/3dade81be6dc467b8e34cde66eb5cdc6)](https://www.codacy.com/app/GatorEducator/gatorgrader?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=GatorEducator/gatorgrader&amp;utm_campaign=Badge_Grade) [![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-orange.svg)](https://github.com/GatorEducator/gatorgrader/graphs/commit-activity) [![GitHub license](https://img.shields.io/github/license/GatorEducator/gatorgrader.svg)](https://github.com/GatorEducator/gatorgrader/blob/master/LICENSE.md) [![All Contributors](https://img.shields.io/badge/all_contributors-33-orange.svg?style=flat-square)](#contributors)\n\n## Table of Contents\n\n* [Quickstart Guide](#quickstart-guide)\n* [Key Features](#key-features)\n* [What Do People Think about GatorGrader?](#what-do-people-think-about-gatorgrader)\n* [Installing GatorGrader](#installing-gatorgrader)\n* [Testing GatorGrader](#testing-gatorgrader)\n  + [Automated Testing](#automated-testing)\n  + [Test Coverage](#test-coverage)\n  + [Testing with Multiple Python Versions](#testing-with-multiple-python-versions)\n  + [Code Linting](#code-linting)\n* [Running GatorGrader](#running-gatorgrader)\n* [Using Docker](#using-docker)\n* [Comparison to Other Tools](#comparison-to-other-tools)\n* [Presentations](#presentations)\n* [Contributing](#contributing)\n* [Contributors](#contributors)\n\n### Notes for PyPI Users\n\nThis release (`1.1.0`) of GatorGrader is intended to be a stop-gap solution. It is released from the [`feature/publish-to-pypi`](https://github.com/GatorEducator/gatorgrader/tree/feature/publish-to-pypi) branch on GitHub. In future versions, some changes may be made to the structure and distribution of this package. Additionally, the documentation available in the rest of this document may or may not be fully accurate. For users who just wish to use GatorGrader on the command line, all that is needed is to install this package and run `gatorgrader`. For help on syntax and available options, see `gatorgrader --help`.\n\nFor users who would like to interact with GatorGrader programmatically, refer to the docstrings available in `gatorgrader.py` and `gator/__init__.py` (or view them in your editor-of-choice with support for a [Python Language Server](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)). In summary, however, GatorGrader can be run by importing the `gator` package and calling `gator.grader(["list", "--of", "command", "--line", "arguments"])`, the syntax of which matches previous versions of GatorGrader. For additional help or guidance, see `gatorgrader --help` or reach out to any of the core maintainers.\n\n## Quickstart Guide\n\n* Starter Repositories\nAn easy way to get started with GatorGrader is to check out our sample starter repositories.\nThe following starter repositories provide examples of how GatorGrader files should be created\nto check programs and documentation for different languages:\n[Java](https://github.com/GatorEducator/java-assignment-starter-100-01),\n[Python](https://github.com/GatorEducator/python-assignment-starter-203-05), [LaTex](https://github.com/GatorEducator/latex-assignment-starter-100-01) and [HTML with CSS](https://github.com/GatorEducator/html-assignment-starter-302-03). These\nexamples also show how to integrate GatorGrader with [GitHub\nClassroom](https://classroom.github.com/) and [Travis\nCI](https://travis-ci.com/). When you follow these examples, the Gradle plugin\nfor GatorGrader will install it automatically when you run `gradle grade` in a\nterminal window. Please be aware that these repositories are meant to have a majority\nof red checks. This is only meant to be a “starter” and give an insight into what must be accomplished within the lab.\n* Solution Repositories\nThe next step to get involved with GatorGrader is to checkout our sample solution\nrepositories. The following solution repositories provide examples of how GatorGrader files should be\ncreated to check programs and documentation for different languages:\n[Java](https://github.com/GatorEducator/java-assignment-solution-100-01),\n[Python](https://github.com/GatorEducator/python-assignment-solution-203-05), [LaTex](https://github.com/GatorEducator/latex-assignment-solution-100-01) , and [HTML with CSS](https://github.com/GatorEducator/html-assignment-solution-302-03). These examples\nalso show how to integrate GatorGrader with  [GitHub\nClassroom](https://classroom.github.com/) and [Travis\nCI](https://travis-ci.com/).  When you follow these examples, the Gradle plugin\nfor GatorGrader will install it automatically when you run `gradle grade` in a\nterminal window. Please be aware that these repositories are meant to have a majority\nof green checks. This is meant to show what must be accomplished within a lab/practical\nand what it looks like when those tasks are completed.\n\n## Key Features\n\nGatorGrader automatically checks the work of technical writers and programmers.\nIt can:\n\n* Use its [Gradle plugin](https://github.com/GatorEducator/gatorgradle) to check\n  projects implemented and documented in a wide variety of languages (e.g.,\n  Java, Python, LaTeX, Markdown, HTML, and CSS).\n\n* Integrate with [GitHub Classroom](https://classroom.github.com/) to check\n  solution and starter repositories created for professors and students,\n  respectively.\n\n* Run in a cloud-based environment like [Travis CI](https://travis-ci.com/) or\n  on the command-line of a developer\'s workstation.\n\n* Operate as a "batteries included" grading tool, supporting automated checks\n  like the following:\n\n  * Does a file exist in the correct directory with the requested name?\n\n  * Does technical writing contain the desired number of words and paragraphs?\n\n  * Does source code contain the designated number of language-specific comments?\n\n  * Does source code or technical writing contain a required fragment or match\n    a specified regular expression?\n\n  * Does a command execute correctly and produce the expected number of output\n    lines?\n\n  * Does a command execute and produce output containing a fragment or matching\n    a regular expression?\n\n  * Does a GitHub repository contain the anticipated number of commits?\n\nAligning with key recommendations in a recent [National Academies\nreport](https://www.nap.edu/catalog/24926/assessing-and-responding-to-the-growth-of-computer-science-undergraduate-enrollments),\nGatorGrader helps instructors automatically check student submissions in both\nintroductory and application-oriented classes using languages like Markdown,\nJava, Python, JavaScript, CSS, and HTML. GatorGrader does not aim to solve\nproblems related to building and linting a project or managing an assignment\'s\nsubmission, instead integrating with existing tools and systems like\n[Gradle](https://gradle.org/), [GitHub](https://github.com/), and [GitHub\nClassroom](https://classroom.github.com/) to effectively handle those tasks.\n\n## Installing GatorGrader\n\nInstalling GatorGrader is not necessary if you intend to use it through its\n[Gradle plugin](https://github.com/GatorEducator/gatorgradle). If you want to\nparticipate in the development of GatorGrader, the project maintainers suggest\nthe use of [Pyenv](https://github.com/pyenv/pyenv) to install Python 3.6 or\nabove. In addition to installing [Git](https://git-scm.com/) to access the\nproject\'s GitHub repository, you should also install\n[Pipenv](https://github.com/pypa/pipenv) for its support of package and virtual\nenvironment management. After completing the installation of these tools, you\ncan type the following command in your terminal window to clone GatorGrader\'s\nGitHub repository:\n\n```bash\ngit clone https://github.com/GatorEducator/gatorgrader.git\n```\n\nIf you plan to develop new features for GatorGrader or if you want to run the\ntool\'s test suite in [Pytest](https://github.com/pytest-dev/pytest), then you\nwill need to install the developer dependencies by typing ``pipenv install --python="$(pyenv which python)" --dev`` in the directory that contains\nGatorGrader. If you want to use GatorGrader, then you can type ``pipenv install --python="$(pyenv which python)"`` instead. Once these commands complete\nsuccessfully, you have officially installed GatorGrader! Note that running these\ncommands will ensure that Pipenv creates a virtual environment for GatorGrader\nthat is bound to the version of Python that Pyenv set for use.\n\n## Testing GatorGrader\n\n### Automated Testing\n\nThe developers use [Pytest](https://docs.pytest.org/en/latest/) for the testing\nof GatorGrader. Depending on your goals, there are several different\nconfigurations in which you can run the provided test suite. If you want to run\nthe test suite to see if the test cases are passing, then running this command\nin a terminal window will perform testing with the version of Python to which\nPipenv\'s virtual environment is currently bound.\n\n```\npipenv run test\n```\n\n### Test Coverage\n\nAlong with running the test suite, the developers of GatorGrader use statement\nand branch coverage to enhance their testing activities. To see the coverage of\nthe tests while also highlighting the lines that are not currently covered by\nthe tests, you can run this command in a terminal window. As with the previous\ncommand, this will run the tests in the version of Python to which Pipenv\'s\nvirtual environment is currently bound.\n\n```\npipenv run cover\n```\n\n### Testing with Multiple Python Versions\n\nThe previous two commands are restricted to running the test suite in the\nversion of Python to which Pipenv was bound. If you have installed multiple\nversions of Python with Pyenv and you want to iteratively bind Pipenv to each\nversion and then run the test suite, then you should first run the following\ncommands to install [Pipx](https://github.com/pipxproject/pipx) and use Pipx to\ninstall [Invoke](https://github.com/pyinvoke/invoke). The first of these three\ncommands will install `pipx`, a program that supports the execution of Python\npackages in isolated environments. The second command makes the directory\n`~/.local/bin/` a part of the search path for executable Python programs and the\nthird one installs the `invoke` command so that it is available on your\nworkstation outside of a virtual environment managed by Pipenv, thereby ensuring\nthat it is always available to run tasks.\n\n```\npip install pipx --user\npython -m userpath append ~/.local/bin/\npipx install invoke\n```\n\nNow you can run the test suite in the specified versions of Python with the\nfollowing command. This example command will run the test suite in Python 3.6.8\nand Python 3.7.3.\n\n```\ninvoke -c scripts/tasks test --pyenv 3.6.8 --pyenv 3.7.3\n```\n\nIf you want to track test coverage while running the tests in both Python 3.6.8\nand 3.7.3, then you can run the following command.\n\n```\ninvoke -c scripts/tasks cover --pyenv 3.6.8 --pyenv 3.7.3\n```\n\nYou can switch the version to which Pipenv is bound by running the following\ncommand that adopts, for instance, Python 3.7.3.\n\n```\ninvoke -c scripts/tasks switch --pyenv 3.7.3\n```\n\n### Code Linting\n\nThe developers of GatorGrader use linting and code formatting tools, such as\n[Pylint](https://github.com/PyCQA/pylint),\n[Pydocstyle](https://github.com/PyCQA/pydocstyle), and\n[Black](https://github.com/python/black). After installing GatorGrader\'s\ndevelopment dependencies with Pipenv, you can run all of the linters by typing\nthis command in a terminal window.\n\n```bash\npipenv run lint --check\n```\n\n### Automated Checks\n\nWant to learn about our linting checks? Check us out on our website,\n[GatorGrader](https://deploy-preview-1--gatorgrader.netlify.com)! We have detailed\ndescriptions of our linting checks and more! To get an idea of the linting checks we\noffer, here is a quick list:\n\n1. ConfirmFileExists\n\n2. CountCommandOutput\n\n3. CountCommits\n\n4. CountFileLines\n\n5. CountFileParagraphs\n\nWant to learn about our automated checks? Check them out on our website,\n[gatorgrader.org](http://www.gatorgrader.org)! We have detailed\ndescriptions of our automated checks and more!\n\nSomething you should know when working with our checks is that all of\nthem come with some **optional arguments**. Optional arguments that you are likely\nto encounter:\n* `-h`\n* `--help`\n* `--exact`\n* `--advanced`\n\nIf `--help` is tagged along with a check then a help message will be displayed and\nthen exited. If further assistance is needed, please contact us on GitHub.\n\nAnother feature with our automated checks is the **plug-in based approach**. This allows\nusers to implement their own check if our initial 15 do not fulfill a check that\nyou find necessary.\n\n## Running GatorGrader\n\nStudents and instructors normally use GatorGrader through its [Gradle\nplugin](https://github.com/GatorEducator/gatorgradle), specifying the requested\nchecks in a `config/gatorgrader.yml` file. When run through Gradle, GatorGrader\nreports each check that it performed, additionally sharing a diagnostic message\nfor each check that did not pass. Individuals who want to run GatorGrader as a\nstand-alone Python application should first install it\'s application\ndependencies with Pipenv and then learn about the supported checks and their\ndefaults by typing `pipenv run python3 gatorgrader.py --help` in a terminal\nwindow.\n\nInstructors often run GatorGrader in conjunction with other tools that check\nsource code and technical writing. For instance, in a Java-based introductory\ncourse, instructors could verify student submissions with\n[Checkstyle](https://github.com/checkstyle/checkstyle), thereby ensuring that\nthe Java source code adheres to the requirements in the [Google Java Style\nGuide](https://google.github.io/styleguide/javaguide.html). In this course, an\ninstructor could require that Markdown files with technical writing meet the\nstandards described in the [Markdown Syntax\nGuide](https://guides.github.com/features/mastering-markdown/), meaning that all\nMarkdown files must pass the checks performed by the [Markdown linting\ntool](https://github.com/markdownlint/markdownlint). These assignments could\nalso require that all submitted technical writing must adhere to the standards\nset by the [Proselint tool](http://proselint.com/). Since GatorGrader can run an\narbitrary command and check its error code, it is also possible to integrate it\nwith a wide variety of other linters, code formatters, and testing tools.\n\nInstructors may at times need to see a full list of checks to have a better understanding\nand therefore, we feel that it is important to know that there is an easy way for that to happen.\nThis action will be completed through command line and therefore, you can type\n`pipenv run python gatorgrader.py ListChecks` into your terminal. This allows for\nall of the checks to be printed out as output. This output will have the necessary\nname labeled with the required and optional arguments. If this output does not give enough content,\nwe warmly invite you to navigate to our website, where we go into more detail about our Automated Checks.\n\n## Using Docker\nA vital part of our process for GatorGrader is to implement and use new techniques\nto further our tool to grow. This is why we chose to use Docker! Docker is a container\nplatform and therefore, allows students using GatorGrader to just open a container\nand have easy access to run all commands that would allow them to build, run, and\ngrade their labs and practicals. Docker is an industry standard and therefore,\ngives us an advantage. To open a container that will allow for the use of GatorGrader,\nrun the following command in your terminal window:\n```\ndocker run -it --rm --name dockagator \\\n\xa0\xa0-v "$(pwd)":/project \\\n\xa0\xa0-v "$HOME/.dockagator":/root/.local/share \\\n\xa0\xa0gatoreducator/dockagator /bin/bash\n```\nFrom here, you are set! Test it out by building, running, or grading your lab/practical!\nIf you would like to learn more about Docker, please follow this [link](https://www.docker.com).\n\n## Comparison to Other Tools\n\nOther automated grading tools include:\n\n- [autograde-github-classroom](https://github.com/apanangadan/autograde-github-classroom): "scripts to download and grade submissions to Github Classroom"\n- [check50](https://github.com/cs50/check50): "a tool for checking student code"\n- [Classroom Assistant](https://classroom.github.com/assistant): "desktop application to help you get student repositories for grading"\n- [nbgrader](https://github.com/jupyter/nbgrader): "a system for assigning and grading notebooks"\n- [nerfherder](https://github.com/kevinwortman/nerfherder): "scripts for automating grading with GitHub Classroom and Moodle"\n- [Submitty](https://github.com/Submitty/Submitty): "homework submission, automated grading, and TA grading system"\n- [WebCat](https://github.com/web-cat): "all-in-one plugin for full processing and feedback generation"\n\nDesigned for instructors who want an alternative to simple scripts or\nstand-alone platforms that do not integrate with industry-standard\ninfrastructure like GitHub and Travis CI, GatorGrader is a tool that\nautomatically checks the work of technical writers and programmers. Unlike other\nsystems, GatorGrader provides a "batteries included" approach to automated\ngrading that makes it easy for instructors to combine well-tested checks for\nprojects that students implement in a wide variety of programming languages.\nGatorGrader\'s developers take its engineering seriously, maintaining\nstandards-compliant source code, a test suite with 100% statement and branch\ncoverage, and top-notch source code and user documentation.\n\n## Presentations\n\nGatorGrader\'s creators give presentations about the development, use, and\nassessment of the tool. Please contact one of the developers if you would like\nto feature a presentation about GatorGrader at your technical conference. The\nfollowing list includes some of our team\'s recent presentations:\n\n- [A Hands-on Guide to Teaching Programming with GitHub, Travis CI, and Python](https://speakerdeck.com/gkapfham/a-hands-on-guide-to-teaching-programming-with-github-travis-ci-and-python) <br> *at PyOhio 2018*\n- [Using GitHub, Travis CI, and Python to Introduce Collaborative Software Development](https://speakerdeck.com/gkapfham/using-github-travis-ci-and-python-to-introduce-collaborative-software-development) <br> *at PyCon Education Summit 2018*\n- [Using Python, Travis CI, and GitHub to Effectively Teach Programming](https://speakerdeck.com/gkapfham/using-python-travis-ci-and-github-to-effectively-teach-programming) <br> *at PyGotham 2018*\n\n## Contributing\n\nAre you interested in contributing to\n[GatorGrader](https://github.com/GatorEducator/gatorgrader),\n[GatorGradle](https://github.com/GatorEducator/gatorgradle), or any of the\nsample assignments (e.g.,\n[Java](https://github.com/GatorEducator/java-assigment-starter),\n[LaTeX](https://github.com/GatorEducator/latex-assignment-starter), or [HTML\nwith CSS](https://github.com/GatorEducator/html-css-assignment-starter))? Great,\nbecause we appreciate the involvement of new contributors! Before you raise an\nissue or start to make a contribution to GatorGrader\'s repository, we ask that\nyou review the project\'s [code of conduct](CODE_OF_CONDUCT.md) and the\n[contribution guidelines](CONTRIBUTING.md).\n\n## Contributors\n\nThanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore -->\n<table>\n  <tr>\n    <td align="center"><a href="https://www.gregorykapfhammer.com"><img src="https://avatars2.githubusercontent.com/u/926029?v=4" width="64px;" alt="Gregory M. Kapfhammer"/><br /><sub><b>Gregory M. Kapfhammer</b></sub></a><br /><a href="#talk-gkapfham" title="Talks">📢</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=gkapfham" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=gkapfham" title="Documentation">📖</a> <a href="#design-gkapfham" title="Design">🎨</a> <a href="#infra-gkapfham" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=gkapfham" title="Tests">⚠️</a></td>\n    <td align="center"><a href="https://saejinmh.com"><img src="https://avatars1.githubusercontent.com/u/5274499?v=4" width="64px;" alt="Saejin Mahlau-Heinert"/><br /><sub><b>Saejin Mahlau-Heinert</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=Michionlion" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=Michionlion" title="Documentation">📖</a> <a href="#infra-Michionlion" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="#review-Michionlion" title="Reviewed Pull Requests">👀</a></td>\n    <td align="center"><a href="https://github.com/dubswalker"><img src="https://avatars2.githubusercontent.com/u/37150088?v=4" width="64px;" alt="Christian Walker"/><br /><sub><b>Christian Walker</b></sub></a><br /><a href="#content-dubswalker" title="Content">🖋</a></td>\n    <td align="center"><a href="https://github.com/everitt-andrew"><img src="https://avatars3.githubusercontent.com/u/31443695?v=4" width="64px;" alt="Andrew Everitt"/><br /><sub><b>Andrew Everitt</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=everitt-andrew" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=everitt-andrew" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://www.christianlussier.com"><img src="https://avatars2.githubusercontent.com/u/32375724?v=4" width="64px;" alt="Christian Lussier"/><br /><sub><b>Christian Lussier</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=lussierc" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=lussierc" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://www.simon-burrows.com"><img src="https://avatars2.githubusercontent.com/u/25254767?v=4" width="64px;" alt="Simon Burrows"/><br /><sub><b>Simon Burrows</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=burrowss" title="Code">💻</a></td>\n    <td align="center"><a href="https://www.austinbristol.com/"><img src="https://avatars1.githubusercontent.com/u/19804014?v=4" width="64px;" alt="Austin Bristol"/><br /><sub><b>Austin Bristol</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=bristola" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/JattMones"><img src="https://avatars0.githubusercontent.com/u/22432176?v=4" width="64px;" alt="Matt"/><br /><sub><b>Matt</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=JattMones" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=JattMones" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/cmiller365"><img src="https://avatars3.githubusercontent.com/u/27263493?v=4" width="64px;" alt="Christopher Miller"/><br /><sub><b>Christopher Miller</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=cmiller365" title="Code">💻</a> <a href="#design-cmiller365" title="Design">🎨</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=cmiller365" title="Documentation">📖</a></td>\n    <td align="center"><a href="http://spencerhuang.netlify.com"><img src="https://avatars0.githubusercontent.com/u/31478964?v=4" width="64px;" alt="Spencer Huang"/><br /><sub><b>Spencer Huang</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=huangs1" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=huangs1" title="Documentation">📖</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="https://github.com/ilikerustoo"><img src="https://avatars3.githubusercontent.com/u/25516043?v=4" width="64px;" alt="Mohammad Khan"/><br /><sub><b>Mohammad Khan</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=ilikerustoo" title="Code">💻</a></td>\n    <td align="center"><a href="http://www.shafferz.com"><img src="https://avatars1.githubusercontent.com/u/26298864?v=4" width="64px;" alt="Zachary Shaffer"/><br /><sub><b>Zachary Shaffer</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=shafferz" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=shafferz" title="Documentation">📖</a></td>\n    <td align="center"><a href="http://alexander.yarkosky.xyz"><img src="https://avatars1.githubusercontent.com/u/36210455?v=4" width="64px;" alt="Alexander Yarkosky"/><br /><sub><b>Alexander Yarkosky</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/issues?q=author%3AAlex-Yarkosky" title="Bug reports">🐛</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=Alex-Yarkosky" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/thomad74"><img src="https://avatars1.githubusercontent.com/u/31478969?v=4" width="64px;" alt="Dillon"/><br /><sub><b>Dillon</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=thomad74" title="Documentation">📖</a></td>\n    <td align="center"><a href="http://zacharyleonardo.com"><img src="https://avatars2.githubusercontent.com/u/35816642?v=4" width="64px;" alt="Zachary Leonardo"/><br /><sub><b>Zachary Leonardo</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=leonardoz15" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/mendezjw"><img src="https://avatars2.githubusercontent.com/u/23535739?v=4" width="64px;" alt="Jonathan W. Mendez"/><br /><sub><b>Jonathan W. Mendez</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=mendezjw" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=mendezjw" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/lylet-AC"><img src="https://avatars3.githubusercontent.com/u/31486141?v=4" width="64px;" alt="Tyler Lyle"/><br /><sub><b>Tyler Lyle</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=lylet-AC" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/finneyj2"><img src="https://avatars3.githubusercontent.com/u/31444681?v=4" width="64px;" alt="finneyj2"/><br /><sub><b>finneyj2</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=finneyj2" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=finneyj2" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/schultzh"><img src="https://avatars0.githubusercontent.com/u/42979565?v=4" width="64px;" alt="schultzh"/><br /><sub><b>schultzh</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/issues?q=author%3Aschultzh" title="Bug reports">🐛</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=schultzh" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=schultzh" title="Documentation">📖</a> <a href="#review-schultzh" title="Reviewed Pull Requests">👀</a></td>\n    <td align="center"><a href="https://github.com/alexheinle"><img src="https://avatars3.githubusercontent.com/u/35603755?v=4" width="64px;" alt="alexheinle"/><br /><sub><b>alexheinle</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/issues?q=author%3Aalexheinle" title="Bug reports">🐛</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=alexheinle" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=alexheinle" title="Documentation">📖</a> <a href="#review-alexheinle" title="Reviewed Pull Requests">👀</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="https://github.com/ZachAndrews98"><img src="https://avatars1.githubusercontent.com/u/15204124?v=4" width="64px;" alt="Zachary Andrews"/><br /><sub><b>Zachary Andrews</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=ZachAndrews98" title="Code">💻</a> <a href="#design-ZachAndrews98" title="Design">🎨</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=ZachAndrews98" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/toccinAC"><img src="https://avatars2.githubusercontent.com/u/31412566?v=4" width="64px;" alt="Nicholas Tocci"/><br /><sub><b>Nicholas Tocci</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=toccinAC" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/hodevin"><img src="https://avatars2.githubusercontent.com/u/31478952?v=4" width="64px;" alt="Devin Ho"/><br /><sub><b>Devin Ho</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=hodevin" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/baldeosinghm"><img src="https://avatars0.githubusercontent.com/u/42876742?v=4" width="64px;" alt="Matthew Baldeosingh"/><br /><sub><b>Matthew Baldeosingh</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=baldeosinghm" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://durchburch.xyz"><img src="https://avatars2.githubusercontent.com/u/31478922?v=4" width="64px;" alt="Jordan Durci"/><br /><sub><b>Jordan Durci</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=durcij" title="Code">💻</a></td>\n    <td align="center"><a href="https://www.linkedin.com/in/karol-vargas-a9a925b8/"><img src="https://avatars0.githubusercontent.com/u/31486084?v=4" width="64px;" alt="Karol Vargas"/><br /><sub><b>Karol Vargas</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=karolvargas" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/cerdamejiaj"><img src="https://avatars3.githubusercontent.com/u/25254696?v=4" width="64px;" alt="Jerfenson Cerda Mejia"/><br /><sub><b>Jerfenson Cerda Mejia</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=cerdamejiaj" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=cerdamejiaj" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/ohnoanarrow"><img src="https://avatars0.githubusercontent.com/u/22673907?v=4" width="64px;" alt="Tara Douglass"/><br /><sub><b>Tara Douglass</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=ohnoanarrow" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=ohnoanarrow" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/ALEXANDERB82"><img src="https://avatars0.githubusercontent.com/u/31444387?v=4" width="64px;" alt="Alexander Butler"/><br /><sub><b>Alexander Butler</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=ALEXANDERB82" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/corlettim"><img src="https://avatars3.githubusercontent.com/u/35552969?v=4" width="64px;" alt="corlettim"/><br /><sub><b>corlettim</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/issues?q=author%3Acorlettim" title="Bug reports">🐛</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=corlettim" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=corlettim" title="Documentation">📖</a> <a href="#review-corlettim" title="Reviewed Pull Requests">👀</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="https://github.com/quigley-c"><img src="https://avatars1.githubusercontent.com/u/35495466?v=4" width="64px;" alt="Carson Quigley"/><br /><sub><b>Carson Quigley</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=quigley-c" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/yeej2"><img src="https://avatars1.githubusercontent.com/u/22895281?v=4" width="64px;" alt="Joshua Yee"/><br /><sub><b>Joshua Yee</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=yeej2" title="Code">💻</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=yeej2" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://github.com/MaddyKapfhammer"><img src="https://avatars1.githubusercontent.com/u/23369060?v=4" width="64px;" alt="Madelyn Kapfhammer"/><br /><sub><b>Madelyn Kapfhammer</b></sub></a><br /><a href="https://github.com/GatorEducator/gatorgrader/commits?author=MaddyKapfhammer" title="Documentation">📖</a> <a href="#infra-MaddyKapfhammer" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/GatorEducator/gatorgrader/commits?author=MaddyKapfhammer" title="Tests">⚠️</a></td>\n  </tr>\n</table>\n\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the\n[all-contributors](https://github.com/all-contributors/all-contributors)\nspecification. Contributions of any kind are welcome!\n',
    'author': 'Gregory Kapfhammer',
    'author_email': 'gkapfham@allegheny.edu',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/GatorEducator/gatorgrader',
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
