import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `CfnConnector`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export interface CfnConnectorProps {
    /**
     * `AWS::KafkaConnect::Connector.Capacity`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-capacity
     */
    readonly capacity: CfnConnector.CapacityProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorconfiguration
     */
    readonly connectorConfiguration: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorname
     */
    readonly connectorName: string;
    /**
     * `AWS::KafkaConnect::Connector.KafkaCluster`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkacluster
     */
    readonly kafkaCluster: CfnConnector.KafkaClusterProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaClusterClientAuthentication`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterclientauthentication
     */
    readonly kafkaClusterClientAuthentication: CfnConnector.KafkaClusterClientAuthenticationProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaClusterEncryptionInTransit`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterencryptionintransit
     */
    readonly kafkaClusterEncryptionInTransit: CfnConnector.KafkaClusterEncryptionInTransitProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaConnectVersion`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaconnectversion
     */
    readonly kafkaConnectVersion: string;
    /**
     * `AWS::KafkaConnect::Connector.Plugins`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-plugins
     */
    readonly plugins: Array<CfnConnector.PluginProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ServiceExecutionRoleArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-serviceexecutionrolearn
     */
    readonly serviceExecutionRoleArn: string;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorDescription`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectordescription
     */
    readonly connectorDescription?: string;
    /**
     * `AWS::KafkaConnect::Connector.LogDelivery`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-logdelivery
     */
    readonly logDelivery?: CfnConnector.LogDeliveryProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.WorkerConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-workerconfiguration
     */
    readonly workerConfiguration?: CfnConnector.WorkerConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::KafkaConnect::Connector`
 *
 *
 *
 * @cloudformationResource AWS::KafkaConnect::Connector
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html
 */
export declare class CfnConnector extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KafkaConnect::Connector";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConnector;
    /**
     *
     * @cloudformationAttribute ConnectorArn
     */
    readonly attrConnectorArn: string;
    /**
     * `AWS::KafkaConnect::Connector.Capacity`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-capacity
     */
    capacity: CfnConnector.CapacityProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorconfiguration
     */
    connectorConfiguration: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorname
     */
    connectorName: string;
    /**
     * `AWS::KafkaConnect::Connector.KafkaCluster`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkacluster
     */
    kafkaCluster: CfnConnector.KafkaClusterProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaClusterClientAuthentication`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterclientauthentication
     */
    kafkaClusterClientAuthentication: CfnConnector.KafkaClusterClientAuthenticationProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaClusterEncryptionInTransit`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterencryptionintransit
     */
    kafkaClusterEncryptionInTransit: CfnConnector.KafkaClusterEncryptionInTransitProperty | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.KafkaConnectVersion`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaconnectversion
     */
    kafkaConnectVersion: string;
    /**
     * `AWS::KafkaConnect::Connector.Plugins`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-plugins
     */
    plugins: Array<CfnConnector.PluginProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::KafkaConnect::Connector.ServiceExecutionRoleArn`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-serviceexecutionrolearn
     */
    serviceExecutionRoleArn: string;
    /**
     * `AWS::KafkaConnect::Connector.ConnectorDescription`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectordescription
     */
    connectorDescription: string | undefined;
    /**
     * `AWS::KafkaConnect::Connector.LogDelivery`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-logdelivery
     */
    logDelivery: CfnConnector.LogDeliveryProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KafkaConnect::Connector.WorkerConfiguration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-workerconfiguration
     */
    workerConfiguration: CfnConnector.WorkerConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::KafkaConnect::Connector`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectorProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-apachekafkacluster.html
     */
    interface ApacheKafkaClusterProperty {
        /**
         * `CfnConnector.ApacheKafkaClusterProperty.BootstrapServers`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-apachekafkacluster.html#cfn-kafkaconnect-connector-apachekafkacluster-bootstrapservers
         */
        readonly bootstrapServers: string;
        /**
         * `CfnConnector.ApacheKafkaClusterProperty.Vpc`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-apachekafkacluster.html#cfn-kafkaconnect-connector-apachekafkacluster-vpc
         */
        readonly vpc: CfnConnector.VpcProperty | cdk.IResolvable;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html
     */
    interface AutoScalingProperty {
        /**
         * `CfnConnector.AutoScalingProperty.MaxWorkerCount`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html#cfn-kafkaconnect-connector-autoscaling-maxworkercount
         */
        readonly maxWorkerCount: number;
        /**
         * `CfnConnector.AutoScalingProperty.McuCount`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html#cfn-kafkaconnect-connector-autoscaling-mcucount
         */
        readonly mcuCount: number;
        /**
         * `CfnConnector.AutoScalingProperty.MinWorkerCount`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html#cfn-kafkaconnect-connector-autoscaling-minworkercount
         */
        readonly minWorkerCount: number;
        /**
         * `CfnConnector.AutoScalingProperty.ScaleInPolicy`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html#cfn-kafkaconnect-connector-autoscaling-scaleinpolicy
         */
        readonly scaleInPolicy: CfnConnector.ScaleInPolicyProperty | cdk.IResolvable;
        /**
         * `CfnConnector.AutoScalingProperty.ScaleOutPolicy`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-autoscaling.html#cfn-kafkaconnect-connector-autoscaling-scaleoutpolicy
         */
        readonly scaleOutPolicy: CfnConnector.ScaleOutPolicyProperty | cdk.IResolvable;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-capacity.html
     */
    interface CapacityProperty {
        /**
         * `CfnConnector.CapacityProperty.AutoScaling`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-capacity.html#cfn-kafkaconnect-connector-capacity-autoscaling
         */
        readonly autoScaling?: CfnConnector.AutoScalingProperty | cdk.IResolvable;
        /**
         * `CfnConnector.CapacityProperty.ProvisionedCapacity`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-capacity.html#cfn-kafkaconnect-connector-capacity-provisionedcapacity
         */
        readonly provisionedCapacity?: CfnConnector.ProvisionedCapacityProperty | cdk.IResolvable;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-cloudwatchlogslogdelivery.html
     */
    interface CloudWatchLogsLogDeliveryProperty {
        /**
         * `CfnConnector.CloudWatchLogsLogDeliveryProperty.Enabled`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-cloudwatchlogslogdelivery.html#cfn-kafkaconnect-connector-cloudwatchlogslogdelivery-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnConnector.CloudWatchLogsLogDeliveryProperty.LogGroup`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-cloudwatchlogslogdelivery.html#cfn-kafkaconnect-connector-cloudwatchlogslogdelivery-loggroup
         */
        readonly logGroup?: string;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-customplugin.html
     */
    interface CustomPluginProperty {
        /**
         * `CfnConnector.CustomPluginProperty.CustomPluginArn`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-customplugin.html#cfn-kafkaconnect-connector-customplugin-custompluginarn
         */
        readonly customPluginArn: string;
        /**
         * `CfnConnector.CustomPluginProperty.Revision`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-customplugin.html#cfn-kafkaconnect-connector-customplugin-revision
         */
        readonly revision: number;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-firehoselogdelivery.html
     */
    interface FirehoseLogDeliveryProperty {
        /**
         * `CfnConnector.FirehoseLogDeliveryProperty.DeliveryStream`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-firehoselogdelivery.html#cfn-kafkaconnect-connector-firehoselogdelivery-deliverystream
         */
        readonly deliveryStream?: string;
        /**
         * `CfnConnector.FirehoseLogDeliveryProperty.Enabled`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-firehoselogdelivery.html#cfn-kafkaconnect-connector-firehoselogdelivery-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkacluster.html
     */
    interface KafkaClusterProperty {
        /**
         * `CfnConnector.KafkaClusterProperty.ApacheKafkaCluster`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkacluster.html#cfn-kafkaconnect-connector-kafkacluster-apachekafkacluster
         */
        readonly apacheKafkaCluster: CfnConnector.ApacheKafkaClusterProperty | cdk.IResolvable;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkaclusterclientauthentication.html
     */
    interface KafkaClusterClientAuthenticationProperty {
        /**
         * `CfnConnector.KafkaClusterClientAuthenticationProperty.AuthenticationType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkaclusterclientauthentication.html#cfn-kafkaconnect-connector-kafkaclusterclientauthentication-authenticationtype
         */
        readonly authenticationType: string;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkaclusterencryptionintransit.html
     */
    interface KafkaClusterEncryptionInTransitProperty {
        /**
         * `CfnConnector.KafkaClusterEncryptionInTransitProperty.EncryptionType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-kafkaclusterencryptionintransit.html#cfn-kafkaconnect-connector-kafkaclusterencryptionintransit-encryptiontype
         */
        readonly encryptionType: string;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-logdelivery.html
     */
    interface LogDeliveryProperty {
        /**
         * `CfnConnector.LogDeliveryProperty.WorkerLogDelivery`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-logdelivery.html#cfn-kafkaconnect-connector-logdelivery-workerlogdelivery
         */
        readonly workerLogDelivery: CfnConnector.WorkerLogDeliveryProperty | cdk.IResolvable;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-plugin.html
     */
    interface PluginProperty {
        /**
         * `CfnConnector.PluginProperty.CustomPlugin`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-plugin.html#cfn-kafkaconnect-connector-plugin-customplugin
         */
        readonly customPlugin: CfnConnector.CustomPluginProperty | cdk.IResolvable;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-provisionedcapacity.html
     */
    interface ProvisionedCapacityProperty {
        /**
         * `CfnConnector.ProvisionedCapacityProperty.McuCount`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-provisionedcapacity.html#cfn-kafkaconnect-connector-provisionedcapacity-mcucount
         */
        readonly mcuCount?: number;
        /**
         * `CfnConnector.ProvisionedCapacityProperty.WorkerCount`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-provisionedcapacity.html#cfn-kafkaconnect-connector-provisionedcapacity-workercount
         */
        readonly workerCount: number;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-s3logdelivery.html
     */
    interface S3LogDeliveryProperty {
        /**
         * `CfnConnector.S3LogDeliveryProperty.Bucket`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-s3logdelivery.html#cfn-kafkaconnect-connector-s3logdelivery-bucket
         */
        readonly bucket?: string;
        /**
         * `CfnConnector.S3LogDeliveryProperty.Enabled`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-s3logdelivery.html#cfn-kafkaconnect-connector-s3logdelivery-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnConnector.S3LogDeliveryProperty.Prefix`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-s3logdelivery.html#cfn-kafkaconnect-connector-s3logdelivery-prefix
         */
        readonly prefix?: string;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-scaleinpolicy.html
     */
    interface ScaleInPolicyProperty {
        /**
         * `CfnConnector.ScaleInPolicyProperty.CpuUtilizationPercentage`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-scaleinpolicy.html#cfn-kafkaconnect-connector-scaleinpolicy-cpuutilizationpercentage
         */
        readonly cpuUtilizationPercentage: number;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-scaleoutpolicy.html
     */
    interface ScaleOutPolicyProperty {
        /**
         * `CfnConnector.ScaleOutPolicyProperty.CpuUtilizationPercentage`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-scaleoutpolicy.html#cfn-kafkaconnect-connector-scaleoutpolicy-cpuutilizationpercentage
         */
        readonly cpuUtilizationPercentage: number;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-vpc.html
     */
    interface VpcProperty {
        /**
         * `CfnConnector.VpcProperty.SecurityGroups`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-vpc.html#cfn-kafkaconnect-connector-vpc-securitygroups
         */
        readonly securityGroups: string[];
        /**
         * `CfnConnector.VpcProperty.Subnets`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-vpc.html#cfn-kafkaconnect-connector-vpc-subnets
         */
        readonly subnets: string[];
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerconfiguration.html
     */
    interface WorkerConfigurationProperty {
        /**
         * `CfnConnector.WorkerConfigurationProperty.Revision`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerconfiguration.html#cfn-kafkaconnect-connector-workerconfiguration-revision
         */
        readonly revision: number;
        /**
         * `CfnConnector.WorkerConfigurationProperty.WorkerConfigurationArn`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerconfiguration.html#cfn-kafkaconnect-connector-workerconfiguration-workerconfigurationarn
         */
        readonly workerConfigurationArn: string;
    }
}
export declare namespace CfnConnector {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerlogdelivery.html
     */
    interface WorkerLogDeliveryProperty {
        /**
         * `CfnConnector.WorkerLogDeliveryProperty.CloudWatchLogs`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerlogdelivery.html#cfn-kafkaconnect-connector-workerlogdelivery-cloudwatchlogs
         */
        readonly cloudWatchLogs?: CfnConnector.CloudWatchLogsLogDeliveryProperty | cdk.IResolvable;
        /**
         * `CfnConnector.WorkerLogDeliveryProperty.Firehose`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerlogdelivery.html#cfn-kafkaconnect-connector-workerlogdelivery-firehose
         */
        readonly firehose?: CfnConnector.FirehoseLogDeliveryProperty | cdk.IResolvable;
        /**
         * `CfnConnector.WorkerLogDeliveryProperty.S3`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kafkaconnect-connector-workerlogdelivery.html#cfn-kafkaconnect-connector-workerlogdelivery-s3
         */
        readonly s3?: CfnConnector.S3LogDeliveryProperty | cdk.IResolvable;
    }
}
