#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const cdk_comprehend_s3olap_1 = require("../../cdk-comprehend-s3olap");
class TypescriptStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const s3olab = new cdk_comprehend_s3olap_1.ComprehendS3olab(this, 'PiiDemo', {
            adminRedactionLambdaConfig: {
                maskCharacter: ' ',
                unsupportedFileHandling: 'PASS',
            },
            billingRedactionLambdaConfig: {
                maskMode: 'REPLACE_WITH_PII_ENTITY_TYPE',
                piiEntityTypes: 'AGE,DRIVER_ID,IP_ADDRESS,MAC_ADDRESS,PASSPORT_NUMBER,PASSWORD,SSN',
            },
            cusrtSupportRedactionLambdaConfig: {
                maskMode: 'REPLACE_WITH_PII_ENTITY_TYPE',
                piiEntityTypes: ' BANK_ACCOUNT_NUMBER,BANK_ROUTING,CREDIT_DEBIT_CVV,CREDIT_DEBIT_EXPIRY,CREDIT_DEBIT_NUMBER,SSN',
            },
        });
        new cdk.CfnOutput(this, 'OPiiAccessControlLambdaArn', { value: s3olab.piiAccessConrtolLambdaArn });
        new cdk.CfnOutput(this, 'OAdminLambdaArn', { value: s3olab.adminLambdaArn });
        new cdk.CfnOutput(this, 'OBillingLambdaArn', { value: s3olab.billingLambdaArn });
        new cdk.CfnOutput(this, 'OCustomerSupportLambdaArn', { value: s3olab.customerSupportLambdaArn });
        new cdk.CfnOutput(this, 'OS3ObjectLambdaGeneralArn', { value: s3olab.s3objectLambdaAccessControlArn });
        new cdk.CfnOutput(this, 'OS3ObjectLambdaAdminArn', { value: s3olab.s3objectLambdaAdminArn });
        new cdk.CfnOutput(this, 'OS3ObjectLambdaBillingArn', { value: s3olab.s3objectLambdaBillingArn });
        new cdk.CfnOutput(this, 'OS3ObjectLambdaCustomerSupportArn', { value: s3olab.customerSupportLambdaArn });
    }
}
const app = new cdk.App();
new TypescriptStack(app, 'TypescriptStack', {
    stackName: 'Comprehend-S3olap',
});
//# sourceMappingURL=data:application/json;base64,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