import { Construct } from 'constructs';
import { AccessConrtolLambdaProps, RedactionLambdaProps } from './comprehend-lambdas';
import { GeneralRoleProps, AdminRoleProps, BillingRoleProps, CustSupportRoleProps } from './iam-roles';
export declare enum IamRoleName {
    GENERAL = "General",
    ADMIN = "Admin",
    BILLING = "Billing",
    CUST_SUPPORT = "CustSupport"
}
export interface S3AccessPointNames {
    /**
     * The name of the S3 aceess point for the general role in the access control case.
     *
     * @default 'accessctl-s3-ap-survey-results-unknown-pii'
     */
    readonly general: string;
    /**
     * The name of the S3 aceess point for the admin role in the redaction case.
     *
     * @default 'admin-s3-access-point-call-transcripts-known-pii'
     */
    readonly admin: string;
    /**
     * The name of the S3 aceess point for the billing role in the redaction case.
     *
     * @default 'bill-s3-access-point-call-transcripts-known-pii'
     */
    readonly billing: string;
    /**
    * The name of the S3 aceess point for the customer support role in the redaction case.
    *
    * @default 'cs-s3-access-point-call-transcripts-known-pii'
    */
    readonly customerSupport: string;
}
export interface ComprehendS3olabProps {
    /**
     * The prefix attached to the name of the S3 bucket where you are going to explore the S3 Object Lambda pertaining to the access control case.
     *
     * @default 6 random words
     */
    readonly surveyBucketPrefix?: string;
    /**
     * The prefix attached to the name of the S3 bucket where you are going to explore the S3 Object Lambda pertaining to the redaction case.
     *
     * @default 6 random words
     */
    readonly transcriptsBucketPrefix?: string;
    /**
     * The names of the S3 access points for the access control case and redaction case.
     */
    readonly s3AccessPointNames?: S3AccessPointNames;
    /**
     * The parameters needed for the `ComprehendPiiAccessControlS3ObjectLambda` function.
     *
     */
    readonly accessControlLambdaConfig?: AccessConrtolLambdaProps;
    /**
     * The parameters of the `ComprehendPiiRedactionS3ObjectLambda` function for the `AdminRole`.
     */
    readonly adminRedactionLambdaConfig?: RedactionLambdaProps;
    /**
     * The parameters of the `ComprehendPiiRedactionS3ObjectLambda` function for the `BillingRole`.
     */
    readonly billingRedactionLambdaConfig?: RedactionLambdaProps;
    /**
    * The parameters of the `ComprehendPiiRedactionS3ObjectLambda` function for the `CustSupportRole`.
    */
    readonly cusrtSupportRedactionLambdaConfig?: RedactionLambdaProps;
    /**
     * The manageable properties for the IAM role used to access the `survey-results.txt` data.
     */
    readonly generalRoleConfig?: GeneralRoleProps;
    /**
     * The manageable properties for the administrator IAM role in the redaction case.
     */
    readonly adminRoleConfig?: AdminRoleProps;
    /**
     * The manageable properties for the billing IAM role in the redaction case.
     */
    readonly billingRoleConfig?: BillingRoleProps;
    /**
     * The manageable properties for the customer support IAM role in the redaction case.
     */
    readonly custSupportRoleConfig?: CustSupportRoleProps;
    /**
     * For distinguish test and normal deployment.
     *
     * @default true
     */
    readonly generateRandomCharacters?: boolean;
    /**
     * The directory path where `files/access_control/*.txt` and `files/redaction/*.txt` will be put.
     *
     * DO NOT INCLUDE `/` in the end.
     *
     * @default __dirname
     */
    readonly exampleFileDir?: string;
}
/**
 * Creates the foundation necessary to deploy the S3 Object Lambda Acceess Control Use Case.
 */
export declare class ComprehendS3olab extends Construct {
    /**
     * The ARN of the S3 Object Lambda for access control.
     */
    readonly s3objectLambdaAccessControlArn: string;
    /**
     * The ARN of the S3 Object Lambda for the admin role in the redaction case.
     */
    readonly s3objectLambdaAdminArn: string;
    /**
     * The ARN of the S3 Object Lambda for the billing role in the redaction case.
     */
    readonly s3objectLambdaBillingArn: string;
    /**
     * The ARN of the S3 Object Lambda for the customer support role in the redaction case.
     */
    readonly s3objectLambdaCustomerSupportArn: string;
    /**
     * The ARN of the Lambda function combined with Amazon Comprehend for the general case.
     */
    readonly piiAccessConrtolLambdaArn: string;
    /**
     * The ARN of the Lambda function combined with Amazon Comprehend for thie administrator role in the redaction case.
     */
    readonly adminLambdaArn: string;
    /**
    * The ARN of the Lambda function combined with Amazon Comprehend for thie billing role in the redaction case.
    */
    readonly billingLambdaArn: string;
    /**
   * The ARN of the Lambda function combined with Amazon Comprehend for thie customer support role in the redaction case.
   */
    readonly customerSupportLambdaArn: string;
    constructor(scope: Construct, id: string, props: ComprehendS3olabProps);
    generateS3Prefix(length: number): string;
    /**
     * Creates a redaction Lambda function for a speicfic IAM role.
     *
     * @param roleName the name of the corresponding IAM role
     * @param serverlessLambdaConfig the corresponding parameter setting for the Amazon Comprehend.
     */
    private initializeRedactLambda;
    /**
     * Gets properties related to the IAM roles.
     *
     * @param roleName the name of the corresponding IAM role.
     * @param roleConfig the corresponding parameter setting for one of the IAM role.
     * @returns the property group.
     */
    private getIamRoleConfig;
    /**
     * Returns the policy name according to the IAM role.
     *
     * @param roleName the name of the corresponding IAM role.
     */
    private _getDefaultPolicyName;
    /**
     * Returns the corresponding name for the access point of the S3 Object Lambda according to the IAM role.
     *
     * @param roleName the name of the corresponding IAM role.
     */
    private _getObjectLambdaAccessPointName;
    /**
     * Returns the corresponding name for the IAM role.
     *
     * @param roleName the name of the corresponding IAM role.
     */
    private _getRoleName;
}
export interface LambdaArnCaptorResourceProps {
    /**
     * the name of the corresponding IAM role
     */
    readonly roleName: string;
    /**
     * The partial fixed name of the gemeral Lambda function created from the serverless application.
     */
    readonly partialLambdaName: string;
}
export declare class LambdaArnCaptorCustomResource extends Construct {
    /**
     * The ARN of the general Lambda function created from the serverless application.
     *
     * @see https://github.com/aws/aws-cdk/issues/8760
     */
    readonly lambdaArn: string;
    constructor(scope: Construct, id: string, props: LambdaArnCaptorResourceProps);
}
