# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mirror_tool', 'mirror_tool.gitlab']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=3.1.2',
 'jsonschema>=4.4.0',
 'requests>=2.27.1',
 'ruamel.yaml>=0.17.21']

entry_points = \
{'console_scripts': ['mirror-tool = mirror_tool.cmd:entrypoint']}

setup_kwargs = {
    'name': 'mirror-tool',
    'version': '0.4.0',
    'description': 'A tool for managing git mirrors.',
    'long_description': '# mirror-tool\n\nA tool for maintaining Git subtree mirrors.\n\n![GitHub Workflow Status (branch)](https://img.shields.io/github/workflow/status/rohanpm/mirror-tool/CI/main) ![PyPI](https://img.shields.io/pypi/v/mirror-tool) [![Docker Repository on Quay](https://quay.io/repository/rmcgover/mirror-tool/status "Docker Repository on Quay")](https://quay.io/repository/rmcgover/mirror-tool)\n\n<!--TOC-->\n\n- [mirror-tool](#mirror-tool)\n  - [Installation](#installation)\n  - [Usage](#usage)\n    - [`mirror-tool validate-config`](#mirror-tool-validate-config)\n    - [`mirror-tool update-local`](#mirror-tool-update-local)\n    - [`mirror-tool update`](#mirror-tool-update)\n    - [`mirror-tool promote`](#mirror-tool-promote)\n  - [Configuration](#configuration)\n    - [Jinja context](#jinja-context)\n  - [License](#license)\n\n<!--TOC-->\n\n## Installation\n\nInstall the `mirror-tool` package from PyPI.\n\n```\npip install mirror-tool\n```\n\n## Usage\n\n`mirror-tool` has the following subcommands. Please install the tool and\nrun with `--help` for complete documentation on the available commands and\noptions.\n\n### `mirror-tool validate-config`\n\nVerify that `.mirror-tool.yaml` in the current directory, or a specified\nconfiguration file, is valid.\n\nExits with a 0 exit code if and only if a valid config file was found.\n\n### `mirror-tool update-local`\n\nFor each mirror defined in the config file, create a subtree merge commit\nupdating that mirror.\n\nBy default, this will not create any commits if there are no changes to be made.\nIt can be forced to create a commit by using the `--allow-empty` argument.\n\n### `mirror-tool update`\n\nPerform the same updates as `update-local`, but also push the commit(s) to any\nconfigured remote targets.\n\nCurrently, GitLab is the only supported target. See the configuration reference\nbelow for more information about GitLab integration.\n\nWhen using this command to push to GitLab, it is recommended to run it from\nwithin a GitLab CI/CD pipeline. The command will use predefined environment\nvariables in the CI environment to determine how to connect to GitLab.\nIf used in other contexts, it will be necessary to explicitly set many\nenvironment variables.\n\n### `mirror-tool promote`\n\nFor any merge requests previously created by `update`, create additional\nmerge request(s) to promote the same changes to other branch(es) as defined\nin config.\n\nThis command can be used to implement a multi-tiered deployment/update workflow,\nfor example:\n\n- Whenever mirrored repos change, create an MR updating them (via `mirror-tool update`), targeting `testing` branch.\n- Perform some pre- or post-merge testing on that MR by some means (outside the\n  scope of mirror-tool).\n- After the MR is submitted to `testing` branch, create a new MR promoting the\n  same changes to `stable` branch (via `mirror-tool promote`).\n\nThe command only operates on changes previously created via\n`mirror-tool update`.\n\nLike `update`, GitLab is currently the only supported target for this command.\n\n## Configuration\n\n`mirror-tool` requires a configuration file. By convention, this should\nbe placed at `.mirror-tool.yaml` at the top level of your superproject\nrepository.\n\nThe following example demonstrates the available configuration options.\n\n```yaml\n# Define the repositories to mirror.\nmirror:\n- url: https://github.com/org/repo1\n  ref: refs/heads/master\n  dir: repo1\n\n- url: https://github.com/org/repo2\n  ref: refs/heads/main\n  dir: repo2\n\n# Git configuration to be applied when mirror-tool creates commits.\n# Any arbitrary config can be set, but this is most commonly needed\n# just to set the name/email on merge commits.\ngit_config:\n  user.name: "mirror-tool"\n  user.email: "noreply@example.com"\n\n# Message for generated commits.\n# This is a Jinja template.\ncommitmsg: |-\n  Merge {{commits[0].revision_abbrev}} to {{mirror.dir}}\n\n  {{commits|length}} commit(s) are being merged.\n\n  {% for commit in commits %}\n  - {{ commit.revision_abbrev }} {{ commit.subject }}\n  {%- endfor %}\n\n# Configures the GitLab merge request integration.\ngitlab_merge:\n  # If enabled, the update command will create/update a GitLab\n  # merge request whenever a mirrored repo is updated.\n  enabled: true\n\n  # Token used to authenticate with GitLab.\n  #\n  # Currently, this token must always be of the format \'$SOME_VARIABLE\',\n  # and the token will be accessed from that environment variable at\n  # runtime. If running from a GitLab CI/CD pipeline, this should be\n  # set as a protected CI variable.\n  token: $GITLAB_MIRROR_TOKEN\n\n  # Source branch used for merge requests.\n  # WARNING: update will do force pushes to this branch!\n  src: latest\n\n  # Target branch used for merge requests.\n  # The following example supposes that the target branch is used\n  # to perform some kind of deployment.\n  dest: deploy\n\n  # Title for the merge request.\n  # This is a Jinja template.\n  title: "Deploy changes [{{ datetime_day }}]"\n\n  # Any desired labels to add onto the merge request.\n  labels:\n  - deploy\n\n  # Description for the merge request.\n  # This is a Jinja template.\n  description: |-\n    Automated update of dependencies generated by\n    {{ env.CI_JOB_URL }}.\n\n    Submitting this merge request will trigger a deployment.\n\n  # Comment(s) to be added when a merge request is created or updated.\n  # Can be used to ping reviewers.\n  # If omitted, comments won\'t be added.\n  # These are Jinja templates.\n  comment:\n    create: "@some-team: please review and submit."\n    update: "@some-team: merge request has been updated, please re-review."\n\n# Configures GitLab promotion between branches.\n# A list of (src, dest) branch pairs with other config.\n# Most config has the same meaning as in gitlab_merge.\ngitlab_promote:\n- src: stage\n  dest: prod\n  title: "Promote from stage to prod [{{datetime_day}}]"\n  token: $GITLAB_MIRROR_TOKEN\n  labels:\n  - promote\n  description: |-\n    Automated promotion of {{ src_mr.web_url }} to prod.\n```\n\n### Jinja context\n\nSome configuration elements are described above as\n[Jinja templates](https://jinja.palletsprojects.com/en/3.0.x/templates/).\nThe following variables are available for use within the templates:\n\n#### `env` (dict)\n\n* All environment variables at the time `mirror-tool` is invoked.\n* If running in GitLab CI/CD, can be used to access the\n  [CI/CD variables](https://docs.gitlab.com/ee/ci/variables/predefined_variables.html).\n* Example: `{{ env.CI_JOB_URL }}` => `https://gitlab.example.com/someteam/somerepo/-/jobs/6366493`\n\n#### `datetime_iso8601` (str)\n\n* Current UTC date/time, in ISO8601 format, with seconds precision.\n* Example: `2022-05-10T05:28:26Z`\n\n#### `datetime_minute` (str)\n\n* Current UTC date/time, with minutes precision.\n* Example: `2022-05-10 05:28`\n\n#### `datetime_day` (str)\n\n* Current UTC date.\n* Example: `2022-05-10`\n\n#### `datetime_week` (str)\n\n* Current UTC year and week of year.\n* Example: `2022wk19` for week 19 of 2022.\n\n#### `updates` (list[UpdateInfo]) *(update only)*\n\nIn most Jinja contexts for the `update` and `update-local` commands,\nthis is a list of objects of the following form:\n\n```python\nUpdateInfo(\n  mirror=Mirror(\n    url="https://github.com/rohanpm/mirror-tool",\n    ref="refs/heads/main",\n    dir="mirror-tool"\n  ),\n\n  # Objects representing commits included in the update, starting\n  # with the most recent.\n  #\n  # If there is a large number of commits being handled, some may be\n  # elided from this list.\n  commits=[\n    Commit(\n      revision="472b7797518b963f8ab381c39858c18b2b784c2e",\n      revision_abbrev="472b779",\n      author_name="Rohan McGovern",\n      author_email="rohan@mcgovern.id.au",\n      author_email_local="rohan",\n      author_datetime=datetime.datetime(2022, 5, 26, 0, 24, 37),\n      committer_name="Rohan McGovern",\n      committer_email="rohan@mcgovern.id.au",\n      committer_email_local="rohan",\n      committer_datetime=datetime.datetime(2022, 5, 26, 0, 37, 37),\n      subject="Raise test coverage to 100%",\n      body="Do this, that and some other\\nthings as well.",\n    ),\n    ...,\n  ],\n\n  # Total number of commits in the update (may be more than len(commits)\n  # if some were elided).\n  commit_count=4,\n\n  # Number of commits omitted from \'commits\' object.\n  # For example, if an update pulled 200 commits, only the most recent 20\n  # may appear in \'commits\', and this value will be set to 180.\n  commit_elided_count=0,\n)\n```\n\nIn the Jinja context for `commitmsg`, as only a single update is being processed,\n`updates` is not defined.  Instead, all of the fields shown above under `UpdateInfo`\nare directly included onto the context.\n\n#### `src_mr` (dict) *(promote only)*\n\nA merge request object which is now being promoted; i.e. a merge request\npreviously created by mirror-tool and submitted to one branch, and now\nbeing promoted by mirror-tool to another branch.\n\nThe format of this object can be found in the\n[GitLab API docs](https://docs.gitlab.com/ee/api/merge_requests.html).\n\nOnly available for the `promote` command.\n\n## License\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n',
    'author': 'Rohan McGovern',
    'author_email': 'rohan@mcgovern.id.au',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/rohanpm/mirror-tool',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4',
}


setup(**setup_kwargs)
