# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['odecloud', 'odecloud.api']

package_data = \
{'': ['*']}

install_requires = \
['certifi==2021.10.8',
 'charset-normalizer==2.0.9',
 'idna==3.3',
 'requests==2.26.0',
 'urllib3==1.26.7']

setup_kwargs = {
    'name': 'odecloud',
    'version': '0.13.6',
    'description': 'Python client for https://server.odecloud.app',
    'long_description': "# python_odecloud\n\n\n\n## Getting started\n\n1. Instantiate your connection to OdeCloud's API:<br>\n\n- If you don't know your client credentials:<br>\n    ```py\n    api = Api('https://server.odecloud.app/api/v1') # All API calls will be made to this domain.\n    api.login('your-email@here.com', 'your_password')\n    ```\n\n- If you already know your client credentials:<br>\n    ```py\n    api = Api(\n        base_url='https://server.odecloud.app/api/v1', # All API calls will be made to this domain\n        client_key='YOUR CLIENT KEY',\n        client_secret='YOUR CLIENT SECRET',\n        user_id='YOUR USER_ID'\n    )\n    ```\n\n2. Now, any calls can be made to OdeCloud's API. Examples below:\n    ```py\n    api.comments.get(createdBy=random_user_id) # GET /api/v1/comments?createdBy=random_user_id/\n    api.comments.post(data=expected_payload) # POST /api/v1/comments/\n    api.comments(random_comment_id).patch(data=expected_payload) # PATCH /api/v1/comments/random_comment_id/\n    api.comments(random_comment_id).delete() # DELETE /api/v1/comments/random_comment_id/\n    ```\nHappy coding!\n\n## Add your files\n\n- [ ] [Create](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/user/project/repository/web_editor.html#create-a-file) or [upload](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/user/project/repository/web_editor.html#upload-a-file) files\n- [ ] [Add files using the command line](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/gitlab-basics/add-file.html#add-a-file-using-the-command-line) or push an existing Git repository with the following command:\n\n```\ncd existing_repo\ngit remote add origin https://gitlab.com/odetech/python_odecloud.git\ngit branch -M main\ngit push -uf origin main\n```\n\n## Integrate with your tools\n\n- [ ] [Set up project integrations](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://gitlab.com/odetech/python_odecloud/-/settings/integrations)\n\n## Collaborate with your team\n\n- [ ] [Invite team members and collaborators](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/user/project/members/)\n- [ ] [Create a new merge request](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/user/project/merge_requests/creating_merge_requests.html)\n- [ ] [Automatically close issues from merge requests](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/user/project/issues/managing_issues.html#closing-issues-automatically)\n- [ ] [Enable merge request approvals](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/user/project/merge_requests/approvals/)\n- [ ] [Automatically merge when pipeline succeeds](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/user/project/merge_requests/merge_when_pipeline_succeeds.html)\n\n## Test and Deploy\n\nUse the built-in continuous integration in GitLab.\n\n- [ ] [Get started with GitLab CI/CD](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/ci/quick_start/index.html)\n- [ ] [Analyze your code for known vulnerabilities with Static Application Security Testing(SAST)](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/user/application_security/sast/)\n- [ ] [Deploy to Kubernetes, Amazon EC2, or Amazon ECS using Auto Deploy](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/topics/autodevops/requirements.html)\n- [ ] [Use pull-based deployments for improved Kubernetes management](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/user/clusters/agent/)\n- [ ] [Set up protected environments](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://docs.gitlab.com/ee/ci/environments/protected_environments.html)\n\n***\n\n# Editing this README\n\nWhen you're ready to make this README your own, just edit this file and use the handy template below (or feel free to structure it however you want - this is just a starting point!).  Thank you to [makeareadme.com](https://gitlab.com/-/experiment/new_project_readme_content:2defa860865367f986f15ae3ee56d99f?https://www.makeareadme.com/) for this template.\n\n## Suggestions for a good README\nEvery project is different, so consider which of these sections apply to yours. The sections used in the template are suggestions for most open source projects. Also keep in mind that while a README can be too long and detailed, too long is better than too short. If you think your README is too long, consider utilizing another form of documentation rather than cutting out information.\n\n## Name\nChoose a self-explaining name for your project.\n\n## Description\nLet people know what your project can do specifically. Provide context and add a link to any reference visitors might be unfamiliar with. A list of Features or a Background subsection can also be added here. If there are alternatives to your project, this is a good place to list differentiating factors.\n\n## Badges\nOn some READMEs, you may see small images that convey metadata, such as whether or not all the tests are passing for the project. You can use Shields to add some to your README. Many services also have instructions for adding a badge.\n\n## Visuals\nDepending on what you are making, it can be a good idea to include screenshots or even a video (you'll frequently see GIFs rather than actual videos). Tools like ttygif can help, but check out Asciinema for a more sophisticated method.\n\n## Installation\nWithin a particular ecosystem, there may be a common way of installing things, such as using Yarn, NuGet, or Homebrew. However, consider the possibility that whoever is reading your README is a novice and would like more guidance. Listing specific steps helps remove ambiguity and gets people to using your project as quickly as possible. If it only runs in a specific context like a particular programming language version or operating system or has dependencies that have to be installed manually, also add a Requirements subsection.\n\n## Usage\nUse examples liberally, and show the expected output if you can. It's helpful to have inline the smallest example of usage that you can demonstrate, while providing links to more sophisticated examples if they are too long to reasonably include in the README.\n\n## Support\nTell people where they can go to for help. It can be any combination of an issue tracker, a chat room, an email address, etc.\n\n## Roadmap\nIf you have ideas for releases in the future, it is a good idea to list them in the README.\n\n## Contributing\nState if you are open to contributions and what your requirements are for accepting them.\n\nFor people who want to make changes to your project, it's helpful to have some documentation on how to get started. Perhaps there is a script that they should run or some environment variables that they need to set. Make these steps explicit. These instructions could also be useful to your future self.\n\nYou can also document commands to lint the code or run tests. These steps help to ensure high code quality and reduce the likelihood that the changes inadvertently break something. Having instructions for running tests is especially helpful if it requires external setup, such as starting a Selenium server for testing in a browser.\n\n## Authors and acknowledgment\nShow your appreciation to those who have contributed to the project.\n\n## License\nFor open source projects, say how it is licensed.\n\n## Project status\nIf you have run out of energy or time for your project, put a note at the top of the README saying that development has slowed down or stopped completely. Someone may choose to fork your project or volunteer to step in as a maintainer or owner, allowing your project to keep going. You can also make an explicit request for maintainers.\n\n",
    'author': 'Vanielle',
    'author_email': 'vanielle@odecloud.com',
    'maintainer': 'OdeCloud',
    'maintainer_email': 'support@odecloud.com',
    'url': 'https://gitlab.com/odetech/python_odecloud',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
