#!/usr/bin/env python
#   -*- coding: utf-8 -*-

from setuptools import setup
from setuptools.command.install import install as _install

class install(_install):
    def pre_install_script(self):
        pass

    def post_install_script(self):
        pass

    def run(self):
        self.pre_install_script()

        _install.run(self)

        self.post_install_script()

if __name__ == '__main__':
    setup(
        name = 'databricks-pybuilder-plugin',
        version = '0.0.5',
        description = 'Pybuilder plugin providing tasks for assets deployment.',
        long_description = "#### databricks-pybuilder-plugin\n\nThe plugin is considered to be used to deploy assets to a Databricks environment.\n\nThe plugin is activated with the following command in your build.by:\n> use_plugin('pypi:databricks_pybuilder_plugin')\n\nIt provides a set of tasks for uploading resources, workspaces, deploying jobs,\nor installing locally built egg dependencies into a databricks cluster.\n\n#### Deployment to Databricks\nAutomated deployment is implemented on the PyBuilder tasks basis.\n\nThe list of available tasks:\n\n1. **export_workspace** - exporting a workspace.\n   A workspace is considered to be a folder in Databricks holding a notebook, or a set of notebooks.\n\nThe task uploads the `src/main/scripts/` content into a Databricks workspace.\nIt overrides files of the same names and leaves other files as is.\n\nBy default, a git branch name is used as a nested folder of a workspace\nfor uploading the content into the Databricks workspace, if it's available.\nThe `default` folder is used otherwise.\nUse the `branch` parameter to import a workspace in your own folder:\n>pyb export_workspace -P branch={custom_directory}\n\nThe final output path would be `/team_folder/application_name/{custom_directory}` in this way.\n\nExecuting the command from a master branch\n>pyb export_workspace\n\nwould upload the workspace files into `/team_folder/application_name/master`.\n\nHere is the list of related deployment settings\n| Property                      | Value |Description |\n| ----------------------------- | ----- | ---------- |\n| project_workspace_path        | `src/main/scripts/` | The path to a folder in the project tree holding notebooks. |\n| remote_workspace_path         | `/team_folder/application_name/` | The Databricks folder the notebooks would be uploaded into from project_workspace_path. |\n\nAll of the properties could be overridden with a -P parameter.\n\nUsage example:\n>pyb export_workspace [-P env={env}] [-P branch={branch}]\n\n\nEnvironment specific properties\nDisabled by default.\n\n\n2. **export_resources** - exporting resources into dbfs.\n   Uploads resource files into dbfs if any. Existing files are to be overridden.\n\nHere is the list of related deployment settings\n| Property               | Value |Description |\n| -----------------------| ----- | ---------- |\n| project_resources_path | `src/main/resources/` | The path to the project resources. |\n\nAll of the properties could be overridden with a -P parameter.\n\nUsage example:\n>pyb export_resources [-P env={env}] [-P branch={branch}]\n\n3. **install_library** - deploying an egg-archive to a Databricks cluster.\n   Uploads an egg archive to dbfs, and re-attaches the library to a cluster by name.\n   Re-installing a new library version triggers the cluster starting\n   to uninstall old libraries versions and to install a new one.\n   Repetitive installations of a library of the same version don't start the cluster.\n   The library is just re-attached to a cluster in this way.\n   Other installed libraries are not affected.\n\nHere is the list of related deployment settings\n| Property            | Value |Description |\n| --------------------| ----- | ---------- |\n| remote_cluster_name | `Test_cluster_name` | The name of a remote Databricks cluster the library to be installed to. |\n| dbfs_library_path   | `dbfs:/FileStore/jars` | The dbfs path to a folder holding the egg archives. |\n\nAll of the properties could be overridden with a -P parameter.\n\nUsage example:\n>pyb install_library\n\n4. **deploy_to_cluster** - a full deployment to a cluster.\n   Runs the `export_resources`, `export_workspace`, `install_library` in a row.\n\nUsage example:\n>pyb deploy_to_cluster\n\n5. **deploy_job** - deploying a job to the Databricks by name.\n   Please, make sure that the job is created on the Databricks side.\n\nExecutes `export_resources` and `export_workspace` tasks preliminarily.\nUpdates the existing job using a job definition file.\nThe definition file supports the jinja2 template syntax.\nPlease, check documentation for details: https://jinja.palletsprojects.com/en/2.11.x/\n\nHere is the list of related deployment settings\n| Property            | Value |Description |\n| --------------------| ----- | ---------- |\n| job_definition_path | `src/main/databricks/databricks_job_settings.json` | The project path to a job definition file. |\n\nAll of the properties could be overridden with a -P parameter.\n\nUsage example:\n>pyb deploy_job [-P env={env}] [-P branch={branch}]\n\n#### To Run a notebook with a custom dependency\n1. Build the egg-archive with the`pyb` command.\n\n2. Deploy all the assets using the command `pyb deploy_to_cluster`.\n\n3. Get to the target folder in the Databricks workspace.\n\n4. Attach the notebook to a cluster and run the script.\n\n\n#### All properties list\n| Property            | Default Value                                                                                                                  | Description                                                                                                                                                                                                                                                                 |\n| --------------------|--------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|\n| databricks_credentials | `{`<br/>`'dev': {'host': '', 'token': ''}`<br/>`'qa': {'host': '', 'token': ''}`<br/>`'prod': {'host': '', 'token': ''}`<br/>`}` | Please specify credentials in the dictionary format: host and token.                                                                                                                                                                                                        |\n| default_environment | `dev`                                                                                                                          | There are 3 supported environments: `dev`, `qa` and `prod`.                                                                                                                                                                                                                 |\n| project_workspace_path | `src/main/scripts/`                                                                                                            | The directory content is going to be uploaded into a databricks workspace.<br/>These are considered to be notebook scripts.                                                                                                                                                 |\n| remote_workspace_path |                                                                                                                                | The databricks workspace that files in `project_workspace_path` are copied to.                                                                                                                                                                                              |\n| include_git_branch_into_output_workspace_path | `True`                                                                                                                         | The flag enables adding an extra directory with the `branch` name to the `remote_workspace_path`. Requires git to be installed.                                                                                                                                             |\n| enable_env_sensitive_workspace_properties | `False`                                                                                                                        | The flag enables environment properties chosen by the `env_config_workspace_path`.                                                                                                                                                                                          |\n| env_config_workspace_path | `environment-settings/{env}.py`                                                                                                | The path to a property file to be chosen as a env properties. By default `env` included into a file name is used to pick properties.                                                                                                                                        |\n| env_config_name | `env`                                                                                                                          | The expected environment properties file name. The `env_config_workspace_path` will be copied to databricks workspace with name.                                                                                                                                            |\n| with_dbfs_resources | `False`                                                                                                                        | The flage enables uploading resource files from the `project_resources_path` directory to databricks hdfs `dbfs_resources_path`.                                                                                                                                            |\n| project_resources_path | `src/main/resources/`                                                                                                          | The local directory path holding resource files to be copied (txt, csv etc).                                                                                                                                                                                                |\n| dbfs_resources_path |                                                                                                                                | The output hdfs directory on databricks environment holding resources.                                                                                                                                                                                                      |\n| dbfs_library_path | `dbfs:/FileStore/jars`                                                                                                         | The output hdfs directory on databricks environment holding a built dependency (egg-archive).                                                                                                                                                                               |\n| attachable_lib_envs | `['dev']`                                                                                                                      | The list of environments that requires a dependency attached to a databricks cluster. The dependency is preliminary must be uploaded to the `dbfs_library_path`.                                                                                                            |\n| cluster_init_timeout | `5 * 60`                                                                                                                       | The timeout of waiting a databricks cluster while it changes its state (initiating, restarting etc).                                                                                                                                                                        |\n| remote_cluster_name |                                                                                                                                | The name of a databricks cluster that dependency is attached to.                                                                                                                                                                                                            |\n| job_definition_path | 'src/main/databricks/job_settings.json'                                                                                       | The path to a dataricks job configuration in a json format - https://docs.databricks.com/dev-tools/api/2.0/jobs.html. It supports Jinja template syntax in order to setup env sensitive properties. It also supports multiple jobs definitions - use a json array for that. |\n| deploy_single_job |                                                                                        | The name of a job to be deployed. If your databricks job config contains multiple definitions, you can deploy just one of these jobs specifying a name of the particular job.                                                                                               |\n| extra_rendering_args |                                                                                        | Custom properties to be populated in the job definition file. Use a dicionary as an argument. For example: `{'app_name': name}`.                                                                                                                                            |\n",
        long_description_content_type = 'text/markdown',
        classifiers = ['Development Status :: 5 - Production/Stable'],
        keywords = '',

        author = 'Mikhail Kavaliou',
        author_email = 'killswitch@tut.by',
        maintainer = '',
        maintainer_email = '',

        license = '',

        url = '',
        project_urls = {},

        scripts = [],
        packages = ['databricks_pybuilder_plugin'],
        namespace_packages = [],
        py_modules = [],
        entry_points = {},
        data_files = [],
        package_data = {},
        install_requires = [],
        dependency_links = [],
        zip_safe = True,
        cmdclass = {'install': install},
        python_requires = '',
        obsoletes = [],
    )
