from typing import Any, Callable, Dict, Union

from canberra._canberra import CanberraError
from canberra.constants import Errors, Props, NOTSET

OnFinishedCallbackWithoutArg = Callable[['Context', int, Union[Errors, CanberraError]], Any]
OnFinishedCallbackWithArg = Callable[['Context', int, Union[Errors, CanberraError], Any], Any]
OnFinishedCallback = Union[OnFinishedCallbackWithArg, OnFinishedCallbackWithoutArg]


class Context:
    def __init__(self, props: Dict[Union[str, Props], str] = None, **other_props: str): ...
    def set_driver(self, driver: Union[str, bytes]) -> None: ...
    def change_device(self, device: Union[str, bytes]) -> None: ...
    def open(self) -> None: ...
    def change_props(self, props: Dict[Union[str, Props], str] = None, **other_props: str) -> None: ...
    def cache(self, props: Dict[Union[str, Props], str] = None, **other_props: str) -> None: ...
    def play(
        self,
        props: Dict[Union[str, Props], str] = None,
        id: int = 0,
        on_finished: OnFinishedCallback = None,
        user_data=NOTSET,
        **other_props: str,
    ) -> None: ...
    def cancel(self, id: int = 0) -> None: ...
    def playing(self, id: int = 0) -> bool: ...
