# permgroups package

Python implementation of permutation groups is presented. 
Two classes are introduced: *Perm* for permutations, 
*Group* for permutation groups (everal versions). 
The class *Perm* is based on Python dictionaries and utilize cycle notation. 
The methods of calculation for the perm order, parity, ranking and unranking 
are given. A random permutation generation is also shown. 

The class *Group* from the *groups* module
is very simple and it is also based on dictionaries. 
It is mainly the presentation of the permutation groups interface with 
methods for the group order, subgroups (normalizer, centralizer, center, 
stabilizer), orbits, and several tests.

The class *Group* from the *setgroups* module
is also simple and it is based on sets.

The class *Group* from the *simsgroups* module
is advanced and it is bases on the Sims theory.

The project is moved from *Google Code*.

## Installation

See doc/quickstart.txt

## References

[1] A. Kapanowski, *Python for education: permutations*. 
http://arxiv.org/abs/1307.7042 [draft]

[2] A. Kapanowski, The Python Papers 9, 3 (2014). 
*Python for education: permutations*. [final version]
http://ojs.pythonpapers.org/index.php/tpp/article/view/258 

## Contributors

Andrzej Kapanowski (project leader)

Tomasz Gądek

EOF
