# PPtool使用指南（by@zemengchuan）

GitHub链接：http://github.com/zemengchuan/PPtool

## 用途：

PPtool是集成了许多能够便利PPdata包的使用方法的python第三方包

## 安装方式

```python
pip install PPtool
```

## 方法库

## 快速获取目标数据的函数

方法：get_methods

描述：通过向get_methods方法传入目标数据的描述，可以快速获取你想要的函数名称，并且可以自行选择需要匹配的函数数量，以及是否需要调用

输入参数：

| 名称     | 类型 | 描述                |
| -------- | ---- | ------------------- |
| describe | str  | 目标数据的名字      |
| limit    | int  | 匹配的数量，默认为5 |


输出参数：返回你选择的数据，如果不需要调用则返回0


方法示例：

```python
import PPtool as pt

method = pt.get_methods("商品价格指数", limit=5)
print(method)
```

结果示例：

```
您希望获取的数据有可能是:(注：这里的待选项数量由limit参数控制)
0       " 企业商品价格指数"，其调用方法为China_CGPI
1       "商品零售价格指数"，其调用方法为China_retail_price_index
2       "大宗商品价格"，其调用方法为China_commodity_price_index
3       "建材价格指数"，其调用方法为China_construction_price_index
4       "工业品出厂价格指数"，其调用方法为China_PPI

请选择需要调用的函数编号：（不调用则填quit）0

您选择的数据是:“ 企业商品价格指数”
[            月份  总指数-指数值  总指数-同比增长  总指数-环比增长  农产品-指数值   农产品-同比增长  农产品-环比增长  矿产品-指数值   矿产品-同比增长  矿产品-环比增长  煤油电-指数值   煤油电-同比增长  煤油电-环
比增长
0    2023年01月份    100.4 -5.639098  0.199601    107.4  15.359828  2.972196    101.9  -1.450677 -0.682261    105.8 -10.338983 -2.037037
1    2022年12月份    100.2 -6.790698  0.400802    104.3   7.971014 -0.666667    102.6  -1.535509  1.886792    108.0  -8.937605  0.185529
2    2022年11月份     99.8 -9.107468 -0.299700    105.0   6.924644 -6.166220    100.7  -6.586271  2.650357    107.8 -12.924071 -0.185185
3    2022年10月份    100.1 -9.082652 -1.573255    111.9  21.498371 -0.089286     98.1 -11.938959  2.400835    108.0 -12.691997 -3.398927
4    2022年09月份    101.7 -5.746061 -0.586510    112.0  24.721604  4.089219     95.8 -16.258741  3.232759    111.8  -4.931973 -2.272727
..         ...      ...       ...       ...      ...        ...       ...      ...        ...       ...      ...        ...       ...
195  2006年10月份    103.8  2.843555  0.193050    106.3   8.116355  0.662879    116.0   9.002067  2.112676    107.0 -11.401838 -2.550091
196  2006年09月份    103.6  2.139406  0.680272    105.6   6.850147  1.343570    113.6   4.048361  0.709220    109.8  -9.495549 -0.453309
197  2006年08月份    102.9  0.753941  0.390244    104.2   4.628979  1.165049    112.8   1.768315  0.624442    110.3 -10.492575 -0.090580
198  2006年07月份    102.5 -0.214174  0.195503    103.0   2.763644  0.292113    112.1   1.009191  1.356239    110.4 -10.657927  0.272480
199  2006年06月份    102.3 -0.689253  0.788177    102.7   2.392822  1.884921    110.6  -0.887176  1.589051    110.1 -10.356619 -0.524033

[200 rows x 13 columns]]
```
