"""Add EMS objects in common to both ExistingHVAC and VRFsystem."""


def addEMSProgramsBase(self, ScriptType: str = None, verboseMode: bool = True):
    """
    Add EMS programs for Base accim.

    Checks if some programs objects are already
    in the model, and otherwise adds them.
    :param verboseMode:
    """
    programlist = ([program.Name
                    for program
                    in self.idf1.idfobjects['EnergyManagementSystem:Program']])

    if 'SetComfTemp' in programlist:
        if verboseMode:
            print('Not added - SetComfTemp Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='SetComfTemp',
            Program_Line_1='if ComfStand == 1',
            Program_Line_2='set ComfTemp = RMOT*0.33+18.8',
            Program_Line_3='elseif ComfStand == 2',
            Program_Line_4='set ComfTemp = PMOT*0.31+17.8',
            Program_Line_5='elseif ComfStand == 3',
            Program_Line_6='set ComfTemp = PMOT*0.48+14.4',
            Program_Line_7='elseif ComfStand == 4',
            Program_Line_8='set ComfTemp = 0',
            Program_Line_9='elseif ComfStand == 5',
            Program_Line_10='set ComfTemp = 0',
            Program_Line_11='elseif ComfStand == 6',
            Program_Line_12='set ComfTemp = 0',
            Program_Line_13='elseif ComfStand == 7',
            Program_Line_14='set ComfTemp = PMOT*0.54+12.83',
            Program_Line_15='elseif ComfStand == 8',
            Program_Line_16='set ComfTemp = PMOT*0.28+17.87',
            Program_Line_17='elseif ComfStand == 9',
            Program_Line_18='set ComfTemp = PMOT*0.39+18.42',
            Program_Line_19='elseif ComfStand == 10',
            Program_Line_20='set ComfTemp = PMOT*0.42+17.6',
            Program_Line_21='elseif ComfStand == 11',
            Program_Line_22='set ComfTemp = PMOT*0.75+5.37',
            Program_Line_23='elseif ComfStand == 12',
            Program_Line_24='set ComfTemp = PMOT*0.25+19.7',
            Program_Line_25='elseif ComfStand == 13',
            Program_Line_26='set ComfTemp = PMOT*0.26+15.9',
            Program_Line_27='elseif ComfStand == 14',
            Program_Line_28='set ComfTemp = PMOT*0.26+16.75',
            Program_Line_29='elseif ComfStand == 15',
            Program_Line_30='set ComfTemp = PMOT*0.56+12.74',
            Program_Line_31='elseif ComfStand == 16',
            Program_Line_32='set ComfTemp = PMOT*0.09+22.32',
            Program_Line_33='elseif ComfStand == 17',
            Program_Line_34='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_35='set ComfTemp = PMOT*0.48+13.9',
            Program_Line_36='else',
            Program_Line_37='set ComfTemp = PMOT*0.59+9.6',
            Program_Line_38='endif',
            Program_Line_39='elseif ComfStand == 18',
            Program_Line_40='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_41='set ComfTemp = PMOT*0.84+5.3',
            Program_Line_42='else',
            Program_Line_43='set ComfTemp = PMOT*0.96-3.6',
            Program_Line_44='endif',
            Program_Line_45='elseif ComfStand == 19',
            Program_Line_46='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_47='set ComfTemp = PMOT*0.27+17.9',
            Program_Line_48='else',
            Program_Line_49='set ComfTemp = PMOT*0.53+10.3',
            Program_Line_50='endif',
            Program_Line_51='elseif ComfStand == 20',
            Program_Line_52='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_53='set ComfTemp = PMOT*0.38+15.7',
            Program_Line_54='else',
            Program_Line_55='set ComfTemp = PMOT*0.47+9.07',
            Program_Line_56='endif',
            Program_Line_57='endif',
        )
        if verboseMode:
            print('Added - SetComfTemp Program')
    #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetComfTemp'])

    for zonename in self.occupiedZones:
        if 'CountHours_'+zonename in programlist:
            if verboseMode:
                print('Not added - CountHours_'+zonename+' Program')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Program',
                Name='CountHours_'+zonename,
                Program_Line_1='if (ComfStand == 1) || (ComfStand == 10)',
                Program_Line_2='if (RMOT >= AHSTall) && (RMOT <= ACSTaul)',
                Program_Line_3='if (' + zonename + '_OpT <= ACSTnoTol)',
                Program_Line_4='if (' + zonename + '_OpT >= AHSTnoTol)',
                Program_Line_5='set ComfHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_6='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_7='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_8='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_9='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_10='endif',
                Program_Line_11='elseif (' + zonename + '_OpT > ACSTnoTol)',
                Program_Line_12='set ComfHours_' + zonename + ' = 0',
                Program_Line_13='set DiscomfAppHotHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_14='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_15='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_16='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_17='elseif (' + zonename + '_OpT < AHSTnoTol)',
                Program_Line_18='set ComfHours_' + zonename + ' = 0',
                Program_Line_19='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_20='set DiscomfAppColdHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_21='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_22='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_23='endif',
                Program_Line_24='elseif (RMOT > ACSTaul)',
                Program_Line_25='set ComfHours_' + zonename + ' = 0',
                Program_Line_26='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_27='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_28='set DiscomfNonAppHotHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_29='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_30='elseif (RMOT < AHSTall)',
                Program_Line_31='set ComfHours_' + zonename + ' = 0',
                Program_Line_32='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_33='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_34='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_35='set DiscomfNonAppColdHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_36='endif',
                Program_Line_37='else',
                Program_Line_38='if (PMOT >= AHSTall) && (PMOT <= ACSTaul)',
                Program_Line_39='if (' + zonename + '_OpT <= ACSTnoTol)',
                Program_Line_40='if (' + zonename + '_OpT >= AHSTnoTol)',
                Program_Line_41='set ComfHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_42='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_43='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_44='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_45='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_46='endif',
                Program_Line_47='elseif (' + zonename + '_OpT > ACSTnoTol)',
                Program_Line_48='set ComfHours_' + zonename + ' = 0',
                Program_Line_49='set DiscomfAppHotHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_50='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_51='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_52='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_53='elseif (' + zonename + '_OpT < AHSTnoTol)',
                Program_Line_54='set ComfHours_' + zonename + ' = 0',
                Program_Line_55='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_56='set DiscomfAppColdHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_57='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_58='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_59='endif',
                Program_Line_60='elseif (PMOT > ACSTaul)',
                Program_Line_61='set ComfHours_' + zonename + ' = 0',
                Program_Line_62='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_63='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_64='set DiscomfNonAppHotHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_65='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_66='elseif (PMOT < AHSTall)',
                Program_Line_67='set ComfHours_' + zonename + ' = 0',
                Program_Line_68='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_69='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_70='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_71='set DiscomfNonAppColdHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_72='endif',
                Program_Line_73='endif',
            )
            if verboseMode:
                print('Added - CountHours_'+zonename+' Program')
    #        print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'CountHours_'+zonename])

    if 'SetAppLimits' in programlist:
        if verboseMode:
            print('Not added - SetAppLimits Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='SetAppLimits',
            Program_Line_1='If ComfStand == 1',
            Program_Line_2='set ACSTaul = 30',
            Program_Line_3='set ACSTall = 10',
            Program_Line_4='set AHSTaul = 30',
            Program_Line_5='set AHSTall = 10',
            Program_Line_6='elseif ComfStand == 2 || ComfStand == 12',
            Program_Line_7='set ACSTaul = 33.5',
            Program_Line_8='set ACSTall = 10',
            Program_Line_9='set AHSTaul = 33.5',
            Program_Line_10='set AHSTall = 10',
            Program_Line_11='elseif ComfStand == 3',
            Program_Line_12='set ACSTaul = 30',
            Program_Line_13='set ACSTall = 5',
            Program_Line_14='set AHSTaul = 30',
            Program_Line_15='set AHSTall = 5',
            Program_Line_16='elseif (ComfStand == 4) || (ComfStand == 5)',
            Program_Line_17='if CAT == 1',
            Program_Line_18='set ACSTaul = 28',
            Program_Line_19='set ACSTall = 18',
            Program_Line_20='set AHSTaul = 28',
            Program_Line_21='set AHSTall = 18',
            Program_Line_22='elseif CAT == 2',
            Program_Line_23='set ACSTaul = 30',
            Program_Line_24='set ACSTall = 18',
            Program_Line_25='set AHSTaul = 28',
            Program_Line_26='set AHSTall = 16',
            Program_Line_27='else',
            Program_Line_28='set ACSTaul = 50',
            Program_Line_29='set ACSTall = 50',
            Program_Line_30='set AHSTaul = 50',
            Program_Line_31='set AHSTall = 50',
            Program_Line_32='endif',
            Program_Line_33='elseif ComfStand == 6',
            Program_Line_34='set ACSTaul = 30',
            Program_Line_35='set ACSTall = -7',
            Program_Line_36='set AHSTaul = 30',
            Program_Line_37='set AHSTall = -7',
            Program_Line_38='elseif ComfStand == 7',
            Program_Line_39='set ACSTaul = 31',
            Program_Line_40='set ACSTall = 12.5',
            Program_Line_41='set AHSTaul = 31',
            Program_Line_42='set AHSTall = 12.5',
            Program_Line_43='elseif ComfStand == 8',
            Program_Line_44='set ACSTaul = 38.5',
            Program_Line_45='set ACSTall = 13',
            Program_Line_46='set AHSTaul = 38.5',
            Program_Line_47='set AHSTall = 13',
            Program_Line_48='elseif ComfStand == 9 || ComfStand == 10 || ComfStand == 11',
            Program_Line_49='set ACSTaul = 33',
            Program_Line_50='set ACSTall = 5.5',
            Program_Line_51='set AHSTaul = 33',
            Program_Line_52='set AHSTall = 5.5',
            Program_Line_53='elseif ComfStand == 13',
            Program_Line_54='set ACSTaul = 25',
            Program_Line_55='set ACSTall = 10',
            Program_Line_56='set AHSTaul = 25',
            Program_Line_57='set AHSTall = 10',
            Program_Line_58='elseif ComfStand == 14',
            Program_Line_59='set ACSTaul = 27',
            Program_Line_60='set ACSTall = 8',
            Program_Line_61='set AHSTaul = 27',
            Program_Line_62='set AHSTall = 8',
            Program_Line_63='elseif ComfStand == 15',
            Program_Line_64='set ACSTaul = 24.8',
            Program_Line_65='set ACSTall = 16.9',
            Program_Line_66='set AHSTaul = 24.8',
            Program_Line_67='set AHSTall = 16.9',
            Program_Line_68='elseif ComfStand == 16',
            Program_Line_69='set ACSTaul = 25.7',
            Program_Line_70='set ACSTall = 16.4',
            Program_Line_71='set AHSTaul = 25.7',
            Program_Line_72='set AHSTall = 16.4',
            Program_Line_73='elseif ComfStand == 17',
            Program_Line_74='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_75='set ACSTaul = 25.25',
            Program_Line_76='set ACSTall = 11.25',
            Program_Line_77='set AHSTaul = 25.25',
            Program_Line_78='set AHSTall = 11.25',
            Program_Line_79='else',
            Program_Line_80='set ACSTaul = 45',
            Program_Line_81='set ACSTall = 23',
            Program_Line_82='set AHSTaul = 45',
            Program_Line_83='set AHSTall = 23',
            Program_Line_84='endif',
            Program_Line_85='elseif ComfStand == 18',
            Program_Line_86='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_87='set ACSTaul = 27.5',
            Program_Line_88='set ACSTall = 15.5',
            Program_Line_89='set AHSTaul = 27.5',
            Program_Line_90='set AHSTall = 15.5',
            Program_Line_91='else',
            Program_Line_92='set ACSTaul = 34',
            Program_Line_93='set ACSTall = 23',
            Program_Line_94='set AHSTaul = 34',
            Program_Line_95='set AHSTall = 23',
            Program_Line_96='endif',
            Program_Line_97='elseif ComfStand == 19',
            Program_Line_98='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_99='set ACSTaul = 25.25',
            Program_Line_100='set ACSTall = 5',
            Program_Line_101='set AHSTaul = 25.25',
            Program_Line_102='set AHSTall = 5',
            Program_Line_103='else',
            Program_Line_104='set ACSTaul = 25.25',
            Program_Line_105='set ACSTall = 11.75',
            Program_Line_106='set AHSTaul = 25.25',
            Program_Line_107='set AHSTall = 11.75',
            Program_Line_108='endif',
            Program_Line_109='elseif ComfStand == 20',
            Program_Line_110='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_111='set ACSTaul = 29.75',
            Program_Line_112='set ACSTall = 13',
            Program_Line_113='set AHSTaul = 29.75',
            Program_Line_114='set AHSTall = 13',
            Program_Line_115='else',
            Program_Line_116='set ACSTaul = 45',
            Program_Line_117='set ACSTall = 23',
            Program_Line_118='set AHSTaul = 45',
            Program_Line_119='set AHSTall = 23',
            Program_Line_120='endif',
            Program_Line_121='else',
            Program_Line_122='set ACSTaul = 50',
            Program_Line_123='set ACSTall = 50',
            Program_Line_124='set AHSTaul = 50',
            Program_Line_125='set AHSTall = 50',
            Program_Line_126='endif',
        )
        if verboseMode:
            print('Added - SetAppLimits Program')
    #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetAppLimits'])

    if 'ApplyCAT' in programlist:
        if verboseMode:
            print('Not added - ApplyCAT Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='ApplyCAT',
            Program_Line_1='if (ComfStand == 1 )',
            Program_Line_2='if (CAT == 1)',
            Program_Line_3='set ACSToffset = 2',
            Program_Line_4='set AHSToffset = -3',
            Program_Line_5='elseif (CAT == 2)',
            Program_Line_6='set ACSToffset = 3',
            Program_Line_7='set AHSToffset = -4',
            Program_Line_8='elseif (CAT == 3)',
            Program_Line_9='set ACSToffset = 4',
            Program_Line_10='set AHSToffset = -5',
            Program_Line_11='endif',
            Program_Line_12='elseif ComfStand == 2 || ComfStand == 3 || ComfStand == 11',
            Program_Line_13='if (CAT == 90)',
            Program_Line_14='set ACSToffset = 2.5',
            Program_Line_15='set AHSToffset = -2.5',
            Program_Line_16='elseif (CAT == 80)',
            Program_Line_17='set ACSToffset = 3.5',
            Program_Line_18='set AHSToffset = -3.5',
            Program_Line_19='endif',
            Program_Line_20='elseif (ComfStand == 4 ) || (ComfStand == 5) || (ComfStand == 6)',
            Program_Line_21='set ACSToffset = 0',
            Program_Line_22='set AHSToffset = 0',
            Program_Line_23='elseif (ComfStand == 7)',
            Program_Line_24='if (CAT == 90)',
            Program_Line_25='set ACSToffset = 2.4',
            Program_Line_26='set AHSToffset = -2.4',
            Program_Line_27='elseif (CAT == 85)',
            Program_Line_28='set ACSToffset = 3.3',
            Program_Line_29='set AHSToffset = -3.3',
            Program_Line_30='elseif (CAT == 80)',
            Program_Line_31='set ACSToffset = 4.1',
            Program_Line_32='set AHSToffset = -4.1',
            Program_Line_33='endif',
            Program_Line_34='elseif (ComfStand == 8)',
            Program_Line_35='if (CAT == 90)',
            Program_Line_36='set ACSToffset = 3.5',
            Program_Line_37='set AHSToffset = -3.5',
            Program_Line_38='elseif (CAT == 85)',
            Program_Line_39='set ACSToffset = 4.8',
            Program_Line_40='set AHSToffset = -4.8',
            Program_Line_41='elseif (CAT == 80)',
            Program_Line_42='set ACSToffset = 5.9',
            Program_Line_43='set AHSToffset = -5.9',
            Program_Line_44='endif',
            Program_Line_45='elseif ComfStand == 9 || ComfStand == 10',
            Program_Line_46='if (CAT == 90)',
            Program_Line_47='set ACSToffset = 2.15',
            Program_Line_48='set AHSToffset = -2.15',
            Program_Line_49='elseif (CAT == 80)',
            Program_Line_50='set ACSToffset = 3.6',
            Program_Line_51='set AHSToffset = -3.6',
            Program_Line_52='endif',
            Program_Line_53='elseif ComfStand == 12',
            Program_Line_54='if (CAT == 90)',
            Program_Line_55='set ACSToffset = 1.7',
            Program_Line_56='set AHSToffset = -1.7',
            Program_Line_57='elseif (CAT == 80)',
            Program_Line_58='set ACSToffset = 2.89',
            Program_Line_59='set AHSToffset = -2.89',
            Program_Line_60='endif',
            Program_Line_61='elseif ComfStand == 13',
            Program_Line_62='if (CAT == 90)',
            Program_Line_63='set ACSToffset = 3.45',
            Program_Line_64='set AHSToffset = -3.45',
            Program_Line_65='elseif (CAT == 80)',
            Program_Line_66='set ACSToffset = 4.55',
            Program_Line_67='set AHSToffset = -4.55',
            Program_Line_68='endif',
            Program_Line_69='elseif ComfStand == 14',
            Program_Line_70='if (CAT == 90)',
            Program_Line_71='set ACSToffset = 3.5',
            Program_Line_72='set AHSToffset = -3.5',
            Program_Line_73='elseif (CAT == 80)',
            Program_Line_74='set ACSToffset = 4.5',
            Program_Line_75='set AHSToffset = -4.5',
            Program_Line_76='endif',
            Program_Line_77='elseif ComfStand == 15',
            Program_Line_78='if (CAT == 90)',
            Program_Line_79='set ACSToffset = 2.8',
            Program_Line_80='set AHSToffset = -2.8',
            Program_Line_81='elseif (CAT == 80)',
            Program_Line_82='set ACSToffset = 3.8',
            Program_Line_83='set AHSToffset = -3.8',
            Program_Line_84='endif',
            Program_Line_85='elseif ComfStand == 16',
            Program_Line_86='if (CAT == 90)',
            Program_Line_87='set ACSToffset = 1.1',
            Program_Line_88='set AHSToffset = -1.1',
            Program_Line_89='elseif (CAT == 80)',
            Program_Line_90='set ACSToffset = 2.1',
            Program_Line_91='set AHSToffset = -2.1',
            Program_Line_92='endif',
            Program_Line_93='elseif (ComfStand == 17) || (ComfStand == 18)',
            Program_Line_94='if CAT == 90',
            Program_Line_95='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_96='set ACSToffset = 2',
            Program_Line_97='set AHSToffset = -2',
            Program_Line_98='else',
            Program_Line_99='set ACSToffset = 3',
            Program_Line_100='set AHSToffset = -3',
            Program_Line_101='endif',
            Program_Line_102='elseif CAT == 80',
            Program_Line_103='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_104='set ACSToffset = 2',
            Program_Line_105='set AHSToffset = -2',
            Program_Line_106='else',
            Program_Line_107='set ACSToffset = 3',
            Program_Line_108='set AHSToffset = -3',
            Program_Line_109='endif',
            Program_Line_110='endif',
            Program_Line_111='elseif ComfStand == 19',
            Program_Line_112='if CAT == 90',
            Program_Line_113='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_114='set ACSToffset = 2',
            Program_Line_115='set AHSToffset = -2',
            Program_Line_116='else',
            Program_Line_117='set ACSToffset = 1',
            Program_Line_118='set AHSToffset = -1',
            Program_Line_119='endif',
            Program_Line_120='elseif CAT == 80',
            Program_Line_121='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_122='set ACSToffset = 3',
            Program_Line_123='set AHSToffset = -3',
            Program_Line_124='else',
            Program_Line_125='set ACSToffset = 2',
            Program_Line_126='set AHSToffset = -2',
            Program_Line_127='endif',
            Program_Line_128='endif',
            Program_Line_129='elseif ComfStand == 20',
            Program_Line_130='if CAT == 90',
            Program_Line_131='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_132='set ACSToffset = 2',
            Program_Line_133='set AHSToffset = -2',
            Program_Line_134='else',
            Program_Line_135='set ACSToffset = 5',
            Program_Line_136='set AHSToffset = -5',
            Program_Line_137='endif',
            Program_Line_138='elseif CAT == 80',
            Program_Line_139='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_140='set ACSToffset = 3',
            Program_Line_141='set AHSToffset = -3',
            Program_Line_142='else',
            Program_Line_143='set ACSToffset = 6',
            Program_Line_144='set AHSToffset = -6',
            Program_Line_145='endif',
            Program_Line_146='endif',
            Program_Line_147='endif',
        )
        if verboseMode:
            print('Added - ApplyCAT Program')
    #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'ApplyCAT'])

    if 'SetAST' in programlist:
        if verboseMode:
            print('Not added - SetAST Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='SetAST',
            Program_Line_1='if (ComfStand == 0) && (CurrentTime < 8)',
            Program_Line_2='set ACST = 27+ACSTtol',
            Program_Line_3='set AHST = 17+AHSTtol',
            Program_Line_4='elseif (ComfStand == 0) && (CurrentTime < 16)',
            Program_Line_5='set ACST = 25+ACSTtol',
            Program_Line_6='set AHST = 20+AHSTtol',
            Program_Line_7='elseif (ComfStand == 0) && (CurrentTime < 23)',
            Program_Line_8='set ACST = 25+ACSTtol',
            Program_Line_9='set AHST = 20+AHSTtol',
            Program_Line_10='elseif (ComfStand == 0) && (CurrentTime < 24)',
            Program_Line_11='set ACST = 27+ACSTtol',
            Program_Line_12='set AHST = 17+AHSTtol',
            Program_Line_13='endif',
            Program_Line_14='if (ComfStand == 1) && (ComfMod == 0)',
            Program_Line_15='if (DayOfYear >= 121) && (DayOfYear < 274)',
            Program_Line_16='if (CAT==1)',
            Program_Line_17='set ACST = 25.5+ACSTtol',
            Program_Line_18='elseif (CAT==2)',
            Program_Line_19='set ACST = 26+ACSTtol',
            Program_Line_20='elseif (CAT==3)',
            Program_Line_21='set ACST = 27+ACSTtol',
            Program_Line_22='endif',
            Program_Line_23='else',
            Program_Line_24='if (CAT==1)',
            Program_Line_25='set ACST = 25+ACSTtol',
            Program_Line_26='elseif (CAT==2)',
            Program_Line_27='set ACST = 25+ACSTtol',
            Program_Line_28='elseif (CAT==3)',
            Program_Line_29='set ACST = 25+ACSTtol',
            Program_Line_30='endif',
            Program_Line_31='endif',
            Program_Line_32='endif',
            Program_Line_33='if (ComfStand == 1) && (ComfMod == 0)',
            Program_Line_34='if (DayOfYear >= 121) && (DayOfYear < 274)',
            Program_Line_35='if (CAT==1)',
            Program_Line_36='set AHST = 23.5+AHSTtol',
            Program_Line_37='elseif (CAT==2)',
            Program_Line_38='set AHST = 23+AHSTtol',
            Program_Line_39='elseif (CAT==3)',
            Program_Line_40='set AHST = 22+AHSTtol',
            Program_Line_41='endif',
            Program_Line_42='else',
            Program_Line_43='if (CAT==1)',
            Program_Line_44='set AHST = 21+AHSTtol',
            Program_Line_45='elseif (CAT==2)',
            Program_Line_46='set AHST = 20+AHSTtol',
            Program_Line_47='elseif (CAT==3)',
            Program_Line_48='set AHST = 18+AHSTtol',
            Program_Line_49='endif',
            Program_Line_50='endif',
            Program_Line_51='endif',
            Program_Line_52='if (ComfStand == 1) && (ComfMod == 1)',
            Program_Line_53='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_54='set ACST = RMOT*0.33+18.8+ACSToffset+ACSTtol',
            Program_Line_55='elseif CurrentTime < 7',
            Program_Line_56='set ACST = 27+ACSTtol',
            Program_Line_57='elseif CurrentTime < 15',
            Program_Line_58='set ACST = 50',
            Program_Line_59='elseif CurrentTime < 23',
            Program_Line_60='set ACST = 25+ACSTtol',
            Program_Line_61='elseif CurrentTime < 24',
            Program_Line_62='set ACST = 27+ACSTtol',
            Program_Line_63='endif',
            Program_Line_64='endif',
            Program_Line_65='if (ComfStand == 1) && (ComfMod == 1)',
            Program_Line_66='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_67='set AHST = RMOT*0.33+18.8+AHSToffset+AHSTtol',
            Program_Line_68='elseif CurrentTime < 7',
            Program_Line_69='set AHST = 17+AHSTtol',
            Program_Line_70='elseif CurrentTime < 23',
            Program_Line_71='set AHST = 20+AHSTtol',
            Program_Line_72='elseif CurrentTime < 24',
            Program_Line_73='set AHST = 17+AHSTtol',
            Program_Line_74='endif',
            Program_Line_75='endif',
            Program_Line_76='if (ComfStand == 1) && (ComfMod == 2)',
            Program_Line_77='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_78='set ACST = RMOT*0.33+18.8+ACSToffset+ACSTtol',
            Program_Line_79='elseif (RMOT < ACSTall) && (CAT==1)',
            Program_Line_80='set ACST = 25+ACSTtol',
            Program_Line_81='elseif (RMOT > ACSTaul) && (CAT==1)',
            Program_Line_82='set ACST = 25.5+ACSTtol',
            Program_Line_83='elseif (RMOT < ACSTall) && (CAT==2)',
            Program_Line_84='set ACST = 25+ACSTtol',
            Program_Line_85='elseif (RMOT > ACSTaul) && (CAT==2)',
            Program_Line_86='set ACST = 26+ACSTtol',
            Program_Line_87='elseif (RMOT < ACSTall) && (CAT==3)',
            Program_Line_88='set ACST = 25+ACSTtol',
            Program_Line_89='elseif (RMOT > ACSTaul) && (CAT==3)',
            Program_Line_90='set ACST = 27+ACSTtol',
            Program_Line_91='endif',
            Program_Line_92='endif',
            Program_Line_93='if (ComfStand == 1) && (ComfMod == 2)',
            Program_Line_94='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_95='set AHST = RMOT*0.33+18.8+AHSToffset+AHSTtol',
            Program_Line_96='elseif (RMOT < AHSTall) && (CAT==1)',
            Program_Line_97='set AHST = 21+AHSTtol',
            Program_Line_98='elseif (RMOT > AHSTaul) && (CAT==1)',
            Program_Line_99='set AHST = 23.5+AHSTtol',
            Program_Line_100='elseif (RMOT < AHSTall) && (CAT==2)',
            Program_Line_101='set AHST = 20+AHSTtol',
            Program_Line_102='elseif (RMOT > AHSTaul) && (CAT==2)',
            Program_Line_103='set AHST = 23+AHSTtol',
            Program_Line_104='elseif (RMOT < AHSTall) && (CAT==3)',
            Program_Line_105='set AHST = 18+AHSTtol',
            Program_Line_106='elseif (RMOT > AHSTaul) && (CAT==3)',
            Program_Line_107='set AHST = 22+AHSTtol',
            Program_Line_108='endif',
            Program_Line_109='endif',
            Program_Line_110='if (ComfStand == 1) && (ComfMod == 3)',
            Program_Line_111='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_112='set ACST = RMOT*0.33+18.8+ACSToffset+ACSTtol',
            Program_Line_113='elseif RMOT < ACSTall',
            Program_Line_114='set ACST = ACSTall*0.33+18.8+ACSToffset+ACSTtol',
            Program_Line_115='elseif RMOT > ACSTaul',
            Program_Line_116='set ACST = ACSTaul*0.33+18.8+ACSToffset+ACSTtol',
            Program_Line_117='endif',
            Program_Line_118='endif',
            Program_Line_119='if (ComfStand == 1) && (ComfMod == 3)',
            Program_Line_120='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_121='set AHST = RMOT*0.33+18.8+AHSToffset+AHSTtol',
            Program_Line_122='elseif RMOT < AHSTall',
            Program_Line_123='set AHST = AHSTall*0.33+18.8+AHSToffset+AHSTtol',
            Program_Line_124='elseif RMOT > AHSTaul',
            Program_Line_125='set AHST = AHSTaul*0.33+18.8+AHSToffset+AHSTtol',
            Program_Line_126='endif',
            Program_Line_127='endif',
            Program_Line_128='if (ComfStand == 2) && (ComfMod == 0)',
            Program_Line_129='if (DayOfYear >= 121) && (DayOfYear < 274)',
            Program_Line_130='if (CAT==80)',
            Program_Line_131='set ACST = 28.35+ACSTtol',
            Program_Line_132='elseif (CAT==90)',
            Program_Line_133='set ACST = 27.42+ACSTtol',
            Program_Line_134='endif',
            Program_Line_135='else',
            Program_Line_136='if (CAT==80)',
            Program_Line_137='set ACST = 26.35+ACSTtol',
            Program_Line_138='elseif (CAT==90)',
            Program_Line_139='set ACST = 25.09+ACSTtol',
            Program_Line_140='endif',
            Program_Line_141='endif',
            Program_Line_142='endif',
            Program_Line_143='if (ComfStand == 2) && (ComfMod == 0)',
            Program_Line_144='if (DayOfYear >= 121) && (DayOfYear < 274)',
            Program_Line_145='if (CAT==80)',
            Program_Line_146='set AHST = 23.78+AHSTtol',
            Program_Line_147='elseif (CAT==90)',
            Program_Line_148='set AHST = 24.74+AHSTtol',
            Program_Line_149='endif',
            Program_Line_150='else',
            Program_Line_151='if (CAT==80)',
            Program_Line_152='set AHST = 20.1+AHSTtol',
            Program_Line_153='elseif (CAT==90)',
            Program_Line_154='set AHST = 21.44+AHSTtol',
            Program_Line_155='endif',
            Program_Line_156='endif',
            Program_Line_157='endif',
            Program_Line_158='if (ComfStand == 2) && (ComfMod == 1)',
            Program_Line_159='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_160='set ACST = PMOT*0.31+17.8+ACSToffset+ACSTtol',
            Program_Line_161='elseif CurrentTime < 7',
            Program_Line_162='set ACST = 27+ACSTtol',
            Program_Line_163='elseif CurrentTime < 15',
            Program_Line_164='set ACST = 50',
            Program_Line_165='elseif CurrentTime < 23',
            Program_Line_166='set ACST = 25+ACSTtol',
            Program_Line_167='elseif CurrentTime < 24',
            Program_Line_168='set ACST = 27+ACSTtol',
            Program_Line_169='endif',
            Program_Line_170='endif',
            Program_Line_171='if (ComfStand == 2) && (ComfMod == 1)',
            Program_Line_172='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_173='set AHST = PMOT*0.31+17.8+AHSToffset+AHSTtol',
            Program_Line_174='elseif CurrentTime < 7',
            Program_Line_175='set AHST = 17+AHSTtol',
            Program_Line_176='elseif CurrentTime < 23',
            Program_Line_177='set AHST = 20+AHSTtol',
            Program_Line_178='elseif CurrentTime < 24',
            Program_Line_179='set AHST = 17+AHSTtol',
            Program_Line_180='endif',
            Program_Line_181='endif',
            Program_Line_182='if (ComfStand == 2) && (ComfMod == 2)',
            Program_Line_183='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_184='set ACST = PMOT*0.31+17.8+ACSToffset+ACSTtol',
            Program_Line_185='elseif CAT==80',
            Program_Line_186='if PMOT < ACSTall',
            Program_Line_187='set ACST = 26.35+ACSTtol',
            Program_Line_188='elseif PMOT > ACSTaul',
            Program_Line_189='set ACST = 28.35+ACSTtol',
            Program_Line_190='endif',
            Program_Line_191='elseif CAT==90',
            Program_Line_192='if PMOT < ACSTall',
            Program_Line_193='set ACST = 25.09+ACSTtol',
            Program_Line_194='elseif PMOT > ACSTaul',
            Program_Line_195='set ACST = 27.42+ACSTtol',
            Program_Line_196='endif',
            Program_Line_197='endif',
            Program_Line_198='endif',
            Program_Line_199='if (ComfStand == 2) && (ComfMod == 2)',
            Program_Line_200='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_201='set AHST = PMOT*0.31+17.8+AHSToffset+AHSTtol',
            Program_Line_202='elseif CAT==80',
            Program_Line_203='if PMOT < AHSTall',
            Program_Line_204='set AHST = 20.1+AHSTtol',
            Program_Line_205='elseif PMOT > AHSTaul',
            Program_Line_206='set AHST = 23.78+AHSTtol',
            Program_Line_207='endif',
            Program_Line_208='elseif CAT==90',
            Program_Line_209='if PMOT < AHSTall',
            Program_Line_210='set AHST = 21.44+AHSTtol',
            Program_Line_211='elseif PMOT > AHSTaul',
            Program_Line_212='set AHST = 24.74+AHSTtol',
            Program_Line_213='endif',
            Program_Line_214='endif',
            Program_Line_215='endif',
            Program_Line_216='if (ComfStand == 2) && (ComfMod == 3)',
            Program_Line_217='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_218='set ACST = PMOT*0.31+17.8+ACSToffset+ACSTtol',
            Program_Line_219='elseif PMOT < ACSTall',
            Program_Line_220='set ACST = ACSTall*0.31+17.8+ACSToffset+ACSTtol',
            Program_Line_221='elseif PMOT > ACSTaul',
            Program_Line_222='set ACST = ACSTaul*0.31+17.8+ACSToffset+ACSTtol',
            Program_Line_223='endif',
            Program_Line_224='endif',
            Program_Line_225='if (ComfStand == 2) && (ComfMod == 3)',
            Program_Line_226='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_227='set AHST = PMOT*0.31+17.8+AHSToffset+AHSTtol',
            Program_Line_228='elseif PMOT < AHSTall',
            Program_Line_229='set AHST = AHSTall*0.31+17.8+AHSToffset+AHSTtol',
            Program_Line_230='elseif PMOT > AHSTaul',
            Program_Line_231='set AHST = AHSTaul*0.31+17.8+AHSToffset+AHSTtol',
            Program_Line_232='endif',
            Program_Line_233='endif',
            Program_Line_234='if (ComfStand == 3) && (ComfMod == 0)',
            Program_Line_235='if (CAT==80)',
            Program_Line_236='set ACST = 28+ACSTtol',
            Program_Line_237='elseif (CAT==90)',
            Program_Line_238='set ACST = 27+ACSTtol',
            Program_Line_239='endif',
            Program_Line_240='endif',
            Program_Line_241='if (ComfStand == 3) && (ComfMod == 0)',
            Program_Line_242='if (CAT==80)',
            Program_Line_243='set AHST = 18+AHSTtol',
            Program_Line_244='elseif (CAT==90)',
            Program_Line_245='set AHST = 19+AHSTtol',
            Program_Line_246='endif',
            Program_Line_247='endif',
            Program_Line_248='if (ComfStand == 3) && (ComfMod == 1)',
            Program_Line_249='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_250='set ACST = PMOT*0.48+14.4+ACSToffset+ACSTtol',
            Program_Line_251='elseif CAT==80',
            Program_Line_252='if PMOT < ACSTall',
            Program_Line_253='set ACST = 28+ACSTtol',
            Program_Line_254='elseif PMOT > ACSTaul',
            Program_Line_255='set ACST = 28+ACSTtol',
            Program_Line_256='endif',
            Program_Line_257='elseif CAT==90',
            Program_Line_258='if PMOT < ACSTall',
            Program_Line_259='set ACST = 27+ACSTtol',
            Program_Line_260='elseif PMOT > ACSTaul',
            Program_Line_261='set ACST = 27+ACSTtol',
            Program_Line_262='endif',
            Program_Line_263='endif',
            Program_Line_264='endif',
            Program_Line_265='if (ComfStand == 3) && (ComfMod == 1)',
            Program_Line_266='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_267='set AHST = PMOT*0.48+14.4+AHSToffset+AHSTtol',
            Program_Line_268='elseif CAT==80',
            Program_Line_269='if PMOT < AHSTall',
            Program_Line_270='set AHST = 18+AHSTtol',
            Program_Line_271='elseif PMOT > AHSTaul',
            Program_Line_272='set AHST = 18+AHSTtol',
            Program_Line_273='endif',
            Program_Line_274='elseif CAT==90',
            Program_Line_275='if PMOT < AHSTall',
            Program_Line_276='set AHST = 19+AHSTtol',
            Program_Line_277='elseif PMOT > AHSTaul',
            Program_Line_278='set AHST = 19+AHSTtol',
            Program_Line_279='endif',
            Program_Line_280='endif',
            Program_Line_281='endif',
            Program_Line_282='if (ComfStand == 3) && (ComfMod == 2)',
            Program_Line_283='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_284='set ACST = PMOT*0.48+14.4+ACSToffset+ACSTtol',
            Program_Line_285='elseif CAT==80',
            Program_Line_286='if PMOT < ACSTall',
            Program_Line_287='set ACST = 26.35+ACSTtol',
            Program_Line_288='elseif PMOT > ACSTaul',
            Program_Line_289='set ACST = 28.35+ACSTtol',
            Program_Line_290='endif',
            Program_Line_291='elseif CAT==90',
            Program_Line_292='if PMOT < ACSTall',
            Program_Line_293='set ACST = 25.09+ACSTtol',
            Program_Line_294='elseif PMOT > ACSTaul',
            Program_Line_295='set ACST = 27.42+ACSTtol',
            Program_Line_296='endif',
            Program_Line_297='endif',
            Program_Line_298='endif',
            Program_Line_299='if (ComfStand == 3) && (ComfMod == 2)',
            Program_Line_300='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_301='set AHST = PMOT*0.48+14.4+AHSToffset+AHSTtol',
            Program_Line_302='elseif CAT==80',
            Program_Line_303='if PMOT < AHSTall',
            Program_Line_304='set AHST = 20.1+AHSTtol',
            Program_Line_305='elseif PMOT > AHSTaul',
            Program_Line_306='set AHST = 23.78+AHSTtol',
            Program_Line_307='endif',
            Program_Line_308='elseif CAT==90',
            Program_Line_309='if PMOT < AHSTall',
            Program_Line_310='set AHST = 21.44+AHSTtol',
            Program_Line_311='elseif PMOT > AHSTaul',
            Program_Line_312='set AHST = 24.74+AHSTtol',
            Program_Line_313='endif',
            Program_Line_314='endif',
            Program_Line_315='endif',
            Program_Line_316='if (ComfStand == 3) && (ComfMod == 3)',
            Program_Line_317='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_318='set ACST = PMOT*0.48+14.4+ACSToffset+ACSTtol',
            Program_Line_319='elseif PMOT < ACSTall',
            Program_Line_320='set ACST = ACSTall*0.48+14.4+ACSToffset+ACSTtol',
            Program_Line_321='elseif PMOT > ACSTaul',
            Program_Line_322='set ACST = ACSTaul*0.48+14.4+ACSToffset+ACSTtol',
            Program_Line_323='endif',
            Program_Line_324='endif',
            Program_Line_325='if (ComfStand == 3) && (ComfMod == 3)',
            Program_Line_326='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_327='set AHST = PMOT*0.48+14.4+AHSToffset+AHSTtol',
            Program_Line_328='elseif PMOT < AHSTall',
            Program_Line_329='set AHST = AHSTall*0.48+14.4+AHSToffset+AHSTtol',
            Program_Line_330='elseif PMOT > AHSTaul',
            Program_Line_331='set AHST = AHSTaul*0.48+14.4+AHSToffset+AHSTtol',
            Program_Line_332='endif',
            Program_Line_333='endif',
            Program_Line_334='if (ComfStand == 4) && (ComfMod == 3)',
            Program_Line_335='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_336='if CAT == 1',
            Program_Line_337='set ACST = PMOT*0.77+12.04+ACSTtol',
            Program_Line_338='elseif CAT == 2',
            Program_Line_339='set ACST = PMOT*0.73+15.28+ACSTtol',
            Program_Line_340='endif',
            Program_Line_341='elseif PMOT < ACSTall',
            Program_Line_342='if CAT == 1',
            Program_Line_343='set ACST = ACSTall*0.77+12.04+ACSTtol',
            Program_Line_344='elseif CAT == 2',
            Program_Line_345='set ACST = ACSTall*0.73+15.28+ACSTtol',
            Program_Line_346='endif',
            Program_Line_347='elseif PMOT > ACSTaul',
            Program_Line_348='if CAT == 1',
            Program_Line_349='set ACST = ACSTaul*0.77+12.04+ACSTtol',
            Program_Line_350='elseif CAT == 2',
            Program_Line_351='set ACST = ACSTaul*0.73+15.28+ACSTtol',
            Program_Line_352='endif',
            Program_Line_353='endif',
            Program_Line_354='endif',
            Program_Line_355='if (ComfStand == 4) && (ComfMod == 3)',
            Program_Line_356='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_357='if CAT == 1',
            Program_Line_358='set AHST = PMOT*0.87+2.76+AHSTtol',
            Program_Line_359='elseif CAT == 2',
            Program_Line_360='set AHST = PMOT*0.91-0.48+AHSTtol',
            Program_Line_361='endif',
            Program_Line_362='elseif PMOT < AHSTall',
            Program_Line_363='if CAT == 1',
            Program_Line_364='set AHST = AHSTall*0.87+2.76+AHSTtol',
            Program_Line_365='elseif CAT == 2',
            Program_Line_366='set AHST = AHSTall*0.91-0.48+AHSTtol',
            Program_Line_367='endif',
            Program_Line_368='elseif PMOT > AHSTaul',
            Program_Line_369='if CAT == 1',
            Program_Line_370='set AHST = AHSTaul*0.87+2.76+AHSTtol',
            Program_Line_371='elseif CAT == 2',
            Program_Line_372='set AHST = AHSTaul*0.91-0.48+AHSTtol',
            Program_Line_373='endif',
            Program_Line_374='endif',
            Program_Line_375='endif',
            Program_Line_376='if (ComfStand == 5) && (ComfMod == 3)',
            Program_Line_377='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_378='if CAT == 1',
            Program_Line_379='set ACST = PMOT*0.77+9.34+ACSTtol',
            Program_Line_380='elseif CAT == 2',
            Program_Line_381='set ACST = PMOT*0.73+12.72+ACSTtol',
            Program_Line_382='endif',
            Program_Line_383='elseif PMOT < ACSTall',
            Program_Line_384='if CAT == 1',
            Program_Line_385='set ACST = ACSTall*0.77+9.34+ACSTtol',
            Program_Line_386='elseif CAT == 2',
            Program_Line_387='set ACST = ACSTall*0.73+12.72+ACSTtol',
            Program_Line_388='endif',
            Program_Line_389='elseif PMOT > ACSTaul',
            Program_Line_390='if CAT == 1',
            Program_Line_391='set ACST = ACSTaul*0.77+9.34+ACSTtol',
            Program_Line_392='elseif CAT == 2',
            Program_Line_393='set ACST = ACSTaul*0.73+12.72+ACSTtol',
            Program_Line_394='endif',
            Program_Line_395='endif',
            Program_Line_396='endif',
            Program_Line_397='if (ComfStand == 5) && (ComfMod == 3)',
            Program_Line_398='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_399='if CAT == 1',
            Program_Line_400='set AHST = PMOT*0.87-0.31+AHSTtol',
            Program_Line_401='elseif CAT == 2',
            Program_Line_402='set AHST = PMOT*0.91-3.69+AHSTtol',
            Program_Line_403='endif',
            Program_Line_404='elseif PMOT < AHSTall',
            Program_Line_405='if CAT == 1',
            Program_Line_406='set AHST = AHSTall*0.87-0.31+AHSTtol',
            Program_Line_407='elseif CAT == 2',
            Program_Line_408='set AHST = AHSTall*0.91-3.69+AHSTtol',
            Program_Line_409='endif',
            Program_Line_410='elseif PMOT > AHSTaul',
            Program_Line_411='if CAT == 1',
            Program_Line_412='set AHST = AHSTaul*0.87-0.31+AHSTtol',
            Program_Line_413='elseif CAT == 2',
            Program_Line_414='set AHST = AHSTaul*0.91-3.69+AHSTtol',
            Program_Line_415='endif',
            Program_Line_416='endif',
            Program_Line_417='endif',
            Program_Line_418='if (ComfStand == 6) && (ComfMod == 2)',
            Program_Line_419='if CAT==80',
            Program_Line_420='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_421='set ACST = PMOT*0.30+25.9+ACSTtol',
            Program_Line_422='elseif PMOT < ACSTall',
            Program_Line_423='set ACST = 26.35+ACSTtol',
            Program_Line_424='elseif PMOT > ACSTaul',
            Program_Line_425='set ACST = 28.35+ACSTtol',
            Program_Line_426='endif',
            Program_Line_427='elseif CAT==90',
            Program_Line_428='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_429='set ACST = PMOT*0.30+23.6+ACSTtol',
            Program_Line_430='elseif PMOT < ACSTall',
            Program_Line_431='set ACST = 25.09+ACSTtol',
            Program_Line_432='elseif PMOT > ACSTaul',
            Program_Line_433='set ACST = 27.42+ACSTtol',
            Program_Line_434='endif',
            Program_Line_435='endif',
            Program_Line_436='endif',
            Program_Line_437='if (ComfStand == 6) && (ComfMod == 2)',
            Program_Line_438='if CAT==80',
            Program_Line_439='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_440='set AHST = PMOT*0.30+25.9+AHSTtol',
            Program_Line_441='elseif PMOT < AHSTall',
            Program_Line_442='set AHST = 20.1+AHSTtol',
            Program_Line_443='elseif PMOT > AHSTaul',
            Program_Line_444='set AHST = 23.78+AHSTtol',
            Program_Line_445='endif',
            Program_Line_446='elseif CAT==90',
            Program_Line_447='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_448='set AHST = PMOT*0.30+23.6+AHSTtol',
            Program_Line_449='elseif PMOT < AHSTall',
            Program_Line_450='set AHST = 21.44+AHSTtol',
            Program_Line_451='elseif PMOT > AHSTaul',
            Program_Line_452='set AHST = 24.74+AHSTtol',
            Program_Line_453='endif',
            Program_Line_454='endif',
            Program_Line_455='endif',
            Program_Line_456='if (ComfStand == 6) && (ComfMod == 3)',
            Program_Line_457='if CAT == 80',
            Program_Line_458='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_459='set ACST = PMOT*0.30+25.9+ACSTtol',
            Program_Line_460='elseif (PMOT < ACSTall)',
            Program_Line_461='set ACST = ACSTall*0.30+25.9+ACSTtol',
            Program_Line_462='elseif (PMOT > ACSTaul)',
            Program_Line_463='set ACST = ACSTaul*0.30+25.9+ACSTtol',
            Program_Line_464='endif',
            Program_Line_465='elseif CAT == 90',
            Program_Line_466='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_467='set ACST = PMOT*0.30+23.6+ACSTtol',
            Program_Line_468='elseif (PMOT < ACSTall)',
            Program_Line_469='set ACST = ACSTall*0.30+23.6+ACSTtol',
            Program_Line_470='elseif (PMOT > ACSTaul)',
            Program_Line_471='set ACST = ACSTaul*0.30+23.6+ACSTtol',
            Program_Line_472='endif',
            Program_Line_473='endif',
            Program_Line_474='endif',
            Program_Line_475='if (ComfStand == 6) && (ComfMod == 3)',
            Program_Line_476='if CAT == 80',
            Program_Line_477='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_478='set AHST = PMOT*0.32+14.88+AHSTtol',
            Program_Line_479='elseif (PMOT < AHSTall)',
            Program_Line_480='set AHST = AHSTall*0.32+14.88+AHSTtol',
            Program_Line_481='elseif (PMOT > AHSTaul)',
            Program_Line_482='set AHST = AHSTaul*0.32+14.88+AHSTtol',
            Program_Line_483='endif',
            Program_Line_484='elseif CAT == 90',
            Program_Line_485='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_486='set AHST = PMOT*0.31+17.14+AHSTtol',
            Program_Line_487='elseif (PMOT < AHSTall)',
            Program_Line_488='set AHST = AHSTall*0.31+17.14+AHSTtol',
            Program_Line_489='elseif (PMOT > AHSTaul)',
            Program_Line_490='set AHST = AHSTaul*0.31+17.14+AHSTtol',
            Program_Line_491='endif',
            Program_Line_492='endif',
            Program_Line_493='endif',
            Program_Line_494='if ComfStand == 7 || ComfStand == 8 || ComfStand == 9 || ComfStand == 10',
            Program_Line_495='if (ComfMod == 0)',
            Program_Line_496='if CAT==80',
            Program_Line_497='set ACST = PMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_498='elseif CAT==85',
            Program_Line_499='set ACST = PMOT*0.078+23.25+2.11+ACSTtol',
            Program_Line_500='elseif CAT==90',
            Program_Line_501='set ACST = PMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_502='endif',
            Program_Line_503='endif',
            Program_Line_504='endif',
            Program_Line_505='if ComfStand == 7 || ComfStand == 8 || ComfStand == 9 || ComfStand == 10',
            Program_Line_506='if (ComfMod == 0)',
            Program_Line_507='if CAT==80',
            Program_Line_508='set AHST = PMOT*0.078+23.25-2.72+AHSTtol',
            Program_Line_509='elseif CAT==85',
            Program_Line_510='set AHST = PMOT*0.078+23.25-2.11+AHSTtol',
            Program_Line_511='elseif CAT==90',
            Program_Line_512='set AHST = PMOT*0.078+23.25-1.5+AHSTtol',
            Program_Line_513='endif',
            Program_Line_514='endif',
            Program_Line_515='endif',
            Program_Line_516='if (ComfStand == 7) && (ComfMod == 1)',
            Program_Line_517='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_518='set ACST = PMOT*0.54+12.83+ACSToffset+ACSTtol',
            Program_Line_519='else',
            Program_Line_520='if CAT==80',
            Program_Line_521='set ACST = PMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_522='elseif CAT==85',
            Program_Line_523='set ACST = PMOT*0.078+23.25+2.11+ACSTtol',
            Program_Line_524='elseif CAT==90',
            Program_Line_525='set ACST = PMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_526='endif',
            Program_Line_527='endif',
            Program_Line_528='endif',
            Program_Line_529='if (ComfStand == 7) && (ComfMod == 1)',
            Program_Line_530='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_531='set AHST = PMOT*0.54+12.83+AHSToffset+AHSTtol',
            Program_Line_532='else',
            Program_Line_533='if CAT==80',
            Program_Line_534='set AHST = PMOT*0.078+23.25-2.72+AHSTtol',
            Program_Line_535='elseif CAT==85',
            Program_Line_536='set AHST = PMOT*0.078+23.25-2.11+AHSTtol',
            Program_Line_537='elseif CAT==90',
            Program_Line_538='set AHST = PMOT*0.078+23.25-1.5+AHSTtol',
            Program_Line_539='endif',
            Program_Line_540='endif',
            Program_Line_541='endif',
            Program_Line_542='if (ComfStand == 7) && (ComfMod == 2)',
            Program_Line_543='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_544='set ACST = PMOT*0.54+12.83+ACSToffset+ACSTtol',
            Program_Line_545='elseif CAT==80',
            Program_Line_546='if PMOT < ACSTall',
            Program_Line_547='set ACST = 26.35+ACSTtol',
            Program_Line_548='elseif PMOT > ACSTaul',
            Program_Line_549='set ACST = 28.35+ACSTtol',
            Program_Line_550='endif',
            Program_Line_551='elseif CAT==85',
            Program_Line_552='if PMOT < ACSTall',
            Program_Line_553='set ACST = 25.72+ACSTtol',
            Program_Line_554='elseif PMOT > ACSTaul',
            Program_Line_555='set ACST = 27.89+ACSTtol',
            Program_Line_556='endif',
            Program_Line_557='elseif CAT==90',
            Program_Line_558='if PMOT < ACSTall',
            Program_Line_559='set ACST = 25.09+ACSTtol',
            Program_Line_560='elseif PMOT > ACSTaul',
            Program_Line_561='set ACST = 27.42+ACSTtol',
            Program_Line_562='endif',
            Program_Line_563='endif',
            Program_Line_564='endif',
            Program_Line_565='if (ComfStand == 7) && (ComfMod == 2)',
            Program_Line_566='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_567='set AHST = PMOT*0.54+12.83+AHSToffset+AHSTtol',
            Program_Line_568='elseif CAT==80',
            Program_Line_569='if PMOT < AHSTall',
            Program_Line_570='set AHST = 20.1+AHSTtol',
            Program_Line_571='elseif PMOT > AHSTaul',
            Program_Line_572='set AHST = 23.78+AHSTtol',
            Program_Line_573='endif',
            Program_Line_574='elseif CAT==85',
            Program_Line_575='if PMOT < AHSTall',
            Program_Line_576='set AHST = 20.77+AHSTtol',
            Program_Line_577='elseif PMOT > AHSTaul',
            Program_Line_578='set AHST = 24.26+AHSTtol',
            Program_Line_579='endif',
            Program_Line_580='elseif CAT==90',
            Program_Line_581='if PMOT < AHSTall',
            Program_Line_582='set AHST = 21.44+AHSTtol',
            Program_Line_583='elseif PMOT > AHSTaul',
            Program_Line_584='set AHST = 24.74+AHSTtol',
            Program_Line_585='endif',
            Program_Line_586='endif',
            Program_Line_587='endif',
            Program_Line_588='if (ComfStand == 7) && (ComfMod == 3)',
            Program_Line_589='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_590='set ACST = PMOT*0.54+12.83+ACSToffset+ACSTtol',
            Program_Line_591='elseif PMOT < ACSTall',
            Program_Line_592='set ACST = ACSTall*0.54+12.83+ACSToffset+ACSTtol',
            Program_Line_593='elseif PMOT > ACSTaul',
            Program_Line_594='set ACST = ACSTaul*0.54+12.83+ACSToffset+ACSTtol',
            Program_Line_595='endif',
            Program_Line_596='endif',
            Program_Line_597='if (ComfStand == 7) && (ComfMod == 3)',
            Program_Line_598='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_599='set AHST = PMOT*0.54+12.83+AHSToffset+AHSTtol',
            Program_Line_600='elseif PMOT < AHSTall',
            Program_Line_601='set AHST = AHSTall*0.54+12.83+AHSToffset+AHSTtol',
            Program_Line_602='elseif PMOT > AHSTaul',
            Program_Line_603='set AHST = AHSTaul*0.54+12.83+AHSToffset+AHSTtol',
            Program_Line_604='endif',
            Program_Line_605='endif',
            Program_Line_606='if (ComfStand == 8) && (ComfMod == 1)',
            Program_Line_607='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_608='set ACST = PMOT*0.28+17.87+ACSToffset+ACSTtol',
            Program_Line_609='else',
            Program_Line_610='if CAT==80',
            Program_Line_611='set ACST = PMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_612='elseif CAT==85',
            Program_Line_613='set ACST = PMOT*0.078+23.25+2.11+ACSTtol',
            Program_Line_614='elseif CAT==90',
            Program_Line_615='set ACST = PMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_616='endif',
            Program_Line_617='endif',
            Program_Line_618='endif',
            Program_Line_619='if (ComfStand == 8) && (ComfMod == 1)',
            Program_Line_620='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_621='set AHST = PMOT*0.28+17.87+AHSToffset+AHSTtol',
            Program_Line_622='else',
            Program_Line_623='if CAT==80',
            Program_Line_624='set AHST = PMOT*0.078+23.25-2.72+AHSTtol',
            Program_Line_625='elseif CAT==85',
            Program_Line_626='set AHST = PMOT*0.078+23.25-2.11+AHSTtol',
            Program_Line_627='elseif CAT==90',
            Program_Line_628='set AHST = PMOT*0.078+23.25-1.5+AHSTtol',
            Program_Line_629='endif',
            Program_Line_630='endif',
            Program_Line_631='endif',
            Program_Line_632='if (ComfStand == 8) && (ComfMod == 2)',
            Program_Line_633='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_634='set ACST = PMOT*0.28+17.87+ACSToffset+ACSTtol',
            Program_Line_635='elseif CAT==80',
            Program_Line_636='if PMOT < ACSTall',
            Program_Line_637='set ACST = 26.35+ACSTtol',
            Program_Line_638='elseif PMOT > ACSTaul',
            Program_Line_639='set ACST = 28.35+ACSTtol',
            Program_Line_640='endif',
            Program_Line_641='elseif CAT==85',
            Program_Line_642='if PMOT < ACSTall',
            Program_Line_643='set ACST = 25.72+ACSTtol',
            Program_Line_644='elseif PMOT > ACSTaul',
            Program_Line_645='set ACST = 27.89+ACSTtol',
            Program_Line_646='endif',
            Program_Line_647='elseif CAT==90',
            Program_Line_648='if PMOT < ACSTall',
            Program_Line_649='set ACST = 25.09+ACSTtol',
            Program_Line_650='elseif PMOT > ACSTaul',
            Program_Line_651='set ACST = 27.42+ACSTtol',
            Program_Line_652='endif',
            Program_Line_653='endif',
            Program_Line_654='endif',
            Program_Line_655='if (ComfStand == 8) && (ComfMod == 2)',
            Program_Line_656='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_657='set AHST = PMOT*0.28+17.87+AHSToffset+AHSTtol',
            Program_Line_658='elseif CAT==80',
            Program_Line_659='if PMOT < AHSTall',
            Program_Line_660='set AHST = 20.1+AHSTtol',
            Program_Line_661='elseif PMOT > AHSTaul',
            Program_Line_662='set AHST = 23.78+AHSTtol',
            Program_Line_663='endif',
            Program_Line_664='elseif CAT==85',
            Program_Line_665='if PMOT < AHSTall',
            Program_Line_666='set AHST = 20.77+AHSTtol',
            Program_Line_667='elseif PMOT > AHSTaul',
            Program_Line_668='set AHST = 24.26+AHSTtol',
            Program_Line_669='endif',
            Program_Line_670='elseif CAT==90',
            Program_Line_671='if PMOT < AHSTall',
            Program_Line_672='set AHST = 21.44+AHSTtol',
            Program_Line_673='elseif PMOT > AHSTaul',
            Program_Line_674='set AHST = 24.74+AHSTtol',
            Program_Line_675='endif',
            Program_Line_676='endif',
            Program_Line_677='endif',
            Program_Line_678='if (ComfStand == 8) && (ComfMod == 3)',
            Program_Line_679='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_680='set ACST = PMOT*0.28+17.87+ACSToffset+ACSTtol',
            Program_Line_681='elseif PMOT < ACSTall',
            Program_Line_682='set ACST = ACSTall*0.28+17.87+ACSToffset+ACSTtol',
            Program_Line_683='elseif PMOT > ACSTaul',
            Program_Line_684='set ACST = ACSTaul*0.28+17.87+ACSToffset+ACSTtol',
            Program_Line_685='endif',
            Program_Line_686='endif',
            Program_Line_687='if (ComfStand == 8) && (ComfMod == 3)',
            Program_Line_688='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_689='set AHST = PMOT*0.28+17.87+AHSToffset+AHSTtol',
            Program_Line_690='elseif PMOT < AHSTall',
            Program_Line_691='set AHST = AHSTall*0.28+17.87+AHSToffset+AHSTtol',
            Program_Line_692='elseif PMOT > AHSTaul',
            Program_Line_693='set AHST = AHSTaul*0.28+17.87+AHSToffset+AHSTtol',
            Program_Line_694='endif',
            Program_Line_695='endif',
            Program_Line_696='if (ComfStand == 9) && (ComfMod == 1)',
            Program_Line_697='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_698='set ACST = PMOT*0.39+18.42+ACSToffset+ACSTtol',
            Program_Line_699='else',
            Program_Line_700='if CAT==80',
            Program_Line_701='set ACST = PMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_702='elseif CAT==90',
            Program_Line_703='set ACST = PMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_704='endif',
            Program_Line_705='endif',
            Program_Line_706='endif',
            Program_Line_707='if (ComfStand == 9) && (ComfMod == 1)',
            Program_Line_708='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_709='set AHST = PMOT*0.39+18.42+AHSToffset+AHSTtol',
            Program_Line_710='else',
            Program_Line_711='if CAT==80',
            Program_Line_712='set AHST = PMOT*0.078+23.25+2.72+AHSTtol',
            Program_Line_713='elseif CAT==90',
            Program_Line_714='set AHST = PMOT*0.078+23.25+1.5+AHSTtol',
            Program_Line_715='endif',
            Program_Line_716='endif',
            Program_Line_717='endif',
            Program_Line_718='if (ComfStand == 9) && (ComfMod == 2)',
            Program_Line_719='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_720='set ACST = PMOT*0.39+18.42+ACSToffset+ACSTtol',
            Program_Line_721='elseif CAT==80',
            Program_Line_722='if PMOT < ACSTall',
            Program_Line_723='set ACST = 26.35+ACSTtol',
            Program_Line_724='elseif PMOT > ACSTaul',
            Program_Line_725='set ACST = 28.35+ACSTtol',
            Program_Line_726='endif',
            Program_Line_727='elseif CAT==90',
            Program_Line_728='if PMOT < ACSTall',
            Program_Line_729='set ACST = 25.09+ACSTtol',
            Program_Line_730='elseif PMOT > ACSTaul',
            Program_Line_731='set ACST = 27.42+ACSTtol',
            Program_Line_732='endif',
            Program_Line_733='endif',
            Program_Line_734='endif',
            Program_Line_735='if (ComfStand == 9) && (ComfMod == 2)',
            Program_Line_736='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_737='set AHST = PMOT*0.39+18.42+AHSToffset+AHSTtol',
            Program_Line_738='elseif CAT==80',
            Program_Line_739='if PMOT < AHSTall',
            Program_Line_740='set AHST = 20.1+AHSTtol',
            Program_Line_741='elseif PMOT > AHSTaul',
            Program_Line_742='set AHST = 23.78+AHSTtol',
            Program_Line_743='endif',
            Program_Line_744='elseif CAT==90',
            Program_Line_745='if PMOT < AHSTall',
            Program_Line_746='set AHST = 21.44+AHSTtol',
            Program_Line_747='elseif PMOT > AHSTaul',
            Program_Line_748='set AHST = 24.74+AHSTtol',
            Program_Line_749='endif',
            Program_Line_750='endif',
            Program_Line_751='endif',
            Program_Line_752='if (ComfStand == 9) && (ComfMod == 3)',
            Program_Line_753='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_754='set ACST = PMOT*0.39+18.42+ACSToffset+ACSTtol',
            Program_Line_755='elseif PMOT < ACSTall',
            Program_Line_756='set ACST = ACSTall*0.39+18.42+ACSToffset+ACSTtol',
            Program_Line_757='elseif PMOT > ACSTaul',
            Program_Line_758='set ACST = ACSTaul*0.39+18.42+ACSToffset+ACSTtol',
            Program_Line_759='endif',
            Program_Line_760='endif',
            Program_Line_761='if (ComfStand == 9) && (ComfMod == 3)',
            Program_Line_762='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_763='set AHST = PMOT*0.39+18.42+AHSToffset+AHSTtol',
            Program_Line_764='elseif PMOT < AHSTall',
            Program_Line_765='set AHST = AHSTall*0.39+18.42+AHSToffset+AHSTtol',
            Program_Line_766='elseif PMOT > AHSTaul',
            Program_Line_767='set AHST = AHSTaul*0.39+18.42+AHSToffset+AHSTtol',
            Program_Line_768='endif',
            Program_Line_769='endif',
            Program_Line_770='!when the model is not applicable, PMOT should be used instead of RMO',
            Program_Line_771='if (ComfStand == 10) && (ComfMod == 1)',
            Program_Line_772='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_773='set ACST = RMOT*0.42+17.6+ACSToffset+ACSTtol',
            Program_Line_774='else',
            Program_Line_775='if CAT==80',
            Program_Line_776='set ACST = RMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_777='elseif CAT==90',
            Program_Line_778='set ACST = RMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_779='endif',
            Program_Line_780='endif',
            Program_Line_781='endif',
            Program_Line_782='if (ComfStand == 10) && (ComfMod == 1)',
            Program_Line_783='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_784='set AHST = RMOT*0.42+17.6+AHSToffset+AHSTtol',
            Program_Line_785='else',
            Program_Line_786='if CAT==80',
            Program_Line_787='set AHST = RMOT*0.078+23.25-2.72+AHSTtol',
            Program_Line_788='elseif CAT==90',
            Program_Line_789='set AHST = RMOT*0.078+23.25-1.5+AHSTtol',
            Program_Line_790='endif',
            Program_Line_791='endif',
            Program_Line_792='endif',
            Program_Line_793='if (ComfStand == 10) && (ComfMod == 2)',
            Program_Line_794='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_795='set ACST = RMOT*0.42+17.6+ACSToffset+ACSTtol',
            Program_Line_796='elseif CAT==80',
            Program_Line_797='if RMOT < ACSTall',
            Program_Line_798='set ACST = 26.35+ACSTtol',
            Program_Line_799='elseif RMOT > ACSTaul',
            Program_Line_800='set ACST = 28.35+ACSTtol',
            Program_Line_801='endif',
            Program_Line_802='elseif CAT==90',
            Program_Line_803='if RMOT < ACSTall',
            Program_Line_804='set ACST = 25.09+ACSTtol',
            Program_Line_805='elseif RMOT > ACSTaul',
            Program_Line_806='set ACST = 27.42+ACSTtol',
            Program_Line_807='endif',
            Program_Line_808='endif',
            Program_Line_809='endif',
            Program_Line_810='if (ComfStand == 10) && (ComfMod == 2)',
            Program_Line_811='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_812='set AHST = RMOT*0.42+17.6+AHSToffset+AHSTtol',
            Program_Line_813='elseif CAT==80',
            Program_Line_814='if RMOT < AHSTall',
            Program_Line_815='set AHST = 20.1+AHSTtol',
            Program_Line_816='elseif RMOT > AHSTaul',
            Program_Line_817='set AHST = 23.78+AHSTtol',
            Program_Line_818='endif',
            Program_Line_819='elseif CAT==90',
            Program_Line_820='if RMOT < AHSTall',
            Program_Line_821='set AHST = 21.44+AHSTtol',
            Program_Line_822='elseif RMOT > AHSTaul',
            Program_Line_823='set AHST = 24.74+AHSTtol',
            Program_Line_824='endif',
            Program_Line_825='endif',
            Program_Line_826='endif',
            Program_Line_827='if (ComfStand == 10) && (ComfMod == 3)',
            Program_Line_828='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_829='set ACST = RMOT*0.42+17.6+ACSToffset+ACSTtol',
            Program_Line_830='elseif RMOT < ACSTall',
            Program_Line_831='set ACST = ACSTall*0.42+17.6+ACSToffset+ACSTtol',
            Program_Line_832='elseif RMOT > ACSTaul',
            Program_Line_833='set ACST = ACSTaul*0.42+17.6+ACSToffset+ACSTtol',
            Program_Line_834='endif',
            Program_Line_835='endif',
            Program_Line_836='if (ComfStand == 10) && (ComfMod == 3)',
            Program_Line_837='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_838='set AHST = RMOT*0.42+17.6+AHSToffset+AHSTtol',
            Program_Line_839='elseif RMOT < AHSTall',
            Program_Line_840='set AHST = AHSTall*0.42+17.6+AHSToffset+AHSTtol',
            Program_Line_841='elseif RMOT > AHSTaul',
            Program_Line_842='set AHST = AHSTaul*0.42+17.6+AHSToffset+AHSTtol',
            Program_Line_843='endif',
            Program_Line_844='endif',
            Program_Line_845='if (ComfStand == 11) && (ComfMod == 1)',
            Program_Line_846='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_847='set ACST = PMOT*0.75+5.37+ACSToffset+ACSTtol',
            Program_Line_848='else',
            Program_Line_849='if CAT==80',
            Program_Line_850='set ACST = PMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_851='elseif CAT==90',
            Program_Line_852='set ACST = PMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_853='endif',
            Program_Line_854='endif',
            Program_Line_855='endif',
            Program_Line_856='if (ComfStand == 11) && (ComfMod == 1)',
            Program_Line_857='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_858='set AHST = PMOT*0.75+5.37+AHSToffset+AHSTtol',
            Program_Line_859='else',
            Program_Line_860='if CAT==80',
            Program_Line_861='set AHST = PMOT*0.078+23.25-2.72+AHSTtol',
            Program_Line_862='elseif CAT==90',
            Program_Line_863='set AHST = PMOT*0.078+23.25-1.5+AHSTtol',
            Program_Line_864='endif',
            Program_Line_865='endif',
            Program_Line_866='endif',
            Program_Line_867='if (ComfStand == 11) && (ComfMod == 2)',
            Program_Line_868='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_869='set ACST = PMOT*0.75+5.37+ACSToffset+ACSTtol',
            Program_Line_870='elseif CAT==80',
            Program_Line_871='if PMOT < ACSTall',
            Program_Line_872='set ACST = 26.35+ACSTtol',
            Program_Line_873='elseif PMOT > ACSTaul',
            Program_Line_874='set ACST = 28.35+ACSTtol',
            Program_Line_875='endif',
            Program_Line_876='elseif CAT==90',
            Program_Line_877='if PMOT < ACSTall',
            Program_Line_878='set ACST = 25.09+ACSTtol',
            Program_Line_879='elseif PMOT > ACSTaul',
            Program_Line_880='set ACST = 27.42+ACSTtol',
            Program_Line_881='endif',
            Program_Line_882='endif',
            Program_Line_883='endif',
            Program_Line_884='if (ComfStand == 11) && (ComfMod == 2)',
            Program_Line_885='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_886='set AHST = PMOT*0.75+5.37+AHSToffset+AHSTtol',
            Program_Line_887='elseif CAT==80',
            Program_Line_888='if PMOT < AHSTall',
            Program_Line_889='set AHST = 20.1+AHSTtol',
            Program_Line_890='elseif PMOT > AHSTaul',
            Program_Line_891='set AHST = 23.78+AHSTtol',
            Program_Line_892='endif',
            Program_Line_893='elseif CAT==90',
            Program_Line_894='if PMOT < AHSTall',
            Program_Line_895='set AHST = 21.44+AHSTtol',
            Program_Line_896='elseif PMOT > AHSTaul',
            Program_Line_897='set AHST = 24.74+AHSTtol',
            Program_Line_898='endif',
            Program_Line_899='endif',
            Program_Line_900='endif',
            Program_Line_901='if (ComfStand == 11) && (ComfMod == 3)',
            Program_Line_902='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_903='set ACST = PMOT*0.75+5.37+ACSToffset+ACSTtol',
            Program_Line_904='elseif PMOT < ACSTall',
            Program_Line_905='set ACST = ACSTall*0.75+5.37+ACSToffset+ACSTtol',
            Program_Line_906='elseif PMOT > ACSTaul',
            Program_Line_907='set ACST = ACSTaul*0.75+5.37+ACSToffset+ACSTtol',
            Program_Line_908='endif',
            Program_Line_909='endif',
            Program_Line_910='if (ComfStand == 11) && (ComfMod == 3)',
            Program_Line_911='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_912='set AHST = PMOT*0.75+5.37+AHSToffset+AHSTtol',
            Program_Line_913='elseif PMOT < AHSTall',
            Program_Line_914='set AHST = AHSTall*0.75+5.37+AHSToffset+AHSTtol',
            Program_Line_915='elseif PMOT > AHSTaul',
            Program_Line_916='set AHST = AHSTaul*0.75+5.37+AHSToffset+AHSTtol',
            Program_Line_917='endif',
            Program_Line_918='endif',
            Program_Line_919='if (ComfStand == 12) && (ComfMod == 0)',
            Program_Line_920='if (CAT==80)',
            Program_Line_921='set ACST = 27+ACSTtol',
            Program_Line_922='elseif (CAT==90)',
            Program_Line_923='set ACST = 25.5+ACSTtol',
            Program_Line_924='endif',
            Program_Line_925='endif',
            Program_Line_926='if (ComfStand == 12) && (ComfMod == 0)',
            Program_Line_927='if (CAT==80)',
            Program_Line_928='set AHST = 20+AHSTtol',
            Program_Line_929='elseif (CAT==90)',
            Program_Line_930='set AHST = 21.5+AHSTtol',
            Program_Line_931='endif',
            Program_Line_932='endif',
            Program_Line_933='if (ComfStand == 12) && (ComfMod == 1)',
            Program_Line_934='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_935='set ACST = PMOT*0.25+19.7+ACSToffset+ACSTtol',
            Program_Line_936='elseif CAT==80',
            Program_Line_937='if PMOT < ACSTall',
            Program_Line_938='set ACST = 27+ACSTtol',
            Program_Line_939='elseif PMOT > ACSTaul',
            Program_Line_940='set ACST = 27+ACSTtol',
            Program_Line_941='endif',
            Program_Line_942='elseif CAT==90',
            Program_Line_943='if PMOT < ACSTall',
            Program_Line_944='set ACST = 25.5+ACSTtol',
            Program_Line_945='elseif PMOT > ACSTaul',
            Program_Line_946='set ACST = 25.5+ACSTtol',
            Program_Line_947='endif',
            Program_Line_948='endif',
            Program_Line_949='endif',
            Program_Line_950='if (ComfStand == 12) && (ComfMod == 1)',
            Program_Line_951='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_952='set AHST = PMOT*0.25+19.7+AHSToffset+AHSTtol',
            Program_Line_953='elseif CAT==80',
            Program_Line_954='if PMOT < AHSTall',
            Program_Line_955='set AHST = 20+AHSTtol',
            Program_Line_956='elseif PMOT > AHSTaul',
            Program_Line_957='set AHST = 20+AHSTtol',
            Program_Line_958='endif',
            Program_Line_959='elseif CAT==90',
            Program_Line_960='if PMOT < AHSTall',
            Program_Line_961='set AHST = 21.5+AHSTtol',
            Program_Line_962='elseif PMOT > AHSTaul',
            Program_Line_963='set AHST = 21.5+AHSTtol',
            Program_Line_964='endif',
            Program_Line_965='endif',
            Program_Line_966='endif',
            Program_Line_967='if (ComfStand == 12) && (ComfMod == 2)',
            Program_Line_968='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_969='set ACST = PMOT*0.25+19.7+ACSToffset+ACSTtol',
            Program_Line_970='elseif CAT==80',
            Program_Line_971='if PMOT < ACSTall',
            Program_Line_972='set ACST = 26.35+ACSTtol',
            Program_Line_973='elseif PMOT > ACSTaul',
            Program_Line_974='set ACST = 28.35+ACSTtol',
            Program_Line_975='endif',
            Program_Line_976='elseif CAT==90',
            Program_Line_977='if PMOT < ACSTall',
            Program_Line_978='set ACST = 25.09+ACSTtol',
            Program_Line_979='elseif PMOT > ACSTaul',
            Program_Line_980='set ACST = 27.42+ACSTtol',
            Program_Line_981='endif',
            Program_Line_982='endif',
            Program_Line_983='endif',
            Program_Line_984='if (ComfStand == 12) && (ComfMod == 2)',
            Program_Line_985='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_986='set AHST = PMOT*0.25+19.7+AHSToffset+AHSTtol',
            Program_Line_987='elseif CAT==80',
            Program_Line_988='if PMOT < AHSTall',
            Program_Line_989='set AHST = 20.1+AHSTtol',
            Program_Line_990='elseif PMOT > AHSTaul',
            Program_Line_991='set AHST = 23.78+AHSTtol',
            Program_Line_992='endif',
            Program_Line_993='elseif CAT==90',
            Program_Line_994='if PMOT < AHSTall',
            Program_Line_995='set AHST = 21.44+AHSTtol',
            Program_Line_996='elseif PMOT > AHSTaul',
            Program_Line_997='set AHST = 24.74+AHSTtol',
            Program_Line_998='endif',
            Program_Line_999='endif',
            Program_Line_1000='endif',
            Program_Line_1001='if (ComfStand == 12) && (ComfMod == 3)',
            Program_Line_1002='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1003='set ACST = PMOT*0.25+19.7+ACSToffset+ACSTtol',
            Program_Line_1004='elseif PMOT < ACSTall',
            Program_Line_1005='set ACST = ACSTall*0.25+19.7+ACSToffset+ACSTtol',
            Program_Line_1006='elseif PMOT > ACSTaul',
            Program_Line_1007='set ACST = ACSTaul*0.25+19.7+ACSToffset+ACSTtol',
            Program_Line_1008='endif',
            Program_Line_1009='endif',
            Program_Line_1010='if (ComfStand == 12) && (ComfMod == 3)',
            Program_Line_1011='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1012='set AHST = PMOT*0.25+19.7+AHSToffset+AHSTtol',
            Program_Line_1013='elseif PMOT < AHSTall',
            Program_Line_1014='set AHST = AHSTall*0.25+19.7+AHSToffset+AHSTtol',
            Program_Line_1015='elseif PMOT > AHSTaul',
            Program_Line_1016='set AHST = AHSTaul*0.25+19.7+AHSToffset+AHSTtol',
            Program_Line_1017='endif',
            Program_Line_1018='endif',
            Program_Line_1019='if (ComfStand == 13) || (ComfStand == 14)',
            Program_Line_1020='if (ComfMod == 0)',
            Program_Line_1021='if (CAT==80)',
            Program_Line_1022='set ACST = 28+ACSTtol',
            Program_Line_1023='elseif (CAT==90)',
            Program_Line_1024='set ACST = 26+ACSTtol',
            Program_Line_1025='endif',
            Program_Line_1026='endif',
            Program_Line_1027='endif',
            Program_Line_1028='if (ComfStand == 13) || (ComfStand == 14)',
            Program_Line_1029='if (ComfMod == 0)',
            Program_Line_1030='if (CAT==80)',
            Program_Line_1031='set AHST = 20+AHSTtol',
            Program_Line_1032='elseif (CAT==90)',
            Program_Line_1033='set AHST = 21+AHSTtol',
            Program_Line_1034='endif',
            Program_Line_1035='endif',
            Program_Line_1036='endif',
            Program_Line_1037='if (ComfStand == 13) && (ComfMod == 1)',
            Program_Line_1038='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1039='set ACST = PMOT*0.26+15.9+ACSToffset+ACSTtol',
            Program_Line_1040='elseif CAT==80',
            Program_Line_1041='if PMOT < ACSTall',
            Program_Line_1042='set ACST = 28+ACSTtol',
            Program_Line_1043='elseif PMOT > ACSTaul',
            Program_Line_1044='set ACST = 28+ACSTtol',
            Program_Line_1045='endif',
            Program_Line_1046='elseif CAT==90',
            Program_Line_1047='if PMOT < ACSTall',
            Program_Line_1048='set ACST = 26+ACSTtol',
            Program_Line_1049='elseif PMOT > ACSTaul',
            Program_Line_1050='set ACST = 26+ACSTtol',
            Program_Line_1051='endif',
            Program_Line_1052='endif',
            Program_Line_1053='endif',
            Program_Line_1054='if (ComfStand == 13) && (ComfMod == 1)',
            Program_Line_1055='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1056='set AHST = PMOT*0.26+15.9+AHSToffset+AHSTtol',
            Program_Line_1057='elseif CAT==80',
            Program_Line_1058='if PMOT < AHSTall',
            Program_Line_1059='set AHST = 20+AHSTtol',
            Program_Line_1060='elseif PMOT > AHSTaul',
            Program_Line_1061='set AHST = 20+AHSTtol',
            Program_Line_1062='endif',
            Program_Line_1063='elseif CAT==90',
            Program_Line_1064='if PMOT < AHSTall',
            Program_Line_1065='set AHST = 21+AHSTtol',
            Program_Line_1066='elseif PMOT > AHSTaul',
            Program_Line_1067='set AHST = 21+AHSTtol',
            Program_Line_1068='endif',
            Program_Line_1069='endif',
            Program_Line_1070='endif',
            Program_Line_1071='if (ComfStand == 13) && (ComfMod == 2)',
            Program_Line_1072='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1073='set ACST = PMOT*0.26+15.9+ACSToffset+ACSTtol',
            Program_Line_1074='elseif CAT==80',
            Program_Line_1075='if PMOT < ACSTall',
            Program_Line_1076='set ACST = 26.35+ACSTtol',
            Program_Line_1077='elseif PMOT > ACSTaul',
            Program_Line_1078='set ACST = 28.35+ACSTtol',
            Program_Line_1079='endif',
            Program_Line_1080='elseif CAT==90',
            Program_Line_1081='if PMOT < ACSTall',
            Program_Line_1082='set ACST = 25.09+ACSTtol',
            Program_Line_1083='elseif PMOT > ACSTaul',
            Program_Line_1084='set ACST = 27.42+ACSTtol',
            Program_Line_1085='endif',
            Program_Line_1086='endif',
            Program_Line_1087='endif',
            Program_Line_1088='if (ComfStand == 13) && (ComfMod == 2)',
            Program_Line_1089='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1090='set AHST = PMOT*0.26+15.9+AHSToffset+AHSTtol',
            Program_Line_1091='elseif CAT==80',
            Program_Line_1092='if PMOT < AHSTall',
            Program_Line_1093='set AHST = 20.1+AHSTtol',
            Program_Line_1094='elseif PMOT > AHSTaul',
            Program_Line_1095='set AHST = 23.78+AHSTtol',
            Program_Line_1096='endif',
            Program_Line_1097='elseif CAT==90',
            Program_Line_1098='if PMOT < AHSTall',
            Program_Line_1099='set AHST = 21.44+AHSTtol',
            Program_Line_1100='elseif PMOT > AHSTaul',
            Program_Line_1101='set AHST = 24.74+AHSTtol',
            Program_Line_1102='endif',
            Program_Line_1103='endif',
            Program_Line_1104='endif',
            Program_Line_1105='if (ComfStand == 13) && (ComfMod == 3)',
            Program_Line_1106='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1107='set ACST = PMOT*0.26+15.9+ACSToffset+ACSTtol',
            Program_Line_1108='elseif PMOT < ACSTall',
            Program_Line_1109='set ACST = ACSTall*0.26+15.9+ACSToffset+ACSTtol',
            Program_Line_1110='elseif PMOT > ACSTaul',
            Program_Line_1111='set ACST = ACSTaul*0.26+15.9+ACSToffset+ACSTtol',
            Program_Line_1112='endif',
            Program_Line_1113='endif',
            Program_Line_1114='if (ComfStand == 13) && (ComfMod == 3)',
            Program_Line_1115='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1116='set AHST = PMOT*0.26+15.9+AHSToffset+AHSTtol',
            Program_Line_1117='elseif PMOT < AHSTall',
            Program_Line_1118='set AHST = AHSTall*0.26+15.9+AHSToffset+AHSTtol',
            Program_Line_1119='elseif PMOT > AHSTaul',
            Program_Line_1120='set AHST = AHSTaul*0.26+15.9+AHSToffset+AHSTtol',
            Program_Line_1121='endif',
            Program_Line_1122='endif',
            Program_Line_1123='if (ComfStand == 14) && (ComfMod == 1)',
            Program_Line_1124='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1125='set ACST = PMOT*0.26+16.75+ACSToffset+ACSTtol',
            Program_Line_1126='elseif CAT==80',
            Program_Line_1127='if PMOT < ACSTall',
            Program_Line_1128='set ACST = 28+ACSTtol',
            Program_Line_1129='elseif PMOT > ACSTaul',
            Program_Line_1130='set ACST = 28+ACSTtol',
            Program_Line_1131='endif',
            Program_Line_1132='elseif CAT==90',
            Program_Line_1133='if PMOT < ACSTall',
            Program_Line_1134='set ACST = 26+ACSTtol',
            Program_Line_1135='elseif PMOT > ACSTaul',
            Program_Line_1136='set ACST = 26+ACSTtol',
            Program_Line_1137='endif',
            Program_Line_1138='endif',
            Program_Line_1139='endif',
            Program_Line_1140='if (ComfStand == 14) && (ComfMod == 1)',
            Program_Line_1141='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1142='set AHST = PMOT*0.26+16.75+AHSToffset+AHSTtol',
            Program_Line_1143='elseif CAT==80',
            Program_Line_1144='if PMOT < AHSTall',
            Program_Line_1145='set AHST = 20+AHSTtol',
            Program_Line_1146='elseif PMOT > AHSTaul',
            Program_Line_1147='set AHST = 20+AHSTtol',
            Program_Line_1148='endif',
            Program_Line_1149='elseif CAT==90',
            Program_Line_1150='if PMOT < AHSTall',
            Program_Line_1151='set AHST = 21+AHSTtol',
            Program_Line_1152='elseif PMOT > AHSTaul',
            Program_Line_1153='set AHST = 21+AHSTtol',
            Program_Line_1154='endif',
            Program_Line_1155='endif',
            Program_Line_1156='endif',
            Program_Line_1157='if (ComfStand == 14) && (ComfMod == 2)',
            Program_Line_1158='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1159='set ACST = PMOT*0.26+16.75+ACSToffset+ACSTtol',
            Program_Line_1160='elseif CAT==80',
            Program_Line_1161='if PMOT < ACSTall',
            Program_Line_1162='set ACST = 26.35+ACSTtol',
            Program_Line_1163='elseif PMOT > ACSTaul',
            Program_Line_1164='set ACST = 28.35+ACSTtol',
            Program_Line_1165='endif',
            Program_Line_1166='elseif CAT==90',
            Program_Line_1167='if PMOT < ACSTall',
            Program_Line_1168='set ACST = 25.09+ACSTtol',
            Program_Line_1169='elseif PMOT > ACSTaul',
            Program_Line_1170='set ACST = 27.42+ACSTtol',
            Program_Line_1171='endif',
            Program_Line_1172='endif',
            Program_Line_1173='endif',
            Program_Line_1174='if (ComfStand == 14) && (ComfMod == 2)',
            Program_Line_1175='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1176='set AHST = PMOT*0.26+16.75+AHSToffset+AHSTtol',
            Program_Line_1177='elseif CAT==80',
            Program_Line_1178='if PMOT < AHSTall',
            Program_Line_1179='set AHST = 20.1+AHSTtol',
            Program_Line_1180='elseif PMOT > AHSTaul',
            Program_Line_1181='set AHST = 23.78+AHSTtol',
            Program_Line_1182='endif',
            Program_Line_1183='elseif CAT==90',
            Program_Line_1184='if PMOT < AHSTall',
            Program_Line_1185='set AHST = 21.44+AHSTtol',
            Program_Line_1186='elseif PMOT > AHSTaul',
            Program_Line_1187='set AHST = 24.74+AHSTtol',
            Program_Line_1188='endif',
            Program_Line_1189='endif',
            Program_Line_1190='endif',
            Program_Line_1191='if (ComfStand == 14) && (ComfMod == 3)',
            Program_Line_1192='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1193='set ACST = PMOT*0.26+16.75+ACSToffset+ACSTtol',
            Program_Line_1194='elseif PMOT < ACSTall',
            Program_Line_1195='set ACST = ACSTall*0.26+16.75+ACSToffset+ACSTtol',
            Program_Line_1196='elseif PMOT > ACSTaul',
            Program_Line_1197='set ACST = ACSTaul*0.26+16.75+ACSToffset+ACSTtol',
            Program_Line_1198='endif',
            Program_Line_1199='endif',
            Program_Line_1200='if (ComfStand == 14) && (ComfMod == 3)',
            Program_Line_1201='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1202='set AHST = PMOT*0.26+16.75+AHSToffset+AHSTtol',
            Program_Line_1203='elseif PMOT < AHSTall',
            Program_Line_1204='set AHST = AHSTall*0.26+16.75+AHSToffset+AHSTtol',
            Program_Line_1205='elseif PMOT > AHSTaul',
            Program_Line_1206='set AHST = AHSTaul*0.26+16.75+AHSToffset+AHSTtol',
            Program_Line_1207='endif',
            Program_Line_1208='endif',
            Program_Line_1209='if (ComfStand == 15) || (ComfStand == 16)',
            Program_Line_1210='if (ComfMod == 0)',
            Program_Line_1211='if (CAT==80)',
            Program_Line_1212='set ACST = 26+ACSTtol',
            Program_Line_1213='elseif (CAT==90)',
            Program_Line_1214='set ACST = 25+ACSTtol',
            Program_Line_1215='endif',
            Program_Line_1216='endif',
            Program_Line_1217='endif',
            Program_Line_1218='if (ComfStand == 15) || (ComfStand == 16)',
            Program_Line_1219='if (ComfMod == 0)',
            Program_Line_1220='if (CAT==80)',
            Program_Line_1221='set AHST = 22+AHSTtol',
            Program_Line_1222='elseif (CAT==90)',
            Program_Line_1223='set AHST = 23+AHSTtol',
            Program_Line_1224='endif',
            Program_Line_1225='endif',
            Program_Line_1226='endif',
            Program_Line_1227='if (ComfStand == 15) && (ComfMod == 1)',
            Program_Line_1228='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1229='set ACST = PMOT*0.56+12.74+ACSToffset+ACSTtol',
            Program_Line_1230='elseif CAT==80',
            Program_Line_1231='if PMOT < ACSTall',
            Program_Line_1232='set ACST = 26+ACSTtol',
            Program_Line_1233='elseif PMOT > ACSTaul',
            Program_Line_1234='set ACST = 26+ACSTtol',
            Program_Line_1235='endif',
            Program_Line_1236='elseif CAT==90',
            Program_Line_1237='if PMOT < ACSTall',
            Program_Line_1238='set ACST = 25+ACSTtol',
            Program_Line_1239='elseif PMOT > ACSTaul',
            Program_Line_1240='set ACST = 25+ACSTtol',
            Program_Line_1241='endif',
            Program_Line_1242='endif',
            Program_Line_1243='endif',
            Program_Line_1244='if (ComfStand == 15) && (ComfMod == 1)',
            Program_Line_1245='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1246='set AHST = PMOT*0.56+12.74+AHSToffset+AHSTtol',
            Program_Line_1247='elseif CAT==80',
            Program_Line_1248='if PMOT < AHSTall',
            Program_Line_1249='set AHST = 22+AHSTtol',
            Program_Line_1250='elseif PMOT > AHSTaul',
            Program_Line_1251='set AHST = 22+AHSTtol',
            Program_Line_1252='endif',
            Program_Line_1253='elseif CAT==90',
            Program_Line_1254='if PMOT < AHSTall',
            Program_Line_1255='set AHST = 23+AHSTtol',
            Program_Line_1256='elseif PMOT > AHSTaul',
            Program_Line_1257='set AHST = 23+AHSTtol',
            Program_Line_1258='endif',
            Program_Line_1259='endif',
            Program_Line_1260='endif',
            Program_Line_1261='if (ComfStand == 15) && (ComfMod == 2)',
            Program_Line_1262='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1263='set ACST = PMOT*0.56+12.74+ACSToffset+ACSTtol',
            Program_Line_1264='elseif CAT==80',
            Program_Line_1265='if PMOT < ACSTall',
            Program_Line_1266='set ACST = 26.35+ACSTtol',
            Program_Line_1267='elseif PMOT > ACSTaul',
            Program_Line_1268='set ACST = 28.35+ACSTtol',
            Program_Line_1269='endif',
            Program_Line_1270='elseif CAT==90',
            Program_Line_1271='if PMOT < ACSTall',
            Program_Line_1272='set ACST = 25.09+ACSTtol',
            Program_Line_1273='elseif PMOT > ACSTaul',
            Program_Line_1274='set ACST = 27.42+ACSTtol',
            Program_Line_1275='endif',
            Program_Line_1276='endif',
            Program_Line_1277='endif',
            Program_Line_1278='if (ComfStand == 15) && (ComfMod == 2)',
            Program_Line_1279='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1280='set AHST = PMOT*0.56+12.74+AHSToffset+AHSTtol',
            Program_Line_1281='elseif CAT==80',
            Program_Line_1282='if PMOT < AHSTall',
            Program_Line_1283='set AHST = 20.1+AHSTtol',
            Program_Line_1284='elseif PMOT > AHSTaul',
            Program_Line_1285='set AHST = 23.78+AHSTtol',
            Program_Line_1286='endif',
            Program_Line_1287='elseif CAT==90',
            Program_Line_1288='if PMOT < AHSTall',
            Program_Line_1289='set AHST = 21.44+AHSTtol',
            Program_Line_1290='elseif PMOT > AHSTaul',
            Program_Line_1291='set AHST = 24.74+AHSTtol',
            Program_Line_1292='endif',
            Program_Line_1293='endif',
            Program_Line_1294='endif',
            Program_Line_1295='if (ComfStand == 15) && (ComfMod == 3)',
            Program_Line_1296='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1297='set ACST = PMOT*0.56+12.74+ACSToffset+ACSTtol',
            Program_Line_1298='elseif PMOT < ACSTall',
            Program_Line_1299='set ACST = ACSTall*0.56+12.74+ACSToffset+ACSTtol',
            Program_Line_1300='elseif PMOT > ACSTaul',
            Program_Line_1301='set ACST = ACSTaul*0.56+12.74+ACSToffset+ACSTtol',
            Program_Line_1302='endif',
            Program_Line_1303='endif',
            Program_Line_1304='if (ComfStand == 15) && (ComfMod == 3)',
            Program_Line_1305='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1306='set AHST = PMOT*0.56+12.74+AHSToffset+AHSTtol',
            Program_Line_1307='elseif PMOT < AHSTall',
            Program_Line_1308='set AHST = AHSTall*0.56+12.74+AHSToffset+AHSTtol',
            Program_Line_1309='elseif PMOT > AHSTaul',
            Program_Line_1310='set AHST = AHSTaul*0.56+12.74+AHSToffset+AHSTtol',
            Program_Line_1311='endif',
            Program_Line_1312='endif',
            Program_Line_1313='if (ComfStand == 16) && (ComfMod == 1)',
            Program_Line_1314='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1315='set ACST = PMOT*0.09+22.32+ACSToffset+ACSTtol',
            Program_Line_1316='elseif CAT==80',
            Program_Line_1317='if PMOT < ACSTall',
            Program_Line_1318='set ACST = 26+ACSTtol',
            Program_Line_1319='elseif PMOT > ACSTaul',
            Program_Line_1320='set ACST = 26+ACSTtol',
            Program_Line_1321='endif',
            Program_Line_1322='elseif CAT==90',
            Program_Line_1323='if PMOT < ACSTall',
            Program_Line_1324='set ACST = 25+ACSTtol',
            Program_Line_1325='elseif PMOT > ACSTaul',
            Program_Line_1326='set ACST = 25+ACSTtol',
            Program_Line_1327='endif',
            Program_Line_1328='endif',
            Program_Line_1329='endif',
            Program_Line_1330='if (ComfStand == 16) && (ComfMod == 1)',
            Program_Line_1331='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1332='set AHST = PMOT*0.09+22.32+AHSToffset+AHSTtol',
            Program_Line_1333='elseif CAT==80',
            Program_Line_1334='if PMOT < AHSTall',
            Program_Line_1335='set AHST = 22+AHSTtol',
            Program_Line_1336='elseif PMOT > AHSTaul',
            Program_Line_1337='set AHST = 22+AHSTtol',
            Program_Line_1338='endif',
            Program_Line_1339='elseif CAT==90',
            Program_Line_1340='if PMOT < AHSTall',
            Program_Line_1341='set AHST = 23+AHSTtol',
            Program_Line_1342='elseif PMOT > AHSTaul',
            Program_Line_1343='set AHST = 23+AHSTtol',
            Program_Line_1344='endif',
            Program_Line_1345='endif',
            Program_Line_1346='endif',
            Program_Line_1347='if (ComfStand == 16) && (ComfMod == 2)',
            Program_Line_1348='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1349='set ACST = PMOT*0.09+22.32+ACSToffset+ACSTtol',
            Program_Line_1350='elseif CAT==80',
            Program_Line_1351='if PMOT < ACSTall',
            Program_Line_1352='set ACST = 26.35+ACSTtol',
            Program_Line_1353='elseif PMOT > ACSTaul',
            Program_Line_1354='set ACST = 28.35+ACSTtol',
            Program_Line_1355='endif',
            Program_Line_1356='elseif CAT==90',
            Program_Line_1357='if PMOT < ACSTall',
            Program_Line_1358='set ACST = 25.09+ACSTtol',
            Program_Line_1359='elseif PMOT > ACSTaul',
            Program_Line_1360='set ACST = 27.42+ACSTtol',
            Program_Line_1361='endif',
            Program_Line_1362='endif',
            Program_Line_1363='endif',
            Program_Line_1364='if (ComfStand == 16) && (ComfMod == 2)',
            Program_Line_1365='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1366='set AHST = PMOT*0.09+22.32+AHSToffset+AHSTtol',
            Program_Line_1367='elseif CAT==80',
            Program_Line_1368='if PMOT < AHSTall',
            Program_Line_1369='set AHST = 20.1+AHSTtol',
            Program_Line_1370='elseif PMOT > AHSTaul',
            Program_Line_1371='set AHST = 23.78+AHSTtol',
            Program_Line_1372='endif',
            Program_Line_1373='elseif CAT==90',
            Program_Line_1374='if PMOT < AHSTall',
            Program_Line_1375='set AHST = 21.44+AHSTtol',
            Program_Line_1376='elseif PMOT > AHSTaul',
            Program_Line_1377='set AHST = 24.74+AHSTtol',
            Program_Line_1378='endif',
            Program_Line_1379='endif',
            Program_Line_1380='endif',
            Program_Line_1381='if (ComfStand == 16) && (ComfMod == 3)',
            Program_Line_1382='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1383='set ACST = PMOT*0.09+22.32+ACSToffset+ACSTtol',
            Program_Line_1384='elseif PMOT < ACSTall',
            Program_Line_1385='set ACST = ACSTall*0.09+22.32+ACSToffset+ACSTtol',
            Program_Line_1386='elseif PMOT > ACSTaul',
            Program_Line_1387='set ACST = ACSTaul*0.09+22.32+ACSToffset+ACSTtol',
            Program_Line_1388='endif',
            Program_Line_1389='endif',
            Program_Line_1390='if (ComfStand == 16) && (ComfMod == 3)',
            Program_Line_1391='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1392='set AHST = PMOT*0.09+22.32+AHSToffset+AHSTtol',
            Program_Line_1393='elseif PMOT < AHSTall',
            Program_Line_1394='set AHST = AHSTall*0.09+22.32+AHSToffset+AHSTtol',
            Program_Line_1395='elseif PMOT > AHSTaul',
            Program_Line_1396='set AHST = AHSTaul*0.09+22.32+AHSToffset+AHSTtol',
            Program_Line_1397='endif',
            Program_Line_1398='endif',
            Program_Line_1399='if (ComfStand == 17) || (ComfStand == 18) || (ComfStand == 19) || (ComfStand == 20)',
            Program_Line_1400='if ComfMod == 0',
            Program_Line_1401='set ACST = 25+ACSTtol',
            Program_Line_1402='set AHST = 20+AHSTtol',
            Program_Line_1403='endif',
            Program_Line_1404='endif',
            Program_Line_1405='if (ComfStand == 17) && (ComfMod == 1)',
            Program_Line_1406='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1407='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1408='set ACST = PMOT*0.48+13.9+ACSToffset+ACSTtol',
            Program_Line_1409='else',
            Program_Line_1410='set ACST = 25+ACSTtol',
            Program_Line_1411='endif',
            Program_Line_1412='else',
            Program_Line_1413='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1414='set ACST = PMOT*0.59+9.6+ACSToffset+ACSTtol',
            Program_Line_1415='else',
            Program_Line_1416='set ACST = 25+ACSTtol',
            Program_Line_1417='endif',
            Program_Line_1418='endif',
            Program_Line_1419='endif',
            Program_Line_1420='if (ComfStand == 17) && (ComfMod == 1)',
            Program_Line_1421='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1422='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1423='set AHST = PMOT*0.48+13.9+AHSToffset+AHSTtol',
            Program_Line_1424='else',
            Program_Line_1425='set AHST = 20+AHSTtol',
            Program_Line_1426='endif',
            Program_Line_1427='else',
            Program_Line_1428='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1429='set AHST = PMOT*0.59+9.6+AHSToffset+AHSTtol',
            Program_Line_1430='else',
            Program_Line_1431='set AHST = 20+AHSTtol',
            Program_Line_1432='endif',
            Program_Line_1433='endif',
            Program_Line_1434='endif',
            Program_Line_1435='if (ComfStand == 17) && (ComfMod == 2)',
            Program_Line_1436='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1437='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1438='set ACST = PMOT*0.48+13.9+ACSToffset+ACSTtol',
            Program_Line_1439='elseif PMOT < ACSTall',
            Program_Line_1440='if CAT == 90',
            Program_Line_1441='set ACST = 23+ACSTtol',
            Program_Line_1442='elseif CAT == 80',
            Program_Line_1443='set ACST = 23+ACSTtol',
            Program_Line_1444='endif',
            Program_Line_1445='elseif PMOT > ACSTaul',
            Program_Line_1446='if CAT == 90',
            Program_Line_1447='set ACST = 24+ACSTtol',
            Program_Line_1448='elseif CAT == 80',
            Program_Line_1449='set ACST = 25+ACSTtol',
            Program_Line_1450='endif',
            Program_Line_1451='endif',
            Program_Line_1452='else',
            Program_Line_1453='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1454='set ACST = PMOT*0.59+9.6+ACSToffset+ACSTtol',
            Program_Line_1455='elseif PMOT < ACSTall',
            Program_Line_1456='if CAT == 90',
            Program_Line_1457='set ACST = 23+ACSTtol',
            Program_Line_1458='elseif CAT == 80',
            Program_Line_1459='set ACST = 23+ACSTtol',
            Program_Line_1460='endif',
            Program_Line_1461='elseif PMOT > ACSTaul',
            Program_Line_1462='if CAT == 90',
            Program_Line_1463='set ACST = 24+ACSTtol',
            Program_Line_1464='elseif CAT == 80',
            Program_Line_1465='set ACST = 25+ACSTtol',
            Program_Line_1466='endif',
            Program_Line_1467='endif',
            Program_Line_1468='endif',
            Program_Line_1469='endif',
            Program_Line_1470='if (ComfStand == 17) && (ComfMod == 2)',
            Program_Line_1471='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1472='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1473='set AHST = PMOT*0.48+13.9+AHSToffset+AHSTtol',
            Program_Line_1474='elseif PMOT < AHSTall',
            Program_Line_1475='if CAT == 90',
            Program_Line_1476='set AHST = 20+AHSTtol',
            Program_Line_1477='elseif CAT == 80',
            Program_Line_1478='set AHST = 19+AHSTtol',
            Program_Line_1479='endif',
            Program_Line_1480='elseif PMOT > AHSTaul',
            Program_Line_1481='if CAT == 90',
            Program_Line_1482='set AHST = 23+AHSTtol',
            Program_Line_1483='elseif CAT == 80',
            Program_Line_1484='set AHST = 22+AHSTtol',
            Program_Line_1485='endif',
            Program_Line_1486='endif',
            Program_Line_1487='else',
            Program_Line_1488='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1489='set AHST = PMOT*0.59+9.6+AHSToffset+AHSTtol',
            Program_Line_1490='elseif PMOT < AHSTall',
            Program_Line_1491='if CAT == 90',
            Program_Line_1492='set AHST = 20+AHSTtol',
            Program_Line_1493='elseif CAT == 80',
            Program_Line_1494='set AHST = 19+AHSTtol',
            Program_Line_1495='endif',
            Program_Line_1496='elseif PMOT > AHSTaul',
            Program_Line_1497='if CAT == 90',
            Program_Line_1498='set AHST = 23+AHSTtol',
            Program_Line_1499='elseif CAT == 80',
            Program_Line_1500='set AHST = 22+AHSTtol',
            Program_Line_1501='endif',
            Program_Line_1502='endif',
            Program_Line_1503='endif',
            Program_Line_1504='endif',
            Program_Line_1505='if (ComfStand == 17) && (ComfMod == 3)',
            Program_Line_1506='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1507='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1508='set ACST = PMOT*0.48+13.9+ACSToffset+ACSTtol',
            Program_Line_1509='elseif PMOT < ACSTall',
            Program_Line_1510='set ACST = ACSTall*0.48+13.9+ACSToffset+ACSTtol',
            Program_Line_1511='elseif PMOT > ACSTaul',
            Program_Line_1512='set ACST = ACSTaul*0.48+13.9+ACSToffset+ACSTtol',
            Program_Line_1513='endif',
            Program_Line_1514='else',
            Program_Line_1515='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1516='set ACST = PMOT*0.59+9.6+ACSToffset+ACSTtol',
            Program_Line_1517='elseif PMOT < ACSTall',
            Program_Line_1518='set ACST = ACSTall*0.59+9.6+ACSToffset+ACSTtol',
            Program_Line_1519='elseif PMOT > ACSTaul',
            Program_Line_1520='set ACST = ACSTaul*0.59+9.6+ACSToffset+ACSTtol',
            Program_Line_1521='endif',
            Program_Line_1522='endif',
            Program_Line_1523='endif',
            Program_Line_1524='if (ComfStand == 17) && (ComfMod == 3)',
            Program_Line_1525='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1526='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1527='set AHST = PMOT*0.48+13.9+AHSToffset+AHSTtol',
            Program_Line_1528='elseif PMOT < AHSTall',
            Program_Line_1529='set AHST = AHSTall*0.48+13.9+AHSToffset+AHSTtol',
            Program_Line_1530='elseif PMOT > AHSTaul',
            Program_Line_1531='set AHST = AHSTaul*0.48+13.9+AHSToffset+AHSTtol',
            Program_Line_1532='endif',
            Program_Line_1533='else',
            Program_Line_1534='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1535='set AHST = PMOT*0.59+9.6+AHSToffset+AHSTtol',
            Program_Line_1536='elseif PMOT < AHSTall',
            Program_Line_1537='set AHST = AHSTall*0.59+9.6+AHSToffset+AHSTtol',
            Program_Line_1538='elseif PMOT > AHSTaul',
            Program_Line_1539='set AHST = AHSTaul*0.59+9.6+AHSToffset+AHSTtol',
            Program_Line_1540='endif',
            Program_Line_1541='endif',
            Program_Line_1542='endif',
            Program_Line_1543='if (ComfStand == 18) && (ComfMod == 1)',
            Program_Line_1544='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1545='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1546='set ACST = PMOT*0.84+5.3+ACSToffset+ACSTtol',
            Program_Line_1547='else',
            Program_Line_1548='set ACST = 25+ACSTtol',
            Program_Line_1549='endif',
            Program_Line_1550='else',
            Program_Line_1551='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1552='set ACST = PMOT*0.96-3.6+ACSToffset+ACSTtol',
            Program_Line_1553='else',
            Program_Line_1554='set ACST = 25+ACSTtol',
            Program_Line_1555='endif',
            Program_Line_1556='endif',
            Program_Line_1557='endif',
            Program_Line_1558='if (ComfStand == 18) && (ComfMod == 1)',
            Program_Line_1559='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1560='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1561='set AHST = PMOT*0.84+5.3+AHSToffset+AHSTtol',
            Program_Line_1562='else',
            Program_Line_1563='set AHST = 20+AHSTtol',
            Program_Line_1564='endif',
            Program_Line_1565='else',
            Program_Line_1566='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1567='set AHST = PMOT*0.96-3.6+AHSToffset+AHSTtol',
            Program_Line_1568='else',
            Program_Line_1569='set AHST = 20+AHSTtol',
            Program_Line_1570='endif',
            Program_Line_1571='endif',
            Program_Line_1572='endif',
            Program_Line_1573='if (ComfStand == 18) && (ComfMod == 2)',
            Program_Line_1574='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1575='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1576='set ACST = PMOT*0.84+5.3+ACSToffset+ACSTtol',
            Program_Line_1577='elseif PMOT < ACSTall',
            Program_Line_1578='if CAT == 90',
            Program_Line_1579='set ACST = 23+ACSTtol',
            Program_Line_1580='elseif CAT == 80',
            Program_Line_1581='set ACST = 23+ACSTtol',
            Program_Line_1582='endif',
            Program_Line_1583='elseif PMOT > ACSTaul',
            Program_Line_1584='if CAT == 90',
            Program_Line_1585='set ACST = 24+ACSTtol',
            Program_Line_1586='elseif CAT == 80',
            Program_Line_1587='set ACST = 25+ACSTtol',
            Program_Line_1588='endif',
            Program_Line_1589='endif',
            Program_Line_1590='else',
            Program_Line_1591='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1592='set ACST = PMOT*0.96-3.6+ACSToffset+ACSTtol',
            Program_Line_1593='elseif PMOT < ACSTall',
            Program_Line_1594='if CAT == 90',
            Program_Line_1595='set ACST = 23+ACSTtol',
            Program_Line_1596='elseif CAT == 80',
            Program_Line_1597='set ACST = 23+ACSTtol',
            Program_Line_1598='endif',
            Program_Line_1599='elseif PMOT > ACSTaul',
            Program_Line_1600='if CAT == 90',
            Program_Line_1601='set ACST = 24+ACSTtol',
            Program_Line_1602='elseif CAT == 80',
            Program_Line_1603='set ACST = 25+ACSTtol',
            Program_Line_1604='endif',
            Program_Line_1605='endif',
            Program_Line_1606='endif',
            Program_Line_1607='endif',
            Program_Line_1608='if (ComfStand == 18) && (ComfMod == 2)',
            Program_Line_1609='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1610='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1611='set AHST = PMOT*0.84+5.3+AHSToffset+AHSTtol',
            Program_Line_1612='elseif PMOT < AHSTall',
            Program_Line_1613='if CAT == 90',
            Program_Line_1614='set AHST = 20+AHSTtol',
            Program_Line_1615='elseif CAT == 80',
            Program_Line_1616='set AHST = 19+AHSTtol',
            Program_Line_1617='endif',
            Program_Line_1618='elseif PMOT > AHSTaul',
            Program_Line_1619='if CAT == 90',
            Program_Line_1620='set AHST = 23+AHSTtol',
            Program_Line_1621='elseif CAT == 80',
            Program_Line_1622='set AHST = 22+AHSTtol',
            Program_Line_1623='endif',
            Program_Line_1624='endif',
            Program_Line_1625='else',
            Program_Line_1626='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1627='set AHST = PMOT*0.96-3.6+AHSToffset+AHSTtol',
            Program_Line_1628='elseif PMOT < AHSTall',
            Program_Line_1629='if CAT == 90',
            Program_Line_1630='set AHST = 20+AHSTtol',
            Program_Line_1631='elseif CAT == 80',
            Program_Line_1632='set AHST = 19+AHSTtol',
            Program_Line_1633='endif',
            Program_Line_1634='elseif PMOT > AHSTaul',
            Program_Line_1635='if CAT == 90',
            Program_Line_1636='set AHST = 23+AHSTtol',
            Program_Line_1637='elseif CAT == 80',
            Program_Line_1638='set AHST = 22+AHSTtol',
            Program_Line_1639='endif',
            Program_Line_1640='endif',
            Program_Line_1641='endif',
            Program_Line_1642='endif',
            Program_Line_1643='if (ComfStand == 18) && (ComfMod == 3)',
            Program_Line_1644='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1645='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1646='set ACST = PMOT*0.84+5.3+ACSToffset+ACSTtol',
            Program_Line_1647='elseif PMOT < ACSTall',
            Program_Line_1648='set ACST = ACSTall*0.84+5.3+ACSToffset+ACSTtol',
            Program_Line_1649='elseif PMOT > ACSTaul',
            Program_Line_1650='set ACST = ACSTaul*0.84+5.3+ACSToffset+ACSTtol',
            Program_Line_1651='endif',
            Program_Line_1652='else',
            Program_Line_1653='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1654='set ACST = PMOT*0.96-3.6+ACSToffset+ACSTtol',
            Program_Line_1655='elseif PMOT < ACSTall',
            Program_Line_1656='set ACST = ACSTall*0.96-3.6+ACSToffset+ACSTtol',
            Program_Line_1657='elseif PMOT > ACSTaul',
            Program_Line_1658='set ACST = ACSTaul*0.96-3.6+ACSToffset+ACSTtol',
            Program_Line_1659='endif',
            Program_Line_1660='endif',
            Program_Line_1661='endif',
            Program_Line_1662='if (ComfStand == 18) && (ComfMod == 3)',
            Program_Line_1663='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1664='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1665='set AHST = PMOT*0.84+5.3+AHSToffset+AHSTtol',
            Program_Line_1666='elseif PMOT < AHSTall',
            Program_Line_1667='set AHST = AHSTall*0.84+5.3+AHSToffset+AHSTtol',
            Program_Line_1668='elseif PMOT > AHSTaul',
            Program_Line_1669='set AHST = AHSTaul*0.84+5.3+AHSToffset+AHSTtol',
            Program_Line_1670='endif',
            Program_Line_1671='else',
            Program_Line_1672='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1673='set AHST = PMOT*0.96-3.6+AHSToffset+AHSTtol',
            Program_Line_1674='elseif PMOT < AHSTall',
            Program_Line_1675='set AHST = AHSTall*0.96-3.6+AHSToffset+AHSTtol',
            Program_Line_1676='elseif PMOT > AHSTaul',
            Program_Line_1677='set AHST = AHSTaul*0.96-3.6+AHSToffset+AHSTtol',
            Program_Line_1678='endif',
            Program_Line_1679='endif',
            Program_Line_1680='endif',
            Program_Line_1681='if (ComfStand == 19) && (ComfMod == 1)',
            Program_Line_1682='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1683='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1684='set ACST = PMOT*0.27+17.9+ACSToffset+ACSTtol',
            Program_Line_1685='else',
            Program_Line_1686='set ACST = 25+ACSTtol',
            Program_Line_1687='endif',
            Program_Line_1688='else',
            Program_Line_1689='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1690='set ACST = PMOT*0.53+10.3+ACSToffset+ACSTtol',
            Program_Line_1691='else',
            Program_Line_1692='set ACST = 25+ACSTtol',
            Program_Line_1693='endif',
            Program_Line_1694='endif',
            Program_Line_1695='endif',
            Program_Line_1696='if (ComfStand == 19) && (ComfMod == 1)',
            Program_Line_1697='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1698='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1699='set AHST = PMOT*0.27+17.9+AHSToffset+AHSTtol',
            Program_Line_1700='else',
            Program_Line_1701='set AHST = 20+AHSTtol',
            Program_Line_1702='endif',
            Program_Line_1703='else',
            Program_Line_1704='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1705='set AHST = PMOT*0.53+10.3+AHSToffset+AHSTtol',
            Program_Line_1706='else',
            Program_Line_1707='set AHST = 20+AHSTtol',
            Program_Line_1708='endif',
            Program_Line_1709='endif',
            Program_Line_1710='endif',
            Program_Line_1711='if (ComfStand == 19) && (ComfMod == 2)',
            Program_Line_1712='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1713='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1714='set ACST = PMOT*0.27+17.9+ACSToffset+ACSTtol',
            Program_Line_1715='elseif PMOT < ACSTall',
            Program_Line_1716='if CAT == 90',
            Program_Line_1717='set ACST = 23+ACSTtol',
            Program_Line_1718='elseif CAT == 80',
            Program_Line_1719='set ACST = 23+ACSTtol',
            Program_Line_1720='endif',
            Program_Line_1721='elseif PMOT > ACSTaul',
            Program_Line_1722='if CAT == 90',
            Program_Line_1723='set ACST = 24+ACSTtol',
            Program_Line_1724='elseif CAT == 80',
            Program_Line_1725='set ACST = 25+ACSTtol',
            Program_Line_1726='endif',
            Program_Line_1727='endif',
            Program_Line_1728='else',
            Program_Line_1729='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1730='set ACST = PMOT*0.53+10.3+ACSToffset+ACSTtol',
            Program_Line_1731='elseif PMOT < ACSTall',
            Program_Line_1732='if CAT == 90',
            Program_Line_1733='set ACST = 23+ACSTtol',
            Program_Line_1734='elseif CAT == 80',
            Program_Line_1735='set ACST = 23+ACSTtol',
            Program_Line_1736='endif',
            Program_Line_1737='elseif PMOT > ACSTaul',
            Program_Line_1738='if CAT == 90',
            Program_Line_1739='set ACST = 24+ACSTtol',
            Program_Line_1740='elseif CAT == 80',
            Program_Line_1741='set ACST = 25+ACSTtol',
            Program_Line_1742='endif',
            Program_Line_1743='endif',
            Program_Line_1744='endif',
            Program_Line_1745='endif',
            Program_Line_1746='if (ComfStand == 19) && (ComfMod == 2)',
            Program_Line_1747='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1748='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1749='set AHST = PMOT*0.27+17.9+AHSToffset+AHSTtol',
            Program_Line_1750='elseif PMOT < AHSTall',
            Program_Line_1751='if CAT == 90',
            Program_Line_1752='set AHST = 20+AHSTtol',
            Program_Line_1753='elseif CAT == 80',
            Program_Line_1754='set AHST = 19+AHSTtol',
            Program_Line_1755='endif',
            Program_Line_1756='elseif PMOT > AHSTaul',
            Program_Line_1757='if CAT == 90',
            Program_Line_1758='set AHST = 23+AHSTtol',
            Program_Line_1759='elseif CAT == 80',
            Program_Line_1760='set AHST = 22+AHSTtol',
            Program_Line_1761='endif',
            Program_Line_1762='endif',
            Program_Line_1763='else',
            Program_Line_1764='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1765='set AHST = PMOT*0.53+10.3+AHSToffset+AHSTtol',
            Program_Line_1766='elseif PMOT < AHSTall',
            Program_Line_1767='if CAT == 90',
            Program_Line_1768='set AHST = 20+AHSTtol',
            Program_Line_1769='elseif CAT == 80',
            Program_Line_1770='set AHST = 19+AHSTtol',
            Program_Line_1771='endif',
            Program_Line_1772='elseif PMOT > AHSTaul',
            Program_Line_1773='if CAT == 90',
            Program_Line_1774='set AHST = 23+AHSTtol',
            Program_Line_1775='elseif CAT == 80',
            Program_Line_1776='set AHST = 22+AHSTtol',
            Program_Line_1777='endif',
            Program_Line_1778='endif',
            Program_Line_1779='endif',
            Program_Line_1780='endif',
            Program_Line_1781='if (ComfStand == 19) && (ComfMod == 3)',
            Program_Line_1782='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1783='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1784='set ACST = PMOT*0.27+17.9+ACSToffset+ACSTtol',
            Program_Line_1785='elseif PMOT < ACSTall',
            Program_Line_1786='set ACST = ACSTall*0.27+17.9+ACSToffset+ACSTtol',
            Program_Line_1787='elseif PMOT > ACSTaul',
            Program_Line_1788='set ACST = ACSTaul*0.27+17.9+ACSToffset+ACSTtol',
            Program_Line_1789='endif',
            Program_Line_1790='else',
            Program_Line_1791='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1792='set ACST = PMOT*0.53+10.3+ACSToffset+ACSTtol',
            Program_Line_1793='elseif PMOT < ACSTall',
            Program_Line_1794='set ACST = ACSTall*0.53+10.3+ACSToffset+ACSTtol',
            Program_Line_1795='elseif PMOT > ACSTaul',
            Program_Line_1796='set ACST = ACSTaul*0.53+10.3+ACSToffset+ACSTtol',
            Program_Line_1797='endif',
            Program_Line_1798='endif',
            Program_Line_1799='endif',
            Program_Line_1800='if (ComfStand == 19) && (ComfMod == 3)',
            Program_Line_1801='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1802='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1803='set AHST = PMOT*0.27+17.9+AHSToffset+AHSTtol',
            Program_Line_1804='elseif PMOT < AHSTall',
            Program_Line_1805='set AHST = AHSTall*0.27+17.9+AHSToffset+AHSTtol',
            Program_Line_1806='elseif PMOT > AHSTaul',
            Program_Line_1807='set AHST = AHSTaul*0.27+17.9+AHSToffset+AHSTtol',
            Program_Line_1808='endif',
            Program_Line_1809='else',
            Program_Line_1810='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1811='set AHST = PMOT*0.53+10.3+AHSToffset+AHSTtol',
            Program_Line_1812='elseif PMOT < AHSTall',
            Program_Line_1813='set AHST = AHSTall*0.53+10.3+AHSToffset+AHSTtol',
            Program_Line_1814='elseif PMOT > AHSTaul',
            Program_Line_1815='set AHST = AHSTaul*0.53+10.3+AHSToffset+AHSTtol',
            Program_Line_1816='endif',
            Program_Line_1817='endif',
            Program_Line_1818='endif',
            Program_Line_1819='if (ComfStand == 20) && (ComfMod == 1)',
            Program_Line_1820='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1821='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1822='set ACST = PMOT*0.38+15.7+ACSToffset+ACSTtol',
            Program_Line_1823='else',
            Program_Line_1824='set ACST = 25+ACSTtol',
            Program_Line_1825='endif',
            Program_Line_1826='else',
            Program_Line_1827='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1828='set ACST = PMOT*0.47+9.07+ACSToffset+ACSTtol',
            Program_Line_1829='else',
            Program_Line_1830='set ACST = 25+ACSTtol',
            Program_Line_1831='endif',
            Program_Line_1832='endif',
            Program_Line_1833='endif',
            Program_Line_1834='if (ComfStand == 20) && (ComfMod == 1)',
            Program_Line_1835='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1836='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1837='set AHST = PMOT*0.38+15.7+AHSToffset+AHSTtol',
            Program_Line_1838='else',
            Program_Line_1839='set AHST = 20+AHSTtol',
            Program_Line_1840='endif',
            Program_Line_1841='else',
            Program_Line_1842='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1843='set AHST = PMOT*0.47+9.07+AHSToffset+AHSTtol',
            Program_Line_1844='else',
            Program_Line_1845='set AHST = 20+AHSTtol',
            Program_Line_1846='endif',
            Program_Line_1847='endif',
            Program_Line_1848='endif',
            Program_Line_1849='if (ComfStand == 20) && (ComfMod == 2)',
            Program_Line_1850='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1851='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1852='set ACST = PMOT*0.38+15.7+ACSToffset+ACSTtol',
            Program_Line_1853='elseif PMOT < ACSTall',
            Program_Line_1854='if CAT == 90',
            Program_Line_1855='set ACST = 23+ACSTtol',
            Program_Line_1856='elseif CAT == 80',
            Program_Line_1857='set ACST = 23+ACSTtol',
            Program_Line_1858='endif',
            Program_Line_1859='elseif PMOT > ACSTaul',
            Program_Line_1860='if CAT == 90',
            Program_Line_1861='set ACST = 24+ACSTtol',
            Program_Line_1862='elseif CAT == 80',
            Program_Line_1863='set ACST = 25+ACSTtol',
            Program_Line_1864='endif',
            Program_Line_1865='endif',
            Program_Line_1866='else',
            Program_Line_1867='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1868='set ACST = PMOT*0.47+9.07+ACSToffset+ACSTtol',
            Program_Line_1869='elseif PMOT < ACSTall',
            Program_Line_1870='if CAT == 90',
            Program_Line_1871='set ACST = 23+ACSTtol',
            Program_Line_1872='elseif CAT == 80',
            Program_Line_1873='set ACST = 23+ACSTtol',
            Program_Line_1874='endif',
            Program_Line_1875='elseif PMOT > ACSTaul',
            Program_Line_1876='if CAT == 90',
            Program_Line_1877='set ACST = 24+ACSTtol',
            Program_Line_1878='elseif CAT == 80',
            Program_Line_1879='set ACST = 25+ACSTtol',
            Program_Line_1880='endif',
            Program_Line_1881='endif',
            Program_Line_1882='endif',
            Program_Line_1883='endif',
            Program_Line_1884='if (ComfStand == 20) && (ComfMod == 2)',
            Program_Line_1885='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1886='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1887='set AHST = PMOT*0.38+15.7+AHSToffset+AHSTtol',
            Program_Line_1888='elseif PMOT < AHSTall',
            Program_Line_1889='if CAT == 90',
            Program_Line_1890='set AHST = 20+AHSTtol',
            Program_Line_1891='elseif CAT == 80',
            Program_Line_1892='set AHST = 19+AHSTtol',
            Program_Line_1893='endif',
            Program_Line_1894='elseif PMOT > AHSTaul',
            Program_Line_1895='if CAT == 90',
            Program_Line_1896='set AHST = 23+AHSTtol',
            Program_Line_1897='elseif CAT == 80',
            Program_Line_1898='set AHST = 22+AHSTtol',
            Program_Line_1899='endif',
            Program_Line_1900='endif',
            Program_Line_1901='else',
            Program_Line_1902='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1903='set AHST = PMOT*0.47+9.07+AHSToffset+AHSTtol',
            Program_Line_1904='elseif PMOT < AHSTall',
            Program_Line_1905='if CAT == 90',
            Program_Line_1906='set AHST = 20+AHSTtol',
            Program_Line_1907='elseif CAT == 80',
            Program_Line_1908='set AHST = 19+AHSTtol',
            Program_Line_1909='endif',
            Program_Line_1910='elseif PMOT > AHSTaul',
            Program_Line_1911='if CAT == 90',
            Program_Line_1912='set AHST = 23+AHSTtol',
            Program_Line_1913='elseif CAT == 80',
            Program_Line_1914='set AHST = 22+AHSTtol',
            Program_Line_1915='endif',
            Program_Line_1916='endif',
            Program_Line_1917='endif',
            Program_Line_1918='endif',
            Program_Line_1919='if (ComfStand == 20) && (ComfMod == 3)',
            Program_Line_1920='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1921='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1922='set ACST = PMOT*0.38+15.7+ACSToffset+ACSTtol',
            Program_Line_1923='elseif PMOT < ACSTall',
            Program_Line_1924='set ACST = ACSTall*0.38+15.7+ACSToffset+ACSTtol',
            Program_Line_1925='elseif PMOT > ACSTaul',
            Program_Line_1926='set ACST = ACSTaul*0.38+15.7+ACSToffset+ACSTtol',
            Program_Line_1927='endif',
            Program_Line_1928='else',
            Program_Line_1929='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1930='set ACST = PMOT*0.47+9.07+ACSToffset+ACSTtol',
            Program_Line_1931='elseif PMOT < ACSTall',
            Program_Line_1932='set ACST = ACSTall*0.47+9.07+ACSToffset+ACSTtol',
            Program_Line_1933='elseif PMOT > ACSTaul',
            Program_Line_1934='set ACST = ACSTaul*0.47+9.07+ACSToffset+ACSTtol',
            Program_Line_1935='endif',
            Program_Line_1936='endif',
            Program_Line_1937='endif',
            Program_Line_1938='if (ComfStand == 20) && (ComfMod == 3)',
            Program_Line_1939='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1940='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1941='set AHST = PMOT*0.38+15.7+AHSToffset+AHSTtol',
            Program_Line_1942='elseif PMOT < AHSTall',
            Program_Line_1943='set AHST = AHSTall*0.38+15.7+AHSToffset+AHSTtol',
            Program_Line_1944='elseif PMOT > AHSTaul',
            Program_Line_1945='set AHST = AHSTaul*0.38+15.7+AHSToffset+AHSTtol',
            Program_Line_1946='endif',
            Program_Line_1947='else',
            Program_Line_1948='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1949='set AHST = PMOT*0.47+9.07+AHSToffset+AHSTtol',
            Program_Line_1950='elseif PMOT < AHSTall',
            Program_Line_1951='set AHST = AHSTall*0.47+9.07+AHSToffset+AHSTtol',
            Program_Line_1952='elseif PMOT > AHSTaul',
            Program_Line_1953='set AHST = AHSTaul*0.47+9.07+AHSToffset+AHSTtol',
            Program_Line_1954='endif',
            Program_Line_1955='endif',
            Program_Line_1956='endif',
        )
        if verboseMode:
            print('Added - SetAST Program')
    #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetAST'])

    if 'SetASTnoTol' in programlist:
        if verboseMode:
            print('Not added - SetASTnoTol Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='SetASTnoTol',
            Program_Line_1='set ACSTnoTol = ACST-ACSTtol',
            Program_Line_2='set AHSTnoTol = AHST-AHSTtol'
            )
        if verboseMode:
            print('Added - SetASTnoTol Program')
    #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetASTnoTol'])

    for zonename in self.occupiedZones:
        if 'CountHoursNoApp_'+zonename in programlist:
            if verboseMode:
                print('Not added - CountHoursNoApp_'+zonename+' Program')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Program',
                Name='CountHoursNoApp_'+zonename,
                Program_Line_1='if ('+zonename+'_OpT <= ACSTnoTol)',
                Program_Line_2='if ('+zonename+'_OpT >= AHSTnoTol)',
                Program_Line_3='set ComfHoursNoApp_'+zonename+'  = 1*ZoneTimeStep',
                Program_Line_4='else',
                Program_Line_5='set ComfHoursNoApp_'+zonename+' = 0',
                Program_Line_6='endif',
                Program_Line_7='else',
                Program_Line_8='set ComfHoursNoApp_'+zonename+' = 0',
                Program_Line_9='endif'
                )
            if verboseMode:
                print('Added - CountHoursNoApp_'+zonename+' Program')
    #        print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'CountHoursNoApp_'+zonename])

        if 'SetGeoVar'+zonename in programlist:
            if verboseMode:
                print('Not added - SetGeoVar'+zonename+' Program')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Program',
                Name='SetGeoVar'+zonename,
                Program_Line_1='set ZoneFloorArea_' + zonename + ' = ZFA_' + zonename + '/2',
                Program_Line_2='set ZoneAirVolume_' + zonename + ' = ZAV_' + zonename + '/2'
            )
            if verboseMode:
                print('Added - SetGeoVar'+zonename+' Program')
    #        print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetGeoVar'+zonename])

    if 'SetInputData' in programlist:
        if verboseMode:
            print('Not added - SetInputData Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='SetInputData',
            Program_Line_1='set ComfStand = 1',
            Program_Line_2='set CAT = 1',
            Program_Line_3='set ComfMod = 2',
            Program_Line_4='set HVACmode = 2',
            Program_Line_5='set VentCtrl = 0',
            Program_Line_6='set VSToffset = 0',
            Program_Line_7='set MinOToffset = 7',
            Program_Line_8='set MaxWindSpeed = 6',
            Program_Line_9='set ACSTtol = -0.25',
            Program_Line_10='set AHSTtol = 0.25'
            )
        if verboseMode:
            print('Added - SetInputData Program')

    if (ScriptType.lower() == 'vrf_mm' or
        ScriptType.lower() == 'ex_mm'):
        if 'SetVST' in programlist:
            if verboseMode:
                print('Not added - SetVST Program')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Program',
                Name='SetVST',
                Program_Line_1='set MinOutTemp = AHST - MinOToffset',
                Program_Line_2='if ComfStand == 0',
                Program_Line_3='if (CurrentTime < 7)',
                Program_Line_4='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_5='elseif (CurrentTime < 15)',
                Program_Line_6='set VST = 22.5+VSToffset',
                Program_Line_7='elseif (CurrentTime < 23)',
                Program_Line_8='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_9='elseif (CurrentTime < 24)',
                Program_Line_10='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_11='endif',
                Program_Line_12='elseif ComfStand == 1 || ComfStand == 10',
                Program_Line_13='if (RMOT >= AHSTall) && (RMOT <= ACSTaul)',
                Program_Line_14='set VST = ComfTemp+VSToffset',
                Program_Line_15='else',
                Program_Line_16='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_17='endif',
                Program_Line_18='elseif ComfStand == 4 || ComfStand == 5 || ComfStand == 6',
                Program_Line_19='if (PMOT >= AHSTall) && (PMOT <= ACSTaul)',
                Program_Line_20='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_21='else',
                Program_Line_22='set VST = 0',
                Program_Line_23='endif',
                Program_Line_24='else',
                Program_Line_25='if (PMOT >= AHSTall) && (PMOT <= ACSTaul)',
                Program_Line_26='set VST = ComfTemp+VSToffset',
                Program_Line_27='else',
                Program_Line_28='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_29='endif',
                Program_Line_30='endif',
            )
            if verboseMode:
                print('Added - SetVST Program')
        #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetVST'])

        for zonename in self.zonenames:
            if 'ApplyAST_'+zonename in programlist:
                if verboseMode:
                    print('Not added - ApplyAST_'+zonename+' Program')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Program',
                    Name='ApplyAST_'+zonename,
                    Program_Line_1='if (' + zonename + '_OpT>VST)&&(' + zonename + '_OutT<VST)',
                    # todo if there is no cooling coil, then zonename_COOLCOIL sensor won't be added
                    #  and therefore it should be omitted in all ExistingHVAC EMS programs; same for _HEATCOIL
                    Program_Line_2='if ' + zonename + '_CoolCoil==0',
                    Program_Line_3='if ' + zonename + '_HeatCoil==0',
                    Program_Line_4='if (' + zonename + '_OpT<ACST)&&(' + zonename + '_OutT>MinOutTemp)',
                    Program_Line_5='if ' + zonename + '_WindSpeed <= MaxWindSpeed',
                    Program_Line_6='set Ventilates_HVACmode2_' + zonename + ' = 1',
                    Program_Line_7='else',
                    Program_Line_8='set Ventilates_HVACmode2_' + zonename + ' = 0',
                    Program_Line_9='endif',
                    Program_Line_10='else',
                    Program_Line_11='set Ventilates_HVACmode2_' + zonename + ' = 0',
                    Program_Line_12='endif',
                    Program_Line_13='else',
                    Program_Line_14='set Ventilates_HVACmode2_' + zonename + ' = 0',
                    Program_Line_15='endif',
                    Program_Line_16='else',
                    Program_Line_17='set Ventilates_HVACmode2_' + zonename + ' = 0',
                    Program_Line_18='endif',
                    Program_Line_19='else',
                    Program_Line_20='set Ventilates_HVACmode2_' + zonename + ' = 0',
                    Program_Line_21='endif',
                    Program_Line_22='if VentCtrl == 0',
                    Program_Line_23='if ' + zonename + '_OutT < ' + zonename + '_OpT',
                    Program_Line_24='if ' + zonename + '_OutT>MinOutTemp',
                    Program_Line_25='if ' + zonename + '_OpT > VST',
                    Program_Line_26='if ' + zonename + '_WindSpeed <= MaxWindSpeed',
                    Program_Line_27='set Ventilates_HVACmode1_' + zonename + ' = 1',
                    Program_Line_28='else',
                    Program_Line_29='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_30='endif',
                    Program_Line_31='else',
                    Program_Line_32='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_33='endif',
                    Program_Line_34='else',
                    Program_Line_35='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_36='endif',
                    Program_Line_37='else',
                    Program_Line_38='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_39='endif',
                    Program_Line_40='elseif VentCtrl == 1',
                    Program_Line_41='if ' + zonename + '_OutT<' + zonename + '_OpT',
                    Program_Line_42='if ' + zonename + '_OutT>MinOutTemp',
                    Program_Line_43='if ' + zonename + '_OpT > ACSTnoTol',
                    Program_Line_44='if ' + zonename + '_WindSpeed <= MaxWindSpeed',
                    Program_Line_45='set Ventilates_HVACmode1_' + zonename + ' = 1',
                    Program_Line_46='else',
                    Program_Line_47='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_48='endif',
                    Program_Line_49='else',
                    Program_Line_50='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_51='endif',
                    Program_Line_52='else',
                    Program_Line_53='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_54='endif',
                    Program_Line_55='else',
                    Program_Line_56='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_57='endif',
                    Program_Line_58='endif',
                    Program_Line_59='if HVACmode == 0',
                    Program_Line_60='set ACST_Act_' + zonename + ' = ACST',
                    Program_Line_61='set AHST_Act_' + zonename + ' = AHST',
                    Program_Line_62='elseif HVACmode == 1',
                    Program_Line_63='Set ACST_Act_' + zonename + ' = 100',
                    Program_Line_64='Set AHST_Act_' + zonename + ' = -100',
                    Program_Line_65='if Ventilates_HVACmode1_' + zonename + ' == 1',
                    Program_Line_66='set VentHours_' + zonename + ' = 1',
                    Program_Line_67='else',
                    Program_Line_68='set VentHours_' + zonename + ' = 0',
                    Program_Line_69='endif',
                    Program_Line_70='elseif HVACmode == 2',
                    Program_Line_71='if Ventilates_HVACmode2_' + zonename + ' == 1',
                    Program_Line_72='set VentHours_' + zonename + ' = 1',
                    Program_Line_73='elseif Ventilates_HVACmode2_' + zonename + ' == 0',
                    Program_Line_74='set VentHours_' + zonename + ' = 0',
                    Program_Line_75='set ACST_Act_' + zonename + ' = ACST',
                    Program_Line_76='set AHST_Act_' + zonename + ' = AHST',
                    Program_Line_77='endif',
                    Program_Line_78='endif'
                )
                if verboseMode:
                    print('Added - ApplyAST_'+zonename+' Program')
            #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'ApplyAST_'+windowname])

        for windowname in self.windownamelist:
            if 'SetWindowOperation_'+windowname in programlist:
                if verboseMode:
                    print('Not added - SetWindowOperation_'+windowname+' Program')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Program',
                    Name='SetWindowOperation_'+windowname,
                    Program_Line_1='if ('+windowname+'_OpT>VST)&&('+windowname+'_OutT < VST)',
                    # todo if there is no cooling coil, then zonename_COOLCOIL sensor won't be added
                    #  and therefore it should be omitted in all ExistingHVAC EMS programs; same for _HEATCOIL
                    Program_Line_2='if '+windowname+'_CoolCoil==0',
                    Program_Line_3='if '+windowname+'_HeatCoil==0',
                    Program_Line_4='if ('+windowname+'_OpT<ACST)&&('+windowname+'_OutT>MinOutTemp)',
                    Program_Line_5='if '+windowname+'_WindSpeed <= MaxWindSpeed',
                    Program_Line_6='set Ventilates_HVACmode2_'+windowname+' = 1',
                    Program_Line_7='else',
                    Program_Line_8='set Ventilates_HVACmode2_'+windowname+' = 0',
                    Program_Line_9='endif',
                    Program_Line_10='else',
                    Program_Line_11='set Ventilates_HVACmode2_'+windowname+' = 0',
                    Program_Line_12='endif',
                    Program_Line_13='else',
                    Program_Line_14='set Ventilates_HVACmode2_'+windowname+' = 0',
                    Program_Line_15='endif',
                    Program_Line_16='else',
                    Program_Line_17='set Ventilates_HVACmode2_'+windowname+' = 0',
                    Program_Line_18='endif',
                    Program_Line_19='else',
                    Program_Line_20='set Ventilates_HVACmode2_'+windowname+' = 0',
                    Program_Line_21='endif',
                    Program_Line_22='if VentCtrl == 0',
                    Program_Line_23='if '+windowname+'_OutT < '+windowname+'_OpT',
                    Program_Line_24='if '+windowname+'_OutT>MinOutTemp',
                    Program_Line_25='if '+windowname+'_OpT > VST',
                    Program_Line_26='if '+windowname+'_WindSpeed <= MaxWindSpeed',
                    Program_Line_27='set Ventilates_HVACmode1_'+windowname+' = 1',
                    Program_Line_28='else',
                    Program_Line_29='set Ventilates_HVACmode1_'+windowname+' = 0',
                    Program_Line_30='endif',
                    Program_Line_31='else',
                    Program_Line_32='set Ventilates_HVACmode1_'+windowname+' = 0',
                    Program_Line_33='endif',
                    Program_Line_34='else',
                    Program_Line_35='set Ventilates_HVACmode1_'+windowname+' = 0',
                    Program_Line_36='endif',
                    Program_Line_37='else',
                    Program_Line_38='set Ventilates_HVACmode1_'+windowname+' = 0',
                    Program_Line_39='endif',
                    Program_Line_40='elseif VentCtrl == 1',
                    Program_Line_41='if '+windowname+'_OutT<'+windowname+'_OpT',
                    Program_Line_42='if '+windowname+'_OutT>MinOutTemp',
                    Program_Line_43='if '+windowname+'_OpT > ACSTnoTol',
                    Program_Line_44='if '+windowname+'_WindSpeed <= MaxWindSpeed',
                    Program_Line_45='set Ventilates_HVACmode1_'+windowname+' = 1',
                    Program_Line_46='else',
                    Program_Line_47='set Ventilates_HVACmode1_'+windowname+' = 0',
                    Program_Line_48='endif',
                    Program_Line_49='else',
                    Program_Line_50='set Ventilates_HVACmode1_'+windowname+' = 0',
                    Program_Line_51='endif',
                    Program_Line_52='else',
                    Program_Line_53='set Ventilates_HVACmode1_'+windowname+' = 0',
                    Program_Line_54='endif',
                    Program_Line_55='else',
                    Program_Line_56='set Ventilates_HVACmode1_'+windowname+' = 0',
                    Program_Line_57='endif',
                    Program_Line_58='endif',
                    Program_Line_59='if HVACmode == 0',
                    Program_Line_60='set '+windowname+'_VentOpenFact = 0',
                    Program_Line_61='elseif HVACmode == 1',
                    Program_Line_62='if Ventilates_HVACmode1_'+windowname+' == 1',
                    Program_Line_63='set '+windowname+'_VentOpenFact = 1',
                    Program_Line_64='else',
                    Program_Line_65='set '+windowname+'_VentOpenFact = 0',
                    Program_Line_66='endif',
                    Program_Line_67='elseif HVACmode == 2',
                    Program_Line_68='if Ventilates_HVACmode2_'+windowname+' == 1',
                    Program_Line_69='set '+windowname+'_VentOpenFact = 1',
                    Program_Line_70='else',
                    Program_Line_71='set '+windowname+'_VentOpenFact = 0',
                    Program_Line_72='endif',
                    Program_Line_73='endif'
                    )
                if verboseMode:
                    print('Added - SetWindowOperation_'+windowname+' Program')
            #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetWindowOperation_'+windowname])
    elif ScriptType.lower() == 'ex_ac' or ScriptType.lower() == 'vrf_ac':
        for zonename in self.zonenames:
            if 'ApplyAST_'+zonename in programlist:
                if verboseMode:
                    print('Not added - ApplyAST_'+zonename+' Program')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Program',
                    Name='ApplyAST_'+zonename,
                    Program_Line_1='set ACST_Act_' + zonename + ' = ACST',
                    Program_Line_2='set AHST_Act_' + zonename + ' = AHST'
                    )

    del programlist


def addEMSPCMBase(self, verboseMode: bool = True):
    """
    Add EMS program calling managers for Base accim.

    Checks if some EMS program calling manager objects are already
    in the model, and otherwise adds them.
    """
    programlist = ([program.Name
                    for program
                    in self.idf1.idfobjects['EnergyManagementSystem:Program']])
    pcmlist = ([pcm.Name
                for pcm
                in self.idf1.idfobjects['EnergyManagementSystem:ProgramCallingManager']])

    for i in programlist:
        if i in pcmlist:
            if verboseMode:
                print('Not added - '+i+' Program Calling Manager')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:ProgramCallingManager',
                Name=i,
                EnergyPlus_Model_Calling_Point="BeginTimestepBeforePredictor",
                Program_Name_1=i
                )
            if verboseMode:
                print('Added - '+i+' Program Calling Manager')
    #        print([program for program in self.idf1.idfobjects['EnergyManagementSystem:ProgramCallingManager'] if program.Name == i])

    del programlist, pcmlist


def addEMSOutputVariableBase(self, ScriptType: str = None, verboseMode: bool = True):
    """Add EMS output variables for Base accim.

    Checks if some EMS output variables objects are already
    in the model, and otherwise adds them.
    """
    EMSOutputVariableAvg_dict = {
        'Comfort Temperature': ['ComfTemp', 'C'],
        'Adaptive Cooling Setpoint Temperature': ['ACST', 'C'],
        'Adaptive Heating Setpoint Temperature': ['AHST', 'C'],
        'Adaptive Cooling Setpoint Temperature_No Tolerance': ['ACSTnoTol', 'C'],
        'Adaptive Heating Setpoint Temperature_No Tolerance': ['AHSTnoTol', 'C'],
    }
    EMSOutputVariableAvgMM_dict = {
        'Ventilation Setpoint Temperature': ['VST', 'C'],
        'Minimum Outdoor Temperature for ventilation': ['MinOutTemp', 'C']
        }
    if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
        EMSOutputVariableAvg_dict.update(EMSOutputVariableAvgMM_dict)

    outputvariablelist = ([outvar.Name
                           for outvar
                           in self.idf1.idfobjects['EnergyManagementSystem:OutputVariable']])

    for i in EMSOutputVariableAvg_dict:
        if i in outputvariablelist:
            if verboseMode:
                print('Not added - '+i+' Output Variable')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:OutputVariable',
                Name=i,
                EMS_Variable_Name=EMSOutputVariableAvg_dict[i][0],
                Type_of_Data_in_Variable='Averaged',
                Update_Frequency='ZoneTimestep',
                EMS_Program_or_Subroutine_Name='',
                Units=EMSOutputVariableAvg_dict[i][1]
                )
            if verboseMode:
                print('Added - '+i+' Output Variable')
            # print([outputvariable for outputvariable in self.idf1.idfobjects['EnergyManagementSystem:OutputVariable'] if outputvariable.Name == i])

    EMSOutputVariableSum_dict = {
        'Comfortable Hours_No Applicability': ['ComfHoursNoApp', 'H'],
        'Comfortable Hours_Applicability': ['ComfHours', 'H'],
        'Discomfortable Applicable Hot Hours': ['DiscomfAppHotHours', 'H'],
        'Discomfortable Applicable Cold Hours': ['DiscomfAppColdHours', 'H'],
        'Discomfortable Non Applicable Hot Hours': ['DiscomfNonAppHotHours', 'H'],
        'Discomfortable Non Applicable Cold Hours': ['DiscomfNonAppColdHours', 'H'],
        'Zone Floor Area': ['ZoneFloorArea', 'm2'],
        'Zone Air Volume': ['ZoneAirVolume', 'm3'],
    }

    for i in EMSOutputVariableSum_dict:
        for zonename in self.occupiedZones:
            if i+'_'+zonename in outputvariablelist:
                if verboseMode:
                    print('Not added - '+i+'_'
                          + zonename + ' Output Variable')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:OutputVariable',
                    Name=i + '_' + zonename,
                    EMS_Variable_Name=EMSOutputVariableSum_dict[i][0]+'_'
                    + zonename,
                    Type_of_Data_in_Variable='Summed',
                    Update_Frequency='ZoneTimestep',
                    EMS_Program_or_Subroutine_Name='',
                    Units=EMSOutputVariableSum_dict[i][1]
                    )
                if verboseMode:
                    print('Added - '+i+'_'
                          + zonename + ' Output Variable')
                # print([outputvariable for outputvariable in self.idf1.idfobjects['EnergyManagementSystem:OutputVariable'] if outputvariable.Name == i+'_'+zonename'])

    if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
        EMSOutputVariableIDFzones_dict = {
            'Ventilation Hours': 'VentHours'
            }

        for i in EMSOutputVariableIDFzones_dict:
            for zonename in self.zonenames:
                if i+'_'+zonename in outputvariablelist:
                    if verboseMode:
                        print('Not added - '+i+'_'
                              + zonename + ' Output Variable')
                else:
                    self.idf1.newidfobject(
                        'EnergyManagementSystem:OutputVariable',
                        Name=i + '_' + zonename,
                        EMS_Variable_Name=EMSOutputVariableIDFzones_dict[i]+'_'
                        + zonename,
                        Type_of_Data_in_Variable='Summed',
                        Update_Frequency='ZoneTimestep',
                        EMS_Program_or_Subroutine_Name='',
                        Units='H'
                        )
                    if verboseMode:
                        print('Added - '+i+'_'
                              + zonename + ' Output Variable')
                    # print([outputvariable for outputvariable in self.idf1.idfobjects['EnergyManagementSystem:OutputVariable'] if outputvariable.Name == i+'_'+zonename'])

    del outputvariablelist


def addGlobVarList(self, ScriptType: str = None, verboseMode: bool = True):
    """Remove existing Global Variable objects and add correct Global Variable objects for accim."""
    globalvariablelist = ([program for program in self.idf1.idfobjects['ENERGYMANAGEMENTSYSTEM:GLOBALVARIABLE']])

    for i in range(len(globalvariablelist)):
        firstglobalvariablelist = self.idf1.idfobjects['ENERGYMANAGEMENTSYSTEM:GLOBALVARIABLE'][-1]
        self.idf1.removeidfobject(firstglobalvariablelist)

    del globalvariablelist

    self.idf1.newidfobject(
        'EnergyManagementSystem:GlobalVariable',
        Erl_Variable_1_Name='ACST',
        Erl_Variable_2_Name='AHST',
        Erl_Variable_3_Name='ACSTnoTol',
        Erl_Variable_4_Name='AHSTnoTol',
        Erl_Variable_5_Name='ComfStand',
        Erl_Variable_6_Name='ACSTaul',
        Erl_Variable_7_Name='ACSTall',
        Erl_Variable_8_Name='AHSTaul',
        Erl_Variable_9_Name='AHSTall',
        Erl_Variable_10_Name='CAT',
        Erl_Variable_11_Name='ACSToffset',
        Erl_Variable_12_Name='AHSToffset',
        Erl_Variable_13_Name='ComfMod',
        Erl_Variable_14_Name='ComfTemp',
        Erl_Variable_15_Name='ACSTtol',
        Erl_Variable_16_Name='AHSTtol'
    )
    for zonename in self.occupiedZones:
        self.idf1.newidfobject(
            'EnergyManagementSystem:GlobalVariable',
            Erl_Variable_1_Name='ComfHours_'+zonename,
            Erl_Variable_2_Name='DiscomfAppHotHours_'+zonename,
            Erl_Variable_3_Name='DiscomfAppColdHours_'+zonename,
            Erl_Variable_4_Name='DiscomfNonAppHotHours_'+zonename,
            Erl_Variable_5_Name='DiscomfNonAppColdHours_'+zonename,
            Erl_Variable_6_Name='ComfHoursNoApp_'+zonename,
            Erl_Variable_7_Name='ZoneFloorArea_' + zonename,
            Erl_Variable_8_Name='ZoneAirVolume_' + zonename

        )

    if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
        self.idf1.newidfobject(
            'EnergyManagementSystem:GlobalVariable',
            Erl_Variable_1_Name='VST',
            Erl_Variable_2_Name='VSToffset',
            Erl_Variable_3_Name='MaxWindSpeed',
            Erl_Variable_4_Name='VentCtrl',
            Erl_Variable_5_Name='HVACmode',
            Erl_Variable_6_Name='MinOutTemp',
            Erl_Variable_7_Name='MinOToffset'
            )
        for zonename in self.zonenames:
            self.idf1.newidfobject(
                'EnergyManagementSystem:GlobalVariable',
                Erl_Variable_1_Name='VentHours_' + zonename
            )

    if verboseMode:
        print("Global variables objects have been added")

def addIntVarList(self, verboseMode: bool = True):
    """Add Internal variables objects for accim."""
    internalvariablelist = ([program for program in self.idf1.idfobjects['ENERGYMANAGEMENTSYSTEM:INTERNALVARIABLE']])

    for i in range(len(internalvariablelist)):
        firstinternalvariablelist = self.idf1.idfobjects['ENERGYMANAGEMENTSYSTEM:INTERNALVARIABLE'][-1]
        self.idf1.removeidfobject(firstinternalvariablelist)

    del internalvariablelist

    intvardict = {
        'ZFA_': 'Zone Floor Area',
        'ZAV_': 'Zone Air Volume'
    }

    for i in range(len(self.zonenames)):
        for j in intvardict:
            self.idf1.newidfobject(
                'EnergyManagementSystem:InternalVariable',
                Name=j+self.zonenames[i],
                Internal_Data_Index_Key_Name=self.zonenames_orig[i],
                Internal_Data_Type=intvardict[j]
            )
    if verboseMode:
        print("Internal variables objects have been added")

# todo add argument for mm outputvariables
def addOutputVariablesBase(
        self,
        ScriptType: str = None,
        TempCtrl: str = None,
        verboseMode: bool = True):
    """Add Output:Variable objects for accim."""
    EnvironmentalImpactFactorslist = ([output for output in self.idf1.idfobjects['Output:EnvironmentalImpactFactors']])
    outputmeterlist = ([output for output in self.idf1.idfobjects['Output:Meter']])
    alloutputs = ([output for output in self.idf1.idfobjects['Output:Variable']])

    if 'vrf' in ScriptType.lower():
        for i in range(len(EnvironmentalImpactFactorslist)):
            firstEnvironmentalImpactFactor = self.idf1.idfobjects['Output:EnvironmentalImpactFactors'][-1]
            self.idf1.removeidfobject(firstEnvironmentalImpactFactor)
        for i in range(len(outputmeterlist)):
            firstoutputmeter = self.idf1.idfobjects['Output:Meter'][-1]
            self.idf1.removeidfobject(firstoutputmeter)
        for i in range(len(alloutputs)):
            firstoutput = self.idf1.idfobjects['Output:Variable'][-1]
            self.idf1.removeidfobject(firstoutput)

    # del EnvironmentalImpactFactorslist,firstEnvironmentalImpactFactor, outputmeterlist, firstoutputmeter, alloutputs, firstoutput

    EMSoutputvariablenamelist = ([outputvariable.Name
                           for outputvariable
                           in self.idf1.idfobjects['EnergyManagementSystem:OutputVariable']])
    outputnamelist = ([output.Variable_Name for output in self.idf1.idfobjects['Output:Variable']])
    addittionaloutputs = [
        # 'Zone Thermostat Operative Temperature',
        'Zone Operative Temperature',
        'Zone Thermal Comfort CEN 15251 Adaptive Model Running Average Outdoor Air Temperature',
        'Zone Thermal Comfort ASHRAE 55 Adaptive Model Running Average Outdoor Air Temperature',
        'Cooling Coil Total Cooling Rate',
        'Heating Coil Heating Rate',
        'Facility Total HVAC Electric Demand Power',
        'Facility Total HVAC Electricity Demand Rate',
        # todo maybe create a new output type to include this variable, to be used in case of tests
        # 'AFN Surface Venting Window or Door Opening Factor',
        'AFN Zone Infiltration Air Change Rate',
        'AFN Zone Infiltration Volume'
    ]
    if TempCtrl.lower() == 'pmv':
        addittionaloutputs.extend([
            'Zone Thermal Comfort Fanger Model PMV',
            'Zone Thermal Comfort Fanger Model PPD'
        ])


    for outputvariable in EMSoutputvariablenamelist:
        if outputvariable in outputnamelist:
            if verboseMode:
                print('Not added - '+outputvariable+' Output:Variable data')
        elif outputvariable.startswith("WIP"):
            if verboseMode:
                print('Not added - '+outputvariable+' Output:Variable data because its WIP')
        elif outputvariable.startswith('Adaptive Thermal Comfort Cost Index'):
            if verboseMode:
                print('Not added - '+outputvariable+' Output:Variable data because its ATCCI')
        else:
            self.idf1.newidfobject(
                'Output:Variable',
                Key_Value='*',
                Variable_Name=outputvariable,
                Reporting_Frequency='Hourly',
                Schedule_Name=''
                )
            if verboseMode:
                print('Added - '+outputvariable+' Output:Variable data')
    #        print([output for output in self.idf1.idfobjects['Output:Variable'] if output.Variable_Name == outputvariable])

    for addittionaloutput in addittionaloutputs:
        if addittionaloutput in outputnamelist:
            if verboseMode:
                print('Not added - '+addittionaloutput+' Output:Variable data')
        else:
            self.idf1.newidfobject(
                'Output:Variable',
                Key_Value='*',
                Variable_Name=addittionaloutput,
                Reporting_Frequency='Hourly',
                Schedule_Name=''
                )
            if verboseMode:
                print('Added - '+addittionaloutput+' Output:Variable data')

    outputlist = ([output for output in self.idf1.idfobjects['Output:Variable']])
    for i in outputlist:
        for addittionaloutput in addittionaloutputs:
            if addittionaloutput in i.Variable_Name:
                i.Schedule_Name = ''

    siteAddOutputs = [
        'Site Outdoor Air Drybulb Temperature',
        'Site Wind Speed',
        'Site Outdoor Air Relative Humidity'
    ]

    other_site_outputs = [
        'Site Outdoor Air Drybulb Temperature [C]',
        'Site Outdoor Air Dewpoint Temperature [C]',
        'Site Outdoor Air Wetbulb Temperature [C]',
        'Site Outdoor Air Humidity Ratio [kgWater/kgAir]',
        'Site Outdoor Air Relative Humidity [%]',
        'Site Outdoor Air Barometric Pressure [Pa]',
        'Site Wind Speed [m/s]',
        'Site Wind Direction [deg]',
        'Site Sky Temperature [C]',
        'Site Horizontal Infrared Radiation Rate per Area [W/m2]',
        'Site Difuse Solar Radiation Rate per Area [W/m2]',
        'Site Direct Solar Radiation Rate per Area [W/m2]',
        'Site Total Sky Cover []',
        'Site Opaque Sky Cover []',
        'Site Precipitation Depth [m]',
        'Site Ground Refected Solar Radiation Rate per Area [W/m2]',
        'Site Ground Temperature [C]',
        'Site Surface Ground Temperature [C]',
        'Site Deep Ground Temperature [C]',
        'Site Simple Factor Model Ground Temperature [C]',
        'Site Outdoor Air Enthalpy [J/kg]',
        'Site Outdoor Air Density [kg/m3]',
        'Site Solar Azimuth Angle [deg]',
        'Site Solar Altitude Angle [deg]',
        'Site Solar Hour Angle [deg]',
        'Site Rain Status []',
        'Site Snow on Ground Status []',
        'Site Exterior Horizontal Sky Illuminance [lux]',
        'Site Exterior Horizontal Beam Illuminance [lux]',
        'Site Exterior Beam Normal Illuminance [lux]',
        'Site Sky Difuse Solar Radiation Luminous Eﬀcacy [lum/W]',
        'Site Beam Solar Radiation Luminous Eﬀcacy [lum/W]',
        'Site Daylighting Model Sky Clearness []',
        'Sky Brightness for Daylighting Calculation []',
        'Site Daylight Saving Time Status []',
        'Site Day Type Index []',
        'Site Mains Water Temperature [C]',
    ]

    for addittionaloutput in siteAddOutputs:
        if addittionaloutput in outputnamelist:
            if verboseMode:
                print('Not added - '+addittionaloutput+' Output:Variable data')
        else:
            self.idf1.newidfobject(
                'Output:Variable',
                Key_Value='Environment',
                Variable_Name=addittionaloutput,
                Reporting_Frequency='Hourly',
                Schedule_Name=''
                )
            if verboseMode:
                print('Added - '+addittionaloutput+' Output:Variable data')

    for zonename in self.zonenames:
        self.idf1.newidfobject(
            'Output:Variable',
            Key_Value='AHST_Sch_'+zonename,
            Variable_Name='Schedule Value',
            Reporting_Frequency='Hourly',
            Schedule_Name=''
            )
        if verboseMode:
            print('Added - AHST_Sch_'+zonename+' Output:Variable data')

        self.idf1.newidfobject(
            'Output:Variable',
            Key_Value='ACST_Sch_'+zonename,
            Variable_Name='Schedule Value',
            Reporting_Frequency='Hourly',
            Schedule_Name=''
            )
        if verboseMode:
            print('Added - ACST_Sch_'+zonename+' Output:Variable data')

    # for zonename in self.zonenames_orig:
    #     self.idf1.newidfobject(
    #         'Output:Variable',
    #         Key_Value=zonename,
    #         Variable_Name='Zone Operative Temperature',
    #         Reporting_Frequency='Hourly',
    #         Schedule_Name=''
    #         )
    #     if verboseMode:
    #         print('Added - '+zonename+' Zone Operative Temperature Output:Variable data')

    if 'vrf' in ScriptType.lower():
        VRFoutputs = [
            'VRF Heat Pump Cooling Electricity Energy',
            'VRF Heat Pump Heating Electricity Energy',
        ]

        for addittionaloutput in VRFoutputs:
            self.idf1.newidfobject(
                'Output:Variable',
                Key_Value='*',
                Variable_Name=addittionaloutput,
                Reporting_Frequency='Hourly',
                Schedule_Name=''
            )
            if verboseMode:
                print('Added - ' + addittionaloutput + ' Output:Variable data')

        for zonename in self.zonenames:
            self.idf1.newidfobject(
                'Output:Variable',
                Key_Value=zonename + ' VRF Indoor Unit DX Cooling Coil',
                Variable_Name='Cooling Coil Total Cooling Rate',
                Reporting_Frequency='Hourly',
                Schedule_Name=''
            )
            if verboseMode:
                print('Added - ' + zonename + ' VRF Indoor Unit DX Cooling Coil Output:Variable data')

            self.idf1.newidfobject(
                'Output:Variable',
                Key_Value=zonename + ' VRF Indoor Unit DX Heating Coil',
                Variable_Name='Heating Coil Heating Rate',
                Reporting_Frequency='Hourly',
                Schedule_Name=''
            )
            if verboseMode:
                print('Added - ' + zonename + ' VRF Indoor Unit DX Heating Coil Output:Variable data')

    del EMSoutputvariablenamelist, outputnamelist, addittionaloutputs,


def addOutputVariablesTimestep(self, verboseMode: bool = True):
    """
    Add Output:Variable objects in timestep frequency.

    No need for further description.
    """
    fulloutputlist = ([output
                       for output
                       in self.idf1.idfobjects['Output:Variable']])
    # print(fulloutputlist)

    outputlist = ([output.Variable_Name
                   for output
                   in self.idf1.idfobjects['Output:Variable']])
    # print(outputlist)

    for i in range(len(outputlist)):
        self.idf1.newidfobject(
            'Output:Variable',
            Key_Value=fulloutputlist[i].Key_Value,
            Variable_Name=fulloutputlist[i].Variable_Name,
            Reporting_Frequency='Timestep',
            Schedule_Name=fulloutputlist[i].Schedule_Name
            )
        if verboseMode:
            print('Added - '+
                  fulloutputlist[i].Variable_Name+
                  ' Output:Variable Timestep data')

    # print([output for output in self.idf1.idfobjects['Output:Variable'] if output.Reporting_Frequency == 'Timestep'])

    del fulloutputlist, outputlist


def addSimplifiedOutputVariables(
        self,
        TempCtrl: str = None,
        verboseMode: bool = True):
    """
    Add simplified Output:Variable objects for accim.

    Remove all outputs and add only VFR outdoor unit consumption
    and operative temperature.
    """
    EnvList = ([output
                for output
                in self.idf1.idfobjects['Output:EnvironmentalImpactFactors']])
    for i in range(len(EnvList)):
        firstEnv = self.idf1.idfobjects['Output:EnvironmentalImpactFactors'][-1]
        self.idf1.removeidfobject(firstEnv)

    outputmeterlist = ([output
                        for output
                        in self.idf1.idfobjects['Output:Meter']])
    for i in range(len(outputmeterlist)):
        firstoutputmeter = self.idf1.idfobjects['Output:Meter'][-1]
        self.idf1.removeidfobject(firstoutputmeter)

    alloutputs = ([output
                   for output
                   in self.idf1.idfobjects['Output:Variable']])
    for i in range(len(alloutputs)):
        firstoutput = self.idf1.idfobjects['Output:Variable'][-1]
        self.idf1.removeidfobject(firstoutput)

    # del EnvironmentalImpactFactorslist,firstEnvironmentalImpactFactor, outputmeterlist, firstoutputmeter, alloutputs, firstoutput

    addittionaloutputs = [
        # 'Zone Thermostat Operative Temperature',
        'Zone Operative Temperature',
        'Cooling Coil Total Cooling Rate',
        'Heating Coil Heating Rate',
    ]

    if TempCtrl.lower() == 'pmv':
        addittionaloutputs.extend([
            'Zone Thermal Comfort Fanger Model PMV',
            'Zone Thermal Comfort Fanger Model PPD'
        ])

    for addittionaloutput in addittionaloutputs:
        self.idf1.newidfobject(
            'Output:Variable',
            Key_Value='*',
            Variable_Name=addittionaloutput,
            Reporting_Frequency='Hourly',
            Schedule_Name=''
            )
        if verboseMode:
            print('Added - '+addittionaloutput+' Output:Variable data')

    del addittionaloutputs


def addEMSSensorsBase(self, ScriptType: str = None, verboseMode: bool = True):
    """Add EMS sensors for accim."""
    sensorlist = ([sensor.Name for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor']])

    if len([i.Name for i in self.idf1.idfobjects['zonelist']]) > 0:
        ppl_key_name = self.occupiedZones_orig[0] + ' People'
    else:
        ppl_key_name = [i for i in self.idf1.idfobjects['PEOPLE']][0].Name

    spacelist = [i for i in self.idf1.idfobjects['spacelist']]

    if 'RMOT' in sensorlist:
        if verboseMode:
            print('Not added - RMOT Sensor')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Sensor',
            Name='RMOT',
            OutputVariable_or_OutputMeter_Index_Key_Name=ppl_key_name,
            OutputVariable_or_OutputMeter_Name='Zone Thermal Comfort CEN 15251 Adaptive Model Running Average Outdoor Air Temperature'
            )
        if verboseMode:
            print('Added - RMOT Sensor')
    #    print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name=='RMOT'])

    if 'PMOT' in sensorlist:
        if verboseMode:
            print('Not added - PMOT Sensor')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Sensor',
            Name='PMOT',
            OutputVariable_or_OutputMeter_Index_Key_Name=ppl_key_name,
            OutputVariable_or_OutputMeter_Name='Zone Thermal Comfort ASHRAE 55 Adaptive Model Running Average Outdoor Air Temperature'
            )
        if verboseMode:
            print('Added - PMOT Sensor')
    #    print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name=='PMOT'])

    for i in range(len(self.zonenames)):
        if self.zonenames[i]+'_OpT' in sensorlist:
            if verboseMode:
                print('Not added - '+self.zonenames[i]+'_OpT Sensor')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Sensor',
                Name=self.zonenames[i]+'_OpT',
                OutputVariable_or_OutputMeter_Index_Key_Name=self.zonenames_orig[i],
                OutputVariable_or_OutputMeter_Name='Zone Operative Temperature'
                )
            if verboseMode:
                print('Added - '+self.zonenames[i]+'_OpT Sensor')
    #        print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name==self.zonenames[i]+'_OpT'])
        if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
            if self.zonenames[i]+'_WindSpeed' in sensorlist:
                if verboseMode:
                    print('Not added - '+self.zonenames[i]+'_WindSpeed Sensor')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Sensor',
                    Name=self.zonenames[i]+'_WindSpeed',
                    OutputVariable_or_OutputMeter_Index_Key_Name=self.zonenames_orig[i],
                    OutputVariable_or_OutputMeter_Name='Zone Outdoor Air Wind Speed'
                    )
                if verboseMode:
                    print('Added - '+self.zonenames[i]+'_WindSpeed Sensor')
        #        print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name==self.zonenames[i]+'_WindSpeed'])
            if self.zonenames[i]+'_OutT' in sensorlist:
                if verboseMode:
                    print('Not added - '+self.zonenames[i]+'_OutT Sensor')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Sensor',
                    Name=self.zonenames[i]+'_OutT',
                    OutputVariable_or_OutputMeter_Index_Key_Name=self.zonenames_orig[i],
                    OutputVariable_or_OutputMeter_Name='Zone Outdoor Air Drybulb Temperature'
                    )
                if verboseMode:
                    print('Added - '+self.zonenames[i]+'_OutT Sensor')
        #        print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name==self.zonenames[i]+'_OutT']

    if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
        for i in range(len(self.windownamelist)):
            if self.windownamelist[i]+'_OpT' in sensorlist:
                if verboseMode:
                    print('Not added - '+self.windownamelist[i]+'_OpT Sensor')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Sensor',
                    Name=self.windownamelist[i]+'_OpT',
                    OutputVariable_or_OutputMeter_Index_Key_Name=self.windownamelist_orig_split[i][0],
                    OutputVariable_or_OutputMeter_Name='Zone Operative Temperature'
                )
                if verboseMode:
                    print('Added - '+self.windownamelist[i]+'_OpT Sensor')

            if self.windownamelist[i]+'_WindSpeed' in sensorlist:
                if verboseMode:
                    print('Not added - '+self.windownamelist[i]+'_WindSpeed Sensor')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Sensor',
                    Name=self.windownamelist[i]+'_WindSpeed',
                    OutputVariable_or_OutputMeter_Index_Key_Name=self.windownamelist_orig_split[i][0],
                    OutputVariable_or_OutputMeter_Name='Zone Outdoor Air Wind Speed'
                    )
                if verboseMode:
                    print('Added - '+self.windownamelist[i]+'_WindSpeed Sensor')

            if self.windownamelist[i]+'_OutT' in sensorlist:
                if verboseMode:
                    print('Not added - '+self.windownamelist[i]+'_WindSpeed Sensor')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Sensor',
                    Name=self.windownamelist[i]+'_OutT',
                    OutputVariable_or_OutputMeter_Index_Key_Name=self.windownamelist_orig_split[i][0],
                    OutputVariable_or_OutputMeter_Name='Zone Outdoor Air Drybulb Temperature'
                    )
                if verboseMode:
                    print('Added - '+self.windownamelist[i]+'_OutT Sensor')

    if 'OutT' in sensorlist:
        if verboseMode:
            print('Not added - OutT Sensor')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Sensor',
            Name='OutT',
            OutputVariable_or_OutputMeter_Index_Key_Name='Environment',
            OutputVariable_or_OutputMeter_Name='Site Outdoor Air Drybulb Temperature'
            )
        if verboseMode:
            print('Added - OutT Sensor')

    # if 'HVACConsump' in sensorlist:
    #     print('Not added - HVACConsump Sensor')
    # else:
    #     self.idf1.newidfobject(
    #         'EnergyManagementSystem:Sensor',
    #         Name='HVACConsump',
    #         OutputVariable_or_OutputMeter_Index_Key_Name='Whole Building',
    #         OutputVariable_or_OutputMeter_Name='Facility Total HVAC Electric Demand Power'
    #         )
    #     print('Added - HVACConsump Sensor')
    #     print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name=='HVACConsump'])


    del sensorlist


def addEMSActuatorsBase(self, ScriptType: str = None, verboseMode: bool = True):
    """Add EMS actuators for accim."""
    actuatorlist = ([actuator.Name for actuator in self.idf1.idfobjects['EnergyManagementSystem:Actuator']])

    for zonename in self.zonenames:
        if 'AHST_Act_'+zonename in actuatorlist:
            if verboseMode:
                print('Not added - AHST_Act_'+zonename+' Actuator')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Actuator',
                Name='AHST_Act_'+zonename,
                Actuated_Component_Unique_Name='AHST_Sch_'+zonename,
                Actuated_Component_Type='Schedule:Compact',
                Actuated_Component_Control_Type='Schedule Value'
                )
            if verboseMode:
                print('Added - AHST_Act_'+zonename+' Actuator')
        #    print([actuator for actuator in self.idf1.idfobjects['EnergyManagementSystem:Actuator'] if actuator.Name=='AHST_Act_'+zonename])

        if 'ACST_Act_'+zonename in actuatorlist:
            if verboseMode:
                print('Not added - ACST_Act_'+zonename+' Actuator')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Actuator',
                Name='ACST_Act_'+zonename,
                Actuated_Component_Unique_Name='ACST_Sch_'+zonename,
                Actuated_Component_Type='Schedule:Compact',
                Actuated_Component_Control_Type='Schedule Value'
                )
            if verboseMode:
                print('Added - ACST_Act_'+zonename+' Actuator')
        #    print([actuator for actuator in self.idf1.idfobjects['EnergyManagementSystem:Actuator'] if actuator.Name=='ACST_Act_'+zonename])

    if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
        for i in range(len(self.windownamelist)):
            if self.windownamelist[i]+'_VentOpenFact' in actuatorlist:
                if verboseMode:
                    print('Not added - '+self.windownamelist[i]+'_OpT Actuator')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Actuator',
                    Name=self.windownamelist[i]+'_VentOpenFact',
                    Actuated_Component_Unique_Name=self.windownamelist_orig[i],
                    Actuated_Component_Type='AirFlow Network Window/Door Opening',
                    Actuated_Component_Control_Type='Venting Opening Factor'
                    )
                if verboseMode:
                    print('Added - '+self.windownamelist[i]+'_VentOpenFact Actuator')
    del actuatorlist


