from tsdoc0.python.segment import Segment
from typing import Final
from typing import Optional
from typing import TYPE_CHECKING

# Conditional import used because there would be a circular dependency
# https://mypy.readthedocs.io/en/latest/common_issues.html#import-cycles
if TYPE_CHECKING:
    from tsdoc0.python.question_abstract import QuestionAbstract  # noqa: F401

import attr


@attr.s(auto_attribs=True, kw_only=True)
class AnswerAbstract(Segment):
    # Forward reference used because there would be a circular dependency
    # https://mypy.readthedocs.io/en/latest/kinds_of_types.html#class-name-forward-references
    parent: Optional["QuestionAbstract"] = attr.ib(eq=False)
    indentation: Final[str]  # type: ignore[misc]
    text: Final[str]  # type: ignore[misc]
