# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class TriggeredTracerouteLearnedInfo(Base):
    """This object holds the attributes for triggered trace route learned information.
    The TriggeredTracerouteLearnedInfo class encapsulates a list of triggeredTracerouteLearnedInfo resources that is managed by the system.
    A list of resources can be retrieved from the server using the TriggeredTracerouteLearnedInfo.find() method.
    """

    __slots__ = ()
    _SDM_NAME = 'triggeredTracerouteLearnedInfo'

    def __init__(self, parent):
        super(TriggeredTracerouteLearnedInfo, self).__init__(parent)

    @property
    def Hops(self):
        """An instance of the Hops class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.vport.protocols.hops_0e9b28b5b0f6a0410ef277e0ce2e6005.Hops)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.vport.protocols.hops_0e9b28b5b0f6a0410ef277e0ce2e6005 import Hops
        return Hops(self)

    @property
    def Fec(self):
        """This signifies the FEC component.

        Returns:
            str
        """
        return self._get_attribute('fec')

    @property
    def Hops(self):
        """This signifies the number of LSP hops.

        Returns:
            str
        """
        return self._get_attribute('hops')

    @property
    def IncomingLabelStack(self):
        """This signifies the information is sent to the MPLS-OAM module which is used for validation of FEC stack received in an echo request. This is the assigned labels stack by the Ixia router and bfd/ping messages are expected to be received from DUT with this stack values. The outer value corresponds to the PSN Tunnel Label and the inner value corresponds to the PW label.

        Returns:
            str
        """
        return self._get_attribute('incomingLabelStack')

    @property
    def NumberOfReplyingHops(self):
        """This signifies the total number of replying LSP hops.

        Returns:
            number
        """
        return self._get_attribute('numberOfReplyingHops')

    @property
    def OutgoingLabelStack(self):
        """This signifies the information is sent to the MPLS-OAM module which is used for validation of FEC outgoing Label stack that is received in an echo request.

        Returns:
            str
        """
        return self._get_attribute('outgoingLabelStack')

    @property
    def Reachability(self):
        """This signifies whether the LSP is reachable with a proper return code or not. If the return code is not set to 3, in the received reply message or if there is no reply message that is received, then the field will show unreachable.

        Returns:
            str
        """
        return self._get_attribute('reachability')

    @property
    def SenderHandle(self):
        """This signifies the sender handle details.

        Returns:
            number
        """
        return self._get_attribute('senderHandle')

    def find(self, Fec=None, Hops=None, IncomingLabelStack=None, NumberOfReplyingHops=None, OutgoingLabelStack=None, Reachability=None, SenderHandle=None):
        """Finds and retrieves triggeredTracerouteLearnedInfo data from the server.

        All named parameters support regex and can be used to selectively retrieve triggeredTracerouteLearnedInfo data from the server.
        By default the find method takes no parameters and will retrieve all triggeredTracerouteLearnedInfo data from the server.

        Args:
            Fec (str): This signifies the FEC component.
            Hops (str): This signifies the number of LSP hops.
            IncomingLabelStack (str): This signifies the information is sent to the MPLS-OAM module which is used for validation of FEC stack received in an echo request. This is the assigned labels stack by the Ixia router and bfd/ping messages are expected to be received from DUT with this stack values. The outer value corresponds to the PSN Tunnel Label and the inner value corresponds to the PW label.
            NumberOfReplyingHops (number): This signifies the total number of replying LSP hops.
            OutgoingLabelStack (str): This signifies the information is sent to the MPLS-OAM module which is used for validation of FEC outgoing Label stack that is received in an echo request.
            Reachability (str): This signifies whether the LSP is reachable with a proper return code or not. If the return code is not set to 3, in the received reply message or if there is no reply message that is received, then the field will show unreachable.
            SenderHandle (number): This signifies the sender handle details.

        Returns:
            self: This instance with matching triggeredTracerouteLearnedInfo data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of triggeredTracerouteLearnedInfo data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the triggeredTracerouteLearnedInfo data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
