# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class MulticastRootRange(Base):
    """Configures the multicast root range values.
    The MulticastRootRange class encapsulates a list of multicastRootRange resources that is be managed by the user.
    A list of resources can be retrieved from the server using the MulticastRootRange.find() method.
    The list can be managed by the user by using the MulticastRootRange.add() and MulticastRootRange.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'multicastRootRange'

    def __init__(self, parent):
        super(MulticastRootRange, self).__init__(parent)

    @property
    def OpaqueValueElement(self):
        """An instance of the OpaqueValueElement class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.vport.protocols.opaquevalueelement_48d1091fb5fff01626b034786d7d2f03.OpaqueValueElement)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.vport.protocols.opaquevalueelement_48d1091fb5fff01626b034786d7d2f03 import OpaqueValueElement
        return OpaqueValueElement(self)

    @property
    def SourceTrafficRange(self):
        """An instance of the SourceTrafficRange class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.vport.protocols.sourcetrafficrange_945ea89934844da58f7a0f66bb6bb135.SourceTrafficRange)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.vport.protocols.sourcetrafficrange_945ea89934844da58f7a0f66bb6bb135 import SourceTrafficRange
        return SourceTrafficRange(self)

    @property
    def ContinuousIncrOpaqueValuesAcrossRoot(self):
        """Signifies the continuous incremented opaque values across root.

        Returns:
            bool
        """
        return self._get_attribute('continuousIncrOpaqueValuesAcrossRoot')
    @ContinuousIncrOpaqueValuesAcrossRoot.setter
    def ContinuousIncrOpaqueValuesAcrossRoot(self, value):
        self._set_attribute('continuousIncrOpaqueValuesAcrossRoot', value)

    @property
    def LspCount(self):
        """Signifies the count of LSP.

        Returns:
            number
        """
        return self._get_attribute('lspCount')
    @LspCount.setter
    def LspCount(self, value):
        self._set_attribute('lspCount', value)

    @property
    def LspType(self):
        """The type of multicast LSP.

        Returns:
            str()
        """
        return self._get_attribute('lspType')

    @property
    def RootAddrStep(self):
        """The Root Address increment step. This is applicable only if Root Address Count is greater than 1.

        Returns:
            str
        """
        return self._get_attribute('rootAddrStep')
    @RootAddrStep.setter
    def RootAddrStep(self, value):
        self._set_attribute('rootAddrStep', value)

    @property
    def RootAddress(self):
        """The root address of the multicast LSP.

        Returns:
            str
        """
        return self._get_attribute('rootAddress')
    @RootAddress.setter
    def RootAddress(self, value):
        self._set_attribute('rootAddress', value)

    @property
    def RootAddressCount(self):
        """The root address count for this Multicast FEC range.

        Returns:
            number
        """
        return self._get_attribute('rootAddressCount')
    @RootAddressCount.setter
    def RootAddressCount(self, value):
        self._set_attribute('rootAddressCount', value)

    def update(self, ContinuousIncrOpaqueValuesAcrossRoot=None, LspCount=None, RootAddrStep=None, RootAddress=None, RootAddressCount=None):
        """Updates a child instance of multicastRootRange on the server.

        Args:
            ContinuousIncrOpaqueValuesAcrossRoot (bool): Signifies the continuous incremented opaque values across root.
            LspCount (number): Signifies the count of LSP.
            RootAddrStep (str): The Root Address increment step. This is applicable only if Root Address Count is greater than 1.
            RootAddress (str): The root address of the multicast LSP.
            RootAddressCount (number): The root address count for this Multicast FEC range.

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, ContinuousIncrOpaqueValuesAcrossRoot=None, LspCount=None, RootAddrStep=None, RootAddress=None, RootAddressCount=None):
        """Adds a new multicastRootRange node on the server and retrieves it in this instance.

        Args:
            ContinuousIncrOpaqueValuesAcrossRoot (bool): Signifies the continuous incremented opaque values across root.
            LspCount (number): Signifies the count of LSP.
            RootAddrStep (str): The Root Address increment step. This is applicable only if Root Address Count is greater than 1.
            RootAddress (str): The root address of the multicast LSP.
            RootAddressCount (number): The root address count for this Multicast FEC range.

        Returns:
            self: This instance with all currently retrieved multicastRootRange data using find and the newly added multicastRootRange data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the multicastRootRange data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, ContinuousIncrOpaqueValuesAcrossRoot=None, LspCount=None, LspType=None, RootAddrStep=None, RootAddress=None, RootAddressCount=None):
        """Finds and retrieves multicastRootRange data from the server.

        All named parameters support regex and can be used to selectively retrieve multicastRootRange data from the server.
        By default the find method takes no parameters and will retrieve all multicastRootRange data from the server.

        Args:
            ContinuousIncrOpaqueValuesAcrossRoot (bool): Signifies the continuous incremented opaque values across root.
            LspCount (number): Signifies the count of LSP.
            LspType (str()): The type of multicast LSP.
            RootAddrStep (str): The Root Address increment step. This is applicable only if Root Address Count is greater than 1.
            RootAddress (str): The root address of the multicast LSP.
            RootAddressCount (number): The root address count for this Multicast FEC range.

        Returns:
            self: This instance with matching multicastRootRange data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of multicastRootRange data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the multicastRootRange data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
