# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class DceTopologyRange(Base):
    """Sets the DCE Topology of a particular DCE ISIS Topology Range.
    The DceTopologyRange class encapsulates a list of dceTopologyRange resources that is be managed by the user.
    A list of resources can be retrieved from the server using the DceTopologyRange.find() method.
    The list can be managed by the user by using the DceTopologyRange.add() and DceTopologyRange.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'dceTopologyRange'

    def __init__(self, parent):
        super(DceTopologyRange, self).__init__(parent)

    @property
    def DceInterestedVlanRange(self):
        """An instance of the DceInterestedVlanRange class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.vport.protocols.dceinterestedvlanrange_138cb6aaf4aff9d936d6fa96f93f65ea.DceInterestedVlanRange)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.vport.protocols.dceinterestedvlanrange_138cb6aaf4aff9d936d6fa96f93f65ea import DceInterestedVlanRange
        return DceInterestedVlanRange(self)

    @property
    def EnableFtag(self):
        """If true, the F tag is enabled.

        Returns:
            bool
        """
        return self._get_attribute('enableFtag')
    @EnableFtag.setter
    def EnableFtag(self, value):
        self._set_attribute('enableFtag', value)

    @property
    def Enabled(self):
        """Signifies if DCE Topology is enabled or disabled.

        Returns:
            bool
        """
        return self._get_attribute('enabled')
    @Enabled.setter
    def Enabled(self, value):
        self._set_attribute('enabled', value)

    @property
    def NicknameList(self):
        """The list of nicknames.

        Returns:
            list(dict(arg1:number,arg2:number,arg3:number))
        """
        return self._get_attribute('nicknameList')
    @NicknameList.setter
    def NicknameList(self, value):
        self._set_attribute('nicknameList', value)

    @property
    def NoOfTreesToCompute(self):
        """The number of trees to compute.

        Returns:
            number
        """
        return self._get_attribute('noOfTreesToCompute')
    @NoOfTreesToCompute.setter
    def NoOfTreesToCompute(self, value):
        self._set_attribute('noOfTreesToCompute', value)

    @property
    def StartFtagValue(self):
        """If true, the Ftag value is started.

        Returns:
            number
        """
        return self._get_attribute('startFtagValue')
    @StartFtagValue.setter
    def StartFtagValue(self, value):
        self._set_attribute('startFtagValue', value)

    @property
    def TopologyCount(self):
        """The count of the topology.

        Returns:
            number
        """
        return self._get_attribute('topologyCount')
    @TopologyCount.setter
    def TopologyCount(self, value):
        self._set_attribute('topologyCount', value)

    @property
    def TopologyId(self):
        """The unique identification number of the topology range.

        Returns:
            number
        """
        return self._get_attribute('topologyId')
    @TopologyId.setter
    def TopologyId(self, value):
        self._set_attribute('topologyId', value)

    @property
    def TopologyIdStep(self):
        """It shows the Increment Step of the ID of DCE Topology Range. Default is 1.

        Returns:
            number
        """
        return self._get_attribute('topologyIdStep')
    @TopologyIdStep.setter
    def TopologyIdStep(self, value):
        self._set_attribute('topologyIdStep', value)

    def update(self, EnableFtag=None, Enabled=None, NicknameList=None, NoOfTreesToCompute=None, StartFtagValue=None, TopologyCount=None, TopologyId=None, TopologyIdStep=None):
        """Updates a child instance of dceTopologyRange on the server.

        Args:
            EnableFtag (bool): If true, the F tag is enabled.
            Enabled (bool): Signifies if DCE Topology is enabled or disabled.
            NicknameList (list(dict(arg1:number,arg2:number,arg3:number))): The list of nicknames.
            NoOfTreesToCompute (number): The number of trees to compute.
            StartFtagValue (number): If true, the Ftag value is started.
            TopologyCount (number): The count of the topology.
            TopologyId (number): The unique identification number of the topology range.
            TopologyIdStep (number): It shows the Increment Step of the ID of DCE Topology Range. Default is 1.

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, EnableFtag=None, Enabled=None, NicknameList=None, NoOfTreesToCompute=None, StartFtagValue=None, TopologyCount=None, TopologyId=None, TopologyIdStep=None):
        """Adds a new dceTopologyRange node on the server and retrieves it in this instance.

        Args:
            EnableFtag (bool): If true, the F tag is enabled.
            Enabled (bool): Signifies if DCE Topology is enabled or disabled.
            NicknameList (list(dict(arg1:number,arg2:number,arg3:number))): The list of nicknames.
            NoOfTreesToCompute (number): The number of trees to compute.
            StartFtagValue (number): If true, the Ftag value is started.
            TopologyCount (number): The count of the topology.
            TopologyId (number): The unique identification number of the topology range.
            TopologyIdStep (number): It shows the Increment Step of the ID of DCE Topology Range. Default is 1.

        Returns:
            self: This instance with all currently retrieved dceTopologyRange data using find and the newly added dceTopologyRange data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the dceTopologyRange data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, EnableFtag=None, Enabled=None, NicknameList=None, NoOfTreesToCompute=None, StartFtagValue=None, TopologyCount=None, TopologyId=None, TopologyIdStep=None):
        """Finds and retrieves dceTopologyRange data from the server.

        All named parameters support regex and can be used to selectively retrieve dceTopologyRange data from the server.
        By default the find method takes no parameters and will retrieve all dceTopologyRange data from the server.

        Args:
            EnableFtag (bool): If true, the F tag is enabled.
            Enabled (bool): Signifies if DCE Topology is enabled or disabled.
            NicknameList (list(dict(arg1:number,arg2:number,arg3:number))): The list of nicknames.
            NoOfTreesToCompute (number): The number of trees to compute.
            StartFtagValue (number): If true, the Ftag value is started.
            TopologyCount (number): The count of the topology.
            TopologyId (number): The unique identification number of the topology range.
            TopologyIdStep (number): It shows the Increment Step of the ID of DCE Topology Range. Default is 1.

        Returns:
            self: This instance with matching dceTopologyRange data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of dceTopologyRange data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the dceTopologyRange data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
