# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class PcReplyLspParameters(Base):
    """PCReply LSP Parameters
    The PcReplyLspParameters class encapsulates a required pcReplyLspParameters resource which will be retrieved from the server every time the property is accessed.
    """

    __slots__ = ()
    _SDM_NAME = 'pcReplyLspParameters'

    def __init__(self, parent):
        super(PcReplyLspParameters, self).__init__(parent)

    @property
    def PceXroSubObjectsList(self):
        """An instance of the PceXroSubObjectsList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.pcexrosubobjectslist.PceXroSubObjectsList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.pcexrosubobjectslist import PceXroSubObjectsList
        return PceXroSubObjectsList(self)

    @property
    def PcepEroSubObjectsList(self):
        """An instance of the PcepEroSubObjectsList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.pceperosubobjectslist.PcepEroSubObjectsList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.pceperosubobjectslist import PcepEroSubObjectsList
        return PcepEroSubObjectsList(self)

    @property
    def PcepMetricSubObjectsList(self):
        """An instance of the PcepMetricSubObjectsList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.pcepmetricsubobjectslist.PcepMetricSubObjectsList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.pcepmetricsubobjectslist import PcepMetricSubObjectsList
        return PcepMetricSubObjectsList(self)

    @property
    def Active(self):
        """Activate/Deactivate Configuration

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('active')

    @property
    def Bandwidth(self):
        """Bandwidth (bits/sec)

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('bandwidth')

    @property
    def BiDirectional(self):
        """Bi-directional

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('biDirectional')

    @property
    def BindingType(self):
        """Indicates the type of binding included in the TLV. Types are as follows: 20bit MPLS Label 32bit MPLS Label. Default value is 20bit MPLS Label.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('bindingType')

    @property
    def Bos(self):
        """This bit is set to True for the last entry in the label stack i.e., for the bottom of the stack, and False for all other label stack entries. This control will be editable only if Binding Type is MPLS Label 32bit.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('bos')

    @property
    def Count(self):
        """Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.

        Returns:
            number
        """
        return self._get_attribute('count')

    @property
    def DescriptiveName(self):
        """Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context

        Returns:
            str
        """
        return self._get_attribute('descriptiveName')

    @property
    def EnableCFlag(self):
        """C Flag

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableCFlag')

    @property
    def EnableEro(self):
        """Include ERO

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableEro')

    @property
    def EnableLoose(self):
        """Loose

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableLoose')

    @property
    def EnableXro(self):
        """Include XRO

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableXro')

    @property
    def ExcludeAny(self):
        """Exclude Any

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('excludeAny')

    @property
    def FailBit(self):
        """Fail Bit

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('failBit')

    @property
    def HoldingPriority(self):
        """Holding Priority

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('holdingPriority')

    @property
    def IncludeAll(self):
        """Include All

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('includeAll')

    @property
    def IncludeAny(self):
        """Include Any

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('includeAny')

    @property
    def IncludeBandwidth(self):
        """Include Bandwidth

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('includeBandwidth')

    @property
    def IncludeLsp(self):
        """Include LSP

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('includeLsp')

    @property
    def IncludeLspa(self):
        """Include LSPA

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('includeLspa')

    @property
    def IncludeMetric(self):
        """Include Metric

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('includeMetric')

    @property
    def IncludeRp(self):
        """Include RP

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('includeRp')

    @property
    def IncludeSymbolicPathNameTlv(self):
        """Indicates if Symbolic-Path-Name TLV is to be included in PCInitiate message.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('includeSymbolicPathNameTlv')

    @property
    def IncludeTEPathBindingTLV(self):
        """Indicates if TE-PATH-BINDING TLV is to be included in PCInitiate message.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('includeTEPathBindingTLV')

    @property
    def LocalProtection(self):
        """Local Protection

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('localProtection')

    @property
    def MplsLabel(self):
        """This control will be editable if the Binding Type is set to either 20bit or 32bit MPLS-Label. This field will take the 20bit value of the MPLS-Label

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('mplsLabel')

    @property
    def Name(self):
        """Name of NGPF element, guaranteed to be unique in Scenario

        Returns:
            str
        """
        return self._get_attribute('name')
    @Name.setter
    def Name(self, value):
        self._set_attribute('name', value)

    @property
    def NatureOfIssue(self):
        """Nature Of Issue

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('natureOfIssue')

    @property
    def NumberOfEroSubObjects(self):
        """Number of ERO Sub Objects

        Returns:
            number
        """
        return self._get_attribute('numberOfEroSubObjects')
    @NumberOfEroSubObjects.setter
    def NumberOfEroSubObjects(self, value):
        self._set_attribute('numberOfEroSubObjects', value)

    @property
    def NumberOfMetricSubObject(self):
        """Number of Metric

        Returns:
            number
        """
        return self._get_attribute('numberOfMetricSubObject')
    @NumberOfMetricSubObject.setter
    def NumberOfMetricSubObject(self, value):
        self._set_attribute('numberOfMetricSubObject', value)

    @property
    def NumberOfXroSubObjects(self):
        """Number of XRO Sub Objects

        Returns:
            number
        """
        return self._get_attribute('numberOfXroSubObjects')
    @NumberOfXroSubObjects.setter
    def NumberOfXroSubObjects(self, value):
        self._set_attribute('numberOfXroSubObjects', value)

    @property
    def PlspId(self):
        """An identifier for the LSP. A PCC creates a unique PLSP-ID for each LSP that is constant for the lifetime of a PCEP session. The PCC will advertise the same PLSP-ID on all PCEP sessions it maintains at a given time.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('plspId')

    @property
    def PriorityValue(self):
        """Priority

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('priorityValue')

    @property
    def ProcessType(self):
        """Indicates how the XRO is responded in the Path Request Response.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('processType')

    @property
    def ReceivedPLSPID(self):
        """Received PLSP-ID in PcRequest

        Returns:
            list(number)
        """
        return self._get_attribute('receivedPLSPID')

    @property
    def ReceivedSymbolicPath(self):
        """Received Symbolic Path Name in PcRequest

        Returns:
            list(str)
        """
        return self._get_attribute('receivedSymbolicPath')

    @property
    def ReflectLSP(self):
        """Reflect LSP

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('reflectLSP')

    @property
    def ReflectRP(self):
        """Reflect RP

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('reflectRP')

    @property
    def ReflectedObjectNoPath(self):
        """Reflected Object

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('reflectedObjectNoPath')

    @property
    def RequestId(self):
        """Request ID

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('requestId')

    @property
    def ResponseOptions(self):
        """Reply Options

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('responseOptions')

    @property
    def ResponsePathType(self):
        """Indicates which type of LSP will be responsed in the Path Request Response.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('responsePathType')

    @property
    def SendEmptyTLV(self):
        """If enabled all fields after Binding Type will be grayed out.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('sendEmptyTLV')

    @property
    def SessionInfo(self):
        """Logs additional information about the LSP state

        Returns:
            list(str[delegatedActive|delegatedDown|delegatedGoingUp|delegatedUp|noLSPObjectInPCRequest|none|notDelegatedActive|notDelegatedDown|notDelegatedGoingUp|notDelegatedUp|pcErrorReceived|removedByPCC|replySent|replySentReportNotReceived])
        """
        return self._get_attribute('sessionInfo')

    @property
    def SetupPriority(self):
        """Setup Priority

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('setupPriority')

    @property
    def SymbolicPathName(self):
        """Each LSP (path) must have a symbolic name that is unique in the PCC. It must remain constant throughout a path's lifetime, which may span across multiple consecutive PCEP sessions and/or PCC restarts.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('symbolicPathName')

    @property
    def Tc(self):
        """This field is used to carry traffic class information. This control will be editable only if Binding Type is MPLS Label 32bit.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('tc')

    @property
    def Ttl(self):
        """This field is used to encode a time-to-live value. This control will be editable only if Binding Type is MPLS Label 32bit.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('ttl')

    def update(self, Name=None, NumberOfEroSubObjects=None, NumberOfMetricSubObject=None, NumberOfXroSubObjects=None):
        """Updates a child instance of pcReplyLspParameters on the server.

        This method has some named parameters with a type: obj (Multivalue).
        The Multivalue class has documentation that details the possible values for those named parameters.

        Args:
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            NumberOfEroSubObjects (number): Number of ERO Sub Objects
            NumberOfMetricSubObject (number): Number of Metric
            NumberOfXroSubObjects (number): Number of XRO Sub Objects

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def get_device_ids(self, PortNames=None, Active=None, Bandwidth=None, BiDirectional=None, BindingType=None, Bos=None, EnableCFlag=None, EnableEro=None, EnableLoose=None, EnableXro=None, ExcludeAny=None, FailBit=None, HoldingPriority=None, IncludeAll=None, IncludeAny=None, IncludeBandwidth=None, IncludeLsp=None, IncludeLspa=None, IncludeMetric=None, IncludeRp=None, IncludeSymbolicPathNameTlv=None, IncludeTEPathBindingTLV=None, LocalProtection=None, MplsLabel=None, NatureOfIssue=None, PlspId=None, PriorityValue=None, ProcessType=None, ReflectLSP=None, ReflectRP=None, ReflectedObjectNoPath=None, RequestId=None, ResponseOptions=None, ResponsePathType=None, SendEmptyTLV=None, SetupPriority=None, SymbolicPathName=None, Tc=None, Ttl=None):
        """Base class infrastructure that gets a list of pcReplyLspParameters device ids encapsulated by this object.

        Use the optional regex parameters in the method to refine the list of device ids encapsulated by this object.

        Args:
            PortNames (str): optional regex of port names
            Active (str): optional regex of active
            Bandwidth (str): optional regex of bandwidth
            BiDirectional (str): optional regex of biDirectional
            BindingType (str): optional regex of bindingType
            Bos (str): optional regex of bos
            EnableCFlag (str): optional regex of enableCFlag
            EnableEro (str): optional regex of enableEro
            EnableLoose (str): optional regex of enableLoose
            EnableXro (str): optional regex of enableXro
            ExcludeAny (str): optional regex of excludeAny
            FailBit (str): optional regex of failBit
            HoldingPriority (str): optional regex of holdingPriority
            IncludeAll (str): optional regex of includeAll
            IncludeAny (str): optional regex of includeAny
            IncludeBandwidth (str): optional regex of includeBandwidth
            IncludeLsp (str): optional regex of includeLsp
            IncludeLspa (str): optional regex of includeLspa
            IncludeMetric (str): optional regex of includeMetric
            IncludeRp (str): optional regex of includeRp
            IncludeSymbolicPathNameTlv (str): optional regex of includeSymbolicPathNameTlv
            IncludeTEPathBindingTLV (str): optional regex of includeTEPathBindingTLV
            LocalProtection (str): optional regex of localProtection
            MplsLabel (str): optional regex of mplsLabel
            NatureOfIssue (str): optional regex of natureOfIssue
            PlspId (str): optional regex of plspId
            PriorityValue (str): optional regex of priorityValue
            ProcessType (str): optional regex of processType
            ReflectLSP (str): optional regex of reflectLSP
            ReflectRP (str): optional regex of reflectRP
            ReflectedObjectNoPath (str): optional regex of reflectedObjectNoPath
            RequestId (str): optional regex of requestId
            ResponseOptions (str): optional regex of responseOptions
            ResponsePathType (str): optional regex of responsePathType
            SendEmptyTLV (str): optional regex of sendEmptyTLV
            SetupPriority (str): optional regex of setupPriority
            SymbolicPathName (str): optional regex of symbolicPathName
            Tc (str): optional regex of tc
            Ttl (str): optional regex of ttl

        Returns:
            list(int): A list of device ids that meets the regex criteria provided in the method parameters

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._get_ngpf_device_ids(locals())

    def ReturnDelegation(self, *args, **kwargs):
        """Executes the returnDelegation operation on the server.

        Return Delegation of PCE-Replied LSPs

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        returnDelegation()

        returnDelegation(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        returnDelegation(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        returnDelegation(Arg2:list)list
            Args:
                args[0] is Arg2 (list(number)): Return Delegation.

            Returns:
                list(str): ID to associate each async action invocation

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('returnDelegation', payload=payload, response_object=None)
