# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class NetTopologyGrid(Base):
    """grid topology
    The NetTopologyGrid class encapsulates a list of netTopologyGrid resources that is be managed by the user.
    A list of resources can be retrieved from the server using the NetTopologyGrid.find() method.
    The list can be managed by the user by using the NetTopologyGrid.add() and NetTopologyGrid.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'netTopologyGrid'

    def __init__(self, parent):
        super(NetTopologyGrid, self).__init__(parent)

    @property
    def Columns(self):
        """number of columns

        Returns:
            number
        """
        return self._get_attribute('columns')
    @Columns.setter
    def Columns(self, value):
        self._set_attribute('columns', value)

    @property
    def IncludeEntryPoint(self):
        """if true, entry node belongs to ring topology, otherwise it is outside of ring

        Returns:
            bool
        """
        return self._get_attribute('includeEntryPoint')
    @IncludeEntryPoint.setter
    def IncludeEntryPoint(self, value):
        self._set_attribute('includeEntryPoint', value)

    @property
    def LinkMultiplier(self):
        """number of links between two nodes

        Returns:
            number
        """
        return self._get_attribute('linkMultiplier')
    @LinkMultiplier.setter
    def LinkMultiplier(self, value):
        self._set_attribute('linkMultiplier', value)

    @property
    def Rows(self):
        """number of rows

        Returns:
            number
        """
        return self._get_attribute('rows')
    @Rows.setter
    def Rows(self, value):
        self._set_attribute('rows', value)

    def update(self, Columns=None, IncludeEntryPoint=None, LinkMultiplier=None, Rows=None):
        """Updates a child instance of netTopologyGrid on the server.

        Args:
            Columns (number): number of columns
            IncludeEntryPoint (bool): if true, entry node belongs to ring topology, otherwise it is outside of ring
            LinkMultiplier (number): number of links between two nodes
            Rows (number): number of rows

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, Columns=None, IncludeEntryPoint=None, LinkMultiplier=None, Rows=None):
        """Adds a new netTopologyGrid node on the server and retrieves it in this instance.

        Args:
            Columns (number): number of columns
            IncludeEntryPoint (bool): if true, entry node belongs to ring topology, otherwise it is outside of ring
            LinkMultiplier (number): number of links between two nodes
            Rows (number): number of rows

        Returns:
            self: This instance with all currently retrieved netTopologyGrid data using find and the newly added netTopologyGrid data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the netTopologyGrid data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, Columns=None, IncludeEntryPoint=None, LinkMultiplier=None, Rows=None):
        """Finds and retrieves netTopologyGrid data from the server.

        All named parameters support regex and can be used to selectively retrieve netTopologyGrid data from the server.
        By default the find method takes no parameters and will retrieve all netTopologyGrid data from the server.

        Args:
            Columns (number): number of columns
            IncludeEntryPoint (bool): if true, entry node belongs to ring topology, otherwise it is outside of ring
            LinkMultiplier (number): number of links between two nodes
            Rows (number): number of rows

        Returns:
            self: This instance with matching netTopologyGrid data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of netTopologyGrid data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the netTopologyGrid data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
