# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class NetTopologyFatTree(Base):
    """Fat Tree topology
    The NetTopologyFatTree class encapsulates a list of netTopologyFatTree resources that is be managed by the user.
    A list of resources can be retrieved from the server using the NetTopologyFatTree.find() method.
    The list can be managed by the user by using the NetTopologyFatTree.add() and NetTopologyFatTree.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'netTopologyFatTree'

    def __init__(self, parent):
        super(NetTopologyFatTree, self).__init__(parent)

    @property
    def Level(self):
        """An instance of the Level class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.level.Level)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.level import Level
        return Level(self)

    @property
    def IncludeEntryPoint(self):
        """if true, entry node belongs to ring topology, otherwise it is outside of ring

        Returns:
            bool
        """
        return self._get_attribute('includeEntryPoint')
    @IncludeEntryPoint.setter
    def IncludeEntryPoint(self, value):
        self._set_attribute('includeEntryPoint', value)

    @property
    def LevelCount(self):
        """Number of Levels

        Returns:
            number
        """
        return self._get_attribute('levelCount')
    @LevelCount.setter
    def LevelCount(self, value):
        self._set_attribute('levelCount', value)

    @property
    def LinkMultiplier(self):
        """number of links between two nodes

        Returns:
            number
        """
        return self._get_attribute('linkMultiplier')
    @LinkMultiplier.setter
    def LinkMultiplier(self, value):
        self._set_attribute('linkMultiplier', value)

    def update(self, IncludeEntryPoint=None, LevelCount=None, LinkMultiplier=None):
        """Updates a child instance of netTopologyFatTree on the server.

        Args:
            IncludeEntryPoint (bool): if true, entry node belongs to ring topology, otherwise it is outside of ring
            LevelCount (number): Number of Levels
            LinkMultiplier (number): number of links between two nodes

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, IncludeEntryPoint=None, LevelCount=None, LinkMultiplier=None):
        """Adds a new netTopologyFatTree node on the server and retrieves it in this instance.

        Args:
            IncludeEntryPoint (bool): if true, entry node belongs to ring topology, otherwise it is outside of ring
            LevelCount (number): Number of Levels
            LinkMultiplier (number): number of links between two nodes

        Returns:
            self: This instance with all currently retrieved netTopologyFatTree data using find and the newly added netTopologyFatTree data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the netTopologyFatTree data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, IncludeEntryPoint=None, LevelCount=None, LinkMultiplier=None):
        """Finds and retrieves netTopologyFatTree data from the server.

        All named parameters support regex and can be used to selectively retrieve netTopologyFatTree data from the server.
        By default the find method takes no parameters and will retrieve all netTopologyFatTree data from the server.

        Args:
            IncludeEntryPoint (bool): if true, entry node belongs to ring topology, otherwise it is outside of ring
            LevelCount (number): Number of Levels
            LinkMultiplier (number): number of links between two nodes

        Returns:
            self: This instance with matching netTopologyFatTree data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of netTopologyFatTree data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the netTopologyFatTree data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
