# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class PceUpdateSrv6MetricSubObjectList(Base):
    """
    The PceUpdateSrv6MetricSubObjectList class encapsulates a list of pceUpdateSrv6MetricSubObjectList resources that is managed by the system.
    A list of resources can be retrieved from the server using the PceUpdateSrv6MetricSubObjectList.find() method.
    """

    __slots__ = ()
    _SDM_NAME = 'pceUpdateSrv6MetricSubObjectList'

    def __init__(self, parent):
        super(PceUpdateSrv6MetricSubObjectList, self).__init__(parent)

    @property
    def ActiveThisMetric(self):
        """Specifies whether the corresponding metric object is active or not.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('activeThisMetric')

    @property
    def BFlag(self):
        """B (bound) flag MUST be set in the METRIC object, which specifies that the SID depth for the computed path MUST NOT exceed the metric-value.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('bFlag')

    @property
    def MetricType(self):
        """This is a drop down which has 4 choices: IGP/ TE/ Hop count/ MSD.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('metricType')

    @property
    def MetricValue(self):
        """User can specify the metric value corresponding to the metric type selected.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('metricValue')

    def find(self):
        """Finds and retrieves pceUpdateSrv6MetricSubObjectList data from the server.

        All named parameters support regex and can be used to selectively retrieve pceUpdateSrv6MetricSubObjectList data from the server.
        By default the find method takes no parameters and will retrieve all pceUpdateSrv6MetricSubObjectList data from the server.

        Returns:
            self: This instance with matching pceUpdateSrv6MetricSubObjectList data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of pceUpdateSrv6MetricSubObjectList data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the pceUpdateSrv6MetricSubObjectList data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)

    def get_device_ids(self, PortNames=None, ActiveThisMetric=None, BFlag=None, MetricType=None, MetricValue=None):
        """Base class infrastructure that gets a list of pceUpdateSrv6MetricSubObjectList device ids encapsulated by this object.

        Use the optional regex parameters in the method to refine the list of device ids encapsulated by this object.

        Args:
            PortNames (str): optional regex of port names
            ActiveThisMetric (str): optional regex of activeThisMetric
            BFlag (str): optional regex of bFlag
            MetricType (str): optional regex of metricType
            MetricValue (str): optional regex of metricValue

        Returns:
            list(int): A list of device ids that meets the regex criteria provided in the method parameters

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._get_ngpf_device_ids(locals())
