# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class Field(Base):
    """Fixed size field.
    The Field class encapsulates a list of field resources that is be managed by the user.
    A list of resources can be retrieved from the server using the Field.find() method.
    The list can be managed by the user by using the Field.add() and Field.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'field'

    def __init__(self, parent):
        super(Field, self).__init__(parent)

    @property
    def Count(self):
        """Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.

        Returns:
            number
        """
        return self._get_attribute('count')

    @property
    def Description(self):
        """Description of the field.

        Returns:
            str
        """
        return self._get_attribute('description')
    @Description.setter
    def Description(self, value):
        self._set_attribute('description', value)

    @property
    def DisplayName(self):
        """Display name used by GUI.

        Returns:
            str
        """
        return self._get_attribute('displayName')

    @property
    def Encoding(self):
        """The encoding of the field in bytes.

        Returns:
            str(iPv4|iPv6|mAC|mACVLAN|decimal|hex|aTM|mACSiteId|mACVLANSiteId|debug|fCID|unknown|hex8WithSpaces|bool|string|float|floatEng|hex8WithColons|mACMAC|decimalFixed2|varLenHex|decimalSigned8)
        """
        return self._get_attribute('encoding')
    @Encoding.setter
    def Encoding(self, value):
        self._set_attribute('encoding', value)

    @property
    def Enum(self):
        """Internal enumeration type used to restrict possible field values.

        Returns:
            str
        """
        return self._get_attribute('enum')
    @Enum.setter
    def Enum(self, value):
        self._set_attribute('enum', value)

    @property
    def IsEditable(self):
        """Information on the requirement of the field.

        Returns:
            bool
        """
        return self._get_attribute('isEditable')
    @IsEditable.setter
    def IsEditable(self, value):
        self._set_attribute('isEditable', value)

    @property
    def IsEnabled(self):
        """Enables disables the field.

        Returns:
            bool
        """
        return self._get_attribute('isEnabled')
    @IsEnabled.setter
    def IsEnabled(self, value):
        self._set_attribute('isEnabled', value)

    @property
    def IsRequired(self):
        """Information on the requirement of the field.

        Returns:
            bool
        """
        return self._get_attribute('isRequired')
    @IsRequired.setter
    def IsRequired(self, value):
        self._set_attribute('isRequired', value)

    @property
    def Name(self):
        """Name of packet field

        Returns:
            str
        """
        return self._get_attribute('name')
    @Name.setter
    def Name(self, value):
        self._set_attribute('name', value)

    @property
    def SingleValue(self):
        """If true the field can only be configured with a single value pattern.

        Returns:
            bool
        """
        return self._get_attribute('singleValue')
    @SingleValue.setter
    def SingleValue(self, value):
        self._set_attribute('singleValue', value)

    @property
    def Size(self):
        """The size of the field in bytes.

        Returns:
            number
        """
        return self._get_attribute('size')
    @Size.setter
    def Size(self, value):
        self._set_attribute('size', value)

    @property
    def SizeType(self):
        """The size types/data unit of the field.

        Returns:
            str(byte|bit)
        """
        return self._get_attribute('sizeType')
    @SizeType.setter
    def SizeType(self, value):
        self._set_attribute('sizeType', value)

    @property
    def Value(self):
        """The string value of the field.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('value')

    def update(self, Description=None, Encoding=None, Enum=None, IsEditable=None, IsEnabled=None, IsRequired=None, Name=None, SingleValue=None, Size=None, SizeType=None):
        """Updates a child instance of field on the server.

        This method has some named parameters with a type: obj (Multivalue).
        The Multivalue class has documentation that details the possible values for those named parameters.

        Args:
            Description (str): Description of the field.
            Encoding (str(iPv4|iPv6|mAC|mACVLAN|decimal|hex|aTM|mACSiteId|mACVLANSiteId|debug|fCID|unknown|hex8WithSpaces|bool|string|float|floatEng|hex8WithColons|mACMAC|decimalFixed2|varLenHex|decimalSigned8)): The encoding of the field in bytes.
            Enum (str): Internal enumeration type used to restrict possible field values.
            IsEditable (bool): Information on the requirement of the field.
            IsEnabled (bool): Enables disables the field.
            IsRequired (bool): Information on the requirement of the field.
            Name (str): Name of packet field
            SingleValue (bool): If true the field can only be configured with a single value pattern.
            Size (number): The size of the field in bytes.
            SizeType (str(byte|bit)): The size types/data unit of the field.

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, Description=None, Encoding=None, Enum=None, IsEditable=None, IsEnabled=None, IsRequired=None, Name=None, SingleValue=None, Size=None, SizeType=None):
        """Adds a new field node on the server and retrieves it in this instance.

        Args:
            Description (str): Description of the field.
            Encoding (str(iPv4|iPv6|mAC|mACVLAN|decimal|hex|aTM|mACSiteId|mACVLANSiteId|debug|fCID|unknown|hex8WithSpaces|bool|string|float|floatEng|hex8WithColons|mACMAC|decimalFixed2|varLenHex|decimalSigned8)): The encoding of the field in bytes.
            Enum (str): Internal enumeration type used to restrict possible field values.
            IsEditable (bool): Information on the requirement of the field.
            IsEnabled (bool): Enables disables the field.
            IsRequired (bool): Information on the requirement of the field.
            Name (str): Name of packet field
            SingleValue (bool): If true the field can only be configured with a single value pattern.
            Size (number): The size of the field in bytes.
            SizeType (str(byte|bit)): The size types/data unit of the field.

        Returns:
            self: This instance with all currently retrieved field data using find and the newly added field data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the field data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, Count=None, Description=None, DisplayName=None, Encoding=None, Enum=None, IsEditable=None, IsEnabled=None, IsRequired=None, Name=None, SingleValue=None, Size=None, SizeType=None):
        """Finds and retrieves field data from the server.

        All named parameters support regex and can be used to selectively retrieve field data from the server.
        By default the find method takes no parameters and will retrieve all field data from the server.

        Args:
            Count (number): Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.
            Description (str): Description of the field.
            DisplayName (str): Display name used by GUI.
            Encoding (str(iPv4|iPv6|mAC|mACVLAN|decimal|hex|aTM|mACSiteId|mACVLANSiteId|debug|fCID|unknown|hex8WithSpaces|bool|string|float|floatEng|hex8WithColons|mACMAC|decimalFixed2|varLenHex|decimalSigned8)): The encoding of the field in bytes.
            Enum (str): Internal enumeration type used to restrict possible field values.
            IsEditable (bool): Information on the requirement of the field.
            IsEnabled (bool): Enables disables the field.
            IsRequired (bool): Information on the requirement of the field.
            Name (str): Name of packet field
            SingleValue (bool): If true the field can only be configured with a single value pattern.
            Size (number): The size of the field in bytes.
            SizeType (str(byte|bit)): The size types/data unit of the field.

        Returns:
            self: This instance with matching field data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of field data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the field data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)

    def get_device_ids(self, PortNames=None, Value=None):
        """Base class infrastructure that gets a list of field device ids encapsulated by this object.

        Use the optional regex parameters in the method to refine the list of device ids encapsulated by this object.

        Args:
            PortNames (str): optional regex of port names
            Value (str): optional regex of value

        Returns:
            list(int): A list of device ids that meets the regex criteria provided in the method parameters

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._get_ngpf_device_ids(locals())
