# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class FlowCondition(Base):
    """Flow condition for displaying egress/ingress statistics.
    The FlowCondition class encapsulates a list of flowCondition resources that is be managed by the user.
    A list of resources can be retrieved from the server using the FlowCondition.find() method.
    The list can be managed by the user by using the FlowCondition.add() and FlowCondition.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'flowCondition'

    def __init__(self, parent):
        super(FlowCondition, self).__init__(parent)

    @property
    def Operator(self):
        """The logical operation to be performed.

        Returns:
            str(isBetween|isDifferent|isEqual|isEqualOrGreater|isEqualOrSmaller|isGreater|isSmaller)
        """
        return self._get_attribute('operator')
    @Operator.setter
    def Operator(self, value):
        self._set_attribute('operator', value)

    @property
    def ShowFirstMatchingSet(self):
        """If true, displays the first matching set.

        Returns:
            bool
        """
        return self._get_attribute('showFirstMatchingSet')
    @ShowFirstMatchingSet.setter
    def ShowFirstMatchingSet(self, value):
        self._set_attribute('showFirstMatchingSet', value)

    @property
    def TrackingFilterId(self):
        """Selected tracking filters from the availableTrackingFilter list.

        Returns:
            str(None|/api/v1/sessions/1/ixnetwork/statistics?deepchild=availableTrackingFilter)
        """
        return self._get_attribute('trackingFilterId')
    @TrackingFilterId.setter
    def TrackingFilterId(self, value):
        self._set_attribute('trackingFilterId', value)

    @property
    def Values(self):
        """Value to be matched for the condition.

        Returns:
            list(number)
        """
        return self._get_attribute('values')
    @Values.setter
    def Values(self, value):
        self._set_attribute('values', value)

    def update(self, Operator=None, ShowFirstMatchingSet=None, TrackingFilterId=None, Values=None):
        """Updates a child instance of flowCondition on the server.

        Args:
            Operator (str(isBetween|isDifferent|isEqual|isEqualOrGreater|isEqualOrSmaller|isGreater|isSmaller)): The logical operation to be performed.
            ShowFirstMatchingSet (bool): If true, displays the first matching set.
            TrackingFilterId (str(None|/api/v1/sessions/1/ixnetwork/statistics?deepchild=availableTrackingFilter)): Selected tracking filters from the availableTrackingFilter list.
            Values (list(number)): Value to be matched for the condition.

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, Operator=None, ShowFirstMatchingSet=None, TrackingFilterId=None, Values=None):
        """Adds a new flowCondition node on the server and retrieves it in this instance.

        Args:
            Operator (str(isBetween|isDifferent|isEqual|isEqualOrGreater|isEqualOrSmaller|isGreater|isSmaller)): The logical operation to be performed.
            ShowFirstMatchingSet (bool): If true, displays the first matching set.
            TrackingFilterId (str(None|/api/v1/sessions/1/ixnetwork/statistics?deepchild=availableTrackingFilter)): Selected tracking filters from the availableTrackingFilter list.
            Values (list(number)): Value to be matched for the condition.

        Returns:
            self: This instance with all currently retrieved flowCondition data using find and the newly added flowCondition data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the flowCondition data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, Operator=None, ShowFirstMatchingSet=None, TrackingFilterId=None, Values=None):
        """Finds and retrieves flowCondition data from the server.

        All named parameters support regex and can be used to selectively retrieve flowCondition data from the server.
        By default the find method takes no parameters and will retrieve all flowCondition data from the server.

        Args:
            Operator (str(isBetween|isDifferent|isEqual|isEqualOrGreater|isEqualOrSmaller|isGreater|isSmaller)): The logical operation to be performed.
            ShowFirstMatchingSet (bool): If true, displays the first matching set.
            TrackingFilterId (str(None|/api/v1/sessions/1/ixnetwork/statistics?deepchild=availableTrackingFilter)): Selected tracking filters from the availableTrackingFilter list.
            Values (list(number)): Value to be matched for the condition.

        Returns:
            self: This instance with matching flowCondition data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of flowCondition data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the flowCondition data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
