# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class AdvancedCVFilters(Base):
    """Sets the advanced filter for a custom view. Note- To change the filter on an existing view, you must first disable it.
    The AdvancedCVFilters class encapsulates a list of advancedCVFilters resources that is be managed by the user.
    A list of resources can be retrieved from the server using the AdvancedCVFilters.find() method.
    The list can be managed by the user by using the AdvancedCVFilters.add() and AdvancedCVFilters.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'advancedCVFilters'

    def __init__(self, parent):
        super(AdvancedCVFilters, self).__init__(parent)

    @property
    def AvailableFilterOptions(self):
        """Returns a list of all the statistics and the operations available for filtering. Note- A protocol and a grouping must be set in order for this to work.

        Returns:
            str
        """
        return self._get_attribute('availableFilterOptions')

    @property
    def AvailableGroupingOptions(self):
        """Returns all the grouping options available. Note - A protocol must be set in order for this to work.

        Returns:
            str
        """
        return self._get_attribute('availableGroupingOptions')

    @property
    def Caption(self):
        """Sets a name for the filter.

        Returns:
            str
        """
        return self._get_attribute('caption')
    @Caption.setter
    def Caption(self, value):
        self._set_attribute('caption', value)

    @property
    def Expression(self):
        """Specifies the filter body. This is a string that must have the specific format. This can be empty or no filter.The available operations and statistics can be obtained from availableFilterOptions.

        Returns:
            str
        """
        return self._get_attribute('expression')
    @Expression.setter
    def Expression(self, value):
        self._set_attribute('expression', value)

    @property
    def Grouping(self):
        """Sets a grouping for the filter.

        Returns:
            str
        """
        return self._get_attribute('grouping')
    @Grouping.setter
    def Grouping(self, value):
        self._set_attribute('grouping', value)

    @property
    def Protocol(self):
        """Sets a protocol for the filter.

        Returns:
            str
        """
        return self._get_attribute('protocol')
    @Protocol.setter
    def Protocol(self, value):
        self._set_attribute('protocol', value)

    @property
    def SortingStats(self):
        """Specifies the list of statistics by which the view is sorted.

        Returns:
            str
        """
        return self._get_attribute('sortingStats')
    @SortingStats.setter
    def SortingStats(self, value):
        self._set_attribute('sortingStats', value)

    def update(self, Caption=None, Expression=None, Grouping=None, Protocol=None, SortingStats=None):
        """Updates a child instance of advancedCVFilters on the server.

        Args:
            Caption (str): Sets a name for the filter.
            Expression (str): Specifies the filter body. This is a string that must have the specific format. This can be empty or no filter.The available operations and statistics can be obtained from availableFilterOptions.
            Grouping (str): Sets a grouping for the filter.
            Protocol (str): Sets a protocol for the filter.
            SortingStats (str): Specifies the list of statistics by which the view is sorted.

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, Caption=None, Expression=None, Grouping=None, Protocol=None, SortingStats=None):
        """Adds a new advancedCVFilters node on the server and retrieves it in this instance.

        Args:
            Caption (str): Sets a name for the filter.
            Expression (str): Specifies the filter body. This is a string that must have the specific format. This can be empty or no filter.The available operations and statistics can be obtained from availableFilterOptions.
            Grouping (str): Sets a grouping for the filter.
            Protocol (str): Sets a protocol for the filter.
            SortingStats (str): Specifies the list of statistics by which the view is sorted.

        Returns:
            self: This instance with all currently retrieved advancedCVFilters data using find and the newly added advancedCVFilters data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the advancedCVFilters data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, AvailableFilterOptions=None, AvailableGroupingOptions=None, Caption=None, Expression=None, Grouping=None, Protocol=None, SortingStats=None):
        """Finds and retrieves advancedCVFilters data from the server.

        All named parameters support regex and can be used to selectively retrieve advancedCVFilters data from the server.
        By default the find method takes no parameters and will retrieve all advancedCVFilters data from the server.

        Args:
            AvailableFilterOptions (str): Returns a list of all the statistics and the operations available for filtering. Note- A protocol and a grouping must be set in order for this to work.
            AvailableGroupingOptions (str): Returns all the grouping options available. Note - A protocol must be set in order for this to work.
            Caption (str): Sets a name for the filter.
            Expression (str): Specifies the filter body. This is a string that must have the specific format. This can be empty or no filter.The available operations and statistics can be obtained from availableFilterOptions.
            Grouping (str): Sets a grouping for the filter.
            Protocol (str): Sets a protocol for the filter.
            SortingStats (str): Specifies the list of statistics by which the view is sorted.

        Returns:
            self: This instance with matching advancedCVFilters data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of advancedCVFilters data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the advancedCVFilters data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
