# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class IsisFabricPathRouter(Base):
    """Fabric-Path Port Configuration
    The IsisFabricPathRouter class encapsulates a list of isisFabricPathRouter resources that is managed by the system.
    A list of resources can be retrieved from the server using the IsisFabricPathRouter.find() method.
    """

    __slots__ = ()
    _SDM_NAME = 'isisFabricPathRouter'

    def __init__(self, parent):
        super(IsisFabricPathRouter, self).__init__(parent)

    @property
    def StartRate(self):
        """An instance of the StartRate class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.globals.topology.isisfabricpathrouter.startrate.startrate.StartRate)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.globals.topology.isisfabricpathrouter.startrate.startrate import StartRate
        return StartRate(self)._select()

    @property
    def StopRate(self):
        """An instance of the StopRate class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.globals.topology.isisfabricpathrouter.stoprate.stoprate.StopRate)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.globals.topology.isisfabricpathrouter.stoprate.stoprate import StopRate
        return StopRate(self)._select()

    @property
    def AllL1RBridgesMAC(self):
        """Fabric-Path All L1 RBridges MAC

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('allL1RBridgesMAC')

    @property
    def Count(self):
        """Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.

        Returns:
            number
        """
        return self._get_attribute('count')

    @property
    def DescriptiveName(self):
        """Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context

        Returns:
            str
        """
        return self._get_attribute('descriptiveName')

    @property
    def HelloMulticastMAC(self):
        """Fabric-Path Hello Multicast MAC

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('helloMulticastMAC')

    @property
    def Name(self):
        """Name of NGPF element, guaranteed to be unique in Scenario

        Returns:
            str
        """
        return self._get_attribute('name')
    @Name.setter
    def Name(self, value):
        self._set_attribute('name', value)

    @property
    def NlpId(self):
        """Fabric-Path NLP ID

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('nlpId')

    @property
    def NoOfLSPsOrMgroupPDUsPerInterval(self):
        """LSPs/MGROUP-PDUs per Interval

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('noOfLSPsOrMgroupPDUsPerInterval')

    @property
    def RateControlInterval(self):
        """Rate Control Interval (ms)

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('rateControlInterval')

    @property
    def RowNames(self):
        """Name of rows

        Returns:
            list(str)
        """
        return self._get_attribute('rowNames')

    @property
    def SendP2PHellosToUnicastMAC(self):
        """TRILL/Fabric-Path Send P2P Hellos To Unicast MAC

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('sendP2PHellosToUnicastMAC')

    def update(self, Name=None):
        """Updates a child instance of isisFabricPathRouter on the server.

        This method has some named parameters with a type: obj (Multivalue).
        The Multivalue class has documentation that details the possible values for those named parameters.

        Args:
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def find(self, Count=None, DescriptiveName=None, Name=None, RowNames=None):
        """Finds and retrieves isisFabricPathRouter data from the server.

        All named parameters support regex and can be used to selectively retrieve isisFabricPathRouter data from the server.
        By default the find method takes no parameters and will retrieve all isisFabricPathRouter data from the server.

        Args:
            Count (number): Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.
            DescriptiveName (str): Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            RowNames (list(str)): Name of rows

        Returns:
            self: This instance with matching isisFabricPathRouter data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of isisFabricPathRouter data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the isisFabricPathRouter data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)

    def get_device_ids(self, PortNames=None, AllL1RBridgesMAC=None, HelloMulticastMAC=None, NlpId=None, NoOfLSPsOrMgroupPDUsPerInterval=None, RateControlInterval=None, SendP2PHellosToUnicastMAC=None):
        """Base class infrastructure that gets a list of isisFabricPathRouter device ids encapsulated by this object.

        Use the optional regex parameters in the method to refine the list of device ids encapsulated by this object.

        Args:
            PortNames (str): optional regex of port names
            AllL1RBridgesMAC (str): optional regex of allL1RBridgesMAC
            HelloMulticastMAC (str): optional regex of helloMulticastMAC
            NlpId (str): optional regex of nlpId
            NoOfLSPsOrMgroupPDUsPerInterval (str): optional regex of noOfLSPsOrMgroupPDUsPerInterval
            RateControlInterval (str): optional regex of rateControlInterval
            SendP2PHellosToUnicastMAC (str): optional regex of sendP2PHellosToUnicastMAC

        Returns:
            list(int): A list of device ids that meets the regex criteria provided in the method parameters

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._get_ngpf_device_ids(locals())
